.TH GRI 1
.SH NAME 
gri \- scientific graphics language
.SH SYNOPSIS
.B gri
[
.B OPTIONS
]
[
.I CommandFile
[
.I PostScriptFile
]]

.SH DESCRIPTION

Gri is a programming language for scientific graphics.  It can make
x-y graphs, contour-graphs, and image graphs.  In addition, Gri has a
full suite of low-level graphical elements and sufficient programming
capabilities (loops, subroutines, etc) to permit complex
customization.

Gri is not point-click.  In some ways it is analogous to TeX.
Extensive power rewards tolerance of a modest learning curve.

.SH OPTIONS

If a command file (CommandFile) is named, commands are read from that file;
otherwise they are read from the keyboard.  If a command file is named, then
a file in which to store the PostScript output may also be named; otherwise
it is stored in a file named by substituting the .ps extension instead 
of .gri in CommandFile.  If no command file is named, the output is named 
gri-00.ps (or gri-01.ps if gri-00.ps exists, etc).

There are 3 special forms that do no graphing:

`gri \fB\-creator\fR postscript_file'
.IP
Extracts the Gri commands that created the Gri PostScript file.
.PP
`gri \fB\-help\fR' or `gri \fB\-h\fR'
.IP
Prints this help message.
.PP
`gri \fB\-version\fR' or `gri \fB\-v\fR'
.IP
Prints the version number of Gri.
.PP
In normal usage, where drawing is expected, Gri takes these options:

\fB\-batch\fR or \fB\-b\fR
.IP
Stops printing of prompts and hints.
.HP
\fB\-chatty[N]\fR or \fB\-c[N]\fR
.IP
Let gri print info messages
.HP
\fB\-debug\fR or \fB\-d\fR
.IP
Turns debugging on (sets variable ..debug.. to value 1).
.HP
\fB\-warn_offpage\fR
.IP
Warn if any item is drawn far off a 8.5x11 inch page.
(This is the default.)
.HP
\fB\-nowarn_offpage\fR
.IP
Don't warn if any item is drawn far off a 8.5x11 inch page
.HP
\fB\-directory\fR pathname
.IP
Specifies the directory where Gri looks for startup files;
otherwise it looks in /opt/gri/lib or at whatever
directory is defined in configure shellscript, at compile time.
.HP
\fB\-directory_default\fR
.IP
Reports directory where gri.cmd should be found,
if not supplied by \fB\-directory\fR.
.HP
\fB\-no_bounding_box\fR
.IP
Make bounding-box be full page.
.HP
\fB\-no_expecting\fR
.IP
Prevent warning message if `expecting version .n.'
command is missing.
.HP
\fB\-no_startup_message\fR
.IP
Stops printing of startup message.
.HP
\fB\-publication\fR or \fB\-p\fR
.IP
Sets the builtin variable ..publication.. to 1; normally it is 0.
One might use if statements (`if !..publication..' ...) on drafts.
.HP
\fB\-superuser\fR or \fB\-s\fR
.IP
Used only by Gri programmers (who can check the value with the
C function `superuser()'.)  An optional value can be supplied
without spaces (e.g. `-s2') to set the debugging level.
Flags are listed below; add flags to get several actions at once
.IP
1: print cmdline before/after substituting synonyms

2: print cmdline before/after substituting rpn expressions

4: print new commands being defined

8: print system commands and `open "... | "' commands before
.IP
they are passed to the system
.IP
128: for author's use only

256: for author's use only
.IP
Note that all flags are equal
to 2 raised to an integer power.  Since the flag values are
detected by a bitwise OR, you can combine flags by adding; thus
specifying a flag of 5 yields flags 1 and 4 together; specifying
15 yields flags 1, 2, 4 and 8.
.HP
\fB\-trace\fR or \fB\-t\fR
.IP
Makes Gri print out command lines as they are executed.
.HP
\fB\-true\fR or \fB\-y\fR
.IP
Makes Gri think the answer to all `query's is RETURN.
.SH "SEE ALSO"

For more information, please consult online 
.I info
and
.I html
manuals.

The 
.I info
manual included in the main
.B gri
Debian package is normally accessed by typing

.B	info gri

(or from within Emacs' own info).

There are also 
.I reference cards
in postscript format.  See
.B /usr/share/doc/gri/*refcard.ps

The Debian package
.B gri-html-doc
provides the
.I html
manual, which when installed is then located at
.IP
.B /usr/share/doc/gri/html/index.html
.PP
or, if you have a web server installed, at
.IP
.B http://localhost/doc/gri/html/index.html
.PP

The HTML manual is accessible via 
.I dwww
and
.I dhelp
Debian help interfaces.
The 
.I html
FAQ is located at
.IP
.B /usr/share/doc/gri/html/FAQ.html
.PP
The
.B gri-html-doc
package also includes
.I examples
in
.B /usr/share/doc/gri/examples/
which are described in the manual, and are included as a quick start primer.

The
.B gri-ps-doc
package is a 
.I PostScript
version of the manual suitable for printing.

.SH GRI_MERGE AND GRI_UNPAGE COMMANDS

Two Perl scripts are provided with Gri to manipulate the PostScript
output.  

.I gri_merge
is used to merge multiple Gri output files into a single PostScript file.
See 
.B gri_merge -h
and its man page for usage information.

.I gri_unpage
is used is split a multi-page Gri output file (in which the
.B new page
command was used) into separate PostScript files, one for each page.

See their respective man pages.

.SH EMACS SUPPORT

An 
.I emacs
mode is provided with Gri.  It is documented in the gri Info or HTML
manual.

The mode is installed automatically in Debian by the elisp file: 

.B /etc/emacs/site-start.d/50gri-el.el

The emacs mode itself is
.I gri-mode.el
and is installed on Debian as 
.B /usr/share/emacs/site-lisp/gri-mode.el

Byte-compiled versions of this file are produced for every flavour of Emacs
that is installed, and are located in places like
.B /usr/share/emacs/23.1/site-lisp/gri-el/gri-mode.elc

.SH "SEE ALSO"
.B
gri_merge(1), gri_unpage(1)

.SH AUTHOR
Gri (c) 1991-2010 Dan Kelley <Dan.Kelley@Dal.CA>

This manual page by Peter S Galbraith <psg@debian.org>.
