.TH "ZIP_FILE_ADD" "3" "August 2, 2014" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_file_add\fR,
\fBzip_file_replace\fR
\- add file to zip archive or replace file in zip archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_int64_t\fR
.PD 0
.HP 4n
\fBzip_file_add\fR(\fIzip_t\ *archive\fR, \fIconst\ char\ *name\fR, \fIzip_source_t\ *source\fR, \fIzip_flags_t\ flags\fR);
.PD
.PP
\fIint\fR
.PD 0
.HP 4n
\fBzip_file_replace\fR(\fIzip_t\ *archive\fR, \fIzip_uint64_t\ index\fR, \fIzip_source_t\ *source\fR, \fIzip_flags_t\ flags\fR);
.PD
.SH "DESCRIPTION"
The function
\fBzip_file_add\fR()
adds a file to a zip archive, while
\fBzip_file_replace\fR()
replaces an existing file in a zip archive.
The argument
\fIarchive\fR
specifies the zip archive to which the file should be added.
\fIname\fR
is the file's name in the zip archive (for
\fBzip_file_add\fR()),
while
\fIindex\fR
specifies which file should be replaced (for
\fBzip_file_replace\fR()).
The
\fIflags\fR
argument can be any combination of
\fRZIP_FL_OVERWRITE\fR
with one of
\fRZIP_FL_ENC_*\fR:
.TP 22n
\fRZIP_FL_OVERWRITE\fR
Overwrite any existing file of the same name.
For
\fBzip_file_add\fR
only.
.TP 22n
\fRZIP_FL_ENC_GUESS\fR
Guess encoding of
\fIname\fR
(default).
.TP 22n
\fRZIP_FL_ENC_UTF_8\fR
Interpret
\fIname\fR
as UTF-8.
.TP 22n
\fRZIP_FL_ENC_CP437\fR
Interpret
\fIname\fR
as code page 437 (CP-437).
.PD 0
.PP
The data is obtained from the
\fIsource\fR
argument, see
zip_source(3).
.PD
.SH "RETURN VALUES"
Upon successful completion,
\fBzip_file_add\fR()
returns the index of the new file in the archive, and
\fBzip_file_replace\fR()
returns 0.
Otherwise, \-1 is returned and the error code in
\fIarchive\fR
is set to indicate the error.
.SH "EXAMPLES"
.nf
.RS 6n
zip_source_t *s;
const char buf="teststring";

if ((s=zip_source_buffer(archive, buffer, sizeof(buf), 0)) == NULL ||
    zip_file_add(archive, name, s, ZIP_FL_ENC_UTF_8) < 0) {
    zip_source_free(s);
    printf("error adding file: %s\en", zip_strerror(archive));
}
.RE
.fi
.SH "ERRORS"
\fBzip_file_add\fR()
and
\fBzip_file_replace\fR()
fail if:
.TP 19n
[\fRZIP_ER_EXISTS\fR]
There is already a file called
\fIname\fR
in the archive.
(Only applies to
\fBzip_file_add\fR(),
and only if
\fRZIP_FL_OVERWRITE\fR
is not provided).
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIsource\fR
or
\fIname\fR
are
\fRNULL\fR,
or
\fIindex\fR
is invalid.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.TP 19n
[\fRZIP_ER_RDONLY\fR]
Archive was opened in read-only mode.
.SH "SEE ALSO"
libzip(3),
zip_source(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
