### Regression tests for naming of results

set.seed(290875)
library("coin")

y1 <- sample(1:20)
y2 <- rnorm(20)
x <- gl(2, 10, labels = c("A", "B"))


###
### Asymptotic
###

### Scalar
asy_scl <- independence_test(y1 ~ x, distr = "asymptotic", teststat = "scalar")
s <- statistic(asy_scl)

stopifnot(identical(   names(    expectation(asy_scl)                                                         ), "A"             ))
stopifnot(identical(   names(       variance(asy_scl)                                                         ), "A"             ))
stopifnot(identical(dimnames(     covariance(asy_scl)                                                         ), list("A", "A")  ))
stopifnot(  is.null(   names(      statistic(asy_scl, type = "test")                                          )                  )) # named in < 1.3-0
stopifnot(identical(dimnames(      statistic(asy_scl, type = "linear")                                        ), list("A", "")   ))
stopifnot(identical(dimnames(      statistic(asy_scl, type = "centered")                                      ), list("A", "")   ))
stopifnot(identical(dimnames(      statistic(asy_scl, type = "standardized")                                  ), list("A", "")   ))
## stopifnot(  is.null(   names(        support(asy_scl)                                                         )                  )) # NA
stopifnot(  is.null(   names(          dperm(asy_scl, x = s)                                                  )                  ))
stopifnot(identical(   names(          dperm(asy_scl, x = c(s = s))                                           ), "s"             ))
stopifnot(  is.null(dimnames(          dperm(asy_scl, x = matrix(s, nrow = 1))                                )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          dperm(asy_scl, x = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          pperm(asy_scl, q = s)                                                  )                  ))
stopifnot(identical(   names(          pperm(asy_scl, q = c(s = s))                                           ), "s"             ))
stopifnot(  is.null(dimnames(          pperm(asy_scl, q = matrix(s, nrow = 1))                                )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          pperm(asy_scl, q = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          qperm(asy_scl, p = 0.75)                                               )                  ))
stopifnot(identical(   names(          qperm(asy_scl, p = c(s = 0.75))                                        ), "s"             ))
stopifnot(  is.null(dimnames(          qperm(asy_scl, p = matrix(0.75, nrow = 1))                             )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          qperm(asy_scl, p = matrix(0.75, nrow = 1, dimnames = list("s", NULL))) ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          rperm(asy_scl, n = 5)                                                  )                  ))
stopifnot(  is.null(   names(         pvalue(asy_scl, method = "global")                                      )                  ))
stopifnot(  is.null(   names(         pvalue(asy_scl, method = "single-step")                                 )                  ))
stopifnot(  is.null(   names(         pvalue(asy_scl, method = "step-down")                                   )                  ))
stopifnot(  is.null(   names(         pvalue(asy_scl, method = "unadjusted")                                  )                  ))
## stopifnot(  is.null(   names(      midpvalue(asy_scl)                                                         )                  )) # NA
## stopifnot(identical(   names(pvalue_interval(asy_scl)                                                         ), c("p_0", "p_1") )) # NA
## stopifnot(  is.null(   names(           size(asy_scl, alpha = 0.05)                                           )                  )) # NA
rm(asy_scl, s)

### Quadratic univariate
asy_qdr_u <- independence_test(y1 ~ x, distr = "asymptotic", teststat = "quadratic")
s <- statistic(asy_qdr_u)

stopifnot(identical(   names(    expectation(asy_qdr_u)                                                         ), "A"             ))
stopifnot(identical(   names(       variance(asy_qdr_u)                                                         ), "A"             ))
stopifnot(identical(dimnames(     covariance(asy_qdr_u)                                                         ), list("A" , "A") ))
stopifnot(  is.null(   names(      statistic(asy_qdr_u, type = "test")                                          )                  ))
stopifnot(identical(dimnames(      statistic(asy_qdr_u, type = "linear")                                        ), list("A" , "")  ))
stopifnot(identical(dimnames(      statistic(asy_qdr_u, type = "centered")                                      ), list("A" , "")  ))
stopifnot(identical(dimnames(      statistic(asy_qdr_u, type = "standardized")                                  ), list("A" , "")  ))
## stopifnot(  is.null(   names(        support(asy_qdr_u)                                                         )                  )) # NA
stopifnot(  is.null(   names(          dperm(asy_qdr_u, x = s)                                                  )                  ))
stopifnot(identical(   names(          dperm(asy_qdr_u, x = c(s = s))                                           ), "s"             ))
stopifnot(  is.null(dimnames(          dperm(asy_qdr_u, x = matrix(s, nrow = 1))                                )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          dperm(asy_qdr_u, x = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          pperm(asy_qdr_u, q = s)                                                  )                  ))
stopifnot(identical(   names(          pperm(asy_qdr_u, q = c(s = s))                                           ), "s"             ))
stopifnot(  is.null(dimnames(          pperm(asy_qdr_u, q = matrix(s, nrow = 1))                                )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          pperm(asy_qdr_u, q = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          qperm(asy_qdr_u, p = 0.75)                                               )                  ))
stopifnot(identical(   names(          qperm(asy_qdr_u, p = c(s = 0.75))                                        ), "s"             ))
stopifnot(  is.null(dimnames(          qperm(asy_qdr_u, p = matrix(0.75, nrow = 1))                             )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          qperm(asy_qdr_u, p = matrix(0.75, nrow = 1, dimnames = list("s", NULL))) ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          rperm(asy_qdr_u, n = 5)                                                  )                  ))
stopifnot(  is.null(   names(         pvalue(asy_qdr_u, method = "global")                                      )                  ))
stopifnot(  is.null(   names(         pvalue(asy_qdr_u, method = "single-step")                                 )                  ))
stopifnot(  is.null(   names(         pvalue(asy_qdr_u, method = "step-down")                                   )                  ))
stopifnot(  is.null(   names(         pvalue(asy_qdr_u, method = "unadjusted")                                  )                  ))
## stopifnot(  is.null(   names(      midpvalue(asy_qdr_u)                                                         )                  )) # NA
## stopifnot(identical(   names(pvalue_interval(asy_qdr_u)                                                         ), c("p_0", "p_1") )) # NA
## stopifnot(  is.null(   names(           size(asy_qdr_u, alpha = 0.05)                                           )                  )) # NA
rm(asy_qdr_u, s)

### Maximum
asy_mxm <- independence_test(y1 + y2 ~ x, distribution = "asymptotic", teststat = "maximum")
s <- statistic(asy_mxm)

stopifnot(identical(   names(    expectation(asy_mxm)                                                         ), c("A:y1", "A:y2")                          ))
stopifnot(identical(   names(       variance(asy_mxm)                                                         ), c("A:y1", "A:y2")                          ))
stopifnot(identical(dimnames(     covariance(asy_mxm)                                                         ), list(c("A:y1", "A:y2"), c("A:y1", "A:y2")) ))
stopifnot(  is.null(   names(      statistic(asy_mxm, type = "test")                                          )                                             ))
stopifnot(identical(dimnames(      statistic(asy_mxm, type = "linear")                                        ), list("A", c("y1", "y2"))                   ))
stopifnot(identical(dimnames(      statistic(asy_mxm, type = "centered")                                      ), list("A", c("y1", "y2"))                   ))
stopifnot(identical(dimnames(      statistic(asy_mxm, type = "standardized")                                  ), list("A", c("y1", "y2"))                   ))
## stopifnot(  is.null(   names(        support(asy_mxm)                                                         )                                             )) # NA
## stopifnot(  is.null(   names(          dperm(asy_mxm, x = s)                                                  )                                             )) # NA
## stopifnot(identical(   names(          dperm(asy_mxm, x = c(s = s))                                           ), "s"                                        )) # NA
## stopifnot(  is.null(dimnames(          dperm(asy_mxm, x = matrix(s, nrow = 1))                                )                                             )) # NA
## stopifnot(identical(dimnames(          dperm(asy_mxm, x = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL)                            )) # NA
stopifnot(  is.null(   names(          pperm(asy_mxm, q = s)                                                  )                                             ))
stopifnot(identical(   names(          pperm(asy_mxm, q = c(s = s))                                           ), "s"                                        ))
stopifnot(  is.null(dimnames(          pperm(asy_mxm, q = matrix(s, nrow = 1))                                )                                             )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          pperm(asy_mxm, q = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL)                            )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          qperm(asy_mxm, p = 0.75)                                               )                                             ))
stopifnot(identical(   names(          qperm(asy_mxm, p = c(s = 0.75))                                        ), "s"                                        ))
stopifnot(  is.null(dimnames(          qperm(asy_mxm, p = matrix(0.75, nrow = 1))                             )                                             )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          qperm(asy_mxm, p = matrix(0.75, nrow = 1, dimnames = list("s", NULL))) ), list("s", NULL)                            )) # non-matrix in < 1.3-1
## stopifnot(  is.null(   names(          rperm(asy_mxm, n = 5)                                                  )                                             )) # NA
stopifnot(  is.null(   names(         pvalue(asy_mxm, method = "global")                                      )                                             ))
stopifnot(identical(dimnames(         pvalue(asy_mxm, method = "single-step")                                 ), list("A", c("y1", "y2"))                   ))
stopifnot(identical(dimnames(         pvalue(asy_mxm, method = "step-down")                                   ), list("A", c("y1", "y2"))                   ))
stopifnot(identical(dimnames(         pvalue(asy_mxm, method = "unadjusted")                                  ), list("A", c("y1", "y2"))                   ))
## stopifnot(  is.null(   names(      midpvalue(asy_mxm)                                                         )                                             )) # NA
## stopifnot(identical(   names(pvalue_interval(asy_mxm)                                                         ), c("p_0", "p_1")                            )) # NA
## stopifnot(  is.null(   names(           size(asy_mxm, alpha = 0.05)                                           )                                             )) # NA
rm(asy_mxm, s)

### Quadratic multivariate
asy_qdr_m <- independence_test(y1 + y2 ~ x, distr = "asymptotic", teststat = "quadratic")
s <- statistic(asy_qdr_m)

stopifnot(identical(   names(    expectation(asy_qdr_m)                                                         ), c("A:y1", "A:y2")                          ))
stopifnot(identical(   names(       variance(asy_qdr_m)                                                         ), c("A:y1", "A:y2")                          ))
stopifnot(identical(dimnames(     covariance(asy_qdr_m)                                                         ), list(c("A:y1", "A:y2"), c("A:y1", "A:y2")) ))
stopifnot(  is.null(   names(      statistic(asy_qdr_m, type = "test")                                          )                                             ))
stopifnot(identical(dimnames(      statistic(asy_qdr_m, type = "linear")                                        ), list("A", c("y1", "y2"))                   ))
stopifnot(identical(dimnames(      statistic(asy_qdr_m, type = "centered")                                      ), list("A", c("y1", "y2"))                   ))
stopifnot(identical(dimnames(      statistic(asy_qdr_m, type = "standardized")                                  ), list("A", c("y1", "y2"))                   ))
## stopifnot(  is.null(   names(        support(asy_qdr_m)                                                         )                                             )) # NA
stopifnot(  is.null(   names(          dperm(asy_qdr_m, x = s)                                                  )                                             ))
stopifnot(identical(   names(          dperm(asy_qdr_m, x = c(s = s))                                           ), "s"                                        ))
stopifnot(  is.null(dimnames(          dperm(asy_qdr_m, x = matrix(s, nrow = 1))                                )                                             )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          dperm(asy_qdr_m, x = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL)                            )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          pperm(asy_qdr_m, q = s)                                                  )                                             ))
stopifnot(identical(   names(          pperm(asy_qdr_m, q = c(s = s))                                           ), "s"                                        ))
stopifnot(  is.null(dimnames(          pperm(asy_qdr_m, q = matrix(s, nrow = 1))                                )                                             )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          pperm(asy_qdr_m, q = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL)                            )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          qperm(asy_qdr_m, p = 0.75)                                               )                                             ))
stopifnot(identical(   names(          qperm(asy_qdr_m, p = c(s = 0.75))                                        ), "s"                                        ))
stopifnot(  is.null(dimnames(          qperm(asy_qdr_m, p = matrix(0.75, nrow = 1))                             )                                             )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          qperm(asy_qdr_m, p = matrix(0.75, nrow = 1, dimnames = list("s", NULL))) ), list("s", NULL)                            )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          rperm(asy_qdr_m, n = 5)                                                  )                                             ))
stopifnot(  is.null(   names(         pvalue(asy_qdr_m, method = "global")                                      )                                             ))
stopifnot(  is.null(   names(         pvalue(asy_qdr_m, method = "single-step")                                 )                                             ))
stopifnot(  is.null(   names(         pvalue(asy_qdr_m, method = "step-down")                                   )                                             ))
stopifnot(  is.null(   names(         pvalue(asy_qdr_m, method = "unadjusted")                                  )                                             ))
## stopifnot(  is.null(   names(      midpvalue(asy_qdr_m)                                                         )                                             )) # NA
## stopifnot(identical(   names(pvalue_interval(asy_qdr_m)                                                         ), c("p_0", "p_1")                            )) # NA
## stopifnot(  is.null(   names(           size(asy_qdr_m, alpha = 0.05)                                           )                                             )) # NA
rm(asy_qdr_m, s)


###
### Approximate
###

### Scalar
app_scl <- independence_test(y1 ~ x, distr = "approximate")
s <- statistic(app_scl)

stopifnot(identical(   names(    expectation(app_scl)                                                         ), "A"             ))
stopifnot(identical(   names(       variance(app_scl)                                                         ), "A"             ))
stopifnot(identical(dimnames(     covariance(app_scl)                                                         ), list("A", "A")  ))
stopifnot(  is.null(   names(      statistic(app_scl, type = "test")                                          )                  )) # named in < 1.3-0
stopifnot(identical(dimnames(      statistic(app_scl, type = "linear")                                        ), list("A", "")   ))
stopifnot(identical(dimnames(      statistic(app_scl, type = "centered")                                      ), list("A", "")   ))
stopifnot(identical(dimnames(      statistic(app_scl, type = "standardized")                                  ), list("A", "")   ))
stopifnot(  is.null(   names(        support(app_scl)                                                         )                  ))
stopifnot(  is.null(   names(          dperm(app_scl, x = s)                                                  )                  ))
stopifnot(identical(   names(          dperm(app_scl, x = c(s = s))                                           ), "s"             ))
stopifnot(  is.null(dimnames(          dperm(app_scl, x = matrix(s, nrow = 1))                                )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          dperm(app_scl, x = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          pperm(app_scl, q = s)                                                  )                  ))
stopifnot(identical(   names(          pperm(app_scl, q = c(s = s))                                           ), "s"             ))
stopifnot(  is.null(dimnames(          pperm(app_scl, q = matrix(s, nrow = 1))                                )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          pperm(app_scl, q = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          qperm(app_scl, p = 0.75)                                               )                  ))
stopifnot(identical(   names(          qperm(app_scl, p = c(s = 0.75))                                        ), "s"             )) # unnamed in < 1.3-0
stopifnot(  is.null(dimnames(          qperm(app_scl, p = matrix(0.75, nrow = 1))                             )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          qperm(app_scl, p = matrix(0.75, nrow = 1, dimnames = list("s", NULL))) ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          rperm(app_scl, n = 5)                                                  )                  ))
stopifnot(  is.null(   names(         pvalue(app_scl, method = "global")                                      )                  ))
stopifnot(  is.null(   names(         pvalue(app_scl, method = "single-step")                                 )                  ))
stopifnot(  is.null(   names(         pvalue(app_scl, method = "step-down")                                   )                  ))
stopifnot(  is.null(   names(         pvalue(app_scl, method = "unadjusted")                                  )                  ))
stopifnot(  is.null(   names(      midpvalue(app_scl)                                                         )                  ))
stopifnot(identical(   names(pvalue_interval(app_scl)                                                         ), c("p_0", "p_1") ))
stopifnot(  is.null(   names(           size(app_scl, alpha = 0.05)                                           )                  ))
rm(app_scl, s)

### Quadratic univariate
app_qdr_u <- independence_test(y1 ~ x, distr = "approximate", teststat = "quadratic")
s <- statistic(app_qdr_u)

stopifnot(identical(   names(    expectation(app_qdr_u)                                                         ), "A"             ))
stopifnot(identical(   names(       variance(app_qdr_u)                                                         ), "A"             ))
stopifnot(identical(dimnames(     covariance(app_qdr_u)                                                         ), list("A", "A")  ))
stopifnot(  is.null(   names(      statistic(app_qdr_u, type = "test")                                          )                  ))
stopifnot(identical(dimnames(      statistic(app_qdr_u, type = "linear")                                        ), list("A", "")   ))
stopifnot(identical(dimnames(      statistic(app_qdr_u, type = "centered")                                      ), list("A", "")   ))
stopifnot(identical(dimnames(      statistic(app_qdr_u, type = "standardized")                                  ), list("A", "")   ))
stopifnot(  is.null(   names(        support(app_qdr_u)                                                         )                  ))
stopifnot(  is.null(   names(          dperm(app_qdr_u, x = s)                                                  )                  ))
stopifnot(identical(   names(          dperm(app_qdr_u, x = c(s = s))                                           ), "s"             ))
stopifnot(  is.null(dimnames(          dperm(app_qdr_u, x = matrix(s, nrow = 1))                                )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          dperm(app_qdr_u, x = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          pperm(app_qdr_u, q = s)                                                  )                  ))
stopifnot(identical(   names(          pperm(app_qdr_u, q = c(s = s))                                           ), "s"             ))
stopifnot(  is.null(dimnames(          pperm(app_qdr_u, q = matrix(s, nrow = 1))                                )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          pperm(app_qdr_u, q = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          qperm(app_qdr_u, p = 0.75)                                               )                  ))
stopifnot(identical(   names(          qperm(app_qdr_u, p = c(s = 0.75))                                        ), "s"             )) # unnamed in < 1.3-0
stopifnot(  is.null(dimnames(          qperm(app_qdr_u, p = matrix(0.75, nrow = 1))                             )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          qperm(app_qdr_u, p = matrix(0.75, nrow = 1, dimnames = list("s", NULL))) ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          rperm(app_qdr_u, n = 5)                                                  )                  ))
stopifnot(  is.null(   names(         pvalue(app_qdr_u, method = "global")                                      )                  ))
stopifnot(  is.null(   names(         pvalue(app_qdr_u, method = "single-step")                                 )                  ))
stopifnot(  is.null(   names(         pvalue(app_qdr_u, method = "step-down")                                   )                  ))
stopifnot(  is.null(   names(         pvalue(app_qdr_u, method = "unadjusted")                                  )                  ))
stopifnot(  is.null(   names(      midpvalue(app_qdr_u)                                                         )                  ))
stopifnot(identical(   names(pvalue_interval(app_qdr_u)                                                         ), c("p_0", "p_1") ))
stopifnot(  is.null(   names(           size(app_qdr_u, alpha = 0.05)                                           )                  ))
rm(app_qdr_u, s)

### Maximum
app_mxm <- independence_test(y1 + y2 ~ x, distr = "approximate", teststat = "maximum")
s <- statistic(app_mxm)

stopifnot(identical(   names(    expectation(app_mxm)                                                         ), c("A:y1", "A:y2")                          ))
stopifnot(identical(   names(       variance(app_mxm)                                                         ), c("A:y1", "A:y2")                          ))
stopifnot(identical(dimnames(     covariance(app_mxm)                                                         ), list(c("A:y1", "A:y2"), c("A:y1", "A:y2")) ))
stopifnot(  is.null(   names(      statistic(app_mxm, type = "test")                                          )                                             ))
stopifnot(identical(dimnames(      statistic(app_mxm, type = "linear")                                        ), list("A", c("y1", "y2"))                   ))
stopifnot(identical(dimnames(      statistic(app_mxm, type = "centered")                                      ), list("A", c("y1", "y2"))                   ))
stopifnot(identical(dimnames(      statistic(app_mxm, type = "standardized")                                  ), list("A", c("y1", "y2"))                   ))
stopifnot(  is.null(   names(        support(app_mxm)                                                         )                                             ))
stopifnot(  is.null(   names(          dperm(app_mxm, x = s)                                                  )                                             ))
stopifnot(identical(   names(          dperm(app_mxm, x = c(s = s))                                           ), "s"                                        ))
stopifnot(  is.null(dimnames(          dperm(app_mxm, x = matrix(s, nrow = 1))                                )                                             )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          dperm(app_mxm, x = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL)                            )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          pperm(app_mxm, q = s)                                                  )                                             ))
stopifnot(identical(   names(          pperm(app_mxm, q = c(s = s))                                           ), "s"                                        ))
stopifnot(  is.null(dimnames(          pperm(app_mxm, q = matrix(s, nrow = 1))                                )                                             )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          pperm(app_mxm, q = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL)                            )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          qperm(app_mxm, p = 0.75)                                               )                                             ))
stopifnot(identical(   names(          qperm(app_mxm, p = c(s = 0.75))                                        ), "s"                                        )) # unnamed in < 1.3-0
stopifnot(  is.null(dimnames(          qperm(app_mxm, p = matrix(0.75, nrow = 1))                             )                                             )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          qperm(app_mxm, p = matrix(0.75, nrow = 1, dimnames = list("s", NULL))) ), list("s", NULL)                            )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          rperm(app_mxm, n = 5)                                                  )                                             ))
stopifnot(  is.null(   names(         pvalue(app_mxm, method = "global")                                      )                                             ))
stopifnot(identical(dimnames(         pvalue(app_mxm, method = "single-step")                                 ), list("A", c("y1", "y2"))                   ))
stopifnot(identical(dimnames(         pvalue(app_mxm, method = "step-down")                                   ), list("A", c("y1", "y2"))                   ))
stopifnot(identical(dimnames(         pvalue(app_mxm, method = "unadjusted")                                  ), list("A", c("y1", "y2"))                   ))
stopifnot(  is.null(   names(      midpvalue(app_mxm)                                                         )                                             ))
stopifnot(identical(   names(pvalue_interval(app_mxm)                                                         ), c("p_0", "p_1")                            ))
stopifnot(  is.null(   names(           size(app_mxm, alpha = 0.05)                                           )                                             ))
rm(app_mxm, s)

### Quadratic multivariate
app_qdr_m <- independence_test(y1 + y2 ~ x, distr = "approximate", teststat = "quadratic")
s <- statistic(app_qdr_m)

stopifnot(identical(   names(    expectation(app_qdr_m)                                                         ), c("A:y1", "A:y2")                          ))
stopifnot(identical(   names(       variance(app_qdr_m)                                                         ), c("A:y1", "A:y2")                          ))
stopifnot(identical(dimnames(     covariance(app_qdr_m)                                                         ), list(c("A:y1", "A:y2"), c("A:y1", "A:y2")) ))
stopifnot(  is.null(   names(      statistic(app_qdr_m, type = "test")                                          )                                             ))
stopifnot(identical(dimnames(      statistic(app_qdr_m, type = "linear")                                        ), list("A", c("y1", "y2"))                   ))
stopifnot(identical(dimnames(      statistic(app_qdr_m, type = "centered")                                      ), list("A", c("y1", "y2"))                   ))
stopifnot(identical(dimnames(      statistic(app_qdr_m, type = "standardized")                                  ), list("A", c("y1", "y2"))                   ))
stopifnot(  is.null(   names(        support(app_qdr_m)                                                         )                                             ))
stopifnot(  is.null(   names(          dperm(app_qdr_m, x = s)                                                  )                                             ))
stopifnot(identical(   names(          dperm(app_qdr_m, x = c(s = s))                                           ), "s"                                        ))
stopifnot(  is.null(dimnames(          dperm(app_qdr_m, x = matrix(s, nrow = 1))                                )                                             )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          dperm(app_qdr_m, x = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL)                            )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          pperm(app_qdr_m, q = s)                                                  )                                             ))
stopifnot(identical(   names(          pperm(app_qdr_m, q = c(s = s))                                           ), "s"                                        ))
stopifnot(  is.null(dimnames(          pperm(app_qdr_m, q = matrix(s, nrow = 1))                                )                                             )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          pperm(app_qdr_m, q = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL)                            )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          qperm(app_qdr_m, p = 0.75)                                               )                                             ))
stopifnot(identical(   names(          qperm(app_qdr_m, p = c(s = 0.75))                                        ), "s"                                        )) # unnamed in < 1.3-0
stopifnot(  is.null(dimnames(          qperm(app_qdr_m, p = matrix(0.75, nrow = 1))                             )                                             )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          qperm(app_qdr_m, p = matrix(0.75, nrow = 1, dimnames = list("s", NULL))) ), list("s", NULL)                            )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          rperm(app_qdr_m, n = 5)                                                  )                                             ))
stopifnot(  is.null(   names(         pvalue(app_qdr_m, method = "global")                                      )                                             ))
stopifnot(  is.null(   names(         pvalue(app_qdr_m, method = "single-step")                                 )                                             ))
stopifnot(  is.null(   names(         pvalue(app_qdr_m, method = "step-down")                                   )                                             ))
stopifnot(  is.null(   names(         pvalue(app_qdr_m, method = "unadjusted")                                  )                                             ))
stopifnot(  is.null(   names(      midpvalue(app_qdr_m)                                                         )                                             ))
stopifnot(identical(   names(pvalue_interval(app_qdr_m)                                                         ), c("p_0", "p_1")                            ))
stopifnot(  is.null(   names(           size(app_qdr_m, alpha = 0.05)                                           )                                             ))
rm(app_qdr_m, s)


###
### Exact using shift algorithm
###

### Scalar
shf_scl <- independence_test(y1 ~ x, distr = exact(algo = "shift"))
s <- statistic(shf_scl)

stopifnot(identical(   names(    expectation(shf_scl)                                                         ), "A"             ))
stopifnot(identical(   names(       variance(shf_scl)                                                         ), "A"             ))
stopifnot(identical(dimnames(     covariance(shf_scl)                                                         ), list("A", "A")  ))
stopifnot(  is.null(   names(      statistic(shf_scl, type = "test")                                          )                  )) # named in < 1.3-0
stopifnot(identical(dimnames(      statistic(shf_scl, type = "linear")                                        ), list("A", "")   ))
stopifnot(identical(dimnames(      statistic(shf_scl, type = "centered")                                      ), list("A", "")   ))
stopifnot(identical(dimnames(      statistic(shf_scl, type = "standardized")                                  ), list("A", "")   ))
stopifnot(  is.null(   names(        support(shf_scl)                                                         )                  ))
stopifnot(  is.null(   names(          dperm(shf_scl, x = s)                                                  )                  ))
stopifnot(identical(   names(          dperm(shf_scl, x = c(s = s))                                           ), "s"             ))
stopifnot(  is.null(dimnames(          dperm(shf_scl, x = matrix(s, nrow = 1))                                )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          dperm(shf_scl, x = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          pperm(shf_scl, q = s)                                                  )                  ))
stopifnot(identical(   names(          pperm(shf_scl, q = c(s = s))                                           ), "s"             ))
stopifnot(  is.null(dimnames(          pperm(shf_scl, q = matrix(s, nrow = 1))                                )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          pperm(shf_scl, q = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          qperm(shf_scl, p = 0.75)                                               )                  ))
stopifnot(identical(   names(          qperm(shf_scl, p = c(s = 0.75))                                        ), "s"             ))
stopifnot(  is.null(dimnames(          qperm(shf_scl, p = matrix(0.75, nrow = 1))                             )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          qperm(shf_scl, p = matrix(0.75, nrow = 1, dimnames = list("s", NULL))) ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          rperm(shf_scl, n = 5)                                                  )                  ))
stopifnot(  is.null(   names(         pvalue(shf_scl, method = "global")                                      )                  ))
stopifnot(  is.null(   names(         pvalue(shf_scl, method = "single-step")                                 )                  ))
stopifnot(  is.null(   names(         pvalue(shf_scl, method = "step-down")                                   )                  ))
stopifnot(  is.null(   names(         pvalue(shf_scl, method = "unadjusted")                                  )                  ))
stopifnot(  is.null(   names(      midpvalue(shf_scl)                                                         )                  ))
stopifnot(identical(   names(pvalue_interval(shf_scl)                                                         ), c("p_0", "p_1") ))
stopifnot(  is.null(   names(           size(shf_scl, alpha = 0.05)                                           )                  ))
rm(shf_scl, s)

### Quadratic univarite
shf_qdr_u <- independence_test(y1 ~ x, distr = exact(algo = "shift"), teststat = "quadratic")
s <- statistic(shf_qdr_u)

stopifnot(identical(   names(    expectation(shf_qdr_u)                                                         ), "A"             ))
stopifnot(identical(   names(       variance(shf_qdr_u)                                                         ), "A"             ))
stopifnot(identical(dimnames(     covariance(shf_qdr_u)                                                         ), list("A", "A")  ))
stopifnot(  is.null(   names(      statistic(shf_qdr_u, type = "test")                                          )                  ))
stopifnot(identical(dimnames(      statistic(shf_qdr_u, type = "linear")                                        ), list("A", "")   ))
stopifnot(identical(dimnames(      statistic(shf_qdr_u, type = "centered")                                      ), list("A", "")   ))
stopifnot(identical(dimnames(      statistic(shf_qdr_u, type = "standardized")                                  ), list("A", "")   ))
stopifnot(  is.null(   names(        support(shf_qdr_u)                                                         )                  ))
stopifnot(  is.null(   names(          dperm(shf_qdr_u, x = s)                                                  )                  ))
stopifnot(identical(   names(          dperm(shf_qdr_u, x = c(s = s))                                           ), "s"             ))
stopifnot(  is.null(dimnames(          dperm(shf_qdr_u, x = matrix(s, nrow = 1))                                )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          dperm(shf_qdr_u, x = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          pperm(shf_qdr_u, q = s)                                                  )                  ))
stopifnot(identical(   names(          pperm(shf_qdr_u, q = c(s = s))                                           ), "s"             ))
stopifnot(  is.null(dimnames(          pperm(shf_qdr_u, q = matrix(s, nrow = 1))                                )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          pperm(shf_qdr_u, q = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          qperm(shf_qdr_u, p = 0.75)                                               )                  ))
stopifnot(identical(   names(          qperm(shf_qdr_u, p = c(s = 0.75))                                        ), "s"             ))
stopifnot(  is.null(dimnames(          qperm(shf_qdr_u, p = matrix(0.75, nrow = 1))                             )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          qperm(shf_qdr_u, p = matrix(0.75, nrow = 1, dimnames = list("s", NULL))) ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          rperm(shf_qdr_u, n = 5)                                                  )                  ))
stopifnot(  is.null(   names(         pvalue(shf_qdr_u, method = "global")                                      )                  ))
stopifnot(  is.null(   names(         pvalue(shf_qdr_u, method = "single-step")                                 )                  ))
stopifnot(  is.null(   names(         pvalue(shf_qdr_u, method = "step-down")                                   )                  ))
stopifnot(  is.null(   names(         pvalue(shf_qdr_u, method = "unadjusted")                                  )                  ))
stopifnot(  is.null(   names(      midpvalue(shf_qdr_u)                                                         )                  ))
stopifnot(identical(   names(pvalue_interval(shf_qdr_u)                                                         ), c("p_0", "p_1") ))
stopifnot(  is.null(   names(           size(shf_qdr_u, alpha = 0.05)                                           )                  ))
rm(shf_qdr_u, s)


###
### Exact using split-up algorithm
###

### Scalar
spl_scl <- independence_test(y1 ~ x, distr = exact(algo = "split"))
s <- statistic(spl_scl)

stopifnot(identical(   names(    expectation(spl_scl)                                                         ), "A"             ))
stopifnot(identical(   names(       variance(spl_scl)                                                         ), "A"             ))
stopifnot(identical(dimnames(     covariance(spl_scl)                                                         ), list("A", "A")  ))
stopifnot(  is.null(   names(      statistic(spl_scl, type = "test")                                          )                  )) # named in < 1.3-0
stopifnot(identical(dimnames(      statistic(spl_scl, type = "linear")                                        ), list("A", "")   ))
stopifnot(identical(dimnames(      statistic(spl_scl, type = "centered")                                      ), list("A", "")   ))
stopifnot(identical(dimnames(      statistic(spl_scl, type = "standardized")                                  ), list("A", "")   ))
## stopifnot(  is.null(   names(        support(spl_scl)                                                         )                  )) # NA
## stopifnot(  is.null(   names(          dperm(spl_scl, x = s)                                                  )                  )) # NA
## stopifnot(identical(   names(          dperm(spl_scl, x = c(s = s))                                           ), "s"             )) # NA
## stopifnot(  is.null(dimnames(          dperm(spl_scl, x = matrix(s, nrow = 1))                                )                  )) # NA
## stopifnot(identical(dimnames(          dperm(spl_scl, x = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL) )) # NA
stopifnot(  is.null(   names(          pperm(spl_scl, q = s)                                                  )                  ))
stopifnot(identical(   names(          pperm(spl_scl, q = c(s = s))                                           ), "s"             ))
stopifnot(  is.null(dimnames(          pperm(spl_scl, q = matrix(s, nrow = 1))                                )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          pperm(spl_scl, q = matrix(s, nrow = 1, dimnames = list("s", NULL)))    ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          qperm(spl_scl, p = 0.75)                                               )                  ))
stopifnot(identical(   names(          qperm(spl_scl, p = c(s = 0.75))                                        ), "s"             ))
stopifnot(  is.null(dimnames(          qperm(spl_scl, p = matrix(0.75, nrow = 1))                             )                  )) # non-matrix in < 1.3-1
stopifnot(identical(dimnames(          qperm(spl_scl, p = matrix(0.75, nrow = 1, dimnames = list("s", NULL))) ), list("s", NULL) )) # non-matrix in < 1.3-1
stopifnot(  is.null(   names(          rperm(spl_scl, n = 5)                                                  )                  ))
stopifnot(  is.null(   names(         pvalue(spl_scl, method = "global")                                      )                  ))
stopifnot(  is.null(   names(         pvalue(spl_scl, method = "single-step")                                 )                  ))
stopifnot(  is.null(   names(         pvalue(spl_scl, method = "step-down")                                   )                  ))
stopifnot(  is.null(   names(         pvalue(spl_scl, method = "unadjusted")                                  )                  ))
## stopifnot(  is.null(   names(      midpvalue(spl_scl)                                                         )                  )) # NA
## stopifnot(identical(   names(pvalue_interval(spl_scl)                                                         ), c("p_0", "p_1") )) # NA
## stopifnot(  is.null(   names(           size(spl_scl, alpha = 0.05)                                           )                  )) # NA
rm(spl_scl, s)
