/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.expression.QueryResult;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;

public class CollectionResult<T>
implements IQueryResult<T> {
    private final Collection<T> collection;

    public CollectionResult(Collection<T> collection) {
        this.collection = collection == null ? Collections.emptySet() : collection;
    }

    @Override
    public IQueryResult<T> query(IQuery<T> query, IProgressMonitor monitor) {
        return query.perform(this.iterator());
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.collection.iterator();
    }

    @Override
    public T[] toArray(Class<T> clazz) {
        return QueryResult.toArray(this.collection, clazz);
    }

    @Override
    public Set<T> toSet() {
        return new HashSet<T>(this.collection);
    }

    @Override
    public Set<T> toUnmodifiableSet() {
        return this.collection instanceof Set ? Collections.unmodifiableSet((Set)this.collection) : this.toSet();
    }

    public String toString() {
        return this.collection.toString();
    }

    @Override
    public Stream<T> stream() {
        return this.collection.stream();
    }
}

