% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keltnerChannels.R
\name{keltnerChannels}
\alias{keltnerChannels}
\title{Keltner Channels}
\usage{
keltnerChannels(HLC, n = 20, maType, atr = 2, ...)
}
\arguments{
\item{HLC}{Object that is coercible to xts or matrix and contains
High-Low-Close prices. If only a univariate series is given, it will be used.
See details.}

\item{n}{Number of periods for moving average.}

\item{maType}{A function or a string naming the function to be called.}

\item{atr}{The number of average true range distances to apply.}

\item{...}{Other arguments to be passed to the maType function.}
}
\value{
A object of the same class as \code{HLC} or a matrix (if
\code{try.xts} fails) containing the columns:
 \describe{
    \item{SMA}{ Simple moving average. }
    \item{EMA}{ Exponential moving average. }
 }

\item{dn}{ The lower Keltner Channel. }
\item{mavg}{ The middle moving average. }
\item{up}{ The upper Keltner Channel. }
}
\description{
Keltner Channels are volatility-based envelopes set above and below a moving
average. This indicator is similar to Bollinger Bands, but Keltner Channels
use the Average True Range (ATR) to set channel distance.
}
\details{
Keltner Channels are a trend following indicator, and can also be used to
identify overbought and oversold levels when there is no trend.

Chester Keltner is credited with the original version of Keltner Channels in
his 1960 book. Linda Bradford Raschke introduced the newer version of
Keltner Channels in the 1980s.
}
\section{Details }{
 Keltner Channels consist of three lines:
The middle band is generally a 20-period EMA of the typical price
([high + low + close]/3). The upper and lower bands are multiples of average
true range (usually 2) above and below the MA.

The middle band is usually calculated using the typical price, but if a
univariate series (e.g. Close, Weighted Close, Median Price, etc.) is
provided, it will be used instead.
}

\examples{

data(ttrc)
kc <- keltnerChannels(ttrc[,c("High","Low","Close")])

}
\references{
The following site(s) were used to code/document this
indicator:\cr
\url{https://school.stockcharts.com/doku.php?id=technical_indicators:keltner_channels}\cr
\url{https://www.linnsoft.com/techind/keltner-channels-keltu-keltd}\cr
\url{https://www.investopedia.com/terms/k/keltnerchannel.asp}\cr
}
\seealso{
See \code{\link{EMA}}, \code{\link{SMA}}, etc. for moving average
options; and note Warning section.
}
\author{
Nick Procyk, Joshua Ulrich

References
}
\keyword{ts}
