// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Hubble

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.3
// 	protoc        (unknown)
// source: tetragon/tetragon.proto

package tetragon

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type KprobeAction int32

const (
	// Unknown action
	KprobeAction_KPROBE_ACTION_UNKNOWN KprobeAction = 0
	// Post action creates an event (default action).
	KprobeAction_KPROBE_ACTION_POST KprobeAction = 1
	// Post action creates a mapping between file descriptors and file names.
	KprobeAction_KPROBE_ACTION_FOLLOWFD KprobeAction = 2
	// Sigkill action synchronously terminates the process.
	KprobeAction_KPROBE_ACTION_SIGKILL KprobeAction = 3
	// Post action removes a mapping between file descriptors and file names.
	KprobeAction_KPROBE_ACTION_UNFOLLOWFD KprobeAction = 4
	// Override action modifies the return value of the call.
	KprobeAction_KPROBE_ACTION_OVERRIDE KprobeAction = 5
	// Post action dupplicates a mapping between file descriptors and file
	// names.
	KprobeAction_KPROBE_ACTION_COPYFD KprobeAction = 6
	// GetURL action issue an HTTP Get request against an URL from userspace.
	KprobeAction_KPROBE_ACTION_GETURL KprobeAction = 7
	// GetURL action issue a DNS lookup against an URL from userspace.
	KprobeAction_KPROBE_ACTION_DNSLOOKUP KprobeAction = 8
	// NoPost action suppresses the transmission of the event to userspace.
	KprobeAction_KPROBE_ACTION_NOPOST KprobeAction = 9
	// Signal action sends specified signal to the process.
	KprobeAction_KPROBE_ACTION_SIGNAL KprobeAction = 10
	// TrackSock action tracks socket.
	KprobeAction_KPROBE_ACTION_TRACKSOCK KprobeAction = 11
	// UntrackSock action un-tracks socket.
	KprobeAction_KPROBE_ACTION_UNTRACKSOCK KprobeAction = 12
	// NotifyEnforcer action notifies enforcer sensor.
	KprobeAction_KPROBE_ACTION_NOTIFYENFORCER KprobeAction = 13
	// CleanupEnforcerNotification action cleanups any state left by NotifyEnforcer
	KprobeAction_KPROBE_ACTION_CLEANUPENFORCERNOTIFICATION KprobeAction = 14
)

// Enum value maps for KprobeAction.
var (
	KprobeAction_name = map[int32]string{
		0:  "KPROBE_ACTION_UNKNOWN",
		1:  "KPROBE_ACTION_POST",
		2:  "KPROBE_ACTION_FOLLOWFD",
		3:  "KPROBE_ACTION_SIGKILL",
		4:  "KPROBE_ACTION_UNFOLLOWFD",
		5:  "KPROBE_ACTION_OVERRIDE",
		6:  "KPROBE_ACTION_COPYFD",
		7:  "KPROBE_ACTION_GETURL",
		8:  "KPROBE_ACTION_DNSLOOKUP",
		9:  "KPROBE_ACTION_NOPOST",
		10: "KPROBE_ACTION_SIGNAL",
		11: "KPROBE_ACTION_TRACKSOCK",
		12: "KPROBE_ACTION_UNTRACKSOCK",
		13: "KPROBE_ACTION_NOTIFYENFORCER",
		14: "KPROBE_ACTION_CLEANUPENFORCERNOTIFICATION",
	}
	KprobeAction_value = map[string]int32{
		"KPROBE_ACTION_UNKNOWN":                     0,
		"KPROBE_ACTION_POST":                        1,
		"KPROBE_ACTION_FOLLOWFD":                    2,
		"KPROBE_ACTION_SIGKILL":                     3,
		"KPROBE_ACTION_UNFOLLOWFD":                  4,
		"KPROBE_ACTION_OVERRIDE":                    5,
		"KPROBE_ACTION_COPYFD":                      6,
		"KPROBE_ACTION_GETURL":                      7,
		"KPROBE_ACTION_DNSLOOKUP":                   8,
		"KPROBE_ACTION_NOPOST":                      9,
		"KPROBE_ACTION_SIGNAL":                      10,
		"KPROBE_ACTION_TRACKSOCK":                   11,
		"KPROBE_ACTION_UNTRACKSOCK":                 12,
		"KPROBE_ACTION_NOTIFYENFORCER":              13,
		"KPROBE_ACTION_CLEANUPENFORCERNOTIFICATION": 14,
	}
)

func (x KprobeAction) Enum() *KprobeAction {
	p := new(KprobeAction)
	*p = x
	return p
}

func (x KprobeAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KprobeAction) Descriptor() protoreflect.EnumDescriptor {
	return file_tetragon_tetragon_proto_enumTypes[0].Descriptor()
}

func (KprobeAction) Type() protoreflect.EnumType {
	return &file_tetragon_tetragon_proto_enumTypes[0]
}

func (x KprobeAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KprobeAction.Descriptor instead.
func (KprobeAction) EnumDescriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{0}
}

type HealthStatusType int32

const (
	HealthStatusType_HEALTH_STATUS_TYPE_UNDEF  HealthStatusType = 0
	HealthStatusType_HEALTH_STATUS_TYPE_STATUS HealthStatusType = 1
)

// Enum value maps for HealthStatusType.
var (
	HealthStatusType_name = map[int32]string{
		0: "HEALTH_STATUS_TYPE_UNDEF",
		1: "HEALTH_STATUS_TYPE_STATUS",
	}
	HealthStatusType_value = map[string]int32{
		"HEALTH_STATUS_TYPE_UNDEF":  0,
		"HEALTH_STATUS_TYPE_STATUS": 1,
	}
)

func (x HealthStatusType) Enum() *HealthStatusType {
	p := new(HealthStatusType)
	*p = x
	return p
}

func (x HealthStatusType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthStatusType) Descriptor() protoreflect.EnumDescriptor {
	return file_tetragon_tetragon_proto_enumTypes[1].Descriptor()
}

func (HealthStatusType) Type() protoreflect.EnumType {
	return &file_tetragon_tetragon_proto_enumTypes[1]
}

func (x HealthStatusType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthStatusType.Descriptor instead.
func (HealthStatusType) EnumDescriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{1}
}

type HealthStatusResult int32

const (
	HealthStatusResult_HEALTH_STATUS_UNDEF   HealthStatusResult = 0
	HealthStatusResult_HEALTH_STATUS_RUNNING HealthStatusResult = 1
	HealthStatusResult_HEALTH_STATUS_STOPPED HealthStatusResult = 2
	HealthStatusResult_HEALTH_STATUS_ERROR   HealthStatusResult = 3
)

// Enum value maps for HealthStatusResult.
var (
	HealthStatusResult_name = map[int32]string{
		0: "HEALTH_STATUS_UNDEF",
		1: "HEALTH_STATUS_RUNNING",
		2: "HEALTH_STATUS_STOPPED",
		3: "HEALTH_STATUS_ERROR",
	}
	HealthStatusResult_value = map[string]int32{
		"HEALTH_STATUS_UNDEF":   0,
		"HEALTH_STATUS_RUNNING": 1,
		"HEALTH_STATUS_STOPPED": 2,
		"HEALTH_STATUS_ERROR":   3,
	}
)

func (x HealthStatusResult) Enum() *HealthStatusResult {
	p := new(HealthStatusResult)
	*p = x
	return p
}

func (x HealthStatusResult) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthStatusResult) Descriptor() protoreflect.EnumDescriptor {
	return file_tetragon_tetragon_proto_enumTypes[2].Descriptor()
}

func (HealthStatusResult) Type() protoreflect.EnumType {
	return &file_tetragon_tetragon_proto_enumTypes[2]
}

func (x HealthStatusResult) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthStatusResult.Descriptor instead.
func (HealthStatusResult) EnumDescriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{2}
}

// Tainted bits to indicate if the kernel was tainted. For further details: https://docs.kernel.org/admin-guide/tainted-kernels.html
type TaintedBitsType int32

const (
	TaintedBitsType_TAINT_UNSET TaintedBitsType = 0
	// A proprietary module was loaded.
	TaintedBitsType_TAINT_PROPRIETARY_MODULE TaintedBitsType = 1
	// A module was force loaded.
	TaintedBitsType_TAINT_FORCED_MODULE TaintedBitsType = 2
	// A module was force unloaded.
	TaintedBitsType_TAINT_FORCED_UNLOAD_MODULE TaintedBitsType = 4
	// A staging driver was loaded.
	TaintedBitsType_TAINT_STAGED_MODULE TaintedBitsType = 1024
	// An out of tree module was loaded.
	TaintedBitsType_TAINT_OUT_OF_TREE_MODULE TaintedBitsType = 4096
	// An unsigned module was loaded. Supported only on kernels built with CONFIG_MODULE_SIG option.
	TaintedBitsType_TAINT_UNSIGNED_MODULE TaintedBitsType = 8192
	// The kernel has been live patched.
	TaintedBitsType_TAINT_KERNEL_LIVE_PATCH_MODULE TaintedBitsType = 32768
	// Loading a test module.
	TaintedBitsType_TAINT_TEST_MODULE TaintedBitsType = 262144
)

// Enum value maps for TaintedBitsType.
var (
	TaintedBitsType_name = map[int32]string{
		0:      "TAINT_UNSET",
		1:      "TAINT_PROPRIETARY_MODULE",
		2:      "TAINT_FORCED_MODULE",
		4:      "TAINT_FORCED_UNLOAD_MODULE",
		1024:   "TAINT_STAGED_MODULE",
		4096:   "TAINT_OUT_OF_TREE_MODULE",
		8192:   "TAINT_UNSIGNED_MODULE",
		32768:  "TAINT_KERNEL_LIVE_PATCH_MODULE",
		262144: "TAINT_TEST_MODULE",
	}
	TaintedBitsType_value = map[string]int32{
		"TAINT_UNSET":                    0,
		"TAINT_PROPRIETARY_MODULE":       1,
		"TAINT_FORCED_MODULE":            2,
		"TAINT_FORCED_UNLOAD_MODULE":     4,
		"TAINT_STAGED_MODULE":            1024,
		"TAINT_OUT_OF_TREE_MODULE":       4096,
		"TAINT_UNSIGNED_MODULE":          8192,
		"TAINT_KERNEL_LIVE_PATCH_MODULE": 32768,
		"TAINT_TEST_MODULE":              262144,
	}
)

func (x TaintedBitsType) Enum() *TaintedBitsType {
	p := new(TaintedBitsType)
	*p = x
	return p
}

func (x TaintedBitsType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TaintedBitsType) Descriptor() protoreflect.EnumDescriptor {
	return file_tetragon_tetragon_proto_enumTypes[3].Descriptor()
}

func (TaintedBitsType) Type() protoreflect.EnumType {
	return &file_tetragon_tetragon_proto_enumTypes[3]
}

func (x TaintedBitsType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TaintedBitsType.Descriptor instead.
func (TaintedBitsType) EnumDescriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{3}
}

type Image struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Identifier of the container image composed of the registry path and the
	// sha256.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the container image composed of the registry path and the tag.
	Name          string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Image) Reset() {
	*x = Image{}
	mi := &file_tetragon_tetragon_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Image) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Image) ProtoMessage() {}

func (x *Image) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Image.ProtoReflect.Descriptor instead.
func (*Image) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{0}
}

func (x *Image) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Image) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type SecurityContext struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// True if this container is priviledged.
	Privileged    bool `protobuf:"varint,1,opt,name=privileged,proto3" json:"privileged,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SecurityContext) Reset() {
	*x = SecurityContext{}
	mi := &file_tetragon_tetragon_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecurityContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityContext) ProtoMessage() {}

func (x *SecurityContext) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityContext.ProtoReflect.Descriptor instead.
func (*SecurityContext) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{1}
}

func (x *SecurityContext) GetPrivileged() bool {
	if x != nil {
		return x.Privileged
	}
	return false
}

type Container struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Identifier of the container.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the container.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Image of the container.
	Image *Image `protobuf:"bytes,3,opt,name=image,proto3" json:"image,omitempty"`
	// Start time of the container.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Process identifier in the container namespace.
	Pid *wrapperspb.UInt32Value `protobuf:"bytes,5,opt,name=pid,proto3" json:"pid,omitempty"`
	// If this is set true, it means that the process might have been originated from
	// a Kubernetes exec probe. For this field to be true, the following must be true:
	//  1. The binary field matches the first element of the exec command list for either
	//     liveness or readiness probe excluding the basename. For example, "/bin/ls"
	//     and "ls" are considered a match.
	//  2. The arguments field exactly matches the rest of the exec command list.
	MaybeExecProbe bool `protobuf:"varint,13,opt,name=maybe_exec_probe,json=maybeExecProbe,proto3" json:"maybe_exec_probe,omitempty"`
	// The security context of the container
	SecurityContext *SecurityContext `protobuf:"bytes,14,opt,name=security_context,json=securityContext,proto3" json:"security_context,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Container) Reset() {
	*x = Container{}
	mi := &file_tetragon_tetragon_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Container) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Container) ProtoMessage() {}

func (x *Container) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Container.ProtoReflect.Descriptor instead.
func (*Container) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{2}
}

func (x *Container) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Container) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Container) GetImage() *Image {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *Container) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Container) GetPid() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Pid
	}
	return nil
}

func (x *Container) GetMaybeExecProbe() bool {
	if x != nil {
		return x.MaybeExecProbe
	}
	return false
}

func (x *Container) GetSecurityContext() *SecurityContext {
	if x != nil {
		return x.SecurityContext
	}
	return nil
}

type Pod struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Kubernetes namespace of the Pod.
	Namespace string `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Name of the Pod.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Container of the Pod from which the process that triggered the event
	// originates.
	Container *Container `protobuf:"bytes,4,opt,name=container,proto3" json:"container,omitempty"`
	// Contains all the labels of the pod.
	PodLabels map[string]string `protobuf:"bytes,5,rep,name=pod_labels,json=podLabels,proto3" json:"pod_labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Kubernetes workload of the Pod.
	Workload string `protobuf:"bytes,6,opt,name=workload,proto3" json:"workload,omitempty"`
	// Kubernetes workload kind (e.g. "Deployment", "DaemonSet") of the Pod.
	WorkloadKind string `protobuf:"bytes,7,opt,name=workload_kind,json=workloadKind,proto3" json:"workload_kind,omitempty"`
	// Contains all the annotations of the pod.
	PodAnnotations map[string]string `protobuf:"bytes,8,rep,name=pod_annotations,json=podAnnotations,proto3" json:"pod_annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *Pod) Reset() {
	*x = Pod{}
	mi := &file_tetragon_tetragon_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Pod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pod) ProtoMessage() {}

func (x *Pod) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pod.ProtoReflect.Descriptor instead.
func (*Pod) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{3}
}

func (x *Pod) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *Pod) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Pod) GetContainer() *Container {
	if x != nil {
		return x.Container
	}
	return nil
}

func (x *Pod) GetPodLabels() map[string]string {
	if x != nil {
		return x.PodLabels
	}
	return nil
}

func (x *Pod) GetWorkload() string {
	if x != nil {
		return x.Workload
	}
	return ""
}

func (x *Pod) GetWorkloadKind() string {
	if x != nil {
		return x.WorkloadKind
	}
	return ""
}

func (x *Pod) GetPodAnnotations() map[string]string {
	if x != nil {
		return x.PodAnnotations
	}
	return nil
}

type Capabilities struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Permitted set indicates what capabilities the process can use. This is a
	// limiting superset for the effective capabilities that the thread may
	// assume. It is also a limiting superset for the capabilities that may be
	// added to the inheritable set by a thread without the CAP_SETPCAP in its
	// effective set.
	Permitted []CapabilitiesType `protobuf:"varint,1,rep,packed,name=permitted,proto3,enum=tetragon.CapabilitiesType" json:"permitted,omitempty"`
	// Effective set indicates what capabilities are active in a process. This
	// is the set used by the kernel to perform permission checks for the
	// thread.
	Effective []CapabilitiesType `protobuf:"varint,2,rep,packed,name=effective,proto3,enum=tetragon.CapabilitiesType" json:"effective,omitempty"`
	// Inheritable set indicates which capabilities will be inherited by the
	// current process when running as a root user.
	Inheritable   []CapabilitiesType `protobuf:"varint,3,rep,packed,name=inheritable,proto3,enum=tetragon.CapabilitiesType" json:"inheritable,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Capabilities) Reset() {
	*x = Capabilities{}
	mi := &file_tetragon_tetragon_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Capabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Capabilities) ProtoMessage() {}

func (x *Capabilities) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Capabilities.ProtoReflect.Descriptor instead.
func (*Capabilities) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{4}
}

func (x *Capabilities) GetPermitted() []CapabilitiesType {
	if x != nil {
		return x.Permitted
	}
	return nil
}

func (x *Capabilities) GetEffective() []CapabilitiesType {
	if x != nil {
		return x.Effective
	}
	return nil
}

func (x *Capabilities) GetInheritable() []CapabilitiesType {
	if x != nil {
		return x.Inheritable
	}
	return nil
}

type Namespace struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Inode number of the namespace.
	Inum uint32 `protobuf:"varint,1,opt,name=inum,proto3" json:"inum,omitempty"`
	// Indicates if namespace belongs to host.
	IsHost        bool `protobuf:"varint,2,opt,name=is_host,json=isHost,proto3" json:"is_host,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Namespace) Reset() {
	*x = Namespace{}
	mi := &file_tetragon_tetragon_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Namespace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Namespace) ProtoMessage() {}

func (x *Namespace) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Namespace.ProtoReflect.Descriptor instead.
func (*Namespace) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{5}
}

func (x *Namespace) GetInum() uint32 {
	if x != nil {
		return x.Inum
	}
	return 0
}

func (x *Namespace) GetIsHost() bool {
	if x != nil {
		return x.IsHost
	}
	return false
}

type Namespaces struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Hostname and NIS domain name.
	Uts *Namespace `protobuf:"bytes,1,opt,name=uts,proto3" json:"uts,omitempty"`
	// System V IPC, POSIX message queues.
	Ipc *Namespace `protobuf:"bytes,2,opt,name=ipc,proto3" json:"ipc,omitempty"`
	// Mount points.
	Mnt *Namespace `protobuf:"bytes,3,opt,name=mnt,proto3" json:"mnt,omitempty"`
	// Process IDs.
	Pid *Namespace `protobuf:"bytes,4,opt,name=pid,proto3" json:"pid,omitempty"`
	// Process IDs for children processes.
	PidForChildren *Namespace `protobuf:"bytes,5,opt,name=pid_for_children,json=pidForChildren,proto3" json:"pid_for_children,omitempty"`
	// Network devices, stacks, ports, etc.
	Net *Namespace `protobuf:"bytes,6,opt,name=net,proto3" json:"net,omitempty"`
	// Boot and monotonic clocks.
	Time *Namespace `protobuf:"bytes,7,opt,name=time,proto3" json:"time,omitempty"`
	// Boot and monotonic clocks for children processes.
	TimeForChildren *Namespace `protobuf:"bytes,8,opt,name=time_for_children,json=timeForChildren,proto3" json:"time_for_children,omitempty"`
	// Cgroup root directory.
	Cgroup *Namespace `protobuf:"bytes,9,opt,name=cgroup,proto3" json:"cgroup,omitempty"`
	// User and group IDs.
	User          *Namespace `protobuf:"bytes,10,opt,name=user,proto3" json:"user,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Namespaces) Reset() {
	*x = Namespaces{}
	mi := &file_tetragon_tetragon_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Namespaces) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Namespaces) ProtoMessage() {}

func (x *Namespaces) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Namespaces.ProtoReflect.Descriptor instead.
func (*Namespaces) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{6}
}

func (x *Namespaces) GetUts() *Namespace {
	if x != nil {
		return x.Uts
	}
	return nil
}

func (x *Namespaces) GetIpc() *Namespace {
	if x != nil {
		return x.Ipc
	}
	return nil
}

func (x *Namespaces) GetMnt() *Namespace {
	if x != nil {
		return x.Mnt
	}
	return nil
}

func (x *Namespaces) GetPid() *Namespace {
	if x != nil {
		return x.Pid
	}
	return nil
}

func (x *Namespaces) GetPidForChildren() *Namespace {
	if x != nil {
		return x.PidForChildren
	}
	return nil
}

func (x *Namespaces) GetNet() *Namespace {
	if x != nil {
		return x.Net
	}
	return nil
}

func (x *Namespaces) GetTime() *Namespace {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *Namespaces) GetTimeForChildren() *Namespace {
	if x != nil {
		return x.TimeForChildren
	}
	return nil
}

func (x *Namespaces) GetCgroup() *Namespace {
	if x != nil {
		return x.Cgroup
	}
	return nil
}

func (x *Namespaces) GetUser() *Namespace {
	if x != nil {
		return x.User
	}
	return nil
}

type UserNamespace struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Nested level of the user namespace. Init or host user namespace is at level 0.
	Level *wrapperspb.Int32Value `protobuf:"bytes,1,opt,name=level,proto3" json:"level,omitempty"`
	// The owner user ID of the namespace
	Uid *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// The owner group ID of the namepace.
	Gid *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=gid,proto3" json:"gid,omitempty"`
	// The user namespace details that include the inode number of the namespace.
	Ns            *Namespace `protobuf:"bytes,4,opt,name=ns,proto3" json:"ns,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserNamespace) Reset() {
	*x = UserNamespace{}
	mi := &file_tetragon_tetragon_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserNamespace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserNamespace) ProtoMessage() {}

func (x *UserNamespace) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserNamespace.ProtoReflect.Descriptor instead.
func (*UserNamespace) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{7}
}

func (x *UserNamespace) GetLevel() *wrapperspb.Int32Value {
	if x != nil {
		return x.Level
	}
	return nil
}

func (x *UserNamespace) GetUid() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Uid
	}
	return nil
}

func (x *UserNamespace) GetGid() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Gid
	}
	return nil
}

func (x *UserNamespace) GetNs() *Namespace {
	if x != nil {
		return x.Ns
	}
	return nil
}

type ProcessCredentials struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The real user ID of the process' owner.
	Uid *wrapperspb.UInt32Value `protobuf:"bytes,1,opt,name=uid,proto3" json:"uid,omitempty"`
	// The real group ID of the process' owner.
	Gid *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=gid,proto3" json:"gid,omitempty"`
	// The effective user ID used for permission checks.
	Euid *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=euid,proto3" json:"euid,omitempty"`
	// The effective group ID used for permission checks.
	Egid *wrapperspb.UInt32Value `protobuf:"bytes,4,opt,name=egid,proto3" json:"egid,omitempty"`
	// The saved user ID.
	Suid *wrapperspb.UInt32Value `protobuf:"bytes,5,opt,name=suid,proto3" json:"suid,omitempty"`
	// The saved group ID.
	Sgid *wrapperspb.UInt32Value `protobuf:"bytes,6,opt,name=sgid,proto3" json:"sgid,omitempty"`
	// the filesystem user ID used for filesystem access checks. Usually equals the euid.
	Fsuid *wrapperspb.UInt32Value `protobuf:"bytes,7,opt,name=fsuid,proto3" json:"fsuid,omitempty"`
	// The filesystem group ID used for filesystem access checks. Usually equals the egid.
	Fsgid *wrapperspb.UInt32Value `protobuf:"bytes,8,opt,name=fsgid,proto3" json:"fsgid,omitempty"`
	// Secure management flags
	Securebits []SecureBitsType `protobuf:"varint,9,rep,packed,name=securebits,proto3,enum=tetragon.SecureBitsType" json:"securebits,omitempty"`
	// Set of capabilities that define the permissions the process can execute with.
	Caps *Capabilities `protobuf:"bytes,10,opt,name=caps,proto3" json:"caps,omitempty"`
	// User namespace where the UIDs, GIDs and capabilities are relative to.
	UserNs        *UserNamespace `protobuf:"bytes,11,opt,name=user_ns,json=userNs,proto3" json:"user_ns,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProcessCredentials) Reset() {
	*x = ProcessCredentials{}
	mi := &file_tetragon_tetragon_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProcessCredentials) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessCredentials) ProtoMessage() {}

func (x *ProcessCredentials) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessCredentials.ProtoReflect.Descriptor instead.
func (*ProcessCredentials) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{8}
}

func (x *ProcessCredentials) GetUid() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Uid
	}
	return nil
}

func (x *ProcessCredentials) GetGid() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Gid
	}
	return nil
}

func (x *ProcessCredentials) GetEuid() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Euid
	}
	return nil
}

func (x *ProcessCredentials) GetEgid() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Egid
	}
	return nil
}

func (x *ProcessCredentials) GetSuid() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Suid
	}
	return nil
}

func (x *ProcessCredentials) GetSgid() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Sgid
	}
	return nil
}

func (x *ProcessCredentials) GetFsuid() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Fsuid
	}
	return nil
}

func (x *ProcessCredentials) GetFsgid() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Fsgid
	}
	return nil
}

func (x *ProcessCredentials) GetSecurebits() []SecureBitsType {
	if x != nil {
		return x.Securebits
	}
	return nil
}

func (x *ProcessCredentials) GetCaps() *Capabilities {
	if x != nil {
		return x.Caps
	}
	return nil
}

func (x *ProcessCredentials) GetUserNs() *UserNamespace {
	if x != nil {
		return x.UserNs
	}
	return nil
}

type InodeProperties struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The inode number
	Number uint64 `protobuf:"varint,1,opt,name=number,proto3" json:"number,omitempty"`
	// The inode links on the file system. If zero means the file is only in memory
	Links         *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=links,proto3" json:"links,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InodeProperties) Reset() {
	*x = InodeProperties{}
	mi := &file_tetragon_tetragon_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InodeProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InodeProperties) ProtoMessage() {}

func (x *InodeProperties) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InodeProperties.ProtoReflect.Descriptor instead.
func (*InodeProperties) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{9}
}

func (x *InodeProperties) GetNumber() uint64 {
	if x != nil {
		return x.Number
	}
	return 0
}

func (x *InodeProperties) GetLinks() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Links
	}
	return nil
}

type FileProperties struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Inode of the file
	Inode *InodeProperties `protobuf:"bytes,1,opt,name=inode,proto3" json:"inode,omitempty"`
	// Path of the file
	Path          string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FileProperties) Reset() {
	*x = FileProperties{}
	mi := &file_tetragon_tetragon_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileProperties) ProtoMessage() {}

func (x *FileProperties) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileProperties.ProtoReflect.Descriptor instead.
func (*FileProperties) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{10}
}

func (x *FileProperties) GetInode() *InodeProperties {
	if x != nil {
		return x.Inode
	}
	return nil
}

func (x *FileProperties) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

type BinaryProperties struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// If set then this is the set user ID used for execution
	Setuid *wrapperspb.UInt32Value `protobuf:"bytes,1,opt,name=setuid,proto3" json:"setuid,omitempty"`
	// If set then this is the set group ID used for execution
	Setgid *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=setgid,proto3" json:"setgid,omitempty"`
	// The reasons why this binary execution changed privileges. Usually this happens when the process executes
	// a binary with the set-user-ID to root or file capability sets.
	// The final granted privileges can be listed inside the `process_credentials` or capabilities fields part of of the `process` object.
	PrivilegesChanged []ProcessPrivilegesChanged `protobuf:"varint,3,rep,packed,name=privileges_changed,json=privilegesChanged,proto3,enum=tetragon.ProcessPrivilegesChanged" json:"privileges_changed,omitempty"`
	// File properties in case the executed binary is:
	// 1. An anonymous shared memory file https://man7.org/linux/man-pages/man7/shm_overview.7.html.
	// 2. An anonymous file obtained with memfd API https://man7.org/linux/man-pages/man2/memfd_create.2.html.
	// 3. Or it was deleted from the file system.
	File          *FileProperties `protobuf:"bytes,4,opt,name=file,proto3" json:"file,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *BinaryProperties) Reset() {
	*x = BinaryProperties{}
	mi := &file_tetragon_tetragon_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BinaryProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BinaryProperties) ProtoMessage() {}

func (x *BinaryProperties) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BinaryProperties.ProtoReflect.Descriptor instead.
func (*BinaryProperties) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{11}
}

func (x *BinaryProperties) GetSetuid() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Setuid
	}
	return nil
}

func (x *BinaryProperties) GetSetgid() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Setgid
	}
	return nil
}

func (x *BinaryProperties) GetPrivilegesChanged() []ProcessPrivilegesChanged {
	if x != nil {
		return x.PrivilegesChanged
	}
	return nil
}

func (x *BinaryProperties) GetFile() *FileProperties {
	if x != nil {
		return x.File
	}
	return nil
}

// User records
type UserRecord struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The UNIX username for this record. Corresponds to `pw_name` field of [struct passwd](https://man7.org/linux/man-pages/man3/getpwnam.3.html)
	// and the `sp_namp` field of [struct spwd](https://man7.org/linux/man-pages/man3/getspnam.3.html).
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserRecord) Reset() {
	*x = UserRecord{}
	mi := &file_tetragon_tetragon_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserRecord) ProtoMessage() {}

func (x *UserRecord) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserRecord.ProtoReflect.Descriptor instead.
func (*UserRecord) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{12}
}

func (x *UserRecord) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type Process struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Exec ID uniquely identifies the process over time across all the nodes in the cluster.
	ExecId string `protobuf:"bytes,1,opt,name=exec_id,json=execId,proto3" json:"exec_id,omitempty"`
	// Process identifier from host PID namespace.
	Pid *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=pid,proto3" json:"pid,omitempty"`
	// The effective User identifier used for permission checks. This field maps to the
	// 'ProcessCredentials.euid' field. Run with the `--enable-process-cred` flag to
	// enable 'ProcessCredentials' and get all the User and Group identifiers.
	Uid *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=uid,proto3" json:"uid,omitempty"`
	// Current working directory of the process.
	Cwd string `protobuf:"bytes,4,opt,name=cwd,proto3" json:"cwd,omitempty"`
	// Absolute path of the executed binary.
	Binary string `protobuf:"bytes,5,opt,name=binary,proto3" json:"binary,omitempty"`
	// Arguments passed to the binary at execution.
	Arguments string `protobuf:"bytes,6,opt,name=arguments,proto3" json:"arguments,omitempty"`
	// Flags are for debugging purposes only and should not be considered a
	// reliable source of information. They hold various information about
	// which syscalls generated events, use of internal Tetragon buffers,
	// errors and more.
	// - `execve` This event is generated by an execve syscall for a new
	// process. See procFs for the other option. A correctly formatted event
	// should either set execve or procFS (described next).
	// - `procFS` This event is generated from a proc interface. This happens
	// at Tetragon init when existing processes are being loaded into Tetragon
	// event buffer. All events should have either execve or procFS set.
	// - `truncFilename` Indicates a truncated processes filename because the
	// buffer size is too small to contain the process filename. Consider
	// increasing buffer size to avoid this.
	// - `truncArgs` Indicates truncated the processes arguments because the
	// buffer size was too small to contain all exec args. Consider increasing
	// buffer size to avoid this.
	// - `taskWalk` Primarily useful for debugging. Indicates a walked process
	// hierarchy to find a parent process in the Tetragon buffer. This may
	// happen when we did not receive an exec event for the immediate parent of
	// a process. Typically means we are looking at a fork that in turn did
	// another fork we don't currently track fork events exactly and instead
	// push an event with the original parent exec data. This flag can provide
	// this insight into the event if needed.
	// - `miss` An error flag indicating we could not find parent info in the
	// Tetragon event buffer. If this is set it should be reported to Tetragon
	// developers for debugging. Tetragon will do its best to recover
	// information about the process from available kernel data structures
	// instead of using cached info in this case. However, args will not be
	// available.
	// - `needsAUID` An internal flag for Tetragon to indicate the audit has
	// not yet been resolved. The BPF hooks look at this flag to determine if
	// probing the audit system is necessary.
	// - `errorFilename` An error flag indicating an error happened while
	// reading the filename. If this is set it should be reported to Tetragon
	// developers for debugging.
	// - `errorArgs` An error flag indicating an error happened while reading
	// the process args. If this is set it should be reported to Tetragon
	// developers for debugging
	// - `needsCWD` An internal flag for Tetragon to indicate the current
	// working directory has not yet been resolved. The Tetragon hooks look at
	// this flag to determine if probing the CWD is necessary.
	// - `noCWDSupport` Indicates that CWD is removed from the event because
	// the buffer size is too small. Consider increasing buffer size to avoid
	// this.
	// - `rootCWD` Indicates that CWD is the root directory. This is necessary
	// to inform readers the CWD is not in the event buffer and is '/' instead.
	// - `errorCWD` An error flag indicating an error occurred while reading
	// the CWD of a process. If this is set it should be reported to Tetragon
	// developers for debugging.
	// - `clone` Indicates the process issued a clone before exec*. This is the
	// general flow to exec* a new process, however its possible to replace the
	// current process with a new process by doing an exec* without a clone. In
	// this case the flag will be omitted and the same PID will be used by the
	// kernel for both the old process and the newly exec'd process.
	// - `unknown` Indicates the process was not found in the process cache
	// and contains just pid and start time.
	Flags string `protobuf:"bytes,7,opt,name=flags,proto3" json:"flags,omitempty"`
	// Start time of the execution.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Audit user ID, this ID is assigned to a user upon login and is inherited
	// by every process even when the user's identity changes. For example, by
	// switching user accounts with su - john.
	Auid *wrapperspb.UInt32Value `protobuf:"bytes,9,opt,name=auid,proto3" json:"auid,omitempty"`
	// Information about the the Kubernetes Pod where the event originated.
	Pod *Pod `protobuf:"bytes,10,opt,name=pod,proto3" json:"pod,omitempty"`
	// The 15 first digits of the container ID.
	Docker string `protobuf:"bytes,11,opt,name=docker,proto3" json:"docker,omitempty"`
	// Exec ID of the parent process.
	ParentExecId string `protobuf:"bytes,12,opt,name=parent_exec_id,json=parentExecId,proto3" json:"parent_exec_id,omitempty"`
	// Reference counter from the Tetragon process cache.
	Refcnt uint32 `protobuf:"varint,13,opt,name=refcnt,proto3" json:"refcnt,omitempty"`
	// Set of capabilities that define the permissions the process can execute with.
	Cap *Capabilities `protobuf:"bytes,14,opt,name=cap,proto3" json:"cap,omitempty"`
	// Linux namespaces of the process, disabled by default, can be enabled by
	// the `--enable-process-ns` flag.
	Ns *Namespaces `protobuf:"bytes,15,opt,name=ns,proto3" json:"ns,omitempty"`
	// Thread ID, note that for the thread group leader, tid is equal to pid.
	Tid *wrapperspb.UInt32Value `protobuf:"bytes,16,opt,name=tid,proto3" json:"tid,omitempty"`
	// Process credentials, disabled by default, can be enabled by the
	// `--enable-process-cred` flag.
	ProcessCredentials *ProcessCredentials `protobuf:"bytes,17,opt,name=process_credentials,json=processCredentials,proto3" json:"process_credentials,omitempty"`
	// Executed binary properties. This field is only available on ProcessExec events.
	BinaryProperties *BinaryProperties `protobuf:"bytes,18,opt,name=binary_properties,json=binaryProperties,proto3" json:"binary_properties,omitempty"`
	// UserRecord contains user information about the event.
	// It is only supported when i) Tetragon is running as a systemd service or directly on the host, and
	// ii) when the flag `--username-metadata` is set to "unix". In this case, the information is retrieved from
	// the traditional user database `/etc/passwd` and no name services lookups are performed.
	// The resolution will only be attempted for processes in the host namespace.
	// Note that this resolution happens in user-space, which means that mapping might have changed
	// between the in-kernel BPF hook being executed and the username resolution.
	User *UserRecord `protobuf:"bytes,19,opt,name=user,proto3" json:"user,omitempty"`
	// If set to true, this process is containerized and is a member of the
	// process tree rooted at pid=1 in its PID namespace. This is useful if,
	// for example, you wish to discern whether a process was spawned using a
	// tool like nsenter or kubectl exec.
	InInitTree    *wrapperspb.BoolValue `protobuf:"bytes,20,opt,name=in_init_tree,json=inInitTree,proto3" json:"in_init_tree,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Process) Reset() {
	*x = Process{}
	mi := &file_tetragon_tetragon_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Process) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Process) ProtoMessage() {}

func (x *Process) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Process.ProtoReflect.Descriptor instead.
func (*Process) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{13}
}

func (x *Process) GetExecId() string {
	if x != nil {
		return x.ExecId
	}
	return ""
}

func (x *Process) GetPid() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Pid
	}
	return nil
}

func (x *Process) GetUid() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Uid
	}
	return nil
}

func (x *Process) GetCwd() string {
	if x != nil {
		return x.Cwd
	}
	return ""
}

func (x *Process) GetBinary() string {
	if x != nil {
		return x.Binary
	}
	return ""
}

func (x *Process) GetArguments() string {
	if x != nil {
		return x.Arguments
	}
	return ""
}

func (x *Process) GetFlags() string {
	if x != nil {
		return x.Flags
	}
	return ""
}

func (x *Process) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Process) GetAuid() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Auid
	}
	return nil
}

func (x *Process) GetPod() *Pod {
	if x != nil {
		return x.Pod
	}
	return nil
}

func (x *Process) GetDocker() string {
	if x != nil {
		return x.Docker
	}
	return ""
}

func (x *Process) GetParentExecId() string {
	if x != nil {
		return x.ParentExecId
	}
	return ""
}

func (x *Process) GetRefcnt() uint32 {
	if x != nil {
		return x.Refcnt
	}
	return 0
}

func (x *Process) GetCap() *Capabilities {
	if x != nil {
		return x.Cap
	}
	return nil
}

func (x *Process) GetNs() *Namespaces {
	if x != nil {
		return x.Ns
	}
	return nil
}

func (x *Process) GetTid() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Tid
	}
	return nil
}

func (x *Process) GetProcessCredentials() *ProcessCredentials {
	if x != nil {
		return x.ProcessCredentials
	}
	return nil
}

func (x *Process) GetBinaryProperties() *BinaryProperties {
	if x != nil {
		return x.BinaryProperties
	}
	return nil
}

func (x *Process) GetUser() *UserRecord {
	if x != nil {
		return x.User
	}
	return nil
}

func (x *Process) GetInInitTree() *wrapperspb.BoolValue {
	if x != nil {
		return x.InInitTree
	}
	return nil
}

type ProcessExec struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Process that triggered the exec.
	Process *Process `protobuf:"bytes,1,opt,name=process,proto3" json:"process,omitempty"`
	// Immediate parent of the process.
	Parent *Process `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// Ancestors of the process beyond the immediate parent.
	Ancestors     []*Process `protobuf:"bytes,3,rep,name=ancestors,proto3" json:"ancestors,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProcessExec) Reset() {
	*x = ProcessExec{}
	mi := &file_tetragon_tetragon_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProcessExec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessExec) ProtoMessage() {}

func (x *ProcessExec) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessExec.ProtoReflect.Descriptor instead.
func (*ProcessExec) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{14}
}

func (x *ProcessExec) GetProcess() *Process {
	if x != nil {
		return x.Process
	}
	return nil
}

func (x *ProcessExec) GetParent() *Process {
	if x != nil {
		return x.Parent
	}
	return nil
}

func (x *ProcessExec) GetAncestors() []*Process {
	if x != nil {
		return x.Ancestors
	}
	return nil
}

type ProcessExit struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Process that triggered the exit.
	Process *Process `protobuf:"bytes,1,opt,name=process,proto3" json:"process,omitempty"`
	// Immediate parent of the process.
	Parent *Process `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// Signal that the process received when it exited, for example SIGKILL or
	// SIGTERM (list all signal names with `kill -l`). If there is no signal
	// handler implemented for a specific process, we report the exit status
	// code that can be found in the status field.
	Signal string `protobuf:"bytes,3,opt,name=signal,proto3" json:"signal,omitempty"`
	// Status code on process exit. For example, the status code can indicate
	// if an error was encountered or the program exited successfully.
	Status uint32 `protobuf:"varint,4,opt,name=status,proto3" json:"status,omitempty"`
	// Date and time of the event.
	Time *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=time,proto3" json:"time,omitempty"`
	// Ancestors of the process beyond the immediate parent.
	Ancestors     []*Process `protobuf:"bytes,6,rep,name=ancestors,proto3" json:"ancestors,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProcessExit) Reset() {
	*x = ProcessExit{}
	mi := &file_tetragon_tetragon_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProcessExit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessExit) ProtoMessage() {}

func (x *ProcessExit) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessExit.ProtoReflect.Descriptor instead.
func (*ProcessExit) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{15}
}

func (x *ProcessExit) GetProcess() *Process {
	if x != nil {
		return x.Process
	}
	return nil
}

func (x *ProcessExit) GetParent() *Process {
	if x != nil {
		return x.Parent
	}
	return nil
}

func (x *ProcessExit) GetSignal() string {
	if x != nil {
		return x.Signal
	}
	return ""
}

func (x *ProcessExit) GetStatus() uint32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *ProcessExit) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *ProcessExit) GetAncestors() []*Process {
	if x != nil {
		return x.Ancestors
	}
	return nil
}

type KprobeSock struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Family        string                 `protobuf:"bytes,1,opt,name=family,proto3" json:"family,omitempty"`
	Type          string                 `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	Protocol      string                 `protobuf:"bytes,3,opt,name=protocol,proto3" json:"protocol,omitempty"`
	Mark          uint32                 `protobuf:"varint,4,opt,name=mark,proto3" json:"mark,omitempty"`
	Priority      uint32                 `protobuf:"varint,5,opt,name=priority,proto3" json:"priority,omitempty"`
	Saddr         string                 `protobuf:"bytes,6,opt,name=saddr,proto3" json:"saddr,omitempty"`
	Daddr         string                 `protobuf:"bytes,7,opt,name=daddr,proto3" json:"daddr,omitempty"`
	Sport         uint32                 `protobuf:"varint,8,opt,name=sport,proto3" json:"sport,omitempty"`
	Dport         uint32                 `protobuf:"varint,9,opt,name=dport,proto3" json:"dport,omitempty"`
	Cookie        uint64                 `protobuf:"varint,10,opt,name=cookie,proto3" json:"cookie,omitempty"`
	State         string                 `protobuf:"bytes,11,opt,name=state,proto3" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KprobeSock) Reset() {
	*x = KprobeSock{}
	mi := &file_tetragon_tetragon_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KprobeSock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KprobeSock) ProtoMessage() {}

func (x *KprobeSock) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KprobeSock.ProtoReflect.Descriptor instead.
func (*KprobeSock) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{16}
}

func (x *KprobeSock) GetFamily() string {
	if x != nil {
		return x.Family
	}
	return ""
}

func (x *KprobeSock) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *KprobeSock) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *KprobeSock) GetMark() uint32 {
	if x != nil {
		return x.Mark
	}
	return 0
}

func (x *KprobeSock) GetPriority() uint32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *KprobeSock) GetSaddr() string {
	if x != nil {
		return x.Saddr
	}
	return ""
}

func (x *KprobeSock) GetDaddr() string {
	if x != nil {
		return x.Daddr
	}
	return ""
}

func (x *KprobeSock) GetSport() uint32 {
	if x != nil {
		return x.Sport
	}
	return 0
}

func (x *KprobeSock) GetDport() uint32 {
	if x != nil {
		return x.Dport
	}
	return 0
}

func (x *KprobeSock) GetCookie() uint64 {
	if x != nil {
		return x.Cookie
	}
	return 0
}

func (x *KprobeSock) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

type KprobeSkb struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Hash          uint32                 `protobuf:"varint,1,opt,name=hash,proto3" json:"hash,omitempty"`
	Len           uint32                 `protobuf:"varint,2,opt,name=len,proto3" json:"len,omitempty"`
	Priority      uint32                 `protobuf:"varint,3,opt,name=priority,proto3" json:"priority,omitempty"`
	Mark          uint32                 `protobuf:"varint,4,opt,name=mark,proto3" json:"mark,omitempty"`
	Saddr         string                 `protobuf:"bytes,5,opt,name=saddr,proto3" json:"saddr,omitempty"`
	Daddr         string                 `protobuf:"bytes,6,opt,name=daddr,proto3" json:"daddr,omitempty"`
	Sport         uint32                 `protobuf:"varint,7,opt,name=sport,proto3" json:"sport,omitempty"`
	Dport         uint32                 `protobuf:"varint,8,opt,name=dport,proto3" json:"dport,omitempty"`
	Proto         uint32                 `protobuf:"varint,9,opt,name=proto,proto3" json:"proto,omitempty"`
	SecPathLen    uint32                 `protobuf:"varint,10,opt,name=sec_path_len,json=secPathLen,proto3" json:"sec_path_len,omitempty"`
	SecPathOlen   uint32                 `protobuf:"varint,11,opt,name=sec_path_olen,json=secPathOlen,proto3" json:"sec_path_olen,omitempty"`
	Protocol      string                 `protobuf:"bytes,12,opt,name=protocol,proto3" json:"protocol,omitempty"`
	Family        string                 `protobuf:"bytes,13,opt,name=family,proto3" json:"family,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KprobeSkb) Reset() {
	*x = KprobeSkb{}
	mi := &file_tetragon_tetragon_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KprobeSkb) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KprobeSkb) ProtoMessage() {}

func (x *KprobeSkb) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KprobeSkb.ProtoReflect.Descriptor instead.
func (*KprobeSkb) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{17}
}

func (x *KprobeSkb) GetHash() uint32 {
	if x != nil {
		return x.Hash
	}
	return 0
}

func (x *KprobeSkb) GetLen() uint32 {
	if x != nil {
		return x.Len
	}
	return 0
}

func (x *KprobeSkb) GetPriority() uint32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *KprobeSkb) GetMark() uint32 {
	if x != nil {
		return x.Mark
	}
	return 0
}

func (x *KprobeSkb) GetSaddr() string {
	if x != nil {
		return x.Saddr
	}
	return ""
}

func (x *KprobeSkb) GetDaddr() string {
	if x != nil {
		return x.Daddr
	}
	return ""
}

func (x *KprobeSkb) GetSport() uint32 {
	if x != nil {
		return x.Sport
	}
	return 0
}

func (x *KprobeSkb) GetDport() uint32 {
	if x != nil {
		return x.Dport
	}
	return 0
}

func (x *KprobeSkb) GetProto() uint32 {
	if x != nil {
		return x.Proto
	}
	return 0
}

func (x *KprobeSkb) GetSecPathLen() uint32 {
	if x != nil {
		return x.SecPathLen
	}
	return 0
}

func (x *KprobeSkb) GetSecPathOlen() uint32 {
	if x != nil {
		return x.SecPathOlen
	}
	return 0
}

func (x *KprobeSkb) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *KprobeSkb) GetFamily() string {
	if x != nil {
		return x.Family
	}
	return ""
}

type KprobeSockaddr struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Family        string                 `protobuf:"bytes,1,opt,name=family,proto3" json:"family,omitempty"`
	Addr          string                 `protobuf:"bytes,2,opt,name=addr,proto3" json:"addr,omitempty"`
	Port          uint32                 `protobuf:"varint,3,opt,name=port,proto3" json:"port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KprobeSockaddr) Reset() {
	*x = KprobeSockaddr{}
	mi := &file_tetragon_tetragon_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KprobeSockaddr) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KprobeSockaddr) ProtoMessage() {}

func (x *KprobeSockaddr) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KprobeSockaddr.ProtoReflect.Descriptor instead.
func (*KprobeSockaddr) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{18}
}

func (x *KprobeSockaddr) GetFamily() string {
	if x != nil {
		return x.Family
	}
	return ""
}

func (x *KprobeSockaddr) GetAddr() string {
	if x != nil {
		return x.Addr
	}
	return ""
}

func (x *KprobeSockaddr) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

type KprobeNetDev struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KprobeNetDev) Reset() {
	*x = KprobeNetDev{}
	mi := &file_tetragon_tetragon_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KprobeNetDev) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KprobeNetDev) ProtoMessage() {}

func (x *KprobeNetDev) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KprobeNetDev.ProtoReflect.Descriptor instead.
func (*KprobeNetDev) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{19}
}

func (x *KprobeNetDev) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type KprobePath struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Mount         string                 `protobuf:"bytes,1,opt,name=mount,proto3" json:"mount,omitempty"`
	Path          string                 `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	Flags         string                 `protobuf:"bytes,3,opt,name=flags,proto3" json:"flags,omitempty"`
	Permission    string                 `protobuf:"bytes,4,opt,name=permission,proto3" json:"permission,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KprobePath) Reset() {
	*x = KprobePath{}
	mi := &file_tetragon_tetragon_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KprobePath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KprobePath) ProtoMessage() {}

func (x *KprobePath) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KprobePath.ProtoReflect.Descriptor instead.
func (*KprobePath) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{20}
}

func (x *KprobePath) GetMount() string {
	if x != nil {
		return x.Mount
	}
	return ""
}

func (x *KprobePath) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *KprobePath) GetFlags() string {
	if x != nil {
		return x.Flags
	}
	return ""
}

func (x *KprobePath) GetPermission() string {
	if x != nil {
		return x.Permission
	}
	return ""
}

type KprobeFile struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Mount         string                 `protobuf:"bytes,1,opt,name=mount,proto3" json:"mount,omitempty"`
	Path          string                 `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	Flags         string                 `protobuf:"bytes,3,opt,name=flags,proto3" json:"flags,omitempty"`
	Permission    string                 `protobuf:"bytes,4,opt,name=permission,proto3" json:"permission,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KprobeFile) Reset() {
	*x = KprobeFile{}
	mi := &file_tetragon_tetragon_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KprobeFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KprobeFile) ProtoMessage() {}

func (x *KprobeFile) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KprobeFile.ProtoReflect.Descriptor instead.
func (*KprobeFile) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{21}
}

func (x *KprobeFile) GetMount() string {
	if x != nil {
		return x.Mount
	}
	return ""
}

func (x *KprobeFile) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *KprobeFile) GetFlags() string {
	if x != nil {
		return x.Flags
	}
	return ""
}

func (x *KprobeFile) GetPermission() string {
	if x != nil {
		return x.Permission
	}
	return ""
}

type KprobeTruncatedBytes struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	BytesArg      []byte                 `protobuf:"bytes,1,opt,name=bytes_arg,json=bytesArg,proto3" json:"bytes_arg,omitempty"`
	OrigSize      uint64                 `protobuf:"varint,2,opt,name=orig_size,json=origSize,proto3" json:"orig_size,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KprobeTruncatedBytes) Reset() {
	*x = KprobeTruncatedBytes{}
	mi := &file_tetragon_tetragon_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KprobeTruncatedBytes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KprobeTruncatedBytes) ProtoMessage() {}

func (x *KprobeTruncatedBytes) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KprobeTruncatedBytes.ProtoReflect.Descriptor instead.
func (*KprobeTruncatedBytes) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{22}
}

func (x *KprobeTruncatedBytes) GetBytesArg() []byte {
	if x != nil {
		return x.BytesArg
	}
	return nil
}

func (x *KprobeTruncatedBytes) GetOrigSize() uint64 {
	if x != nil {
		return x.OrigSize
	}
	return 0
}

type KprobeCred struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Permitted     []CapabilitiesType     `protobuf:"varint,1,rep,packed,name=permitted,proto3,enum=tetragon.CapabilitiesType" json:"permitted,omitempty"`
	Effective     []CapabilitiesType     `protobuf:"varint,2,rep,packed,name=effective,proto3,enum=tetragon.CapabilitiesType" json:"effective,omitempty"`
	Inheritable   []CapabilitiesType     `protobuf:"varint,3,rep,packed,name=inheritable,proto3,enum=tetragon.CapabilitiesType" json:"inheritable,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KprobeCred) Reset() {
	*x = KprobeCred{}
	mi := &file_tetragon_tetragon_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KprobeCred) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KprobeCred) ProtoMessage() {}

func (x *KprobeCred) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KprobeCred.ProtoReflect.Descriptor instead.
func (*KprobeCred) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{23}
}

func (x *KprobeCred) GetPermitted() []CapabilitiesType {
	if x != nil {
		return x.Permitted
	}
	return nil
}

func (x *KprobeCred) GetEffective() []CapabilitiesType {
	if x != nil {
		return x.Effective
	}
	return nil
}

func (x *KprobeCred) GetInheritable() []CapabilitiesType {
	if x != nil {
		return x.Inheritable
	}
	return nil
}

type KprobeLinuxBinprm struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Path          string                 `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Flags         string                 `protobuf:"bytes,2,opt,name=flags,proto3" json:"flags,omitempty"`
	Permission    string                 `protobuf:"bytes,3,opt,name=permission,proto3" json:"permission,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KprobeLinuxBinprm) Reset() {
	*x = KprobeLinuxBinprm{}
	mi := &file_tetragon_tetragon_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KprobeLinuxBinprm) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KprobeLinuxBinprm) ProtoMessage() {}

func (x *KprobeLinuxBinprm) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KprobeLinuxBinprm.ProtoReflect.Descriptor instead.
func (*KprobeLinuxBinprm) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{24}
}

func (x *KprobeLinuxBinprm) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *KprobeLinuxBinprm) GetFlags() string {
	if x != nil {
		return x.Flags
	}
	return ""
}

func (x *KprobeLinuxBinprm) GetPermission() string {
	if x != nil {
		return x.Permission
	}
	return ""
}

type KprobeCapability struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Value         *wrapperspb.Int32Value `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Name          string                 `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KprobeCapability) Reset() {
	*x = KprobeCapability{}
	mi := &file_tetragon_tetragon_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KprobeCapability) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KprobeCapability) ProtoMessage() {}

func (x *KprobeCapability) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KprobeCapability.ProtoReflect.Descriptor instead.
func (*KprobeCapability) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{25}
}

func (x *KprobeCapability) GetValue() *wrapperspb.Int32Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *KprobeCapability) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type KprobeUserNamespace struct {
	state         protoimpl.MessageState  `protogen:"open.v1"`
	Level         *wrapperspb.Int32Value  `protobuf:"bytes,1,opt,name=level,proto3" json:"level,omitempty"`
	Owner         *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=owner,proto3" json:"owner,omitempty"`
	Group         *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=group,proto3" json:"group,omitempty"`
	Ns            *Namespace              `protobuf:"bytes,4,opt,name=ns,proto3" json:"ns,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KprobeUserNamespace) Reset() {
	*x = KprobeUserNamespace{}
	mi := &file_tetragon_tetragon_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KprobeUserNamespace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KprobeUserNamespace) ProtoMessage() {}

func (x *KprobeUserNamespace) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KprobeUserNamespace.ProtoReflect.Descriptor instead.
func (*KprobeUserNamespace) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{26}
}

func (x *KprobeUserNamespace) GetLevel() *wrapperspb.Int32Value {
	if x != nil {
		return x.Level
	}
	return nil
}

func (x *KprobeUserNamespace) GetOwner() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Owner
	}
	return nil
}

func (x *KprobeUserNamespace) GetGroup() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *KprobeUserNamespace) GetNs() *Namespace {
	if x != nil {
		return x.Ns
	}
	return nil
}

type KprobeBpfAttr struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ProgType      string                 `protobuf:"bytes,1,opt,name=ProgType,proto3" json:"ProgType,omitempty"`
	InsnCnt       uint32                 `protobuf:"varint,2,opt,name=InsnCnt,proto3" json:"InsnCnt,omitempty"`
	ProgName      string                 `protobuf:"bytes,3,opt,name=ProgName,proto3" json:"ProgName,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KprobeBpfAttr) Reset() {
	*x = KprobeBpfAttr{}
	mi := &file_tetragon_tetragon_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KprobeBpfAttr) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KprobeBpfAttr) ProtoMessage() {}

func (x *KprobeBpfAttr) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KprobeBpfAttr.ProtoReflect.Descriptor instead.
func (*KprobeBpfAttr) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{27}
}

func (x *KprobeBpfAttr) GetProgType() string {
	if x != nil {
		return x.ProgType
	}
	return ""
}

func (x *KprobeBpfAttr) GetInsnCnt() uint32 {
	if x != nil {
		return x.InsnCnt
	}
	return 0
}

func (x *KprobeBpfAttr) GetProgName() string {
	if x != nil {
		return x.ProgName
	}
	return ""
}

type KprobePerfEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	KprobeFunc    string                 `protobuf:"bytes,1,opt,name=KprobeFunc,proto3" json:"KprobeFunc,omitempty"`
	Type          string                 `protobuf:"bytes,2,opt,name=Type,proto3" json:"Type,omitempty"`
	Config        uint64                 `protobuf:"varint,3,opt,name=Config,proto3" json:"Config,omitempty"`
	ProbeOffset   uint64                 `protobuf:"varint,4,opt,name=ProbeOffset,proto3" json:"ProbeOffset,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KprobePerfEvent) Reset() {
	*x = KprobePerfEvent{}
	mi := &file_tetragon_tetragon_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KprobePerfEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KprobePerfEvent) ProtoMessage() {}

func (x *KprobePerfEvent) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KprobePerfEvent.ProtoReflect.Descriptor instead.
func (*KprobePerfEvent) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{28}
}

func (x *KprobePerfEvent) GetKprobeFunc() string {
	if x != nil {
		return x.KprobeFunc
	}
	return ""
}

func (x *KprobePerfEvent) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *KprobePerfEvent) GetConfig() uint64 {
	if x != nil {
		return x.Config
	}
	return 0
}

func (x *KprobePerfEvent) GetProbeOffset() uint64 {
	if x != nil {
		return x.ProbeOffset
	}
	return 0
}

type KprobeBpfMap struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MapType       string                 `protobuf:"bytes,1,opt,name=MapType,proto3" json:"MapType,omitempty"`
	KeySize       uint32                 `protobuf:"varint,2,opt,name=KeySize,proto3" json:"KeySize,omitempty"`
	ValueSize     uint32                 `protobuf:"varint,3,opt,name=ValueSize,proto3" json:"ValueSize,omitempty"`
	MaxEntries    uint32                 `protobuf:"varint,4,opt,name=MaxEntries,proto3" json:"MaxEntries,omitempty"`
	MapName       string                 `protobuf:"bytes,5,opt,name=MapName,proto3" json:"MapName,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KprobeBpfMap) Reset() {
	*x = KprobeBpfMap{}
	mi := &file_tetragon_tetragon_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KprobeBpfMap) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KprobeBpfMap) ProtoMessage() {}

func (x *KprobeBpfMap) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KprobeBpfMap.ProtoReflect.Descriptor instead.
func (*KprobeBpfMap) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{29}
}

func (x *KprobeBpfMap) GetMapType() string {
	if x != nil {
		return x.MapType
	}
	return ""
}

func (x *KprobeBpfMap) GetKeySize() uint32 {
	if x != nil {
		return x.KeySize
	}
	return 0
}

func (x *KprobeBpfMap) GetValueSize() uint32 {
	if x != nil {
		return x.ValueSize
	}
	return 0
}

func (x *KprobeBpfMap) GetMaxEntries() uint32 {
	if x != nil {
		return x.MaxEntries
	}
	return 0
}

func (x *KprobeBpfMap) GetMapName() string {
	if x != nil {
		return x.MapName
	}
	return ""
}

type SyscallId struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            uint32                 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Abi           string                 `protobuf:"bytes,2,opt,name=abi,proto3" json:"abi,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SyscallId) Reset() {
	*x = SyscallId{}
	mi := &file_tetragon_tetragon_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyscallId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyscallId) ProtoMessage() {}

func (x *SyscallId) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyscallId.ProtoReflect.Descriptor instead.
func (*SyscallId) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{30}
}

func (x *SyscallId) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *SyscallId) GetAbi() string {
	if x != nil {
		return x.Abi
	}
	return ""
}

type KprobeArgument struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Arg:
	//
	//	*KprobeArgument_StringArg
	//	*KprobeArgument_IntArg
	//	*KprobeArgument_SkbArg
	//	*KprobeArgument_SizeArg
	//	*KprobeArgument_BytesArg
	//	*KprobeArgument_PathArg
	//	*KprobeArgument_FileArg
	//	*KprobeArgument_TruncatedBytesArg
	//	*KprobeArgument_SockArg
	//	*KprobeArgument_CredArg
	//	*KprobeArgument_LongArg
	//	*KprobeArgument_BpfAttrArg
	//	*KprobeArgument_PerfEventArg
	//	*KprobeArgument_BpfMapArg
	//	*KprobeArgument_UintArg
	//	*KprobeArgument_UserNamespaceArg
	//	*KprobeArgument_CapabilityArg
	//	*KprobeArgument_ProcessCredentialsArg
	//	*KprobeArgument_UserNsArg
	//	*KprobeArgument_ModuleArg
	//	*KprobeArgument_KernelCapTArg
	//	*KprobeArgument_CapInheritableArg
	//	*KprobeArgument_CapPermittedArg
	//	*KprobeArgument_CapEffectiveArg
	//	*KprobeArgument_LinuxBinprmArg
	//	*KprobeArgument_NetDevArg
	//	*KprobeArgument_BpfCmdArg
	//	*KprobeArgument_SyscallId
	//	*KprobeArgument_SockaddrArg
	Arg           isKprobeArgument_Arg `protobuf_oneof:"arg"`
	Label         string               `protobuf:"bytes,18,opt,name=label,proto3" json:"label,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KprobeArgument) Reset() {
	*x = KprobeArgument{}
	mi := &file_tetragon_tetragon_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KprobeArgument) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KprobeArgument) ProtoMessage() {}

func (x *KprobeArgument) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KprobeArgument.ProtoReflect.Descriptor instead.
func (*KprobeArgument) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{31}
}

func (x *KprobeArgument) GetArg() isKprobeArgument_Arg {
	if x != nil {
		return x.Arg
	}
	return nil
}

func (x *KprobeArgument) GetStringArg() string {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_StringArg); ok {
			return x.StringArg
		}
	}
	return ""
}

func (x *KprobeArgument) GetIntArg() int32 {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_IntArg); ok {
			return x.IntArg
		}
	}
	return 0
}

func (x *KprobeArgument) GetSkbArg() *KprobeSkb {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_SkbArg); ok {
			return x.SkbArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetSizeArg() uint64 {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_SizeArg); ok {
			return x.SizeArg
		}
	}
	return 0
}

func (x *KprobeArgument) GetBytesArg() []byte {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_BytesArg); ok {
			return x.BytesArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetPathArg() *KprobePath {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_PathArg); ok {
			return x.PathArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetFileArg() *KprobeFile {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_FileArg); ok {
			return x.FileArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetTruncatedBytesArg() *KprobeTruncatedBytes {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_TruncatedBytesArg); ok {
			return x.TruncatedBytesArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetSockArg() *KprobeSock {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_SockArg); ok {
			return x.SockArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetCredArg() *KprobeCred {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_CredArg); ok {
			return x.CredArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetLongArg() int64 {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_LongArg); ok {
			return x.LongArg
		}
	}
	return 0
}

func (x *KprobeArgument) GetBpfAttrArg() *KprobeBpfAttr {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_BpfAttrArg); ok {
			return x.BpfAttrArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetPerfEventArg() *KprobePerfEvent {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_PerfEventArg); ok {
			return x.PerfEventArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetBpfMapArg() *KprobeBpfMap {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_BpfMapArg); ok {
			return x.BpfMapArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetUintArg() uint32 {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_UintArg); ok {
			return x.UintArg
		}
	}
	return 0
}

// Deprecated: Marked as deprecated in tetragon/tetragon.proto.
func (x *KprobeArgument) GetUserNamespaceArg() *KprobeUserNamespace {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_UserNamespaceArg); ok {
			return x.UserNamespaceArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetCapabilityArg() *KprobeCapability {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_CapabilityArg); ok {
			return x.CapabilityArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetProcessCredentialsArg() *ProcessCredentials {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_ProcessCredentialsArg); ok {
			return x.ProcessCredentialsArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetUserNsArg() *UserNamespace {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_UserNsArg); ok {
			return x.UserNsArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetModuleArg() *KernelModule {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_ModuleArg); ok {
			return x.ModuleArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetKernelCapTArg() string {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_KernelCapTArg); ok {
			return x.KernelCapTArg
		}
	}
	return ""
}

func (x *KprobeArgument) GetCapInheritableArg() string {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_CapInheritableArg); ok {
			return x.CapInheritableArg
		}
	}
	return ""
}

func (x *KprobeArgument) GetCapPermittedArg() string {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_CapPermittedArg); ok {
			return x.CapPermittedArg
		}
	}
	return ""
}

func (x *KprobeArgument) GetCapEffectiveArg() string {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_CapEffectiveArg); ok {
			return x.CapEffectiveArg
		}
	}
	return ""
}

func (x *KprobeArgument) GetLinuxBinprmArg() *KprobeLinuxBinprm {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_LinuxBinprmArg); ok {
			return x.LinuxBinprmArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetNetDevArg() *KprobeNetDev {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_NetDevArg); ok {
			return x.NetDevArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetBpfCmdArg() BpfCmd {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_BpfCmdArg); ok {
			return x.BpfCmdArg
		}
	}
	return BpfCmd_BPF_MAP_CREATE
}

func (x *KprobeArgument) GetSyscallId() *SyscallId {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_SyscallId); ok {
			return x.SyscallId
		}
	}
	return nil
}

func (x *KprobeArgument) GetSockaddrArg() *KprobeSockaddr {
	if x != nil {
		if x, ok := x.Arg.(*KprobeArgument_SockaddrArg); ok {
			return x.SockaddrArg
		}
	}
	return nil
}

func (x *KprobeArgument) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

type isKprobeArgument_Arg interface {
	isKprobeArgument_Arg()
}

type KprobeArgument_StringArg struct {
	StringArg string `protobuf:"bytes,1,opt,name=string_arg,json=stringArg,proto3,oneof"`
}

type KprobeArgument_IntArg struct {
	IntArg int32 `protobuf:"varint,2,opt,name=int_arg,json=intArg,proto3,oneof"`
}

type KprobeArgument_SkbArg struct {
	SkbArg *KprobeSkb `protobuf:"bytes,3,opt,name=skb_arg,json=skbArg,proto3,oneof"`
}

type KprobeArgument_SizeArg struct {
	SizeArg uint64 `protobuf:"varint,4,opt,name=size_arg,json=sizeArg,proto3,oneof"`
}

type KprobeArgument_BytesArg struct {
	BytesArg []byte `protobuf:"bytes,5,opt,name=bytes_arg,json=bytesArg,proto3,oneof"`
}

type KprobeArgument_PathArg struct {
	PathArg *KprobePath `protobuf:"bytes,6,opt,name=path_arg,json=pathArg,proto3,oneof"`
}

type KprobeArgument_FileArg struct {
	FileArg *KprobeFile `protobuf:"bytes,7,opt,name=file_arg,json=fileArg,proto3,oneof"`
}

type KprobeArgument_TruncatedBytesArg struct {
	TruncatedBytesArg *KprobeTruncatedBytes `protobuf:"bytes,8,opt,name=truncated_bytes_arg,json=truncatedBytesArg,proto3,oneof"`
}

type KprobeArgument_SockArg struct {
	SockArg *KprobeSock `protobuf:"bytes,9,opt,name=sock_arg,json=sockArg,proto3,oneof"`
}

type KprobeArgument_CredArg struct {
	CredArg *KprobeCred `protobuf:"bytes,10,opt,name=cred_arg,json=credArg,proto3,oneof"`
}

type KprobeArgument_LongArg struct {
	LongArg int64 `protobuf:"varint,11,opt,name=long_arg,json=longArg,proto3,oneof"`
}

type KprobeArgument_BpfAttrArg struct {
	BpfAttrArg *KprobeBpfAttr `protobuf:"bytes,12,opt,name=bpf_attr_arg,json=bpfAttrArg,proto3,oneof"`
}

type KprobeArgument_PerfEventArg struct {
	PerfEventArg *KprobePerfEvent `protobuf:"bytes,13,opt,name=perf_event_arg,json=perfEventArg,proto3,oneof"`
}

type KprobeArgument_BpfMapArg struct {
	BpfMapArg *KprobeBpfMap `protobuf:"bytes,14,opt,name=bpf_map_arg,json=bpfMapArg,proto3,oneof"`
}

type KprobeArgument_UintArg struct {
	UintArg uint32 `protobuf:"varint,15,opt,name=uint_arg,json=uintArg,proto3,oneof"`
}

type KprobeArgument_UserNamespaceArg struct {
	// Deprecated: Marked as deprecated in tetragon/tetragon.proto.
	UserNamespaceArg *KprobeUserNamespace `protobuf:"bytes,16,opt,name=user_namespace_arg,json=userNamespaceArg,proto3,oneof"`
}

type KprobeArgument_CapabilityArg struct {
	CapabilityArg *KprobeCapability `protobuf:"bytes,17,opt,name=capability_arg,json=capabilityArg,proto3,oneof"`
}

type KprobeArgument_ProcessCredentialsArg struct {
	ProcessCredentialsArg *ProcessCredentials `protobuf:"bytes,19,opt,name=process_credentials_arg,json=processCredentialsArg,proto3,oneof"`
}

type KprobeArgument_UserNsArg struct {
	UserNsArg *UserNamespace `protobuf:"bytes,20,opt,name=user_ns_arg,json=userNsArg,proto3,oneof"`
}

type KprobeArgument_ModuleArg struct {
	ModuleArg *KernelModule `protobuf:"bytes,21,opt,name=module_arg,json=moduleArg,proto3,oneof"`
}

type KprobeArgument_KernelCapTArg struct {
	KernelCapTArg string `protobuf:"bytes,22,opt,name=kernel_cap_t_arg,json=kernelCapTArg,proto3,oneof"` // Capabilities in hexadecimal format.
}

type KprobeArgument_CapInheritableArg struct {
	CapInheritableArg string `protobuf:"bytes,23,opt,name=cap_inheritable_arg,json=capInheritableArg,proto3,oneof"` // Capabilities inherited by a forked process in hexadecimal format.
}

type KprobeArgument_CapPermittedArg struct {
	CapPermittedArg string `protobuf:"bytes,24,opt,name=cap_permitted_arg,json=capPermittedArg,proto3,oneof"` // Capabilities that are currently permitted in hexadecimal format.
}

type KprobeArgument_CapEffectiveArg struct {
	CapEffectiveArg string `protobuf:"bytes,25,opt,name=cap_effective_arg,json=capEffectiveArg,proto3,oneof"` // Capabilities that are actually used in hexadecimal format.
}

type KprobeArgument_LinuxBinprmArg struct {
	LinuxBinprmArg *KprobeLinuxBinprm `protobuf:"bytes,26,opt,name=linux_binprm_arg,json=linuxBinprmArg,proto3,oneof"`
}

type KprobeArgument_NetDevArg struct {
	NetDevArg *KprobeNetDev `protobuf:"bytes,27,opt,name=net_dev_arg,json=netDevArg,proto3,oneof"`
}

type KprobeArgument_BpfCmdArg struct {
	BpfCmdArg BpfCmd `protobuf:"varint,28,opt,name=bpf_cmd_arg,json=bpfCmdArg,proto3,enum=tetragon.BpfCmd,oneof"`
}

type KprobeArgument_SyscallId struct {
	SyscallId *SyscallId `protobuf:"bytes,29,opt,name=syscall_id,json=syscallId,proto3,oneof"`
}

type KprobeArgument_SockaddrArg struct {
	SockaddrArg *KprobeSockaddr `protobuf:"bytes,30,opt,name=sockaddr_arg,json=sockaddrArg,proto3,oneof"`
}

func (*KprobeArgument_StringArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_IntArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_SkbArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_SizeArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_BytesArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_PathArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_FileArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_TruncatedBytesArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_SockArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_CredArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_LongArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_BpfAttrArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_PerfEventArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_BpfMapArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_UintArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_UserNamespaceArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_CapabilityArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_ProcessCredentialsArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_UserNsArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_ModuleArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_KernelCapTArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_CapInheritableArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_CapPermittedArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_CapEffectiveArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_LinuxBinprmArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_NetDevArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_BpfCmdArg) isKprobeArgument_Arg() {}

func (*KprobeArgument_SyscallId) isKprobeArgument_Arg() {}

func (*KprobeArgument_SockaddrArg) isKprobeArgument_Arg() {}

type ProcessKprobe struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Process that triggered the kprobe.
	Process *Process `protobuf:"bytes,1,opt,name=process,proto3" json:"process,omitempty"`
	// Immediate parent of the process.
	Parent *Process `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// Symbol on which the kprobe was attached.
	FunctionName string `protobuf:"bytes,3,opt,name=function_name,json=functionName,proto3" json:"function_name,omitempty"`
	// Arguments definition of the observed kprobe.
	Args []*KprobeArgument `protobuf:"bytes,4,rep,name=args,proto3" json:"args,omitempty"`
	// Return value definition of the observed kprobe.
	Return *KprobeArgument `protobuf:"bytes,5,opt,name=return,proto3" json:"return,omitempty"`
	// Action performed when the kprobe matched.
	Action KprobeAction `protobuf:"varint,6,opt,name=action,proto3,enum=tetragon.KprobeAction" json:"action,omitempty"`
	// Kernel stack trace to the call.
	KernelStackTrace []*StackTraceEntry `protobuf:"bytes,7,rep,name=kernel_stack_trace,json=kernelStackTrace,proto3" json:"kernel_stack_trace,omitempty"`
	// Name of the Tracing Policy that created that kprobe.
	PolicyName string `protobuf:"bytes,8,opt,name=policy_name,json=policyName,proto3" json:"policy_name,omitempty"`
	// Action performed when the return kprobe executed.
	ReturnAction KprobeAction `protobuf:"varint,9,opt,name=return_action,json=returnAction,proto3,enum=tetragon.KprobeAction" json:"return_action,omitempty"`
	// Short message of the Tracing Policy to inform users what is going on.
	Message string `protobuf:"bytes,10,opt,name=message,proto3" json:"message,omitempty"`
	// Tags of the Tracing Policy to categorize the event.
	Tags []string `protobuf:"bytes,11,rep,name=tags,proto3" json:"tags,omitempty"`
	// User-mode stack trace to the call.
	UserStackTrace []*StackTraceEntry `protobuf:"bytes,12,rep,name=user_stack_trace,json=userStackTrace,proto3" json:"user_stack_trace,omitempty"`
	// Ancestors of the process beyond the immediate parent.
	Ancestors     []*Process `protobuf:"bytes,13,rep,name=ancestors,proto3" json:"ancestors,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProcessKprobe) Reset() {
	*x = ProcessKprobe{}
	mi := &file_tetragon_tetragon_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProcessKprobe) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessKprobe) ProtoMessage() {}

func (x *ProcessKprobe) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessKprobe.ProtoReflect.Descriptor instead.
func (*ProcessKprobe) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{32}
}

func (x *ProcessKprobe) GetProcess() *Process {
	if x != nil {
		return x.Process
	}
	return nil
}

func (x *ProcessKprobe) GetParent() *Process {
	if x != nil {
		return x.Parent
	}
	return nil
}

func (x *ProcessKprobe) GetFunctionName() string {
	if x != nil {
		return x.FunctionName
	}
	return ""
}

func (x *ProcessKprobe) GetArgs() []*KprobeArgument {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *ProcessKprobe) GetReturn() *KprobeArgument {
	if x != nil {
		return x.Return
	}
	return nil
}

func (x *ProcessKprobe) GetAction() KprobeAction {
	if x != nil {
		return x.Action
	}
	return KprobeAction_KPROBE_ACTION_UNKNOWN
}

func (x *ProcessKprobe) GetKernelStackTrace() []*StackTraceEntry {
	if x != nil {
		return x.KernelStackTrace
	}
	return nil
}

func (x *ProcessKprobe) GetPolicyName() string {
	if x != nil {
		return x.PolicyName
	}
	return ""
}

func (x *ProcessKprobe) GetReturnAction() KprobeAction {
	if x != nil {
		return x.ReturnAction
	}
	return KprobeAction_KPROBE_ACTION_UNKNOWN
}

func (x *ProcessKprobe) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *ProcessKprobe) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *ProcessKprobe) GetUserStackTrace() []*StackTraceEntry {
	if x != nil {
		return x.UserStackTrace
	}
	return nil
}

func (x *ProcessKprobe) GetAncestors() []*Process {
	if x != nil {
		return x.Ancestors
	}
	return nil
}

type ProcessTracepoint struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Process that triggered the tracepoint.
	Process *Process `protobuf:"bytes,1,opt,name=process,proto3" json:"process,omitempty"`
	// Immediate parent of the process.
	Parent *Process `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// Subsystem of the tracepoint.
	Subsys string `protobuf:"bytes,4,opt,name=subsys,proto3" json:"subsys,omitempty"`
	// Event of the subsystem.
	Event string `protobuf:"bytes,5,opt,name=event,proto3" json:"event,omitempty"`
	// Arguments definition of the observed tracepoint.
	// TODO: once we implement all we want, rename KprobeArgument to GenericArgument
	Args []*KprobeArgument `protobuf:"bytes,6,rep,name=args,proto3" json:"args,omitempty"`
	// Name of the policy that created that tracepoint.
	PolicyName string `protobuf:"bytes,7,opt,name=policy_name,json=policyName,proto3" json:"policy_name,omitempty"`
	// Action performed when the tracepoint matched.
	Action KprobeAction `protobuf:"varint,8,opt,name=action,proto3,enum=tetragon.KprobeAction" json:"action,omitempty"`
	// Short message of the Tracing Policy to inform users what is going on.
	Message string `protobuf:"bytes,9,opt,name=message,proto3" json:"message,omitempty"`
	// Tags of the Tracing Policy to categorize the event.
	Tags []string `protobuf:"bytes,10,rep,name=tags,proto3" json:"tags,omitempty"`
	// Ancestors of the process beyond the immediate parent.
	Ancestors     []*Process `protobuf:"bytes,11,rep,name=ancestors,proto3" json:"ancestors,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProcessTracepoint) Reset() {
	*x = ProcessTracepoint{}
	mi := &file_tetragon_tetragon_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProcessTracepoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessTracepoint) ProtoMessage() {}

func (x *ProcessTracepoint) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessTracepoint.ProtoReflect.Descriptor instead.
func (*ProcessTracepoint) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{33}
}

func (x *ProcessTracepoint) GetProcess() *Process {
	if x != nil {
		return x.Process
	}
	return nil
}

func (x *ProcessTracepoint) GetParent() *Process {
	if x != nil {
		return x.Parent
	}
	return nil
}

func (x *ProcessTracepoint) GetSubsys() string {
	if x != nil {
		return x.Subsys
	}
	return ""
}

func (x *ProcessTracepoint) GetEvent() string {
	if x != nil {
		return x.Event
	}
	return ""
}

func (x *ProcessTracepoint) GetArgs() []*KprobeArgument {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *ProcessTracepoint) GetPolicyName() string {
	if x != nil {
		return x.PolicyName
	}
	return ""
}

func (x *ProcessTracepoint) GetAction() KprobeAction {
	if x != nil {
		return x.Action
	}
	return KprobeAction_KPROBE_ACTION_UNKNOWN
}

func (x *ProcessTracepoint) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *ProcessTracepoint) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *ProcessTracepoint) GetAncestors() []*Process {
	if x != nil {
		return x.Ancestors
	}
	return nil
}

type ProcessUprobe struct {
	state   protoimpl.MessageState `protogen:"open.v1"`
	Process *Process               `protobuf:"bytes,1,opt,name=process,proto3" json:"process,omitempty"`
	Parent  *Process               `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	Path    string                 `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	Symbol  string                 `protobuf:"bytes,4,opt,name=symbol,proto3" json:"symbol,omitempty"`
	// Name of the policy that created that uprobe.
	PolicyName string `protobuf:"bytes,5,opt,name=policy_name,json=policyName,proto3" json:"policy_name,omitempty"`
	// Short message of the Tracing Policy to inform users what is going on.
	Message string `protobuf:"bytes,6,opt,name=message,proto3" json:"message,omitempty"`
	// Arguments definition of the observed uprobe.
	Args []*KprobeArgument `protobuf:"bytes,7,rep,name=args,proto3" json:"args,omitempty"`
	// Tags of the Tracing Policy to categorize the event.
	Tags []string `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty"`
	// Ancestors of the process beyond the immediate parent.
	Ancestors []*Process `protobuf:"bytes,9,rep,name=ancestors,proto3" json:"ancestors,omitempty"`
	// uprobe offset (mutualy exclusive with symbol)
	Offset uint64 `protobuf:"varint,10,opt,name=offset,proto3" json:"offset,omitempty"`
	// uprobe ref_ctr_offset
	RefCtrOffset  uint64 `protobuf:"varint,11,opt,name=ref_ctr_offset,json=refCtrOffset,proto3" json:"ref_ctr_offset,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProcessUprobe) Reset() {
	*x = ProcessUprobe{}
	mi := &file_tetragon_tetragon_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProcessUprobe) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessUprobe) ProtoMessage() {}

func (x *ProcessUprobe) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessUprobe.ProtoReflect.Descriptor instead.
func (*ProcessUprobe) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{34}
}

func (x *ProcessUprobe) GetProcess() *Process {
	if x != nil {
		return x.Process
	}
	return nil
}

func (x *ProcessUprobe) GetParent() *Process {
	if x != nil {
		return x.Parent
	}
	return nil
}

func (x *ProcessUprobe) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *ProcessUprobe) GetSymbol() string {
	if x != nil {
		return x.Symbol
	}
	return ""
}

func (x *ProcessUprobe) GetPolicyName() string {
	if x != nil {
		return x.PolicyName
	}
	return ""
}

func (x *ProcessUprobe) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *ProcessUprobe) GetArgs() []*KprobeArgument {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *ProcessUprobe) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *ProcessUprobe) GetAncestors() []*Process {
	if x != nil {
		return x.Ancestors
	}
	return nil
}

func (x *ProcessUprobe) GetOffset() uint64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *ProcessUprobe) GetRefCtrOffset() uint64 {
	if x != nil {
		return x.RefCtrOffset
	}
	return 0
}

type ProcessLsm struct {
	state   protoimpl.MessageState `protogen:"open.v1"`
	Process *Process               `protobuf:"bytes,1,opt,name=process,proto3" json:"process,omitempty"`
	Parent  *Process               `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// LSM hook name.
	FunctionName string `protobuf:"bytes,3,opt,name=function_name,json=functionName,proto3" json:"function_name,omitempty"`
	// Name of the policy that created that LSM hook.
	PolicyName string `protobuf:"bytes,5,opt,name=policy_name,json=policyName,proto3" json:"policy_name,omitempty"`
	// Short message of the Tracing Policy to inform users what is going on.
	Message string `protobuf:"bytes,6,opt,name=message,proto3" json:"message,omitempty"`
	// Arguments definition of the observed LSM hook.
	Args []*KprobeArgument `protobuf:"bytes,7,rep,name=args,proto3" json:"args,omitempty"`
	// Action performed when the LSM hook matched.
	Action KprobeAction `protobuf:"varint,8,opt,name=action,proto3,enum=tetragon.KprobeAction" json:"action,omitempty"`
	// Tags of the Tracing Policy to categorize the event.
	Tags []string `protobuf:"bytes,9,rep,name=tags,proto3" json:"tags,omitempty"`
	// Ancestors of the process beyond the immediate parent.
	Ancestors []*Process `protobuf:"bytes,10,rep,name=ancestors,proto3" json:"ancestors,omitempty"`
	// IMA file hash. Format algorithm:value.
	ImaHash       string `protobuf:"bytes,11,opt,name=ima_hash,json=imaHash,proto3" json:"ima_hash,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProcessLsm) Reset() {
	*x = ProcessLsm{}
	mi := &file_tetragon_tetragon_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProcessLsm) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessLsm) ProtoMessage() {}

func (x *ProcessLsm) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessLsm.ProtoReflect.Descriptor instead.
func (*ProcessLsm) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{35}
}

func (x *ProcessLsm) GetProcess() *Process {
	if x != nil {
		return x.Process
	}
	return nil
}

func (x *ProcessLsm) GetParent() *Process {
	if x != nil {
		return x.Parent
	}
	return nil
}

func (x *ProcessLsm) GetFunctionName() string {
	if x != nil {
		return x.FunctionName
	}
	return ""
}

func (x *ProcessLsm) GetPolicyName() string {
	if x != nil {
		return x.PolicyName
	}
	return ""
}

func (x *ProcessLsm) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *ProcessLsm) GetArgs() []*KprobeArgument {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *ProcessLsm) GetAction() KprobeAction {
	if x != nil {
		return x.Action
	}
	return KprobeAction_KPROBE_ACTION_UNKNOWN
}

func (x *ProcessLsm) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *ProcessLsm) GetAncestors() []*Process {
	if x != nil {
		return x.Ancestors
	}
	return nil
}

func (x *ProcessLsm) GetImaHash() string {
	if x != nil {
		return x.ImaHash
	}
	return ""
}

type KernelModule struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Kernel module name
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If true the module signature was verified successfully. Depends on kernels compiled with
	// CONFIG_MODULE_SIG option, for details please read: https://www.kernel.org/doc/Documentation/admin-guide/module-signing.rst
	SignatureOk *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=signature_ok,json=signatureOk,proto3" json:"signature_ok,omitempty"`
	// The module tainted flags that will be applied on the kernel. For further details please read: https://docs.kernel.org/admin-guide/tainted-kernels.html
	Tainted       []TaintedBitsType `protobuf:"varint,3,rep,packed,name=tainted,proto3,enum=tetragon.TaintedBitsType" json:"tainted,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *KernelModule) Reset() {
	*x = KernelModule{}
	mi := &file_tetragon_tetragon_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KernelModule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KernelModule) ProtoMessage() {}

func (x *KernelModule) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KernelModule.ProtoReflect.Descriptor instead.
func (*KernelModule) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{36}
}

func (x *KernelModule) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *KernelModule) GetSignatureOk() *wrapperspb.BoolValue {
	if x != nil {
		return x.SignatureOk
	}
	return nil
}

func (x *KernelModule) GetTainted() []TaintedBitsType {
	if x != nil {
		return x.Tainted
	}
	return nil
}

type Test struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Arg0          uint64                 `protobuf:"varint,1,opt,name=arg0,proto3" json:"arg0,omitempty"`
	Arg1          uint64                 `protobuf:"varint,2,opt,name=arg1,proto3" json:"arg1,omitempty"`
	Arg2          uint64                 `protobuf:"varint,3,opt,name=arg2,proto3" json:"arg2,omitempty"`
	Arg3          uint64                 `protobuf:"varint,4,opt,name=arg3,proto3" json:"arg3,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Test) Reset() {
	*x = Test{}
	mi := &file_tetragon_tetragon_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Test) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Test) ProtoMessage() {}

func (x *Test) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Test.ProtoReflect.Descriptor instead.
func (*Test) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{37}
}

func (x *Test) GetArg0() uint64 {
	if x != nil {
		return x.Arg0
	}
	return 0
}

func (x *Test) GetArg1() uint64 {
	if x != nil {
		return x.Arg1
	}
	return 0
}

func (x *Test) GetArg2() uint64 {
	if x != nil {
		return x.Arg2
	}
	return 0
}

func (x *Test) GetArg3() uint64 {
	if x != nil {
		return x.Arg3
	}
	return 0
}

type GetHealthStatusRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	EventSet      []HealthStatusType     `protobuf:"varint,1,rep,packed,name=event_set,json=eventSet,proto3,enum=tetragon.HealthStatusType" json:"event_set,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetHealthStatusRequest) Reset() {
	*x = GetHealthStatusRequest{}
	mi := &file_tetragon_tetragon_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetHealthStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetHealthStatusRequest) ProtoMessage() {}

func (x *GetHealthStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetHealthStatusRequest.ProtoReflect.Descriptor instead.
func (*GetHealthStatusRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{38}
}

func (x *GetHealthStatusRequest) GetEventSet() []HealthStatusType {
	if x != nil {
		return x.EventSet
	}
	return nil
}

type HealthStatus struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Event         HealthStatusType       `protobuf:"varint,1,opt,name=event,proto3,enum=tetragon.HealthStatusType" json:"event,omitempty"`
	Status        HealthStatusResult     `protobuf:"varint,2,opt,name=status,proto3,enum=tetragon.HealthStatusResult" json:"status,omitempty"`
	Details       string                 `protobuf:"bytes,3,opt,name=details,proto3" json:"details,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HealthStatus) Reset() {
	*x = HealthStatus{}
	mi := &file_tetragon_tetragon_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HealthStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthStatus) ProtoMessage() {}

func (x *HealthStatus) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthStatus.ProtoReflect.Descriptor instead.
func (*HealthStatus) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{39}
}

func (x *HealthStatus) GetEvent() HealthStatusType {
	if x != nil {
		return x.Event
	}
	return HealthStatusType_HEALTH_STATUS_TYPE_UNDEF
}

func (x *HealthStatus) GetStatus() HealthStatusResult {
	if x != nil {
		return x.Status
	}
	return HealthStatusResult_HEALTH_STATUS_UNDEF
}

func (x *HealthStatus) GetDetails() string {
	if x != nil {
		return x.Details
	}
	return ""
}

type GetHealthStatusResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	HealthStatus  []*HealthStatus        `protobuf:"bytes,1,rep,name=health_status,json=healthStatus,proto3" json:"health_status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetHealthStatusResponse) Reset() {
	*x = GetHealthStatusResponse{}
	mi := &file_tetragon_tetragon_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetHealthStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetHealthStatusResponse) ProtoMessage() {}

func (x *GetHealthStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetHealthStatusResponse.ProtoReflect.Descriptor instead.
func (*GetHealthStatusResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{40}
}

func (x *GetHealthStatusResponse) GetHealthStatus() []*HealthStatus {
	if x != nil {
		return x.HealthStatus
	}
	return nil
}

// loader sensor event triggered for loaded binary/library
type ProcessLoader struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Process       *Process               `protobuf:"bytes,1,opt,name=process,proto3" json:"process,omitempty"`
	Path          string                 `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	Buildid       []byte                 `protobuf:"bytes,3,opt,name=buildid,proto3" json:"buildid,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProcessLoader) Reset() {
	*x = ProcessLoader{}
	mi := &file_tetragon_tetragon_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProcessLoader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessLoader) ProtoMessage() {}

func (x *ProcessLoader) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessLoader.ProtoReflect.Descriptor instead.
func (*ProcessLoader) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{41}
}

func (x *ProcessLoader) GetProcess() *Process {
	if x != nil {
		return x.Process
	}
	return nil
}

func (x *ProcessLoader) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *ProcessLoader) GetBuildid() []byte {
	if x != nil {
		return x.Buildid
	}
	return nil
}

// RuntimeHookRequest synchronously propagates information to the agent about run-time state.
type RuntimeHookRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Event:
	//
	//	*RuntimeHookRequest_CreateContainer
	Event         isRuntimeHookRequest_Event `protobuf_oneof:"event"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RuntimeHookRequest) Reset() {
	*x = RuntimeHookRequest{}
	mi := &file_tetragon_tetragon_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeHookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeHookRequest) ProtoMessage() {}

func (x *RuntimeHookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeHookRequest.ProtoReflect.Descriptor instead.
func (*RuntimeHookRequest) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{42}
}

func (x *RuntimeHookRequest) GetEvent() isRuntimeHookRequest_Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *RuntimeHookRequest) GetCreateContainer() *CreateContainer {
	if x != nil {
		if x, ok := x.Event.(*RuntimeHookRequest_CreateContainer); ok {
			return x.CreateContainer
		}
	}
	return nil
}

type isRuntimeHookRequest_Event interface {
	isRuntimeHookRequest_Event()
}

type RuntimeHookRequest_CreateContainer struct {
	CreateContainer *CreateContainer `protobuf:"bytes,1,opt,name=createContainer,proto3,oneof"`
}

func (*RuntimeHookRequest_CreateContainer) isRuntimeHookRequest_Event() {}

type RuntimeHookResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RuntimeHookResponse) Reset() {
	*x = RuntimeHookResponse{}
	mi := &file_tetragon_tetragon_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeHookResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeHookResponse) ProtoMessage() {}

func (x *RuntimeHookResponse) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeHookResponse.ProtoReflect.Descriptor instead.
func (*RuntimeHookResponse) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{43}
}

// CreateContainer informs the agent that a container was created
// This is intented to be used by OCI hooks (but not limited to them) and corresponds to the
// CreateContainer hook:
// https://github.com/opencontainers/runtime-spec/blob/main/config.md#createcontainer-hooks.
//
// The containerName, containerID, podName, podUID, and podNamespace fields are retrieved from the
// annotations as a convenience, and may be left empty if the corresponding annotations are not
// found.
type CreateContainer struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// cgroupsPath is the cgroups path for the container. The path is expected to be relative to the
	// cgroups mountpoint. See: https://github.com/opencontainers/runtime-spec/blob/58ec43f9fc39e0db229b653ae98295bfde74aeab/specs-go/config.go#L174
	CgroupsPath string `protobuf:"bytes,1,opt,name=cgroupsPath,proto3" json:"cgroupsPath,omitempty"`
	// rootDir is the absolute path of the root directory of the container.
	// See: https://github.com/opencontainers/runtime-spec/blob/main/specs-go/config.go#L174
	RootDir string `protobuf:"bytes,2,opt,name=rootDir,proto3" json:"rootDir,omitempty"`
	// annotations are the run-time annotations for the container
	// see https://github.com/opencontainers/runtime-spec/blob/main/config.md#annotations
	Annotations map[string]string `protobuf:"bytes,3,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// containerName is the name of the container
	ContainerName string `protobuf:"bytes,4,opt,name=containerName,proto3" json:"containerName,omitempty"`
	// containerID is the id of the container
	ContainerID string `protobuf:"bytes,5,opt,name=containerID,proto3" json:"containerID,omitempty"`
	// podName is the pod name
	PodName string `protobuf:"bytes,6,opt,name=podName,proto3" json:"podName,omitempty"`
	// podUID is the pod uid
	PodUID string `protobuf:"bytes,7,opt,name=podUID,proto3" json:"podUID,omitempty"`
	// podNamespace is the namespace of the pod
	PodNamespace string `protobuf:"bytes,8,opt,name=podNamespace,proto3" json:"podNamespace,omitempty"`
	// containerImage is the full image location (repo + image)
	ContainerImage string `protobuf:"bytes,9,opt,name=containerImage,proto3" json:"containerImage,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *CreateContainer) Reset() {
	*x = CreateContainer{}
	mi := &file_tetragon_tetragon_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateContainer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateContainer) ProtoMessage() {}

func (x *CreateContainer) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateContainer.ProtoReflect.Descriptor instead.
func (*CreateContainer) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{44}
}

func (x *CreateContainer) GetCgroupsPath() string {
	if x != nil {
		return x.CgroupsPath
	}
	return ""
}

func (x *CreateContainer) GetRootDir() string {
	if x != nil {
		return x.RootDir
	}
	return ""
}

func (x *CreateContainer) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *CreateContainer) GetContainerName() string {
	if x != nil {
		return x.ContainerName
	}
	return ""
}

func (x *CreateContainer) GetContainerID() string {
	if x != nil {
		return x.ContainerID
	}
	return ""
}

func (x *CreateContainer) GetPodName() string {
	if x != nil {
		return x.PodName
	}
	return ""
}

func (x *CreateContainer) GetPodUID() string {
	if x != nil {
		return x.PodUID
	}
	return ""
}

func (x *CreateContainer) GetPodNamespace() string {
	if x != nil {
		return x.PodNamespace
	}
	return ""
}

func (x *CreateContainer) GetContainerImage() string {
	if x != nil {
		return x.ContainerImage
	}
	return ""
}

type StackTraceEntry struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// linear address of the function in kernel or user space.
	Address uint64 `protobuf:"varint,1,opt,name=address,proto3" json:"address,omitempty"`
	// offset is the offset into the native instructions for the function.
	Offset uint64 `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	// symbol is the symbol name of the function.
	Symbol string `protobuf:"bytes,3,opt,name=symbol,proto3" json:"symbol,omitempty"`
	// module path for user space addresses.
	Module        string `protobuf:"bytes,4,opt,name=module,proto3" json:"module,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StackTraceEntry) Reset() {
	*x = StackTraceEntry{}
	mi := &file_tetragon_tetragon_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StackTraceEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackTraceEntry) ProtoMessage() {}

func (x *StackTraceEntry) ProtoReflect() protoreflect.Message {
	mi := &file_tetragon_tetragon_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackTraceEntry.ProtoReflect.Descriptor instead.
func (*StackTraceEntry) Descriptor() ([]byte, []int) {
	return file_tetragon_tetragon_proto_rawDescGZIP(), []int{45}
}

func (x *StackTraceEntry) GetAddress() uint64 {
	if x != nil {
		return x.Address
	}
	return 0
}

func (x *StackTraceEntry) GetOffset() uint64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *StackTraceEntry) GetSymbol() string {
	if x != nil {
		return x.Symbol
	}
	return ""
}

func (x *StackTraceEntry) GetModule() string {
	if x != nil {
		return x.Module
	}
	return ""
}

var File_tetragon_tetragon_proto protoreflect.FileDescriptor

var file_tetragon_tetragon_proto_rawDesc = []byte{
	0x0a, 0x17, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2f, 0x74, 0x65, 0x74, 0x72, 0x61,
	0x67, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x08, 0x74, 0x65, 0x74, 0x72, 0x61,
	0x67, 0x6f, 0x6e, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x12, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2f, 0x62,
	0x70, 0x66, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67,
	0x6f, 0x6e, 0x2f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x2b, 0x0a, 0x05, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x31, 0x0a, 0x0f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65,
	0x67, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x69,
	0x6c, 0x65, 0x67, 0x65, 0x64, 0x22, 0xb1, 0x02, 0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f,
	0x6e, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x39,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x03, 0x70, 0x69, 0x64,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x70, 0x69, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x61, 0x79,
	0x62, 0x65, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0e, 0x6d, 0x61, 0x79, 0x62, 0x65, 0x45, 0x78, 0x65, 0x63, 0x50, 0x72,
	0x6f, 0x62, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0xb5, 0x03, 0x0a, 0x03, 0x50, 0x6f,
	0x64, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x31, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f,
	0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x09, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x3b, 0x0a, 0x0a, 0x70, 0x6f, 0x64, 0x5f, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x74, 0x65, 0x74,
	0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x64, 0x2e, 0x50, 0x6f, 0x64, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09, 0x70, 0x6f, 0x64, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12,
	0x23, 0x0a, 0x0d, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x6b, 0x69, 0x6e, 0x64,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x4b, 0x69, 0x6e, 0x64, 0x12, 0x4a, 0x0a, 0x0f, 0x70, 0x6f, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x64, 0x2e, 0x50, 0x6f, 0x64,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0e, 0x70, 0x6f, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x1a, 0x3c, 0x0a, 0x0e, 0x50, 0x6f, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x41,
	0x0a, 0x13, 0x50, 0x6f, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xc0, 0x01, 0x0a, 0x0c, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x12, 0x38, 0x0a, 0x09, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e,
	0x2e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x09, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x12, 0x38, 0x0a, 0x09,
	0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32,
	0x1a, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x65, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x3c, 0x0a, 0x0b, 0x69, 0x6e, 0x68, 0x65, 0x72, 0x69,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x74, 0x65,
	0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x69, 0x6e, 0x68, 0x65, 0x72, 0x69, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x22, 0x38, 0x0a, 0x09, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x69, 0x6e, 0x75, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x04, 0x69, 0x6e, 0x75, 0x6d, 0x12, 0x17, 0x0a, 0x07, 0x69, 0x73, 0x5f, 0x68, 0x6f, 0x73, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x69, 0x73, 0x48, 0x6f, 0x73, 0x74, 0x22, 0xce,
	0x03, 0x0a, 0x0a, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x25, 0x0a,
	0x03, 0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x74, 0x65, 0x74,
	0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52,
	0x03, 0x75, 0x74, 0x73, 0x12, 0x25, 0x0a, 0x03, 0x69, 0x70, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x13, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x03, 0x69, 0x70, 0x63, 0x12, 0x25, 0x0a, 0x03, 0x6d,
	0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61,
	0x67, 0x6f, 0x6e, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x03, 0x6d,
	0x6e, 0x74, 0x12, 0x25, 0x0a, 0x03, 0x70, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x52, 0x03, 0x70, 0x69, 0x64, 0x12, 0x3d, 0x0a, 0x10, 0x70, 0x69, 0x64,
	0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x0e, 0x70, 0x69, 0x64, 0x46, 0x6f, 0x72,
	0x43, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x03, 0x6e, 0x65, 0x74, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e,
	0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x03, 0x6e, 0x65, 0x74, 0x12,
	0x27, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x11, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x6f,
	0x72, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x12, 0x2b, 0x0a, 0x06, 0x63, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x74, 0x65, 0x74, 0x72,
	0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x06,
	0x63, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x27, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x22,
	0xc7, 0x01, 0x0a, 0x0d, 0x55, 0x73, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x12, 0x31, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x6c,
	0x65, 0x76, 0x65, 0x6c, 0x12, 0x2e, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x03, 0x75, 0x69, 0x64, 0x12, 0x2e, 0x0a, 0x03, 0x67, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x03, 0x67, 0x69, 0x64, 0x12, 0x23, 0x0a, 0x02, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x13, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x02, 0x6e, 0x73, 0x22, 0xbc, 0x04, 0x0a, 0x12, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73,
	0x12, 0x2e, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x75, 0x69, 0x64,
	0x12, 0x2e, 0x0a, 0x03, 0x67, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x67, 0x69, 0x64,
	0x12, 0x30, 0x0a, 0x04, 0x65, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x65, 0x75,
	0x69, 0x64, 0x12, 0x30, 0x0a, 0x04, 0x65, 0x67, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04,
	0x65, 0x67, 0x69, 0x64, 0x12, 0x30, 0x0a, 0x04, 0x73, 0x75, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x04, 0x73, 0x75, 0x69, 0x64, 0x12, 0x30, 0x0a, 0x04, 0x73, 0x67, 0x69, 0x64, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x04, 0x73, 0x67, 0x69, 0x64, 0x12, 0x32, 0x0a, 0x05, 0x66, 0x73, 0x75, 0x69,
	0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x66, 0x73, 0x75, 0x69, 0x64, 0x12, 0x32, 0x0a, 0x05,
	0x66, 0x73, 0x67, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49,
	0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x66, 0x73, 0x67, 0x69, 0x64,
	0x12, 0x38, 0x0a, 0x0a, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x62, 0x69, 0x74, 0x73, 0x18, 0x09,
	0x20, 0x03, 0x28, 0x0e, 0x32, 0x18, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x69, 0x74, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x62, 0x69, 0x74, 0x73, 0x12, 0x2a, 0x0a, 0x04, 0x63, 0x61,
	0x70, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61,
	0x67, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x52, 0x04, 0x63, 0x61, 0x70, 0x73, 0x12, 0x30, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6e,
	0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67,
	0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x4e, 0x73, 0x22, 0x5d, 0x0a, 0x0f, 0x49, 0x6e, 0x6f, 0x64,
	0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x6e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x6e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x22, 0x55, 0x0a, 0x0e, 0x46, 0x69, 0x6c, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x05, 0x69, 0x6e, 0x6f,
	0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61,
	0x67, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x52, 0x05, 0x69, 0x6e, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0xff,
	0x01, 0x0a, 0x10, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x06, 0x73, 0x65, 0x74, 0x75, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x06, 0x73, 0x65, 0x74, 0x75, 0x69, 0x64, 0x12, 0x34, 0x0a, 0x06, 0x73, 0x65, 0x74,
	0x67, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74,
	0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x73, 0x65, 0x74, 0x67, 0x69, 0x64, 0x12,
	0x51, 0x0a, 0x12, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x73, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x64, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x74, 0x65,
	0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x50, 0x72,
	0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x52,
	0x11, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x64, 0x12, 0x2c, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x18, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x46, 0x69, 0x6c, 0x65,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x04, 0x66, 0x69, 0x6c, 0x65,
	0x22, 0x20, 0x0a, 0x0a, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xc4, 0x06, 0x0a, 0x07, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x17,
	0x0a, 0x07, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x65, 0x78, 0x65, 0x63, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x03, 0x70, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x03, 0x70, 0x69, 0x64, 0x12, 0x2e, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x77, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x63, 0x77, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x69, 0x6e,
	0x61, 0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x69, 0x6e, 0x61, 0x72,
	0x79, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x14, 0x0a, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x30, 0x0a, 0x04, 0x61, 0x75, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x61, 0x75,
	0x69, 0x64, 0x12, 0x1f, 0x0a, 0x03, 0x70, 0x6f, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0d, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x64, 0x52, 0x03,
	0x70, 0x6f, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0e, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x65, 0x63, 0x49,
	0x64, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x66, 0x63, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x06, 0x72, 0x65, 0x66, 0x63, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x03, 0x63, 0x61, 0x70,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f,
	0x6e, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x03,
	0x63, 0x61, 0x70, 0x12, 0x24, 0x0a, 0x02, 0x6e, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x14, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x52, 0x02, 0x6e, 0x73, 0x12, 0x2e, 0x0a, 0x03, 0x74, 0x69, 0x64,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x74, 0x69, 0x64, 0x12, 0x4d, 0x0a, 0x13, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f,
	0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x73, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x43, 0x72, 0x65,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x47, 0x0a, 0x11, 0x62, 0x69, 0x6e, 0x61,
	0x72, 0x79, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x12, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x42,
	0x69, 0x6e, 0x61, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52,
	0x10, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x28, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x14, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52,
	0x65, 0x63, 0x6f, 0x72, 0x64, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x3c, 0x0a, 0x0c, 0x69,
	0x6e, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x5f, 0x74, 0x72, 0x65, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x69,
	0x6e, 0x49, 0x6e, 0x69, 0x74, 0x54, 0x72, 0x65, 0x65, 0x22, 0x96, 0x01, 0x0a, 0x0b, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x45, 0x78, 0x65, 0x63, 0x12, 0x2b, 0x0a, 0x07, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x65, 0x74,
	0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x07, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x29, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f,
	0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x2f, 0x0a, 0x09, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x09, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x73, 0x22, 0xf6, 0x01, 0x0a, 0x0b, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x45, 0x78,
	0x69, 0x74, 0x12, 0x2b, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12,
	0x29, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x69, 0x67, 0x6e,
	0x61, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x09, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x52, 0x09, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x22, 0x8a, 0x02, 0x0a, 0x0a,
	0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x53, 0x6f, 0x63, 0x6b, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x61,
	0x6d, 0x69, 0x6c, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x61, 0x6d, 0x69,
	0x6c, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x6d, 0x61, 0x72, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x04, 0x6d, 0x61, 0x72, 0x6b, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x61, 0x64, 0x64, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x73, 0x61, 0x64, 0x64, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x64, 0x61, 0x64, 0x64,
	0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x64, 0x61, 0x64, 0x64, 0x72, 0x12, 0x14,
	0x0a, 0x05, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x73,
	0x70, 0x6f, 0x72, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x64, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x05, 0x64, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f,
	0x6f, 0x6b, 0x69, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x63, 0x6f, 0x6f, 0x6b,
	0x69, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0xc9, 0x02, 0x0a, 0x09, 0x4b, 0x70, 0x72,
	0x6f, 0x62, 0x65, 0x53, 0x6b, 0x62, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x61, 0x73, 0x68, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x68, 0x61, 0x73, 0x68, 0x12, 0x10, 0x0a, 0x03, 0x6c, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x6c, 0x65, 0x6e, 0x12, 0x1a, 0x0a, 0x08,
	0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08,
	0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6d, 0x61, 0x72, 0x6b,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x6d, 0x61, 0x72, 0x6b, 0x12, 0x14, 0x0a, 0x05,
	0x73, 0x61, 0x64, 0x64, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x61, 0x64,
	0x64, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x64, 0x61, 0x64, 0x64, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x64, 0x61, 0x64, 0x64, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x70, 0x6f, 0x72,
	0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x14,
	0x0a, 0x05, 0x64, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x64,
	0x70, 0x6f, 0x72, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x05, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x0a, 0x0c, 0x73, 0x65,
	0x63, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x6c, 0x65, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0a, 0x73, 0x65, 0x63, 0x50, 0x61, 0x74, 0x68, 0x4c, 0x65, 0x6e, 0x12, 0x22, 0x0a, 0x0d,
	0x73, 0x65, 0x63, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x6f, 0x6c, 0x65, 0x6e, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x0b, 0x73, 0x65, 0x63, 0x50, 0x61, 0x74, 0x68, 0x4f, 0x6c, 0x65, 0x6e,
	0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x16, 0x0a, 0x06,
	0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x61,
	0x6d, 0x69, 0x6c, 0x79, 0x22, 0x50, 0x0a, 0x0e, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x53, 0x6f,
	0x63, 0x6b, 0x61, 0x64, 0x64, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x12, 0x12,
	0x0a, 0x04, 0x61, 0x64, 0x64, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x61, 0x64,
	0x64, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x22, 0x0a, 0x0c, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65,
	0x4e, 0x65, 0x74, 0x44, 0x65, 0x76, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6c, 0x0a, 0x0a, 0x4b, 0x70,
	0x72, 0x6f, 0x62, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x6c, 0x0a, 0x0a, 0x4b, 0x70, 0x72, 0x6f,
	0x62, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x12, 0x14, 0x0a, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x50, 0x0a, 0x14, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65,
	0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x1b,
	0x0a, 0x09, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x08, 0x62, 0x79, 0x74, 0x65, 0x73, 0x41, 0x72, 0x67, 0x12, 0x1b, 0x0a, 0x09, 0x6f,
	0x72, 0x69, 0x67, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08,
	0x6f, 0x72, 0x69, 0x67, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xbe, 0x01, 0x0a, 0x0a, 0x4b, 0x70, 0x72,
	0x6f, 0x62, 0x65, 0x43, 0x72, 0x65, 0x64, 0x12, 0x38, 0x0a, 0x09, 0x70, 0x65, 0x72, 0x6d, 0x69,
	0x74, 0x74, 0x65, 0x64, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x74, 0x65, 0x74,
	0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x74, 0x65,
	0x64, 0x12, 0x38, 0x0a, 0x09, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e,
	0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x09, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x3c, 0x0a, 0x0b, 0x69,
	0x6e, 0x68, 0x65, 0x72, 0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x1a, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x69, 0x6e,
	0x68, 0x65, 0x72, 0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x5d, 0x0a, 0x11, 0x4b, 0x70, 0x72,
	0x6f, 0x62, 0x65, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x42, 0x69, 0x6e, 0x70, 0x72, 0x6d, 0x12, 0x12,
	0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x59, 0x0a, 0x10, 0x4b, 0x70, 0x72, 0x6f,
	0x62, 0x65, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x31, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xd5, 0x01, 0x0a, 0x13, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x55, 0x73,
	0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x31, 0x0a, 0x05, 0x6c,
	0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x32,
	0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x12, 0x32, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x23, 0x0a, 0x02, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x13, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x02, 0x6e, 0x73, 0x22, 0x61, 0x0a, 0x0d, 0x4b,
	0x70, 0x72, 0x6f, 0x62, 0x65, 0x42, 0x70, 0x66, 0x41, 0x74, 0x74, 0x72, 0x12, 0x1a, 0x0a, 0x08,
	0x50, 0x72, 0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x50, 0x72, 0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x49, 0x6e, 0x73, 0x6e,
	0x43, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x49, 0x6e, 0x73, 0x6e, 0x43,
	0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x50, 0x72, 0x6f, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x7f,
	0x0a, 0x0f, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x50, 0x65, 0x72, 0x66, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x46, 0x75, 0x6e,
	0x63, 0x12, 0x12, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x20, 0x0a,
	0x0b, 0x50, 0x72, 0x6f, 0x62, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x0b, 0x50, 0x72, 0x6f, 0x62, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22,
	0x9a, 0x01, 0x0a, 0x0c, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x42, 0x70, 0x66, 0x4d, 0x61, 0x70,
	0x12, 0x18, 0x0a, 0x07, 0x4d, 0x61, 0x70, 0x54, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x4d, 0x61, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x4b, 0x65,
	0x79, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x4b, 0x65, 0x79,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x4d, 0x61, 0x78, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x4d, 0x61, 0x78, 0x45, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x4d, 0x61, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x4d, 0x61, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x2d, 0x0a, 0x09,
	0x53, 0x79, 0x73, 0x63, 0x61, 0x6c, 0x6c, 0x49, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x62, 0x69,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x61, 0x62, 0x69, 0x22, 0xb0, 0x0c, 0x0a, 0x0e,
	0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1f,
	0x0a, 0x0a, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x41, 0x72, 0x67, 0x12,
	0x19, 0x0a, 0x07, 0x69, 0x6e, 0x74, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x48, 0x00, 0x52, 0x06, 0x69, 0x6e, 0x74, 0x41, 0x72, 0x67, 0x12, 0x2e, 0x0a, 0x07, 0x73, 0x6b,
	0x62, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x74, 0x65,
	0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x53, 0x6b, 0x62,
	0x48, 0x00, 0x52, 0x06, 0x73, 0x6b, 0x62, 0x41, 0x72, 0x67, 0x12, 0x1b, 0x0a, 0x08, 0x73, 0x69,
	0x7a, 0x65, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x48, 0x00, 0x52, 0x07,
	0x73, 0x69, 0x7a, 0x65, 0x41, 0x72, 0x67, 0x12, 0x1d, 0x0a, 0x09, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x5f, 0x61, 0x72, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x08, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x41, 0x72, 0x67, 0x12, 0x31, 0x0a, 0x08, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x61,
	0x72, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61,
	0x67, 0x6f, 0x6e, 0x2e, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x50, 0x61, 0x74, 0x68, 0x48, 0x00,
	0x52, 0x07, 0x70, 0x61, 0x74, 0x68, 0x41, 0x72, 0x67, 0x12, 0x31, 0x0a, 0x08, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x74, 0x65,
	0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x46, 0x69, 0x6c,
	0x65, 0x48, 0x00, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x65, 0x41, 0x72, 0x67, 0x12, 0x50, 0x0a, 0x13,
	0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f,
	0x61, 0x72, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x74, 0x65, 0x74, 0x72,
	0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x54, 0x72, 0x75, 0x6e, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x48, 0x00, 0x52, 0x11, 0x74, 0x72, 0x75,
	0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x41, 0x72, 0x67, 0x12, 0x31,
	0x0a, 0x08, 0x73, 0x6f, 0x63, 0x6b, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4b, 0x70, 0x72, 0x6f,
	0x62, 0x65, 0x53, 0x6f, 0x63, 0x6b, 0x48, 0x00, 0x52, 0x07, 0x73, 0x6f, 0x63, 0x6b, 0x41, 0x72,
	0x67, 0x12, 0x31, 0x0a, 0x08, 0x63, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4b,
	0x70, 0x72, 0x6f, 0x62, 0x65, 0x43, 0x72, 0x65, 0x64, 0x48, 0x00, 0x52, 0x07, 0x63, 0x72, 0x65,
	0x64, 0x41, 0x72, 0x67, 0x12, 0x1b, 0x0a, 0x08, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x61, 0x72, 0x67,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x07, 0x6c, 0x6f, 0x6e, 0x67, 0x41, 0x72,
	0x67, 0x12, 0x3b, 0x0a, 0x0c, 0x62, 0x70, 0x66, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x5f, 0x61, 0x72,
	0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67,
	0x6f, 0x6e, 0x2e, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x42, 0x70, 0x66, 0x41, 0x74, 0x74, 0x72,
	0x48, 0x00, 0x52, 0x0a, 0x62, 0x70, 0x66, 0x41, 0x74, 0x74, 0x72, 0x41, 0x72, 0x67, 0x12, 0x41,
	0x0a, 0x0e, 0x70, 0x65, 0x72, 0x66, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x72, 0x67,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f,
	0x6e, 0x2e, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x50, 0x65, 0x72, 0x66, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x48, 0x00, 0x52, 0x0c, 0x70, 0x65, 0x72, 0x66, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x41, 0x72,
	0x67, 0x12, 0x38, 0x0a, 0x0b, 0x62, 0x70, 0x66, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x61, 0x72, 0x67,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f,
	0x6e, 0x2e, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x42, 0x70, 0x66, 0x4d, 0x61, 0x70, 0x48, 0x00,
	0x52, 0x09, 0x62, 0x70, 0x66, 0x4d, 0x61, 0x70, 0x41, 0x72, 0x67, 0x12, 0x1b, 0x0a, 0x08, 0x75,
	0x69, 0x6e, 0x74, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x00, 0x52,
	0x07, 0x75, 0x69, 0x6e, 0x74, 0x41, 0x72, 0x67, 0x12, 0x51, 0x0a, 0x12, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e,
	0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x55, 0x73, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x10, 0x75, 0x73, 0x65, 0x72, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x41, 0x72, 0x67, 0x12, 0x43, 0x0a, 0x0e, 0x63,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x11, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4b,
	0x70, 0x72, 0x6f, 0x62, 0x65, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x48,
	0x00, 0x52, 0x0d, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x41, 0x72, 0x67,
	0x12, 0x56, 0x0a, 0x17, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x72, 0x65, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x48,
	0x00, 0x52, 0x15, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x73, 0x41, 0x72, 0x67, 0x12, 0x39, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x6e, 0x73, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x4e, 0x73,
	0x41, 0x72, 0x67, 0x12, 0x37, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x61, 0x72,
	0x67, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67,
	0x6f, 0x6e, 0x2e, 0x4b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x48,
	0x00, 0x52, 0x09, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x41, 0x72, 0x67, 0x12, 0x29, 0x0a, 0x10,
	0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x5f, 0x63, 0x61, 0x70, 0x5f, 0x74, 0x5f, 0x61, 0x72, 0x67,
	0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0d, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c,
	0x43, 0x61, 0x70, 0x54, 0x41, 0x72, 0x67, 0x12, 0x30, 0x0a, 0x13, 0x63, 0x61, 0x70, 0x5f, 0x69,
	0x6e, 0x68, 0x65, 0x72, 0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x17,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x11, 0x63, 0x61, 0x70, 0x49, 0x6e, 0x68, 0x65, 0x72,
	0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x72, 0x67, 0x12, 0x2c, 0x0a, 0x11, 0x63, 0x61, 0x70,
	0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x18,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0f, 0x63, 0x61, 0x70, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x74, 0x74, 0x65, 0x64, 0x41, 0x72, 0x67, 0x12, 0x2c, 0x0a, 0x11, 0x63, 0x61, 0x70, 0x5f, 0x65,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x19, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x0f, 0x63, 0x61, 0x70, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x41, 0x72, 0x67, 0x12, 0x47, 0x0a, 0x10, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x5f, 0x62,
	0x69, 0x6e, 0x70, 0x72, 0x6d, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4b, 0x70, 0x72, 0x6f, 0x62,
	0x65, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x42, 0x69, 0x6e, 0x70, 0x72, 0x6d, 0x48, 0x00, 0x52, 0x0e,
	0x6c, 0x69, 0x6e, 0x75, 0x78, 0x42, 0x69, 0x6e, 0x70, 0x72, 0x6d, 0x41, 0x72, 0x67, 0x12, 0x38,
	0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x76, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x1b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4b,
	0x70, 0x72, 0x6f, 0x62, 0x65, 0x4e, 0x65, 0x74, 0x44, 0x65, 0x76, 0x48, 0x00, 0x52, 0x09, 0x6e,
	0x65, 0x74, 0x44, 0x65, 0x76, 0x41, 0x72, 0x67, 0x12, 0x32, 0x0a, 0x0b, 0x62, 0x70, 0x66, 0x5f,
	0x63, 0x6d, 0x64, 0x5f, 0x61, 0x72, 0x67, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e,
	0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x42, 0x70, 0x66, 0x43, 0x6d, 0x64, 0x48,
	0x00, 0x52, 0x09, 0x62, 0x70, 0x66, 0x43, 0x6d, 0x64, 0x41, 0x72, 0x67, 0x12, 0x34, 0x0a, 0x0a,
	0x73, 0x79, 0x73, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x13, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x53, 0x79, 0x73, 0x63,
	0x61, 0x6c, 0x6c, 0x49, 0x64, 0x48, 0x00, 0x52, 0x09, 0x73, 0x79, 0x73, 0x63, 0x61, 0x6c, 0x6c,
	0x49, 0x64, 0x12, 0x3d, 0x0a, 0x0c, 0x73, 0x6f, 0x63, 0x6b, 0x61, 0x64, 0x64, 0x72, 0x5f, 0x61,
	0x72, 0x67, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61,
	0x67, 0x6f, 0x6e, 0x2e, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x53, 0x6f, 0x63, 0x6b, 0x61, 0x64,
	0x64, 0x72, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x6f, 0x63, 0x6b, 0x61, 0x64, 0x64, 0x72, 0x41, 0x72,
	0x67, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x05, 0x0a, 0x03, 0x61, 0x72, 0x67, 0x22, 0xe7,
	0x04, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65,
	0x12, 0x2b, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x11, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x29, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a,
	0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x65,
	0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x41, 0x72, 0x67,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x12, 0x30, 0x0a, 0x06, 0x72,
	0x65, 0x74, 0x75, 0x72, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x65,
	0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x41, 0x72, 0x67,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x12, 0x2e, 0x0a,
	0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e,
	0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a,
	0x12, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x72,
	0x61, 0x63, 0x65, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x74, 0x65, 0x74, 0x72,
	0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x63,
	0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0d, 0x72, 0x65, 0x74, 0x75, 0x72,
	0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16,
	0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61,
	0x67, 0x73, 0x12, 0x43, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x5f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x74,
	0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61,
	0x63, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x72, 0x53, 0x74, 0x61,
	0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x12, 0x2f, 0x0a, 0x09, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x65, 0x74,
	0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x09, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x22, 0xf7, 0x02, 0x0a, 0x11, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x54, 0x72, 0x61, 0x63, 0x65, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x2b,
	0x0a, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x29, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x65,
	0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x12, 0x14,
	0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4b, 0x70,
	0x72, 0x6f, 0x62, 0x65, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x61, 0x72,
	0x67, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4b,
	0x70, 0x72, 0x6f, 0x62, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67,
	0x73, 0x12, 0x2f, 0x0a, 0x09, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x0b,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x09, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x73, 0x22, 0xff, 0x02, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x55, 0x70,
	0x72, 0x6f, 0x62, 0x65, 0x12, 0x2b, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e,
	0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x12, 0x29, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x11, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x2c, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x18, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4b, 0x70, 0x72,
	0x6f, 0x62, 0x65, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x61, 0x72, 0x67,
	0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x2f, 0x0a, 0x09, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61,
	0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x09, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x24,
	0x0a, 0x0e, 0x72, 0x65, 0x66, 0x5f, 0x63, 0x74, 0x72, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x72, 0x65, 0x66, 0x43, 0x74, 0x72, 0x4f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x22, 0x82, 0x03, 0x0a, 0x0a, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x4c, 0x73, 0x6d, 0x12, 0x2b, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x12, 0x29, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x11, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x2c, 0x0a, 0x04, 0x61,
	0x72, 0x67, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x65, 0x74, 0x72,
	0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x41, 0x72, 0x67, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x12, 0x2e, 0x0a, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x74, 0x65, 0x74, 0x72,
	0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x4b, 0x70, 0x72, 0x6f, 0x62, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x2f, 0x0a,
	0x09, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x11, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x52, 0x09, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x19,
	0x0a, 0x08, 0x69, 0x6d, 0x61, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x69, 0x6d, 0x61, 0x48, 0x61, 0x73, 0x68, 0x22, 0x96, 0x01, 0x0a, 0x0c, 0x4b, 0x65,
	0x72, 0x6e, 0x65, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3d,
	0x0a, 0x0c, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6f, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0b, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6b, 0x12, 0x33, 0x0a,
	0x07, 0x74, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x19,
	0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x69, 0x6e, 0x74, 0x65,
	0x64, 0x42, 0x69, 0x74, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x74, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x64, 0x22, 0x56, 0x0a, 0x04, 0x54, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x61, 0x72,
	0x67, 0x30, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x61, 0x72, 0x67, 0x30, 0x12, 0x12,
	0x0a, 0x04, 0x61, 0x72, 0x67, 0x31, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x61, 0x72,
	0x67, 0x31, 0x12, 0x12, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x32, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x04, 0x61, 0x72, 0x67, 0x32, 0x12, 0x12, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x33, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x61, 0x72, 0x67, 0x33, 0x22, 0x51, 0x0a, 0x16, 0x47, 0x65,
	0x74, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65,
	0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67,
	0x6f, 0x6e, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x08, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x22, 0x90, 0x01,
	0x0a, 0x0c, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x30,
	0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e,
	0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x12, 0x34, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1c, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x22, 0x56, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x0d, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x48, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x6a, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x4c, 0x6f, 0x61, 0x64, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x07, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x65, 0x74,
	0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x07, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x69, 0x64, 0x22, 0x64, 0x0a, 0x12, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x48,
	0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x0f, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x48, 0x00,
	0x52, 0x0f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x15, 0x0a, 0x13, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x48, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xa1, 0x03, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x50, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x50, 0x61, 0x74, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x6f, 0x6f, 0x74, 0x44,
	0x69, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x72, 0x6f, 0x6f, 0x74, 0x44, 0x69,
	0x72, 0x12, 0x4c, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f,
	0x6e, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x24, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x49, 0x44, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x44, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x6f, 0x64, 0x4e, 0x61,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x6f, 0x64, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x6f, 0x64, 0x55, 0x49, 0x44, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x70, 0x6f, 0x64, 0x55, 0x49, 0x44, 0x12, 0x22, 0x0a, 0x0c, 0x70, 0x6f, 0x64,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x70, 0x6f, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x26, 0x0a,
	0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x73, 0x0a, 0x0f, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72,
	0x61, 0x63, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x79,
	0x6d, 0x62, 0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x79, 0x6d, 0x62,
	0x6f, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2a, 0xc4, 0x03, 0x0a, 0x0c, 0x4b,
	0x70, 0x72, 0x6f, 0x62, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x15, 0x4b,
	0x50, 0x52, 0x4f, 0x42, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x4b, 0x50, 0x52, 0x4f, 0x42, 0x45,
	0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x4f, 0x53, 0x54, 0x10, 0x01, 0x12, 0x1a,
	0x0a, 0x16, 0x4b, 0x50, 0x52, 0x4f, 0x42, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x46, 0x4f, 0x4c, 0x4c, 0x4f, 0x57, 0x46, 0x44, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x4b, 0x50,
	0x52, 0x4f, 0x42, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x49, 0x47, 0x4b,
	0x49, 0x4c, 0x4c, 0x10, 0x03, 0x12, 0x1c, 0x0a, 0x18, 0x4b, 0x50, 0x52, 0x4f, 0x42, 0x45, 0x5f,
	0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x46, 0x4f, 0x4c, 0x4c, 0x4f, 0x57, 0x46,
	0x44, 0x10, 0x04, 0x12, 0x1a, 0x0a, 0x16, 0x4b, 0x50, 0x52, 0x4f, 0x42, 0x45, 0x5f, 0x41, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4f, 0x56, 0x45, 0x52, 0x52, 0x49, 0x44, 0x45, 0x10, 0x05, 0x12,
	0x18, 0x0a, 0x14, 0x4b, 0x50, 0x52, 0x4f, 0x42, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x43, 0x4f, 0x50, 0x59, 0x46, 0x44, 0x10, 0x06, 0x12, 0x18, 0x0a, 0x14, 0x4b, 0x50, 0x52,
	0x4f, 0x42, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x47, 0x45, 0x54, 0x55, 0x52,
	0x4c, 0x10, 0x07, 0x12, 0x1b, 0x0a, 0x17, 0x4b, 0x50, 0x52, 0x4f, 0x42, 0x45, 0x5f, 0x41, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x4e, 0x53, 0x4c, 0x4f, 0x4f, 0x4b, 0x55, 0x50, 0x10, 0x08,
	0x12, 0x18, 0x0a, 0x14, 0x4b, 0x50, 0x52, 0x4f, 0x42, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x4e, 0x4f, 0x50, 0x4f, 0x53, 0x54, 0x10, 0x09, 0x12, 0x18, 0x0a, 0x14, 0x4b, 0x50,
	0x52, 0x4f, 0x42, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x49, 0x47, 0x4e,
	0x41, 0x4c, 0x10, 0x0a, 0x12, 0x1b, 0x0a, 0x17, 0x4b, 0x50, 0x52, 0x4f, 0x42, 0x45, 0x5f, 0x41,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x53, 0x4f, 0x43, 0x4b, 0x10,
	0x0b, 0x12, 0x1d, 0x0a, 0x19, 0x4b, 0x50, 0x52, 0x4f, 0x42, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x53, 0x4f, 0x43, 0x4b, 0x10, 0x0c,
	0x12, 0x20, 0x0a, 0x1c, 0x4b, 0x50, 0x52, 0x4f, 0x42, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x59, 0x45, 0x4e, 0x46, 0x4f, 0x52, 0x43, 0x45, 0x52,
	0x10, 0x0d, 0x12, 0x2d, 0x0a, 0x29, 0x4b, 0x50, 0x52, 0x4f, 0x42, 0x45, 0x5f, 0x41, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4c, 0x45, 0x41, 0x4e, 0x55, 0x50, 0x45, 0x4e, 0x46, 0x4f, 0x52,
	0x43, 0x45, 0x52, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x0e, 0x2a, 0x4f, 0x0a, 0x10, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x44, 0x45,
	0x46, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x55, 0x53, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53,
	0x10, 0x01, 0x2a, 0x7c, 0x0a, 0x12, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x17, 0x0a, 0x13, 0x48, 0x45, 0x41, 0x4c,
	0x54, 0x48, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x44, 0x45, 0x46, 0x10,
	0x00, 0x12, 0x19, 0x0a, 0x15, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x55, 0x53, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15,
	0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x53, 0x54,
	0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x48, 0x45, 0x41, 0x4c, 0x54,
	0x48, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03,
	0x2a, 0x8d, 0x02, 0x0a, 0x0f, 0x54, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x64, 0x42, 0x69, 0x74, 0x73,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x41, 0x49, 0x4e, 0x54, 0x5f, 0x55, 0x4e,
	0x53, 0x45, 0x54, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x54, 0x41, 0x49, 0x4e, 0x54, 0x5f, 0x50,
	0x52, 0x4f, 0x50, 0x52, 0x49, 0x45, 0x54, 0x41, 0x52, 0x59, 0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c,
	0x45, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x41, 0x49, 0x4e, 0x54, 0x5f, 0x46, 0x4f, 0x52,
	0x43, 0x45, 0x44, 0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a,
	0x54, 0x41, 0x49, 0x4e, 0x54, 0x5f, 0x46, 0x4f, 0x52, 0x43, 0x45, 0x44, 0x5f, 0x55, 0x4e, 0x4c,
	0x4f, 0x41, 0x44, 0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x10, 0x04, 0x12, 0x18, 0x0a, 0x13,
	0x54, 0x41, 0x49, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x4d, 0x4f, 0x44,
	0x55, 0x4c, 0x45, 0x10, 0x80, 0x08, 0x12, 0x1d, 0x0a, 0x18, 0x54, 0x41, 0x49, 0x4e, 0x54, 0x5f,
	0x4f, 0x55, 0x54, 0x5f, 0x4f, 0x46, 0x5f, 0x54, 0x52, 0x45, 0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x55,
	0x4c, 0x45, 0x10, 0x80, 0x20, 0x12, 0x1a, 0x0a, 0x15, 0x54, 0x41, 0x49, 0x4e, 0x54, 0x5f, 0x55,
	0x4e, 0x53, 0x49, 0x47, 0x4e, 0x45, 0x44, 0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x10, 0x80,
	0x40, 0x12, 0x24, 0x0a, 0x1e, 0x54, 0x41, 0x49, 0x4e, 0x54, 0x5f, 0x4b, 0x45, 0x52, 0x4e, 0x45,
	0x4c, 0x5f, 0x4c, 0x49, 0x56, 0x45, 0x5f, 0x50, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x4d, 0x4f, 0x44,
	0x55, 0x4c, 0x45, 0x10, 0x80, 0x80, 0x02, 0x12, 0x17, 0x0a, 0x11, 0x54, 0x41, 0x49, 0x4e, 0x54,
	0x5f, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x10, 0x80, 0x80, 0x10,
	0x42, 0x2c, 0x5a, 0x2a, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63,
	0x69, 0x6c, 0x69, 0x75, 0x6d, 0x2f, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x65, 0x74, 0x72, 0x61, 0x67, 0x6f, 0x6e, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_tetragon_tetragon_proto_rawDescOnce sync.Once
	file_tetragon_tetragon_proto_rawDescData = file_tetragon_tetragon_proto_rawDesc
)

func file_tetragon_tetragon_proto_rawDescGZIP() []byte {
	file_tetragon_tetragon_proto_rawDescOnce.Do(func() {
		file_tetragon_tetragon_proto_rawDescData = protoimpl.X.CompressGZIP(file_tetragon_tetragon_proto_rawDescData)
	})
	return file_tetragon_tetragon_proto_rawDescData
}

var file_tetragon_tetragon_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_tetragon_tetragon_proto_msgTypes = make([]protoimpl.MessageInfo, 49)
var file_tetragon_tetragon_proto_goTypes = []any{
	(KprobeAction)(0),               // 0: tetragon.KprobeAction
	(HealthStatusType)(0),           // 1: tetragon.HealthStatusType
	(HealthStatusResult)(0),         // 2: tetragon.HealthStatusResult
	(TaintedBitsType)(0),            // 3: tetragon.TaintedBitsType
	(*Image)(nil),                   // 4: tetragon.Image
	(*SecurityContext)(nil),         // 5: tetragon.SecurityContext
	(*Container)(nil),               // 6: tetragon.Container
	(*Pod)(nil),                     // 7: tetragon.Pod
	(*Capabilities)(nil),            // 8: tetragon.Capabilities
	(*Namespace)(nil),               // 9: tetragon.Namespace
	(*Namespaces)(nil),              // 10: tetragon.Namespaces
	(*UserNamespace)(nil),           // 11: tetragon.UserNamespace
	(*ProcessCredentials)(nil),      // 12: tetragon.ProcessCredentials
	(*InodeProperties)(nil),         // 13: tetragon.InodeProperties
	(*FileProperties)(nil),          // 14: tetragon.FileProperties
	(*BinaryProperties)(nil),        // 15: tetragon.BinaryProperties
	(*UserRecord)(nil),              // 16: tetragon.UserRecord
	(*Process)(nil),                 // 17: tetragon.Process
	(*ProcessExec)(nil),             // 18: tetragon.ProcessExec
	(*ProcessExit)(nil),             // 19: tetragon.ProcessExit
	(*KprobeSock)(nil),              // 20: tetragon.KprobeSock
	(*KprobeSkb)(nil),               // 21: tetragon.KprobeSkb
	(*KprobeSockaddr)(nil),          // 22: tetragon.KprobeSockaddr
	(*KprobeNetDev)(nil),            // 23: tetragon.KprobeNetDev
	(*KprobePath)(nil),              // 24: tetragon.KprobePath
	(*KprobeFile)(nil),              // 25: tetragon.KprobeFile
	(*KprobeTruncatedBytes)(nil),    // 26: tetragon.KprobeTruncatedBytes
	(*KprobeCred)(nil),              // 27: tetragon.KprobeCred
	(*KprobeLinuxBinprm)(nil),       // 28: tetragon.KprobeLinuxBinprm
	(*KprobeCapability)(nil),        // 29: tetragon.KprobeCapability
	(*KprobeUserNamespace)(nil),     // 30: tetragon.KprobeUserNamespace
	(*KprobeBpfAttr)(nil),           // 31: tetragon.KprobeBpfAttr
	(*KprobePerfEvent)(nil),         // 32: tetragon.KprobePerfEvent
	(*KprobeBpfMap)(nil),            // 33: tetragon.KprobeBpfMap
	(*SyscallId)(nil),               // 34: tetragon.SyscallId
	(*KprobeArgument)(nil),          // 35: tetragon.KprobeArgument
	(*ProcessKprobe)(nil),           // 36: tetragon.ProcessKprobe
	(*ProcessTracepoint)(nil),       // 37: tetragon.ProcessTracepoint
	(*ProcessUprobe)(nil),           // 38: tetragon.ProcessUprobe
	(*ProcessLsm)(nil),              // 39: tetragon.ProcessLsm
	(*KernelModule)(nil),            // 40: tetragon.KernelModule
	(*Test)(nil),                    // 41: tetragon.Test
	(*GetHealthStatusRequest)(nil),  // 42: tetragon.GetHealthStatusRequest
	(*HealthStatus)(nil),            // 43: tetragon.HealthStatus
	(*GetHealthStatusResponse)(nil), // 44: tetragon.GetHealthStatusResponse
	(*ProcessLoader)(nil),           // 45: tetragon.ProcessLoader
	(*RuntimeHookRequest)(nil),      // 46: tetragon.RuntimeHookRequest
	(*RuntimeHookResponse)(nil),     // 47: tetragon.RuntimeHookResponse
	(*CreateContainer)(nil),         // 48: tetragon.CreateContainer
	(*StackTraceEntry)(nil),         // 49: tetragon.StackTraceEntry
	nil,                             // 50: tetragon.Pod.PodLabelsEntry
	nil,                             // 51: tetragon.Pod.PodAnnotationsEntry
	nil,                             // 52: tetragon.CreateContainer.AnnotationsEntry
	(*timestamppb.Timestamp)(nil),   // 53: google.protobuf.Timestamp
	(*wrapperspb.UInt32Value)(nil),  // 54: google.protobuf.UInt32Value
	(CapabilitiesType)(0),           // 55: tetragon.CapabilitiesType
	(*wrapperspb.Int32Value)(nil),   // 56: google.protobuf.Int32Value
	(SecureBitsType)(0),             // 57: tetragon.SecureBitsType
	(ProcessPrivilegesChanged)(0),   // 58: tetragon.ProcessPrivilegesChanged
	(*wrapperspb.BoolValue)(nil),    // 59: google.protobuf.BoolValue
	(BpfCmd)(0),                     // 60: tetragon.BpfCmd
}
var file_tetragon_tetragon_proto_depIdxs = []int32{
	4,   // 0: tetragon.Container.image:type_name -> tetragon.Image
	53,  // 1: tetragon.Container.start_time:type_name -> google.protobuf.Timestamp
	54,  // 2: tetragon.Container.pid:type_name -> google.protobuf.UInt32Value
	5,   // 3: tetragon.Container.security_context:type_name -> tetragon.SecurityContext
	6,   // 4: tetragon.Pod.container:type_name -> tetragon.Container
	50,  // 5: tetragon.Pod.pod_labels:type_name -> tetragon.Pod.PodLabelsEntry
	51,  // 6: tetragon.Pod.pod_annotations:type_name -> tetragon.Pod.PodAnnotationsEntry
	55,  // 7: tetragon.Capabilities.permitted:type_name -> tetragon.CapabilitiesType
	55,  // 8: tetragon.Capabilities.effective:type_name -> tetragon.CapabilitiesType
	55,  // 9: tetragon.Capabilities.inheritable:type_name -> tetragon.CapabilitiesType
	9,   // 10: tetragon.Namespaces.uts:type_name -> tetragon.Namespace
	9,   // 11: tetragon.Namespaces.ipc:type_name -> tetragon.Namespace
	9,   // 12: tetragon.Namespaces.mnt:type_name -> tetragon.Namespace
	9,   // 13: tetragon.Namespaces.pid:type_name -> tetragon.Namespace
	9,   // 14: tetragon.Namespaces.pid_for_children:type_name -> tetragon.Namespace
	9,   // 15: tetragon.Namespaces.net:type_name -> tetragon.Namespace
	9,   // 16: tetragon.Namespaces.time:type_name -> tetragon.Namespace
	9,   // 17: tetragon.Namespaces.time_for_children:type_name -> tetragon.Namespace
	9,   // 18: tetragon.Namespaces.cgroup:type_name -> tetragon.Namespace
	9,   // 19: tetragon.Namespaces.user:type_name -> tetragon.Namespace
	56,  // 20: tetragon.UserNamespace.level:type_name -> google.protobuf.Int32Value
	54,  // 21: tetragon.UserNamespace.uid:type_name -> google.protobuf.UInt32Value
	54,  // 22: tetragon.UserNamespace.gid:type_name -> google.protobuf.UInt32Value
	9,   // 23: tetragon.UserNamespace.ns:type_name -> tetragon.Namespace
	54,  // 24: tetragon.ProcessCredentials.uid:type_name -> google.protobuf.UInt32Value
	54,  // 25: tetragon.ProcessCredentials.gid:type_name -> google.protobuf.UInt32Value
	54,  // 26: tetragon.ProcessCredentials.euid:type_name -> google.protobuf.UInt32Value
	54,  // 27: tetragon.ProcessCredentials.egid:type_name -> google.protobuf.UInt32Value
	54,  // 28: tetragon.ProcessCredentials.suid:type_name -> google.protobuf.UInt32Value
	54,  // 29: tetragon.ProcessCredentials.sgid:type_name -> google.protobuf.UInt32Value
	54,  // 30: tetragon.ProcessCredentials.fsuid:type_name -> google.protobuf.UInt32Value
	54,  // 31: tetragon.ProcessCredentials.fsgid:type_name -> google.protobuf.UInt32Value
	57,  // 32: tetragon.ProcessCredentials.securebits:type_name -> tetragon.SecureBitsType
	8,   // 33: tetragon.ProcessCredentials.caps:type_name -> tetragon.Capabilities
	11,  // 34: tetragon.ProcessCredentials.user_ns:type_name -> tetragon.UserNamespace
	54,  // 35: tetragon.InodeProperties.links:type_name -> google.protobuf.UInt32Value
	13,  // 36: tetragon.FileProperties.inode:type_name -> tetragon.InodeProperties
	54,  // 37: tetragon.BinaryProperties.setuid:type_name -> google.protobuf.UInt32Value
	54,  // 38: tetragon.BinaryProperties.setgid:type_name -> google.protobuf.UInt32Value
	58,  // 39: tetragon.BinaryProperties.privileges_changed:type_name -> tetragon.ProcessPrivilegesChanged
	14,  // 40: tetragon.BinaryProperties.file:type_name -> tetragon.FileProperties
	54,  // 41: tetragon.Process.pid:type_name -> google.protobuf.UInt32Value
	54,  // 42: tetragon.Process.uid:type_name -> google.protobuf.UInt32Value
	53,  // 43: tetragon.Process.start_time:type_name -> google.protobuf.Timestamp
	54,  // 44: tetragon.Process.auid:type_name -> google.protobuf.UInt32Value
	7,   // 45: tetragon.Process.pod:type_name -> tetragon.Pod
	8,   // 46: tetragon.Process.cap:type_name -> tetragon.Capabilities
	10,  // 47: tetragon.Process.ns:type_name -> tetragon.Namespaces
	54,  // 48: tetragon.Process.tid:type_name -> google.protobuf.UInt32Value
	12,  // 49: tetragon.Process.process_credentials:type_name -> tetragon.ProcessCredentials
	15,  // 50: tetragon.Process.binary_properties:type_name -> tetragon.BinaryProperties
	16,  // 51: tetragon.Process.user:type_name -> tetragon.UserRecord
	59,  // 52: tetragon.Process.in_init_tree:type_name -> google.protobuf.BoolValue
	17,  // 53: tetragon.ProcessExec.process:type_name -> tetragon.Process
	17,  // 54: tetragon.ProcessExec.parent:type_name -> tetragon.Process
	17,  // 55: tetragon.ProcessExec.ancestors:type_name -> tetragon.Process
	17,  // 56: tetragon.ProcessExit.process:type_name -> tetragon.Process
	17,  // 57: tetragon.ProcessExit.parent:type_name -> tetragon.Process
	53,  // 58: tetragon.ProcessExit.time:type_name -> google.protobuf.Timestamp
	17,  // 59: tetragon.ProcessExit.ancestors:type_name -> tetragon.Process
	55,  // 60: tetragon.KprobeCred.permitted:type_name -> tetragon.CapabilitiesType
	55,  // 61: tetragon.KprobeCred.effective:type_name -> tetragon.CapabilitiesType
	55,  // 62: tetragon.KprobeCred.inheritable:type_name -> tetragon.CapabilitiesType
	56,  // 63: tetragon.KprobeCapability.value:type_name -> google.protobuf.Int32Value
	56,  // 64: tetragon.KprobeUserNamespace.level:type_name -> google.protobuf.Int32Value
	54,  // 65: tetragon.KprobeUserNamespace.owner:type_name -> google.protobuf.UInt32Value
	54,  // 66: tetragon.KprobeUserNamespace.group:type_name -> google.protobuf.UInt32Value
	9,   // 67: tetragon.KprobeUserNamespace.ns:type_name -> tetragon.Namespace
	21,  // 68: tetragon.KprobeArgument.skb_arg:type_name -> tetragon.KprobeSkb
	24,  // 69: tetragon.KprobeArgument.path_arg:type_name -> tetragon.KprobePath
	25,  // 70: tetragon.KprobeArgument.file_arg:type_name -> tetragon.KprobeFile
	26,  // 71: tetragon.KprobeArgument.truncated_bytes_arg:type_name -> tetragon.KprobeTruncatedBytes
	20,  // 72: tetragon.KprobeArgument.sock_arg:type_name -> tetragon.KprobeSock
	27,  // 73: tetragon.KprobeArgument.cred_arg:type_name -> tetragon.KprobeCred
	31,  // 74: tetragon.KprobeArgument.bpf_attr_arg:type_name -> tetragon.KprobeBpfAttr
	32,  // 75: tetragon.KprobeArgument.perf_event_arg:type_name -> tetragon.KprobePerfEvent
	33,  // 76: tetragon.KprobeArgument.bpf_map_arg:type_name -> tetragon.KprobeBpfMap
	30,  // 77: tetragon.KprobeArgument.user_namespace_arg:type_name -> tetragon.KprobeUserNamespace
	29,  // 78: tetragon.KprobeArgument.capability_arg:type_name -> tetragon.KprobeCapability
	12,  // 79: tetragon.KprobeArgument.process_credentials_arg:type_name -> tetragon.ProcessCredentials
	11,  // 80: tetragon.KprobeArgument.user_ns_arg:type_name -> tetragon.UserNamespace
	40,  // 81: tetragon.KprobeArgument.module_arg:type_name -> tetragon.KernelModule
	28,  // 82: tetragon.KprobeArgument.linux_binprm_arg:type_name -> tetragon.KprobeLinuxBinprm
	23,  // 83: tetragon.KprobeArgument.net_dev_arg:type_name -> tetragon.KprobeNetDev
	60,  // 84: tetragon.KprobeArgument.bpf_cmd_arg:type_name -> tetragon.BpfCmd
	34,  // 85: tetragon.KprobeArgument.syscall_id:type_name -> tetragon.SyscallId
	22,  // 86: tetragon.KprobeArgument.sockaddr_arg:type_name -> tetragon.KprobeSockaddr
	17,  // 87: tetragon.ProcessKprobe.process:type_name -> tetragon.Process
	17,  // 88: tetragon.ProcessKprobe.parent:type_name -> tetragon.Process
	35,  // 89: tetragon.ProcessKprobe.args:type_name -> tetragon.KprobeArgument
	35,  // 90: tetragon.ProcessKprobe.return:type_name -> tetragon.KprobeArgument
	0,   // 91: tetragon.ProcessKprobe.action:type_name -> tetragon.KprobeAction
	49,  // 92: tetragon.ProcessKprobe.kernel_stack_trace:type_name -> tetragon.StackTraceEntry
	0,   // 93: tetragon.ProcessKprobe.return_action:type_name -> tetragon.KprobeAction
	49,  // 94: tetragon.ProcessKprobe.user_stack_trace:type_name -> tetragon.StackTraceEntry
	17,  // 95: tetragon.ProcessKprobe.ancestors:type_name -> tetragon.Process
	17,  // 96: tetragon.ProcessTracepoint.process:type_name -> tetragon.Process
	17,  // 97: tetragon.ProcessTracepoint.parent:type_name -> tetragon.Process
	35,  // 98: tetragon.ProcessTracepoint.args:type_name -> tetragon.KprobeArgument
	0,   // 99: tetragon.ProcessTracepoint.action:type_name -> tetragon.KprobeAction
	17,  // 100: tetragon.ProcessTracepoint.ancestors:type_name -> tetragon.Process
	17,  // 101: tetragon.ProcessUprobe.process:type_name -> tetragon.Process
	17,  // 102: tetragon.ProcessUprobe.parent:type_name -> tetragon.Process
	35,  // 103: tetragon.ProcessUprobe.args:type_name -> tetragon.KprobeArgument
	17,  // 104: tetragon.ProcessUprobe.ancestors:type_name -> tetragon.Process
	17,  // 105: tetragon.ProcessLsm.process:type_name -> tetragon.Process
	17,  // 106: tetragon.ProcessLsm.parent:type_name -> tetragon.Process
	35,  // 107: tetragon.ProcessLsm.args:type_name -> tetragon.KprobeArgument
	0,   // 108: tetragon.ProcessLsm.action:type_name -> tetragon.KprobeAction
	17,  // 109: tetragon.ProcessLsm.ancestors:type_name -> tetragon.Process
	59,  // 110: tetragon.KernelModule.signature_ok:type_name -> google.protobuf.BoolValue
	3,   // 111: tetragon.KernelModule.tainted:type_name -> tetragon.TaintedBitsType
	1,   // 112: tetragon.GetHealthStatusRequest.event_set:type_name -> tetragon.HealthStatusType
	1,   // 113: tetragon.HealthStatus.event:type_name -> tetragon.HealthStatusType
	2,   // 114: tetragon.HealthStatus.status:type_name -> tetragon.HealthStatusResult
	43,  // 115: tetragon.GetHealthStatusResponse.health_status:type_name -> tetragon.HealthStatus
	17,  // 116: tetragon.ProcessLoader.process:type_name -> tetragon.Process
	48,  // 117: tetragon.RuntimeHookRequest.createContainer:type_name -> tetragon.CreateContainer
	52,  // 118: tetragon.CreateContainer.annotations:type_name -> tetragon.CreateContainer.AnnotationsEntry
	119, // [119:119] is the sub-list for method output_type
	119, // [119:119] is the sub-list for method input_type
	119, // [119:119] is the sub-list for extension type_name
	119, // [119:119] is the sub-list for extension extendee
	0,   // [0:119] is the sub-list for field type_name
}

func init() { file_tetragon_tetragon_proto_init() }
func file_tetragon_tetragon_proto_init() {
	if File_tetragon_tetragon_proto != nil {
		return
	}
	file_tetragon_bpf_proto_init()
	file_tetragon_capabilities_proto_init()
	file_tetragon_tetragon_proto_msgTypes[31].OneofWrappers = []any{
		(*KprobeArgument_StringArg)(nil),
		(*KprobeArgument_IntArg)(nil),
		(*KprobeArgument_SkbArg)(nil),
		(*KprobeArgument_SizeArg)(nil),
		(*KprobeArgument_BytesArg)(nil),
		(*KprobeArgument_PathArg)(nil),
		(*KprobeArgument_FileArg)(nil),
		(*KprobeArgument_TruncatedBytesArg)(nil),
		(*KprobeArgument_SockArg)(nil),
		(*KprobeArgument_CredArg)(nil),
		(*KprobeArgument_LongArg)(nil),
		(*KprobeArgument_BpfAttrArg)(nil),
		(*KprobeArgument_PerfEventArg)(nil),
		(*KprobeArgument_BpfMapArg)(nil),
		(*KprobeArgument_UintArg)(nil),
		(*KprobeArgument_UserNamespaceArg)(nil),
		(*KprobeArgument_CapabilityArg)(nil),
		(*KprobeArgument_ProcessCredentialsArg)(nil),
		(*KprobeArgument_UserNsArg)(nil),
		(*KprobeArgument_ModuleArg)(nil),
		(*KprobeArgument_KernelCapTArg)(nil),
		(*KprobeArgument_CapInheritableArg)(nil),
		(*KprobeArgument_CapPermittedArg)(nil),
		(*KprobeArgument_CapEffectiveArg)(nil),
		(*KprobeArgument_LinuxBinprmArg)(nil),
		(*KprobeArgument_NetDevArg)(nil),
		(*KprobeArgument_BpfCmdArg)(nil),
		(*KprobeArgument_SyscallId)(nil),
		(*KprobeArgument_SockaddrArg)(nil),
	}
	file_tetragon_tetragon_proto_msgTypes[42].OneofWrappers = []any{
		(*RuntimeHookRequest_CreateContainer)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_tetragon_tetragon_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   49,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_tetragon_tetragon_proto_goTypes,
		DependencyIndexes: file_tetragon_tetragon_proto_depIdxs,
		EnumInfos:         file_tetragon_tetragon_proto_enumTypes,
		MessageInfos:      file_tetragon_tetragon_proto_msgTypes,
	}.Build()
	File_tetragon_tetragon_proto = out.File
	file_tetragon_tetragon_proto_rawDesc = nil
	file_tetragon_tetragon_proto_goTypes = nil
	file_tetragon_tetragon_proto_depIdxs = nil
}
