---
myst:
  html_meta:
    keywords: LaTeX,graphiques,dessins,image sur une page,image indépendante,MetaPost"
---
# Comment créer une image indépendante en SVG ?

Une fois que l'on a pris l'habitude d'utiliser LaTeX pour dessiner ou représenter ses données, notamment avec les extensions <ctanpkg:TikZ> et <ctanpkg:pgfplots>, il est tentant d'y avoir recours dans d'autres contextes que la préparation d'un document LaTeX.

La classe <ctanpkg:standalone> permet de produire facilement une image
indépendante, contenue dans un document PDF faisant juste la taille de son contenu. Elle
propose aussi des options pour générer des fichiers dans d'autres formats
graphiques, comme [SVG](wpfr:Scalable_Vector_Graphics) ou
[PNG](wpfr:Portable_Network_Graphics). 

D’autres logiciels du monde de TeX dédiés à la production graphique vous
permettent de créer des images dans d’autres format que le PDF. 

## Comment créer une image indépendante ?

Il suffit d'appeler la classe <ctanpkg:standalone>. Il devient inutile de
préciser la taille du papier : celle-ci sera ajustée exactement à la taille
finale de l'image. 

Avec l'option de classe `tikz`, le chargement de Ti*k*Z se fait automatiquement :

```
\documentclass[tikz]{standalone}
\begin{document}
\begin{tikzpicture}
  \fill[orange] (0,0) circle (2cm);
  \node[font=\bfseries] at (0cm,0cm) {SVG};
\end{tikzpicture}
\end{document}
```

Si vous avez besoin de charger des bibliothèques Ti*k*Z, vous pouvez le faire avec `\usetikzlibrary{...}` dans le préambule de votre document :

```{noedit}
\usetikzlibrary{arrows,snakes}
```

:::{warning}
La classe `standalone` ne doit pas être confondue [avec la classe
`minimal`](https://faq.gutenberg-asso.fr/2_programmation/extensions/classe_minimal) :

- <ctanpkg:minimal> est un simple exemple théorique d'une classe minimale, qui
  n'est pas destinée à être utilisée.
- <ctanpkg:standalone> vous fournit au contraire de nombreuses options pour
produire des documents indépendants.
:::

## Comment produire un fichier SVG à partir d'un fichier TeX ?

### Avec les options de l'extension <ctanpkg:standalone>

L'extension <ctanpkg:standalone> peut se charger elle-même de la conversion du document produit en un autre format graphique. L'option de classe `convert` est faite pour cela. En utilisant en plus la primitive TeX `\jobname`, le nom du fichier SVG créé pourra être le même que celui du document PDF :

```{noedit}
\documentclass[tikz,convert={outfile=\jobname.svg}]{standalone}
```

La conversion de format n'est pas implémentée directement en TeX. La classe <ctanpkg:standalone> appelle en fait des convertisseurs externes, comme [ImageMagick](wpfr:ImageMagick) ou `pdf2svg`, qui doivent être installés.

Si lors de la compilation, vous avez l'avertissement :

```text
Class standalone Warning: Conversion failed! Please ensure that shell escape
(standalone)              is enabled (e.g. use '-shell-escape').
```

Cela veut dire que votre installation de LaTeX empêche par défaut l'exécution de sous-programmes externes, pour des raisons de sécurité.

Comme indiqué dans le message d'avertissement, pour autoriser manuellement cette exécution, vous pouvez utiliser l'option de ligne de commande `-shell-escape` pour lancer la compilation :

```bash
pdflatex -shell-escape fichier.tex
```

:::{warning}
Vous pouvez rencontrer d'autres messages d'avertissement lors de la compilation de votre document vers le format SVG :

```text
Output written on fichier.pdf (1 page, 13115 bytes).
Transcript written on fichier.log.
convert: attempt to perform an operation not allowed by the security policy `PDF' @ error/constitute.c/IsCoderAuthorized/422.
convert: no images defined `fichier.svg' @ error/convert.c/ConvertImageCommand/3285.
system returned with code 256

Class standalone Warning: Conversion unsuccessful!
(standalone)              There might be something wrong with your
(standalone)              conversation software or the file permissions!
```

Le problème est lié à une faille de sécurité dans le traitement des fichiers PDF
par GhostScript pour les versions antérieures à 9.24 ([repérée en
2018](https://www.kb.cert.org/vuls/id/332928/)). Pour limiter les conséquences
de cette faille de sécurité, les développeurs d'ImageMagick ont temporairement
configuré leur logiciel pour refuser de traiter les fichiers PDF.

Ce problème a été résolu avec la version 9.24 de GhosScript.
:::
### En ligne de commande

Vous pouvez également appeler ImageMagick vous-même, en ligne de commande, sur
le PDF généré avec LaTeX, en utilisant la ligne de commande suivante :

```bash
convert fichier.pdf fichier.svg
```

## Avec MetaPost

MetaPost permet lui aussi de générer de fichiers PDF, SVG ou PNG. 
Par défaut, MetaPost produit du _Encapsulated PostScript_ (EPSF). Ainsi, la
ligne de commande suivante
```bash
mpost fichier.mp
```
produira le fichier `fichier.1` (si la figure est numérotée 1 dans le code
MetaPost) qui sera un fichier PostScript. 

### Fichier PDF

Les distributions TeX fournisse aussi le programme `mptopdf` qui permet de
produire un fichier PDF. Ainsi, la commande suivante :
```bash
mptopdf fichier.mp
```
produira le fichier `fichier-1.pdf`. 

### Fichier SVG

Pour obtenir un fichier SVG, il faudra rajouter le code suivant dans le fichier
MetaPost :
```text
outputformat:="svg";
```
La ligne de commande suivante
```bash
mpost fichier.mp
```
produira alors le fichier **SVG** `fichier.1`. 

:::{tip}
Si on souhaite un nommage de fichier plus standard, il suffira d’ajouter dans
son code MetaPost
```text
outputtemplate:= "%j-%c.svg";
```
pour obtenir à la suite de la compilation par `mpost` le fichier `fichier-1.svg`.
:::

### Fichier PNG

Pour obtenir un fichier PNG, il faudra rajouter le code suivant dans le fichier
MetaPost :
```text
outputformat:="png";
```
La ligne de commande suivante
```bash
mpost fichier.mp
```
produira alors le fichier **PNG** `fichier.1`. 
:::{tip}
Encore une fois, si on souhaite un nommage de fichier plus standard, il suffira d’ajouter dans
son code MetaPost
```text
outputtemplate:= "%j-%c.png";
```
pour obtenir à la suite de la compilation par `mpost` le fichier
`fichier-1.png`.

On pourra régler aussi la résolution du fichier PNG en modifiant les trois
variables `outputformatoptions`, `hppp` et `vppp`. La résolution par défaut est
de 72dpi (_dots per inch_). Les variables `hppp` et `vppp` permettent de définir
le facteur d’échelle en points par pixel (_points per pixel_). 
:::





:::{sources}
- [How can I use TikZ to make standalone (SVG) graphics?](https://tex.stackexchange.com/questions/51757/how-can-i-use-tikz-to-make-standalone-svg-graphics)
- [ImageMagick security policy ‘PDF’ blocking conversion](https://stackoverflow.com/questions/52998331/imagemagick-security-policy-pdf-blocking-conversion).
:::
