---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, tableau, array, 
              matrice, tabular
---

# Comment composer un tableau en mode mathématique ?

Avant toute chose, les mécanismes vus par la suite sont très similaires
à ceux vus à la question "[](/3_composition/tableaux/construire_un_tableau)",
à ceci près que l'environnement contenant le tableau change.


## Avec les commandes de base

En mode mathématique, un tableau se compose dans un environnement `array`, 
comme dans cet exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\large Résultats :
\[
  \begin{array}{|c @=c|}
    \hline
    \alpha + \beta & 12 \\
    \hline
    \sqrt{\gamma} & 36 \\
    \hline
  \end{array}
\]
\end{document}
```

S'il existe un environnement `tabular` pour mettre en forme des tableaux, 
il reste bien distinct de `array` :  
- dans un environnement `array`, le contenu des cellules est composé 
  en mode mathématique (comme s'il y avait des `$...$` autour de 
  chaque cellule) ;
- dans un environnement `tabular`, le contenu des cellules est composé 
  en mode texte.

Il est parfaitement possible d'insérer un environnement `tabular` 
en mode mathématique, mais ses cellules resteront composées en mode texte.
Par contre, il faut être en mode mathématique pour insérer un `array`.

Les environnements `array` et `tabular` partagent beaucoup de choses, 
mais utilisent aussi chacun des paramètres spécifiques. Par exemple, l'espace
séparant deux colonnes est défini de façon distincte :
- par `\arraycolsep` pour `array` ; 
- par `\tabcolsep` pour `tabular`.

Notez que même dans un environnement `array`, les 
spécificateurs de colonnes `p`, `m` et `b`, vus à la question 
"[](/3_composition/tableaux/construire_un_tableau)", basculent le contenu 
des cellules en mode texte.


## Avec l'extension <ctanpkg:array>

L'extension <ctanpkg:array> est très utile pour mettre en forme les tableaux
en se basant sur l'environnement `array`. Elle pourra donc vous servir 
pour des mises en forme particulières. Malgré son nom, elle modifie 
le comportement à la fois des environnements `array` et `tabular`. 
Sur ce sujet, vous pouvez pas exemple consulter 
"[](/3_composition/tableaux/lignes/augmenter_la_largeur_des_lignes_d_un_tableau)".


:::{sources}
- [Difference between tabular and array environment](https://tex.stackexchange.com/q/204838), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::