---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, choisir une police, choisir une fonte, polices T1, 
              polices Type 1, fontes PostScript
---

# Où trouver des fontes de type 1 "8-bit" ?

Des réponses de cette FAQ recommandent d'utiliser une police "8 bits" pour permettre 
[l'accentuation](/3_composition/langues/cesure/coupures_de_mots_accentues) 
des [langues flexionnelles](wpfr:Langue_flexionnelle) 
ainsi que l'utilisation de polices de type 1 pour s'assurer d'obtenir 
[un PDF de bonne qualité](/5_fichiers/formats/fontes/mon_document_est_flou_a_cause_des_fontes_t3). 
Ces recommandations étaient autrefois contradictoires : on ne pouvait pas simplement "passer" 
des polices *Computer Modern* libres aux polices de type 1 avec encodage de Cork (ou similaires). 
La première approche qui a permis d'atténuer ces problèmes a été le développement 
de polices virtuelles qui constituent une bonne approche de l'encodage Cork (voir ci-dessous). 
Aujourd'hui, cependant, nous disposons de "vraies" polices de type 1, 
avec des alternatives gratuites, commerciales et *shareware*.

- <ctanpkg:CM-super> est un ensemble auto-tracé qui englobe tous les encodages T1 et TS1 
  ainsi que la série T2\* (la famille d'encodages qui couvre les langues 
  basées sur les alphabets cyrilliques). Ces polices sont assez faciles à installer 
  (les instructions d'installation sont claires), mais elles sont volumineuses : 
  n'essayez pas de les installer si vous manquez d'espace disque.

- <ctanpkg:CM-LGC> est un ensemble de "super-fontes" similaire 
  mais de taille beaucoup plus modeste. Il couvre les encodages T1, TS1 et T2A 
  (comme <ctanpkg:CM-super>, et couvre également l'encodage LGR (pour la composition du grec, 
  basé sur les sources MetaFont de Claudio Beccari). <ctanpkg:CM-LGC> parvient à rester modeste 
  en taille en allant à l'extrême opposé de <ctanpkg:CM-super>, 
  qui inclut des polices à toutes les tailles supportées par la fonte *European Computer* originale 
  (une gamme énorme). En effet, <ctanpkg:CM-LGC> a une police par forme de police, 
  obtenant d'autres tailles par mise à l'échelle. 
  Cette approche entraîne inévitablement une perte de qualité, 
  mais pour les machines dont l'espace disque est limité, <ctanpkg:CM-LGC> est un choix évident.

- <ctanpkg:Tt2001> est un simple scan des polices *European Computer* 
  et des polices *[Text Companion](/5_fichiers/formats/fontes/que_sont_les_fontes_ec)*, 
  et a quelques vertus : il est sensiblement plus petit que <ctanpkg:CM-super> 
  tout en étant moins austère que <ctanpkg:CM-LGC>.

- *[Latin Modern](ctanpkg:lm)* est produit en utilisant le programme 
  [MetaType1](/5_fichiers/formats/fontes/tracer_les_contours_d_une_police_metafont). 
  Cette gamme est livrée avec des variantes encodées T1, TS1 LY1 
  (ainsi qu'une variante utilisant l'encodage polonais QX). Pour le jeu de glyphes qu'elle couvre,
  ses contours semblent plutôt plus propres que ceux de <ctanpkg:CM-super>. 
  [Latin Modern](ctanpkg:lm) est également plus modeste que <ctanpkg:CM-super> 
  en ce qui concerne l'espace disque qu'elle requiert, 
  tout en n'étant pas aussi austère que <ctanpkg:CM-LGC> dans sa gamme de tailles de conception.
  Les polices de *[Latin Modern](ctanpkg:lm)* sont proposées dans le même ensemble de tailles 
  que les polices <ctanpkg:CM> d'origine. Il est difficile de contester ce choix : 
  la gamme de tailles de Knuth a résisté à l'épreuve du temps 
  et constitue l'une des bases sur lesquelles repose l'excellence du système TeX.

- Les [fontes virtuelles](/5_fichiers/formats/fontes/que_sont_les_fontes_virtuelles) 
  nous aident à résoudre le problème, puisqu'elles nous permettent de faire correspondre 
  des "éléments du fichier DVI" à des caractères individuels dans la police virtuelle. 
  Nous pouvons donc créer un caractère "é" 
  en recréant les commandes DVI qui résulteraient du code `\'e`. 
  Cependant, comme il s'agit de deux caractères sélectionnés dans une police, 
  la méthode tromper *Acrobat Reader* : vous ne pouvez pas utiliser les fonctions du programme 
  pour rechercher du texte contenant ce type de caractères ; de même,  
  si vous "copiez" du texte depuis une fenêtre contenant un tel caractère, 
  vous trouverez quelque chose d'inattendu (typiquement l'accent 
  et les caractères de "base" séparés par un espace) lorsque vous "collerez" le résultat. 
  Toutefois, si vous pouvez vous accommoder de cette difficulté, 
  les polices virtuelles constituent une solution utile et simple au problème.

- Il existe deux offres de polices virtuelles de 8 bits basées sur *Computer Modern* : 
  les ensembles <ctanpkg:ae> ("almost EC" autrement dit "presque *European Computer*") 
  et <ctanpkg:zefonts>. L'ensemble <ctanpkg:zefonts> a une couverture plus large 
  (bien que l'ensemble <ctanpkg:ae> puisse être étendu pour offrir des guillemets 
  en utilisant l'extension <ctanpkg:aeguill>). Aucune ne propose des caractères 
  tels que `eth` et `thorn` (utilisés, par exemple, en islandais), 
  mais l'extension [aecompl](ctanpkg:ae) fonctionne avec les polices <ctanpkg:ae> 
  pour fournir les caractères manquants des polices *European Computer* 
  (c'est-à-dire sous forme de bitmaps).

- La seule police 8 bits de type *Computer Modern* encore disponible dans le commerce 
  provient de Micropress, qui propose l'ensemble des polices *European Computer* au format Type 1,
  dans le cadre de sa gamme de versions de polices distribuées à l'origine au format MetaFont. 
  Sur ce sujet, voir la question "[](/6_distributions/installation/implementations_commerciales)".

- La [distribution shareware BaKoMa TeX](/6_distributions/installation/trouver_les_sources_pour_les_differents_systemes_d_exploitation2)
  offre un ensemble de polices *European Computer* de type 1, 
  en tant qu'option supplémentaire du shareware. 
  *A priori*, ces polices sont *uniquement* disponibles pour les utilisateurs de BaKoMa TeX : 
  elles sont stockées dans un format d'archive qui ne semble pas être accessible au public.

- Enfin, vous pouvez utiliser l'une des innombrables polices de texte disponibles au format Type 1
 (avec les métriques [PSNFSS](ctanpkg:psNFSS) appropriées pour l'encodage T1, 
 ou les métriques pour un autre encodage 8 bits tel que LY1). 
 Cependant, si vous utilisez la police de texte d'un collègue 
 (même quelque chose d'aussi simple que la fonte *Times* d'Adobe), 
 vous devez trouver une famille correspondante de polices mathématiques (si besoin est), 
 ce qui n'a rien d'évident. Voir ici "[](/5_fichiers/formats/fontes/fontes_t1_pour_les_mathematiques)".


:::{sources}
[Finding "8-bit Type 1 fonts](faquk:FAQ-type1T1)
:::
