/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreWriter;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.ui.graph.actions.Bundle;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;
import yguard.A.A.D;
import yguard.A.A.Y;
import yguard.A.J.SA;

public class GenerateGraphAction
extends TopGraphAction {
    public String getName() {
        return Bundle.CTL_GenerateGraphAction();
    }

    @Override
    protected void actionPerformed(TopComponent tc) {
        try {
            int rows = 1000;
            int cols = 1000;
            int gaps = 300;
            SA viewGraph = this.getTopViewGraph();
            GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)viewGraph);
            GraphID graphID = GraphViewManager.getDefault().getGraphID(viewGraph);
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphDataStoreWriter writer = graphStore.getGraphDataStore().getDataStoreWriter();
            writer.beginUpdate();
            viewGraph.\u00cc();
            EntityFactory entityFactory = EntityFactory.forGraphID((GraphID)graphID);
            LinkFactory linkFactory = LinkFactory.forGraphID((GraphID)graphID);
            EntityID previousEntity = null;
            for (int c = 0; c < cols; ++c) {
                for (int r = 0; r < rows; ++r) {
                    int num = c * rows + r + 1;
                    if (num % 1000 == 0) {
                        System.out.println(num);
                    }
                    MaltegoEntity entity = (MaltegoEntity)entityFactory.createInstance("maltego.Phrase", true, false);
                    GraphStoreWriter.addEntity((GraphID)graphID, (MaltegoEntity)entity);
                    EntityID entityID = (EntityID)entity.getID();
                    Y node = wrapper.node(entityID);
                    viewGraph.D(node, (double)(c * gaps), (double)(r * gaps));
                    if (r != 0) {
                        MaltegoLink link = linkFactory.createInstance(MaltegoLinkSpec.getManualSpec(), false, false);
                        GraphStoreWriter.addLink((GraphID)graphID, (MaltegoLink)link, (LinkEntityIDs)new LinkEntityIDs(previousEntity, entityID));
                    }
                    previousEntity = entityID;
                }
            }
            System.out.println("Commiting...");
            viewGraph.D((Object)false);
            writer.endUpdate();
            viewGraph.\u00ff();
            System.out.println("Done");
        }
        catch (GraphStoreException | TypeInstantiationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

