/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.ui.graph.actions.ZoomToSelectionAction;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class SelectCollectionsAction
extends TopGraphAction {
    private GraphID _currentGraphID = null;
    private GraphStructureStore _graphStructureStore;
    private final StructureListener _structureListener = new StructureListener();

    @Override
    protected void onTopGraphChanged() {
        super.onTopGraphChanged();
        if (this._graphStructureStore != null) {
            this._graphStructureStore.removePropertyChangeListener((PropertyChangeListener)this._structureListener);
            this._graphStructureStore = null;
        }
        this._currentGraphID = this.getTopGraphID();
        if (this._currentGraphID != null) {
            this._graphStructureStore = GraphStoreViewRegistry.getDefault().getDefaultView(this._currentGraphID).getGraphStructureStore();
            this._graphStructureStore.addPropertyChangeListener((PropertyChangeListener)this._structureListener);
        }
    }

    @Override
    protected boolean isEnabled(TopComponent tc) {
        return this.hasCollectionsOnGraph(this.getTopGraphID());
    }

    protected boolean hasCollectionsOnGraph(GraphID graphID) {
        boolean graphHasCollections = false;
        if (graphID != null) {
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            try {
                int viewEntitiesCount = view.getGraphStructureStore().getStructureReader().getEntityCount();
                int modelEntitiesCount = view.getModel().getGraphStructureStore().getStructureReader().getEntityCount();
                graphHasCollections = viewEntitiesCount != modelEntitiesCount;
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return graphHasCollections;
    }

    protected Set<EntityID> getCollectionEntityIds(GraphID graphID) {
        HashSet<EntityID> result = new HashSet<EntityID>();
        if (graphID != null) {
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            try {
                for (EntityID viewEntity : view.getGraphStructureStore().getStructureReader().getEntities()) {
                    if (!view.getModelViewMappings().isOnlyViewEntity(viewEntity)) continue;
                    result.add(viewEntity);
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return result;
    }

    @Override
    protected void actionPerformed(final TopComponent tc) {
        Set<EntityID> toSelect = this.getCollectionEntityIds(this._currentGraphID);
        GraphSelection selection = GraphSelection.forGraph((GraphID)this._currentGraphID);
        selection.setSelectedViewEntities(toSelect);
        ZoomToSelectionAction zoomAction = (ZoomToSelectionAction)SystemAction.get(ZoomToSelectionAction.class);
        if (zoomAction != null) {
            zoomAction.zoomToSelection();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tc.requestActive();
            }
        });
    }

    public String getName() {
        return "Select Collections";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/SelectCollections.png";
    }

    protected void updateButtonEnabled() {
        this.setEnabled(this.hasCollectionsOnGraph(this._currentGraphID));
    }

    private class StructureListener
    implements PropertyChangeListener {
        private StructureListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            GraphStructureMods mods = (GraphStructureMods)pce.getNewValue();
            if (!mods.getEntitiesAdded().isEmpty() || !mods.getEntitiesRemoved().isEmpty()) {
                SelectCollectionsAction.this.updateButtonEnabled();
            }
        }
    }
}

