/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.script;

import com.paterva.maltego.view.customization.ui.script.ScriptAugmentDescriptor;
import com.paterva.maltego.view.customization.ui.script.ScriptFunctionProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import yguard.A.A.Y;

public class NodeScriptFunctionProvider
implements ScriptFunctionProvider<Y> {
    private static NodeScriptFunctionProvider _instance;
    private static final String FUNCT_HAS_PROP = "hasProperty(key)";
    private static final String FUNCT_PROP_VALUE = "getPropertyValue(key)";
    private static final String FUNCT_PROPS_CONTAIN = "propertiesContain(string)";
    private static final String FUNCT_PROPS_CONTAIN_CI = "propertiesContainCI(string)";
    private static final String FUNCT_HAS_DISPLAY_INFO = "hasDisplayInfo(key)";
    private static final String FUNCT_DISPLAY_INFO_VALUE = "getDisplayInfoValue(key)";
    private static final String FUNCT_DISPLAY_INFO_CONTAINS = "displayInfoContains(string)";
    private static final String FUNCT_DISPLAY_INFO_CONTAINS_CI = "displayInfoContainsCI(string)";
    private static final String FUNCT_IS_TYPE = "isType(type)";
    private static final String NEW_LINE;
    private final List<ScriptAugmentDescriptor> _functions = new ArrayList<ScriptAugmentDescriptor>();

    public static synchronized NodeScriptFunctionProvider instance() {
        if (_instance == null) {
            _instance = new NodeScriptFunctionProvider();
        }
        return _instance;
    }

    private NodeScriptFunctionProvider() {
        this._functions.add(new ScriptAugmentDescriptor(FUNCT_HAS_PROP, "boolean", "Does a property with the given key exist?"));
        this._functions.add(new ScriptAugmentDescriptor(FUNCT_PROP_VALUE, "object", "Return the value of the property with the given key"));
        this._functions.add(new ScriptAugmentDescriptor(FUNCT_PROPS_CONTAIN, "boolean", "Does any property contain the value?"));
        this._functions.add(new ScriptAugmentDescriptor(FUNCT_PROPS_CONTAIN_CI, "boolean", "Does any property contain the string (case insensitive)?"));
        this._functions.add(new ScriptAugmentDescriptor(FUNCT_HAS_DISPLAY_INFO, "boolean", "Does display information with the given key exist?"));
        this._functions.add(new ScriptAugmentDescriptor(FUNCT_DISPLAY_INFO_VALUE, "object", "Return the value of the display information with the given key"));
        this._functions.add(new ScriptAugmentDescriptor(FUNCT_DISPLAY_INFO_CONTAINS, "boolean", "Does the display information contain the string?"));
        this._functions.add(new ScriptAugmentDescriptor(FUNCT_DISPLAY_INFO_CONTAINS_CI, "boolean", "Does the display information contain the string (case insensitive)?"));
        this._functions.add(new ScriptAugmentDescriptor(FUNCT_IS_TYPE, "boolean", "Is the entity of the given type, taking inheritance into account?"));
    }

    @Override
    public List<ScriptAugmentDescriptor> getDescriptors() {
        return Collections.unmodifiableList(this._functions);
    }

    @Override
    public String addFunctions(String script) {
        StringBuilder sb = new StringBuilder();
        if (this.containsFunction(script, FUNCT_HAS_PROP)) {
            sb.append("function hasProperty(key) {").append(NEW_LINE).append("    for (var i = 0; i < propertyKeys.length; i++) {").append(NEW_LINE).append("        if (propertyKeys[i] == key) {").append(NEW_LINE).append("            return true;").append(NEW_LINE).append("        }").append(NEW_LINE).append("    }").append(NEW_LINE).append("    return false;").append(NEW_LINE).append("}").append(NEW_LINE);
        }
        if (this.containsFunction(script, FUNCT_PROP_VALUE)) {
            sb.append("function getPropertyValue(key) {").append(NEW_LINE).append("    for (var i = 0; i < propertyKeys.length; i++) {").append(NEW_LINE).append("        if (propertyKeys[i] == key) {").append(NEW_LINE).append("            return propertyValues[i];").append(NEW_LINE).append("        }").append(NEW_LINE).append("    }").append(NEW_LINE).append("}").append(NEW_LINE);
        }
        if (this.containsFunction(script, FUNCT_PROPS_CONTAIN)) {
            sb.append("function propertiesContain(string) {").append(NEW_LINE).append("    if (typeof (string) !== 'undefined' && string !== null) {").append(NEW_LINE).append("        for (var i = 0; i < propertyValues.length; i++) {").append(NEW_LINE).append("            var temp_prop = propertyValues[i];").append(NEW_LINE).append("            if (typeof (temp_prop) !== 'undefined' && temp_prop !== null && temp_prop.toString().indexOf(string) !== -1) {").append(NEW_LINE).append("                return true;").append(NEW_LINE).append("            }").append(NEW_LINE).append("        }").append(NEW_LINE).append("    }").append(NEW_LINE).append("    return false;").append(NEW_LINE).append("}").append(NEW_LINE);
        }
        if (this.containsFunction(script, FUNCT_PROPS_CONTAIN_CI)) {
            sb.append("function propertiesContainCI(string) {").append(NEW_LINE).append("    if (typeof (string) !== 'undefined' && string !== null) {").append(NEW_LINE).append("        string = string.toLowerCase();").append(NEW_LINE).append("        for (var i = 0; i < propertyValues.length; i++) {").append(NEW_LINE).append("            var temp_prop = propertyValues[i];").append(NEW_LINE).append("            if (typeof (temp_prop) !== 'undefined' && temp_prop !== null && temp_prop.toString().toLowerCase().indexOf(string) !== -1) {").append(NEW_LINE).append("                return true;").append(NEW_LINE).append("            }").append(NEW_LINE).append("        }").append(NEW_LINE).append("    }").append(NEW_LINE).append("    return false;").append(NEW_LINE).append("}").append(NEW_LINE);
        }
        if (this.containsFunction(script, FUNCT_HAS_DISPLAY_INFO)) {
            sb.append("function hasDisplayInfo(key) {").append(NEW_LINE).append("    for (var i = 0; i < displayInfoKeys.length; i++) {").append(NEW_LINE).append("        if (displayInfoKeys[i] == key) {").append(NEW_LINE).append("            return true;").append(NEW_LINE).append("        }").append(NEW_LINE).append("    }").append(NEW_LINE).append("    return false;").append(NEW_LINE).append("}").append(NEW_LINE);
        }
        if (this.containsFunction(script, FUNCT_DISPLAY_INFO_VALUE)) {
            sb.append("function getDisplayInfoValue(key) {").append(NEW_LINE).append("    for (var i = 0; i < displayInfoKeys.length; i++) {").append(NEW_LINE).append("        if (displayInfoKeys[i] == key) {").append(NEW_LINE).append("            return displayInfoValues[i];").append(NEW_LINE).append("        }").append(NEW_LINE).append("    }").append(NEW_LINE).append("}").append(NEW_LINE);
        }
        if (this.containsFunction(script, FUNCT_DISPLAY_INFO_CONTAINS)) {
            sb.append("function displayInfoContains(string) {").append(NEW_LINE).append("    if (typeof (string) !== 'undefined' && string !== null) {").append(NEW_LINE).append("        for (var i = 0; i < propertyValues.length; i++) {").append(NEW_LINE).append("            var temp_prop = propertyValues[i];").append(NEW_LINE).append("            if (typeof (temp_prop) !== 'undefined' && temp_prop !== null && temp_prop.toString().indexOf(string) !== -1) {").append(NEW_LINE).append("                return true;").append(NEW_LINE).append("            }").append(NEW_LINE).append("        }").append(NEW_LINE).append("    }").append(NEW_LINE).append("    return false;").append(NEW_LINE).append("}").append(NEW_LINE);
        }
        if (this.containsFunction(script, FUNCT_DISPLAY_INFO_CONTAINS_CI)) {
            sb.append("function displayInfoContainsCI(string) {").append(NEW_LINE).append("    if (typeof (string) !== 'undefined' && string !== null) {").append(NEW_LINE).append("        string = string.toLowerCase();").append(NEW_LINE).append("        for (var i = 0; i < propertyValues.length; i++) {").append(NEW_LINE).append("            var temp_prop = propertyValues[i]").append(NEW_LINE).append("            if (typeof (temp_prop) !== 'undefined' && temp_prop !== null && temp_prop.toString().toLowerCase().indexOf(string) !== -1) {").append(NEW_LINE).append("                return true;").append(NEW_LINE).append("            }").append(NEW_LINE).append("        }").append(NEW_LINE).append("    }").append(NEW_LINE).append("    return false;").append(NEW_LINE).append("}").append(NEW_LINE);
        }
        if (this.containsFunction(script, FUNCT_IS_TYPE)) {
            sb.append("function isType(type) {").append(NEW_LINE).append("    for (var i = 0; i < types.length; i++) {").append(NEW_LINE).append("        if (types[i] == type) {").append(NEW_LINE).append("            return true;").append(NEW_LINE).append("        }").append(NEW_LINE).append("    }").append(NEW_LINE).append("    return false;").append(NEW_LINE).append("}").append(NEW_LINE);
        }
        sb.append(script);
        return sb.toString();
    }

    private String getFunctionName(String signature) {
        return signature.replaceFirst("\\(.*\\)", "");
    }

    private boolean containsFunction(String script, String function) {
        return script.contains(this.getFunctionName(function));
    }

    static {
        NEW_LINE = System.getProperty("line.separator");
    }
}

