/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.Evaluator;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.types.PhoneNumber;
import com.paterva.maltego.util.StringUtilities;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class PhoneNumberEvaluator
extends Evaluator.Replacement {
    private static final Logger LOG = Logger.getLogger(PhoneNumberEvaluator.class.getName());
    private static final Pattern ORIGINAL_PATTERN = PhoneNumberEvaluator.createPattern("original");
    private static final Pattern REGION_PATTERN = PhoneNumberEvaluator.createPattern("region");
    private static final Pattern TYPE_PATTERN = PhoneNumberEvaluator.createPattern("type");
    private static final Pattern NATIONAL_PATTERN = PhoneNumberEvaluator.createPattern("national");
    private static final Pattern EXTENSION_PATTERN = PhoneNumberEvaluator.createPattern("extension");

    public static boolean isSuitableFor(String value) {
        return true;
    }

    @Override
    public String evaluate(String formula, DataSource inputs) {
        String result = formula;
        result = PROPERTY_PATTERN.matcher(result).replaceAll("$2");
        String previous = null;
        while (!result.equals(previous)) {
            previous = result;
            result = PhoneNumberEvaluator.parse(result, inputs, ORIGINAL_PATTERN, PhoneNumber::getCreationString);
            result = PhoneNumberEvaluator.parse(result, inputs, REGION_PATTERN, PhoneNumber::getRegion);
            result = PhoneNumberEvaluator.parse(result, inputs, TYPE_PATTERN, PhoneNumber::getNumberType);
            result = PhoneNumberEvaluator.parse(result, inputs, NATIONAL_PATTERN, PhoneNumber::toStringNational);
            result = PhoneNumberEvaluator.parse(result, inputs, EXTENSION_PATTERN, PhoneNumber::getExtension);
        }
        return result;
    }

    private static String parse(String formula, DataSource inputs, Pattern pattern, Function<PhoneNumber, String> func) {
        return PhoneNumberEvaluator.parse(formula, pattern, (sb, propertyName) -> {
            if (!StringUtilities.isNullOrEmpty((String)propertyName)) {
                String value = PhoneNumberEvaluator.getPhoneNumber(propertyName, inputs).map(func).orElse("");
                sb.append(value);
            }
        });
    }

    private static Optional<PhoneNumber> getPhoneNumber(String propertyName, DataSource inputs) {
        PropertyDescriptor property = new PropertyDescriptor(PhoneNumber.class, propertyName);
        return Optional.ofNullable((PhoneNumber)inputs.getValue(property));
    }

    @Override
    public String getName() {
        return "maltego.phonenumber";
    }
}

