/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.convert;

import com.paterva.maltego.typing.convert.DefaultStringConverter;
import com.paterva.maltego.typing.convert.StringConverter;
import com.paterva.maltego.typing.types.IPAddress;
import java.util.logging.Logger;

public class IPAddressStringConverter
implements StringConverter {
    private static final Logger LOG = Logger.getLogger(IPAddressStringConverter.class.getName());

    @Override
    public Object convertFrom(String value, Class to) throws IllegalArgumentException {
        IPAddress result = null;
        if (value != null) {
            try {
                result = IPAddress.parse(value);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Cannot not convert '" + value + "' to IP Address: " + ex.getMessage());
            }
        }
        return result;
    }

    @Override
    public String convertTo(Object value, Class from) throws IllegalArgumentException {
        if (value instanceof IPAddress) {
            IPAddress ip = (IPAddress)value;
            return ip.toStringCompressed();
        }
        return DefaultStringConverter.instance().convertTo(value, from);
    }
}

