/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.runviews.favs;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.runregistry.RunProvider;
import com.paterva.maltego.runregistry.RunProviderComparator;
import com.paterva.maltego.runregistry.favs.RunFavorites;
import com.paterva.maltego.runregistry.item.RunProviderItem;
import com.paterva.maltego.runregistry.item.RunnableItem;
import com.paterva.maltego.runviews.favs.FavoritesItem;
import com.paterva.maltego.util.StringUtilities;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.Icon;

public class RunFavoritesProvider
extends RunFavorites
implements RunProvider {
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport((Object)this);
    private final Map<RunProvider, List<RunnableItem>> _items = new TreeMap<RunProvider, List<RunnableItem>>((Comparator<RunProvider>)new RunProviderComparator());
    private Map<String, String> _filterText = new HashMap<String, String>();

    public int getPosition() {
        return 10;
    }

    public void setFavorites(RunProvider runProvider, List<RunnableItem> items) {
        this._items.put(runProvider, items);
    }

    public List<RunProviderItem> getItems(String component) {
        if (!StringUtilities.isNullOrEmpty((String)this.getFilterText(component))) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<RunProviderItem> favorites = new ArrayList<RunProviderItem>();
        for (Map.Entry<RunProvider, List<RunnableItem>> entry : this._items.entrySet()) {
            String namePrefix = entry.getKey().getClass().getSimpleName();
            for (RunnableItem runnableItem : entry.getValue()) {
                String name = namePrefix + "." + runnableItem.getName();
                favorites.add((RunProviderItem)new UniqueNameRunnableItem(name, runnableItem));
            }
        }
        if (favorites.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(new FavoritesItem(favorites));
    }

    public void run(List<RunProviderItem> items, GraphID graphID, Set<EntityID> entities) {
    }

    public boolean isUpdating() {
        return false;
    }

    private void fireItemsChanged() {
        this._changeSupport.firePropertyChange("itemsChanged", null, this._items);
    }

    public void setFilterText(String component, String text) {
        this._filterText.put(component, text);
    }

    private String getFilterText(String component) {
        return this._filterText.get(component);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    private static class UniqueNameRunnableItem
    implements RunnableItem {
        private final String _name;
        private final RunnableItem _delegate;

        public UniqueNameRunnableItem(String name, RunnableItem delegate) {
            this._name = name;
            this._delegate = delegate;
        }

        public String getName() {
            return this._name;
        }

        public String getDisplayName() {
            return this._delegate.getDisplayName();
        }

        public String getDescription() {
            return this._delegate.getDescription();
        }

        public Icon getIcon() {
            return this._delegate.getIcon();
        }

        public boolean isExpandedByDefault() {
            return this._delegate.isExpandedByDefault();
        }

        public List<? extends RunProviderItem> getChildren() {
            return this._delegate.getChildren();
        }

        public boolean canRun() {
            return this._delegate.canRun();
        }

        public void run(GraphID graphID, Set<EntityID> entities) {
            this._delegate.run(graphID, entities);
        }

        public boolean hasSettings() {
            return this._delegate.hasSettings();
        }

        public void showSettings() {
            this._delegate.showSettings();
        }

        public boolean hasConfig() {
            return this._delegate.hasConfig();
        }

        public void showConfig() {
            this._delegate.showConfig();
        }

        public boolean hasHelp() {
            return this._delegate.hasHelp();
        }

        public void showHelp() {
            this._delegate.showHelp();
        }

        public boolean canFavorite() {
            return this._delegate.canFavorite();
        }

        public void setFavorite(boolean favorite) {
            this._delegate.setFavorite(favorite);
        }

        public boolean isFavorite() {
            return this._delegate.isFavorite();
        }

        public String getLafPrefix() {
            return this._delegate.getLafPrefix();
        }

        public List<Action> getContextActions() {
            return this._delegate.getContextActions();
        }

        public List<Action> getToolbarActions() {
            return this._delegate.getToolbarActions();
        }

        public boolean isShowIn(String componentName) {
            return this._delegate.isShowIn(componentName);
        }

        public boolean isRememberPage() {
            return this._delegate.isRememberPage();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this._delegate.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this._delegate.removePropertyChangeListener(listener);
        }
    }
}

