/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard.licensed;

import com.paterva.maltego.licensing.ui.wizard.LicenseWebLinksPanel;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import com.paterva.maltego.util.ui.dialog.ValidatingPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class LicenseKeyPanel
extends ValidatingPanel {
    private ButtonGroup advancedButtonGroup;
    private JCheckBox advancedCheckBox;
    private JPanel advancedInnerPanel;
    private JPanel advancedPanel;
    private JLabel egLabel;
    private JLabel iconLabel;
    private JPanel keyPanel;
    private JTextField keyTextField;
    private LicenseWebLinksPanel licenseWebLinksPanel;
    private JRadioButton machineRadioButton;
    private JTextArea machineTextArea;
    private JRadioButton userRadioButton;
    private JTextArea userTextArea;

    public LicenseKeyPanel(ValidatingController controller) {
        super(controller);
        this.initComponents();
        this.keyTextField.getDocument().addDocumentListener((DocumentListener)this.getChangeEventPropagator());
        this.keyTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LicenseKeyPanel.this.updateLinksPanel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LicenseKeyPanel.this.updateLinksPanel();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LicenseKeyPanel.this.updateLinksPanel();
            }
        });
        this.licenseWebLinksPanel.setVisible(false);
        this.updateAdvancedPanel();
        Color bgColor = new JButton().getBackground().brighter();
        this.machineTextArea.setBackground(bgColor);
        this.userTextArea.setBackground(bgColor);
    }

    public void setKey(String key) {
        this.keyTextField.setText(key);
    }

    public String getKey() {
        String key = this.keyTextField.getText().trim().toUpperCase();
        key = key.replaceAll("[^\\w\\-]", "");
        return key;
    }

    public void setIcon(Icon icon) {
        this.iconLabel.setIcon(icon);
    }

    public void setMachineLicense(boolean machineLicense) {
        this.machineRadioButton.setSelected(machineLicense);
        this.userRadioButton.setSelected(!machineLicense);
    }

    public boolean isMachineLicense() {
        return this.machineRadioButton.isSelected();
    }

    private void updateLinksPanel() {
        this.licenseWebLinksPanel.setLicenseKey(this.getKey());
    }

    private void updateAdvancedPanel() {
        this.advancedCheckBox.setVisible(Utilities.isWindows());
        boolean visible = this.advancedCheckBox.isSelected();
        this.machineRadioButton.setVisible(visible);
        this.machineTextArea.setVisible(visible);
        this.userRadioButton.setVisible(visible);
        this.userTextArea.setVisible(visible);
    }

    private void initComponents() {
        this.advancedButtonGroup = new ButtonGroup();
        this.licenseWebLinksPanel = new LicenseWebLinksPanel();
        this.keyPanel = new JPanel();
        JLabel keyLabel = new JLabel();
        this.keyTextField = new JTextField();
        this.iconLabel = new JLabel();
        this.egLabel = new JLabel();
        this.advancedPanel = new JPanel();
        this.advancedCheckBox = new JCheckBox();
        this.advancedInnerPanel = new JPanel();
        this.machineTextArea = new JTextArea();
        this.userTextArea = new JTextArea();
        this.machineRadioButton = new JRadioButton();
        this.userRadioButton = new JRadioButton();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.add(this.licenseWebLinksPanel, gridBagConstraints);
        this.keyPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)keyLabel, (String)NbBundle.getMessage(LicenseKeyPanel.class, (String)"LicenseKeyPanel.keyLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.keyPanel.add((Component)keyLabel, gridBagConstraints);
        this.keyTextField.setText(NbBundle.getMessage(LicenseKeyPanel.class, (String)"LicenseKeyPanel.keyTextField.text"));
        this.keyTextField.setPreferredSize(new Dimension(260, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.keyPanel.add((Component)this.keyTextField, gridBagConstraints);
        this.iconLabel.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/paterva/maltego/licensing/ui/resources/Valid.png")));
        Mnemonics.setLocalizedText((JLabel)this.iconLabel, (String)NbBundle.getMessage(LicenseKeyPanel.class, (String)"LicenseKeyPanel.iconLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.keyPanel.add((Component)this.iconLabel, gridBagConstraints);
        this.egLabel.setFont(this.egLabel.getFont().deriveFont((float)this.egLabel.getFont().getSize() - 1.0f));
        this.egLabel.setForeground(UIManager.getLookAndFeelDefaults().getColor("7-description-foreground"));
        Mnemonics.setLocalizedText((JLabel)this.egLabel, (String)NbBundle.getMessage(LicenseKeyPanel.class, (String)"LicenseKeyPanel.egLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        this.keyPanel.add((Component)this.egLabel, gridBagConstraints);
        this.advancedPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.advancedCheckBox, (String)NbBundle.getMessage(LicenseKeyPanel.class, (String)"LicenseKeyPanel.advancedCheckBox.text"));
        this.advancedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseKeyPanel.this.advancedCheckBoxActionPerformed(evt);
            }
        });
        this.advancedPanel.add((Component)this.advancedCheckBox, "North");
        this.advancedInnerPanel.setPreferredSize(new Dimension(400, 200));
        this.advancedInnerPanel.setLayout(new GridBagLayout());
        this.machineTextArea.setEditable(false);
        this.machineTextArea.setLineWrap(true);
        this.machineTextArea.setText(NbBundle.getMessage(LicenseKeyPanel.class, (String)"LicenseKeyPanel.machineTextArea.text"));
        this.machineTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.advancedInnerPanel.add((Component)this.machineTextArea, gridBagConstraints);
        this.userTextArea.setEditable(false);
        this.userTextArea.setLineWrap(true);
        this.userTextArea.setText(NbBundle.getMessage(LicenseKeyPanel.class, (String)"LicenseKeyPanel.userTextArea.text"));
        this.userTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.advancedInnerPanel.add((Component)this.userTextArea, gridBagConstraints);
        this.advancedButtonGroup.add(this.machineRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.machineRadioButton, (String)NbBundle.getMessage(LicenseKeyPanel.class, (String)"LicenseKeyPanel.machineRadioButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 30, 3, 3);
        this.advancedInnerPanel.add((Component)this.machineRadioButton, gridBagConstraints);
        this.advancedButtonGroup.add(this.userRadioButton);
        this.userRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.userRadioButton, (String)NbBundle.getMessage(LicenseKeyPanel.class, (String)"LicenseKeyPanel.userRadioButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 30, 3, 3);
        this.advancedInnerPanel.add((Component)this.userRadioButton, gridBagConstraints);
        this.advancedPanel.add((Component)this.advancedInnerPanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 0, 0, 3);
        this.keyPanel.add((Component)this.advancedPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.add(this.keyPanel, gridBagConstraints);
    }

    private void advancedCheckBoxActionPerformed(ActionEvent evt) {
        this.updateAdvancedPanel();
    }
}

