/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.polyglot.EngineAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class DefaultScope {
    DefaultScope() {
    }

    private static boolean isInternal(FrameSlot slot) {
        Object identifier = slot.getIdentifier();
        if (identifier == null) {
            return true;
        }
        return EngineAccessor.INSTRUMENT.isInputValueSlotIdentifier(identifier);
    }

    /*
     * WARNING - void declaration
     */
    @CompilerDirectives.TruffleBoundary
    static Object getVariables(RootNode root, Frame frame, Class<? extends TruffleLanguage<?>> language) {
        Map<Object, Object> slotsMap;
        List<? extends FrameSlot> slots;
        if (frame == null) {
            slots = root.getFrameDescriptor().getSlots();
        } else {
            void var6_9;
            slots = frame.getFrameDescriptor().getSlots();
            ArrayList<? extends FrameSlot> nonNulls = null;
            int lastI = 0;
            boolean bl = false;
            while (var6_9 < slots.size()) {
                FrameSlot slot = slots.get((int)var6_9);
                if (!EngineAccessor.INTEROP.isInteropType(frame.getValue(slot)) || DefaultScope.isInternal(slot)) {
                    if (nonNulls == null) {
                        nonNulls = new ArrayList<FrameSlot>(slots.size());
                    }
                    nonNulls.addAll(slots.subList(lastI, (int)var6_9));
                    lastI = var6_9 + true;
                }
                ++var6_9;
            }
            if (nonNulls != null) {
                if (lastI < slots.size()) {
                    nonNulls.addAll(slots.subList(lastI, slots.size()));
                }
                slots = nonNulls;
            }
        }
        if (slots.isEmpty()) {
            slotsMap = Collections.emptyMap();
        } else if (slots.size() == 1) {
            FrameSlot slot = slots.get(0);
            slotsMap = Collections.singletonMap(Objects.toString(slot.getIdentifier()), slot);
        } else {
            slotsMap = new LinkedHashMap(slots.size());
            for (FrameSlot frameSlot : slots) {
                slotsMap.put(Objects.toString(frameSlot.getIdentifier()), frameSlot);
            }
        }
        return new VariablesMapObject(slotsMap, root, frame, language);
    }

    static Object getArguments(Object[] frameArguments, Class<? extends TruffleLanguage<?>> language) {
        return new ArgumentsArrayObject(frameArguments, language);
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class ArgumentNamesObject
    implements TruffleObject {
        private final int n;

        ArgumentNamesObject(int n) {
            this.n = n;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        long getArraySize() {
            return this.n;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(index)) {
                throw InvalidArrayIndexException.create(index);
            }
            return Long.toString(index);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isArrayElementReadable(long index) {
            return index >= 0L && index < (long)this.n;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class ArgumentsArrayObject
    implements TruffleObject {
        final Object[] args;
        private final Class<? extends TruffleLanguage<?>> language;

        ArgumentsArrayObject(Object[] args, Class<? extends TruffleLanguage<?>> language) {
            this.args = args;
            this.language = language;
        }

        @ExportMessage
        boolean hasLanguage() {
            return true;
        }

        @ExportMessage
        Class<? extends TruffleLanguage<?>> getLanguage() {
            return this.language;
        }

        @ExportMessage
        boolean isScope() {
            return true;
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        Object getMembers(boolean includeInternal) {
            return new ArgumentNamesObject(this.args.length);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isMemberReadable(String member) {
            try {
                int index = Integer.parseInt(member);
                if (0 <= index && index < this.args.length) {
                    return EngineAccessor.INTEROP.isInteropType(this.args[index]);
                }
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @ExportMessage.Repeat(value={@ExportMessage(name="isMemberModifiable"), @ExportMessage(name="isMemberInsertable")})
        boolean isMemberModifiable(String member) {
            return false;
        }

        @ExportMessage
        Object readMember(String member) throws UnsupportedMessageException {
            try {
                int index = Integer.parseInt(member);
                if (0 <= index && index < this.args.length) {
                    return this.args[index];
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            throw UnsupportedMessageException.create();
        }

        @ExportMessage
        void writeMember(String member, Object value) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @ExportMessage
        Object toDisplayString(boolean allowSideEffects) {
            return "local";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class VariableNamesObject
    implements TruffleObject {
        static final VariableNamesObject EMPTY = new VariableNamesObject(Collections.emptySet());
        final List<String> names;

        VariableNamesObject(Set<String> names) {
            this.names = new ArrayList<String>(names);
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        long getArraySize() {
            return this.names.size();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(index)) {
                throw InvalidArrayIndexException.create(index);
            }
            return this.names.get((int)index);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isArrayElementReadable(long index) {
            return index >= 0L && index < (long)this.names.size();
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class NullValue
    implements TruffleObject {
        private static final NullValue INSTANCE = new NullValue();

        NullValue() {
        }

        @ExportMessage
        boolean isNull() {
            return true;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class VariablesMapObject
    implements TruffleObject {
        final Map<String, ? extends FrameSlot> slots;
        final RootNode root;
        final Frame frame;
        private final Class<? extends TruffleLanguage<?>> language;

        private VariablesMapObject(Map<String, ? extends FrameSlot> slots, RootNode root, Frame frame, Class<? extends TruffleLanguage<?>> language) {
            this.slots = slots;
            this.root = root;
            this.frame = frame;
            this.language = language;
        }

        public static boolean isInstance(TruffleObject obj) {
            return obj instanceof VariablesMapObject;
        }

        @ExportMessage
        boolean hasLanguage() {
            return true;
        }

        @ExportMessage
        Class<? extends TruffleLanguage<?>> getLanguage() {
            return this.language;
        }

        @ExportMessage
        boolean isScope() {
            return true;
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readMember(String member) throws UnknownIdentifierException {
            if (this.frame == null) {
                return NullValue.INSTANCE;
            }
            FrameSlot slot = this.slots.get(member);
            if (slot == null) {
                throw UnknownIdentifierException.create(member);
            }
            return this.frame.getValue(slot);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object getMembers(boolean includeInternal) {
            return new VariableNamesObject(this.slots.keySet());
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isMemberReadable(String member) {
            return this.slots.containsKey(member);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isMemberModifiable(String member) {
            return this.slots.containsKey(member) && this.frame != null;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        void writeMember(String member, Object value) throws UnknownIdentifierException, UnsupportedMessageException {
            if (this.frame == null) {
                throw UnsupportedMessageException.create();
            }
            FrameSlot slot = this.slots.get(member);
            if (slot == null) {
                throw UnknownIdentifierException.create(member);
            }
            this.frame.setObject(slot, value);
        }

        @ExportMessage
        boolean isMemberInsertable(String member) {
            return false;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean hasSourceLocation() {
            return this.root.getSourceSection() != null;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        SourceSection getSourceLocation() {
            return this.root.getSourceSection();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object toDisplayString(boolean allowSideEffects) {
            String name = this.root.getName();
            if (name == null) {
                name = "local";
            }
            return name;
        }
    }
}

