/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.lucene.serialize.DocumentProperty;
import com.pinkmatter.pandora.lucene.serialize.DocumentPropertyCollector;
import com.pinkmatter.pandora.lucene.serialize.TypeConverter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSerializer {
    private final Logger LOG = LoggerFactory.getLogger(IndexSerializer.class);

    public void write(String name, Object value, Document to) throws PandoraException {
        try {
            this.LOG.debug("Serializing property: {}", (Object)name);
            TypeConverter.assertValidPropertyName(name);
            if (value != null) {
                TypeConverter converter = TypeConverter.get(value);
                if (converter == null) {
                    this.LOG.error("Could not find a TypeConverter for object: {}, type: {}", value, value.getClass());
                    throw new PandoraException(String.format("Could not find a TypeConverter for object: %s of type: %s.", value, value.getClass()));
                }
                converter.write(value, name, to);
            }
        }
        catch (PandoraException ex) {
            throw new PandoraException(String.format("Error serializing property: %s with value: %s to document.", name, value.toString()), (Throwable)ex);
        }
    }

    public void write(Map<String, Object> input, Document to) throws PandoraException {
        this.LOG.debug("Serializing document...");
        for (Map.Entry<String, Object> property : input.entrySet()) {
            this.write(property.getKey(), property.getValue(), to);
        }
    }

    public LinkedHashMap<String, Object> readAll(Document from) throws PandoraException {
        return this.readAll(from.getFields());
    }

    private LinkedHashMap<String, Object> readAll(List<IndexableField> fields) throws PandoraException {
        this.LOG.debug("Deserializing document...");
        DocumentPropertyCollector collector = new DocumentPropertyCollector();
        collector.collectAll(fields);
        LinkedHashMap<String, Object> artifact = new LinkedHashMap<String, Object>();
        for (DocumentProperty propertyField : collector.getProperties()) {
            String name = propertyField.getName();
            this.LOG.debug("Deserializing property: {}", (Object)name);
            artifact.put(name, propertyField.read());
        }
        return artifact;
    }

    public Object read(String property, Document from) throws PandoraException {
        List<IndexableField> filtered = DocumentPropertyCollector.filter(property, from.getFields());
        return this.readAll(filtered).get(property);
    }
}

