/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.serialized;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.io.BinaryCodec;
import com.spatial4j.core.shape.Shape;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.spatial.serialized.SerializedDVStrategy;
import org.apache.lucene.util.BytesRefBuilder;

public class SerializedSortedSetDVStrategy
extends SerializedDVStrategy {
    public SerializedSortedSetDVStrategy(SpatialContext ctx, String fieldName) {
        super(ctx, fieldName);
    }

    public Field[] createIndexableFields(Shape shape) {
        Field[] fields = super.createIndexableFields(shape);
        fields[0] = new SortedSetDocValuesField(fields[0].name(), fields[0].binaryValue());
        return fields;
    }

    public ValueSource makeShapeValueSource() {
        return new ShapeSortedSetDocValueSource(this.getFieldName(), this.ctx.getBinaryCodec());
    }

    class ShapeSortedSetDocValueSource
    extends ValueSource {
        private final String fieldName;
        private final BinaryCodec binaryCodec;

        private ShapeSortedSetDocValueSource(String fieldName, BinaryCodec binaryCodec) {
            this.fieldName = fieldName;
            this.binaryCodec = binaryCodec;
        }

        public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
            final SortedSetDocValues docValues = readerContext.reader().getSortedSetDocValues(this.fieldName);
            return new FunctionValues(){
                int bytesRefDoc = -1;
                ArrayList<BytesRefBuilder> builders = new ArrayList();
                int count = 0;

                boolean fillBytes(int doc) {
                    if (this.bytesRefDoc != doc) {
                        docValues.setDocument(doc);
                        this.count = (int)docValues.getValueCount();
                        this.bytesRefDoc = doc;
                        for (int i = 0; i < this.count; ++i) {
                            if (this.builders.size() <= i) {
                                this.builders.add(new BytesRefBuilder());
                            }
                            BytesRefBuilder bytesRef = this.builders.get(i);
                            bytesRef.copyBytes(docValues.lookupOrd(docValues.nextOrd()));
                        }
                    }
                    return this.count != 0;
                }

                public boolean exists(int doc) {
                    return this.fillBytes(doc);
                }

                public boolean bytesVal(int doc, BytesRefBuilder target) {
                    throw new UnsupportedOperationException();
                }

                public Object objectVal(int docId) {
                    if (!this.fillBytes(docId)) {
                        return null;
                    }
                    try {
                        if (this.count == 1) {
                            return this.readShape(this.builders.get(0));
                        }
                        ArrayList<Shape> shapes = new ArrayList<Shape>(this.count);
                        for (int i = 0; i < this.count; ++i) {
                            BytesRefBuilder bytesRef = this.builders.get(i);
                            shapes.add(this.readShape(bytesRef));
                        }
                        return SerializedSortedSetDVStrategy.this.getSpatialContext().makeCollection(shapes);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                private Shape readShape(BytesRefBuilder bytesRef) throws IOException {
                    DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(bytesRef.bytes(), 0, bytesRef.length()));
                    return ShapeSortedSetDocValueSource.this.binaryCodec.readShape((DataInput)dataInput);
                }

                public Explanation explain(int doc) {
                    return Explanation.match((float)Float.NaN, (String)this.toString(doc), (Explanation[])new Explanation[0]);
                }

                public String toString(int doc) {
                    return ShapeSortedSetDocValueSource.this.description() + "=" + this.objectVal(doc);
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ShapeSortedSetDocValueSource that = (ShapeSortedSetDocValueSource)((Object)o);
            return this.fieldName.equals(that.fieldName);
        }

        public int hashCode() {
            int result = this.fieldName.hashCode();
            return result;
        }

        public String description() {
            return "shapeSortedSetDocVal(" + this.fieldName + ")";
        }
    }
}

