/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl.structures;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.graph.store.views.impl.structures.EntityLinks;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ViewEntity {
    private final Set<EntityID> _collection;
    private final String _type;
    private final EntityLinks _viewAndModelLinks;

    public ViewEntity(String type, EntityLinks viewAndModelLinks) {
        this._type = type;
        this._collection = new HashSet<EntityID>();
        this._viewAndModelLinks = viewAndModelLinks;
    }

    public ViewEntity(String type, Set<EntityID> collection, EntityLinks viewAndModelLinks) {
        this._type = type;
        this._collection = collection;
        this._viewAndModelLinks = viewAndModelLinks;
    }

    public ViewEntity(ViewEntity viewEntity) {
        this._collection = new HashSet<EntityID>(viewEntity._collection.size());
        this._collection.addAll(viewEntity._collection);
        this._type = viewEntity._type;
        this._viewAndModelLinks = new EntityLinks(viewEntity._viewAndModelLinks);
    }

    public Set<EntityID> getCollection() {
        return this._collection;
    }

    public boolean isCollection() {
        return !this._collection.isEmpty();
    }

    public String getType() {
        return this._type;
    }

    public boolean collectionContains(EntityID entity) {
        return this._collection.contains(entity);
    }

    public EntityLinks getAllLinks() {
        return this._viewAndModelLinks;
    }

    public void clear() {
        this._viewAndModelLinks.clear();
        this._collection.clear();
    }

    public String toString() {
        return "ViewEntity{_collection=" + this._collection + ", _type=" + this._type + ", _viewAndModelLinks=" + this._viewAndModelLinks + '}';
    }

    public int hashCode() {
        int hash = 3;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViewEntity other = (ViewEntity)obj;
        if (!Objects.equals(this._type, other._type)) {
            return false;
        }
        if (!Objects.equals(this._collection, other._collection)) {
            return false;
        }
        return Objects.equals(this._viewAndModelLinks, other._viewAndModelLinks);
    }
}

