/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.treelist.parts.link;

import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.treelist.lazy.LazyTreelistSettings;
import com.paterva.maltego.treelist.lazy.etable.ETableColumnModel;
import com.paterva.maltego.treelist.lazy.outline.LazyOutline;
import com.paterva.maltego.treelist.parts.PartsTable;
import com.paterva.maltego.treelist.parts.link.LinkHoverableIconRenderer;
import com.paterva.maltego.treelist.parts.link.LinkRowModel;
import com.paterva.maltego.treelist.parts.link.LinkSortOrderProvider;
import com.paterva.maltego.treelist.parts.link.LinkTreeModel;
import com.paterva.maltego.treelist.parts.link.LinkTreelistModel;
import com.paterva.maltego.util.ui.GraphicsUtils;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.Enumeration;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RowModel;

public class LinkTable
extends PartsTable<LinkID, MaltegoLink> {
    protected static final int[] COLUMNS = new int[]{0, 1, 2, 3};

    public static LinkTable create(String name) {
        LinkTreelistModel model = new LinkTreelistModel(name, COLUMNS);
        LinkTable table = new LinkTable();
        LinkTreeModel treeModel = new LinkTreeModel((LazyOutline)table, model);
        LinkRowModel rowModel = new LinkRowModel(model);
        OutlineModel outlineModel = DefaultOutlineModel.createOutlineModel((TreeModel)treeModel, (RowModel)rowModel, (boolean)true, (String)"Link");
        table.setTreelistModel(model);
        table.setTreeModel(treeModel);
        table.setRowModel(rowModel);
        table.setSortOrderProvider(new LinkSortOrderProvider(model));
        table.setRootVisible(false);
        table.setModel((TableModel)outlineModel);
        table.initColumns();
        return table;
    }

    public LinkTable() {
        super(false);
    }

    public void initColumns() {
        ETableColumnModel etcm = (ETableColumnModel)this.getColumnModel();
        LinkHoverableIconRenderer renderer = new LinkHoverableIconRenderer(this);
        etcm.getColumn(1).setCellRenderer(renderer);
        LazyTreelistSettings settings = LazyTreelistSettings.getDefault();
        int iconSize = settings.getIconSize()[this.isSmall() ? 0 : 1];
        etcm.getColumn(0).setPreferredWidth(this.getIconColumnWidth(true) * 7);
        this.configureIconColumn(0, GraphicsUtils.getInspectIcon((int)iconSize, (boolean)false), true);
        etcm.moveColumn(1, 0);
    }

    @Override
    protected void doCopy() {
        StringBuilder sb = new StringBuilder();
        Enumeration<TableColumn> columns = this.getColumnModel().getColumns();
        boolean first = true;
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            if (!first) {
                sb.append(",");
            }
            Object headerValue = column.getHeaderValue();
            sb.append(headerValue.toString());
            first = false;
        }
        sb.append("\n");
        for (Object row : (TableColumn)this.getSelectedRows()) {
            columns = this.getColumnModel().getColumns();
            first = true;
            while (columns.hasMoreElements()) {
                TableColumn column = columns.nextElement();
                if (!first) {
                    sb.append(",");
                }
                Object value = this.getValueAt((int)row, this.getColumnModel().getColumnIndex(column.getIdentifier()));
                sb.append(value);
                first = false;
            }
            sb.append("\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(sb.toString()), null);
    }
}

