/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.Truncatable;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.binary.JSAddConstantLeftNumberNodeGen;
import com.oracle.truffle.js.nodes.binary.JSAddConstantRightNumberNodeGen;
import com.oracle.truffle.js.nodes.binary.JSAddNodeGen;
import com.oracle.truffle.js.nodes.binary.JSAddSubNumericUnitNode;
import com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import com.oracle.truffle.js.nodes.binary.JSConcatStringsNode;
import com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import com.oracle.truffle.js.nodes.cast.JSDoubleToStringNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.util.Set;

@NodeInfo(shortName="+")
public abstract class JSAddNode
extends JSBinaryNode
implements Truncatable {
    @CompilerDirectives.CompilationFinal
    boolean truncate;

    protected JSAddNode(boolean truncate, JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
        this.truncate = truncate;
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right, boolean truncate) {
        if (right instanceof JSConstantNode.JSConstantNumericUnitNode) {
            return JSAddSubNumericUnitNode.create(left, true, truncate);
        }
        if (left instanceof JSConstantNode.JSConstantIntegerNode && right instanceof JSConstantNode.JSConstantIntegerNode) {
            int rightValue;
            int leftValue = ((JSConstantNode.JSConstantIntegerNode)left).executeInt(null);
            long value = (long)leftValue + (long)(rightValue = ((JSConstantNode.JSConstantIntegerNode)right).executeInt(null));
            return JSRuntime.longIsRepresentableAsInt(value) ? JSConstantNode.createInt((int)value) : JSConstantNode.createDouble(value);
        }
        if (right instanceof JSConstantNode.JSConstantIntegerNode || right instanceof JSConstantNode.JSConstantDoubleNode) {
            Object rightValue = ((JSConstantNode)right).execute(null);
            return JSAddConstantRightNumberNodeGen.create(left, (Number)rightValue, truncate);
        }
        if (left instanceof JSConstantNode.JSConstantStringNode && right instanceof JSConstantNode.JSConstantStringNode) {
            return JSConstantNode.createString((String)left.execute(null) + (String)right.execute(null));
        }
        if (left instanceof JSConstantNode.JSConstantIntegerNode || left instanceof JSConstantNode.JSConstantDoubleNode) {
            Object leftValue = ((JSConstantNode)left).execute(null);
            return JSAddConstantLeftNumberNodeGen.create((Number)leftValue, right, truncate);
        }
        return JSAddNodeGen.create(truncate, left, right);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        return JSAddNode.create(left, right, false);
    }

    public static JavaScriptNode createUnoptimized(JavaScriptNode left, JavaScriptNode right, boolean truncate) {
        return JSAddNodeGen.create(truncate, left, right);
    }

    public static JSAddNode createUnoptimized() {
        return JSAddNodeGen.create(false, null, null);
    }

    public abstract Object execute(Object var1, Object var2);

    @Specialization(guards={"truncate"})
    protected static int doIntTruncate(int a, int b) {
        return a + b;
    }

    @Specialization(guards={"!truncate"}, rewriteOn={ArithmeticException.class})
    protected static int doInt(int a, int b) {
        return Math.addExact(a, b);
    }

    @Specialization(guards={"!truncate"}, rewriteOn={ArithmeticException.class})
    protected static Object doIntOverflow(int a, int b) {
        long result = (long)a + (long)b;
        return JSAddNode.doIntOverflowStaticLong(result);
    }

    static Object doIntOverflowStaticLong(long result) {
        if (JSRuntime.longIsRepresentableAsInt(result)) {
            return (int)result;
        }
        if (JSRuntime.isSafeInteger(result)) {
            return SafeInteger.valueOf(result);
        }
        throw new ArithmeticException();
    }

    @Specialization(rewriteOn={ArithmeticException.class})
    protected static SafeInteger doIntSafeInteger(int a, SafeInteger b) {
        return SafeInteger.valueOf(a).addExact(b);
    }

    @Specialization(rewriteOn={ArithmeticException.class})
    protected static SafeInteger doSafeIntegerInt(SafeInteger a, int b) {
        return a.addExact(SafeInteger.valueOf(b));
    }

    @Specialization(rewriteOn={ArithmeticException.class})
    protected static SafeInteger doSafeInteger(SafeInteger a, SafeInteger b) {
        return a.addExact(b);
    }

    @Specialization
    protected static double doDouble(double a, double b) {
        return a + b;
    }

    @Specialization
    protected BigInt doBigInt(BigInt left, BigInt right) {
        return left.add(right);
    }

    @Specialization
    protected CharSequence doString(CharSequence a, CharSequence b, @Cached @Cached.Shared(value="concatStringsNode") JSConcatStringsNode concatStringsNode) {
        return concatStringsNode.executeCharSequence(a, b);
    }

    @Specialization
    protected CharSequence doStringInt(CharSequence a, int b) {
        return JSLazyString.createLazyInt(a, b);
    }

    @Specialization
    protected CharSequence doIntString(int a, CharSequence b) {
        return JSLazyString.createLazyInt(a, b);
    }

    @Specialization(guards={"isNumber(b)"})
    protected CharSequence doStringNumber(CharSequence a, Object b, @Cached @Cached.Shared(value="concatStringsNode") JSConcatStringsNode concatStringsNode, @Cached @Cached.Shared(value="doubleToStringNode") JSDoubleToStringNode doubleToStringNode) {
        return concatStringsNode.executeCharSequence(a, doubleToStringNode.executeString(b));
    }

    @Specialization(guards={"isNumber(a)"})
    protected CharSequence doNumberString(Object a, CharSequence b, @Cached @Cached.Shared(value="concatStringsNode") JSConcatStringsNode concatStringsNode, @Cached @Cached.Shared(value="doubleToStringNode") JSDoubleToStringNode doubleToStringNode) {
        return concatStringsNode.executeCharSequence(doubleToStringNode.executeString(a), b);
    }

    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected Object doOverloaded(Object a, Object b, @Cached(value="createHintNone(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a, b);
    }

    protected String getOverloadedOperatorName() {
        return "+";
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "!hasOverloadedOperators(b)"}, replaces={"doInt", "doIntOverflow", "doIntTruncate", "doSafeInteger", "doIntSafeInteger", "doSafeIntegerInt", "doDouble", "doBigInt", "doString", "doStringInt", "doIntString", "doStringNumber", "doNumberString"})
    protected Object doPrimitiveConversion(Object a, Object b, @Cached(value="createHintNone()") JSToPrimitiveNode toPrimitiveA, @Cached(value="createHintNone()") JSToPrimitiveNode toPrimitiveB, @Cached(value="create()") JSToNumericNode toNumericA, @Cached(value="create()") JSToNumericNode toNumericB, @Cached(value="create()") JSToStringNode toStringA, @Cached(value="create()") JSToStringNode toStringB, @Cached(value="createBinaryProfile()") ConditionProfile profileA, @Cached(value="createBinaryProfile()") ConditionProfile profileB, @Cached(value="copyRecursive()") JSAddNode add, @Cached(value="create()") BranchProfile mixedNumericTypes) {
        Object castB;
        Object castA;
        Object primitiveA = toPrimitiveA.execute(a);
        Object primitiveB = toPrimitiveB.execute(b);
        if (profileA.profile(JSGuards.isString(primitiveA))) {
            castA = primitiveA;
            castB = toStringB.executeString(primitiveB);
        } else if (profileB.profile(JSGuards.isString(primitiveB))) {
            castA = toStringA.executeString(primitiveA);
            castB = primitiveB;
        } else {
            castA = toNumericA.execute(primitiveA);
            castB = toNumericB.execute(primitiveB);
            this.ensureBothSameNumericType(castA, castB, mixedNumericTypes);
        }
        return add.execute(castA, castB);
    }

    public final JSAddNode copyRecursive() {
        return (JSAddNode)JSAddNode.create(null, null, this.truncate);
    }

    @Override
    public void setTruncate() {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.truncate) {
            this.truncate = true;
        }
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSAddNodeGen.createUnoptimized(JSAddNode.cloneUninitialized(this.getLeft(), materializedTags), JSAddNode.cloneUninitialized(this.getRight(), materializedTags), this.truncate);
    }
}

