/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import java.util.Objects;

public abstract class AbstractObjectArray
extends AbstractWritableArray {
    protected AbstractObjectArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    AbstractWritableArray sameTypeHolesArray(DynamicObject object, int length, Object array, long indexOffset, int arrayOffset, int usedLength, int holeCount) {
        return HolesObjectArray.makeHolesObjectArray(object, length, (Object[])array, indexOffset, arrayOffset, usedLength, holeCount, this.integrityLevel);
    }

    public abstract void setInBoundsFast(DynamicObject var1, int var2, Object var3);

    @Override
    public final ScriptArray setElementImpl(DynamicObject object, long index, Object value, boolean strict) {
        assert (index >= 0L);
        if (CompilerDirectives.injectBranchProbability((double)0.9999, (boolean)this.isSupported(object, index))) {
            assert (value != null);
            this.setSupported(object, (int)index, value);
            return this;
        }
        return this.rewrite(object, index, value).setElementImpl(object, index, value, strict);
    }

    private ScriptArray rewrite(DynamicObject object, long index, Object value) {
        if (this.isSupportedContiguous(object, index)) {
            return this.toContiguous(object, index, value);
        }
        if (this.isSupportedHoles(object, index)) {
            return this.toHoles(object, index, value);
        }
        return this.toSparse(object, index, value);
    }

    @Override
    public Object getInBoundsFast(DynamicObject object, int index) {
        return this.getInBoundsFastObject(object, index);
    }

    @Override
    int getArrayLength(Object array) {
        return ((Object[])array).length;
    }

    protected static Object[] getArray(DynamicObject object) {
        Object array = JSAbstractArray.arrayGetArray(object);
        if (array.getClass() == Object[].class) {
            return (Object[])CompilerDirectives.castExact((Object)array, Object[].class);
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public abstract Object getInBoundsFastObject(DynamicObject var1, int var2);

    public final void setInBounds(DynamicObject object, int index, Object value, ScriptArray.ProfileHolder profile) {
        AbstractObjectArray.getArray((DynamicObject)object)[this.prepareInBounds((DynamicObject)object, (int)index, (ScriptArray.ProfileHolder)profile)] = AbstractObjectArray.checkNonNull(value);
    }

    public final void setSupported(DynamicObject object, int index, Object value) {
        int preparedIndex = this.prepareSupported(object, index, ScriptArray.ProfileHolder.empty());
        AbstractObjectArray.getArray((DynamicObject)object)[preparedIndex] = AbstractObjectArray.checkNonNull(value);
    }

    @Override
    void fillWithHoles(Object array, int fromIndex, int toIndex) {
        Object[] objectArray = (Object[])array;
        for (int i = fromIndex; i < toIndex; ++i) {
            objectArray[i] = null;
        }
    }

    @Override
    protected final void setHoleValue(DynamicObject object, int preparedIndex) {
        AbstractObjectArray.getArray((DynamicObject)object)[preparedIndex] = null;
    }

    @Override
    protected final void fillHoles(DynamicObject object, int internalIndex, int grown, ScriptArray.ProfileHolder profile) {
        if (grown != 0) {
            this.incrementHolesCount(object, Math.abs(grown) - 1);
        }
        assert (this.checkFillHoles(object, internalIndex, grown));
    }

    @Override
    protected final boolean isHolePrepared(DynamicObject object, int preparedIndex) {
        return HolesObjectArray.isHoleValue(AbstractObjectArray.getArray(object)[preparedIndex]);
    }

    @Override
    protected final int getArrayCapacity(DynamicObject object) {
        return AbstractObjectArray.getArray(object).length;
    }

    @Override
    protected final void resizeArray(DynamicObject object, int newCapacity, int oldCapacity, int offset) {
        Object[] newArray = new Object[newCapacity];
        System.arraycopy(AbstractObjectArray.getArray(object), 0, newArray, offset, oldCapacity);
        JSAbstractArray.arraySetArray(object, newArray);
    }

    @Override
    public abstract AbstractObjectArray toHoles(DynamicObject var1, long var2, Object var4);

    @Override
    public final AbstractWritableArray toDouble(DynamicObject object, long index, double value) {
        return this;
    }

    @Override
    public final AbstractWritableArray toObject(DynamicObject object, long index, Object value) {
        return this;
    }

    @Override
    public ScriptArray deleteElementImpl(DynamicObject object, long index, boolean strict) {
        return this.toHoles(object, index, null).deleteElementImpl(object, index, strict);
    }

    @Override
    protected final void moveRangePrepared(DynamicObject object, int src, int dst, int len) {
        Object[] array = AbstractObjectArray.getArray(object);
        System.arraycopy(array, src, array, dst, len);
    }

    @Override
    public final Object allocateArray(int length) {
        return new Object[length];
    }

    @Override
    public Object cloneArray(DynamicObject object) {
        return AbstractObjectArray.getArray(object).clone();
    }

    @Override
    protected abstract AbstractObjectArray withIntegrityLevel(int var1);

    protected static Object checkNonNull(Object value) {
        assert (value != null);
        return value;
    }

    protected Object castNonNull(Object value) {
        return Objects.requireNonNull(value);
    }
}

