/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.planargraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.planargraph.DirectedEdge;
import com.vividsolutions.jts.planargraph.Edge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DirectedEdgeStar {
    protected List outEdges = new ArrayList();
    private boolean sorted = false;

    public void add(DirectedEdge de) {
        this.outEdges.add(de);
        this.sorted = false;
    }

    public void remove(DirectedEdge de) {
        this.outEdges.remove(de);
    }

    public Iterator iterator() {
        this.sortEdges();
        return this.outEdges.iterator();
    }

    public int getDegree() {
        return this.outEdges.size();
    }

    public Coordinate getCoordinate() {
        Iterator it = this.iterator();
        if (!it.hasNext()) {
            return null;
        }
        DirectedEdge e = (DirectedEdge)it.next();
        return e.getCoordinate();
    }

    public List getEdges() {
        this.sortEdges();
        return this.outEdges;
    }

    private void sortEdges() {
        if (!this.sorted) {
            Collections.sort(this.outEdges);
            this.sorted = true;
        }
    }

    public int getIndex(Edge edge) {
        this.sortEdges();
        for (int i = 0; i < this.outEdges.size(); ++i) {
            DirectedEdge de = (DirectedEdge)this.outEdges.get(i);
            if (de.getEdge() != edge) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(DirectedEdge dirEdge) {
        this.sortEdges();
        for (int i = 0; i < this.outEdges.size(); ++i) {
            DirectedEdge de = (DirectedEdge)this.outEdges.get(i);
            if (de != dirEdge) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(int i) {
        int modi = i % this.outEdges.size();
        if (modi < 0) {
            modi += this.outEdges.size();
        }
        return modi;
    }

    public DirectedEdge getNextEdge(DirectedEdge dirEdge) {
        int i = this.getIndex(dirEdge);
        return (DirectedEdge)this.outEdges.get(this.getIndex(i + 1));
    }

    public DirectedEdge getNextCWEdge(DirectedEdge dirEdge) {
        int i = this.getIndex(dirEdge);
        return (DirectedEdge)this.outEdges.get(this.getIndex(i - 1));
    }
}

