/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import javax.swing.JCheckBox;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.util.gui.WrapperLayout;

class InputCheckboxControl
extends BaseInputControl {
    private final JCheckBox widget;

    public InputCheckboxControl(HTMLBaseInputElement modelNode) {
        super(modelNode);
        this.setLayout(WrapperLayout.getInstance());
        JCheckBox checkBox = new JCheckBox();
        checkBox.setOpaque(false);
        this.widget = checkBox;
        checkBox.setSelected(this.controlElement.getAttributeAsBoolean("checked"));
        this.add(checkBox);
    }

    @Override
    public void reset(int availWidth, int availHeight) {
        super.reset(availWidth, availHeight);
    }

    @Override
    public void click() {
        this.widget.doClick();
    }

    @Override
    public boolean getChecked() {
        return this.widget.isSelected();
    }

    @Override
    public void setChecked(boolean checked) {
        this.widget.setSelected(checked);
    }

    @Override
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        this.widget.setEnabled(!disabled);
    }

    @Override
    public void resetInput() {
        this.widget.setSelected(this.controlElement.getAttributeAsBoolean("checked"));
    }

    @Override
    public String getValue() {
        return this.controlElement.getAttribute("value");
    }
}

