/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph;

import com.paterva.maltego.chatapi.AbstractChatRoom;
import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.ChatRoomCookie;
import com.paterva.maltego.chatapi.conn.ConnectionException;
import com.paterva.maltego.chatapi.conn.ConnectionHandler;
import com.paterva.maltego.chatapi.conn.ConnectionInfo;
import com.paterva.maltego.chatapi.conn.ConnectionInitiationCallback;
import com.paterva.maltego.chatapi.conn.ConnectionStatus;
import com.paterva.maltego.chatapi.conn.ConnectionStatusEvent;
import com.paterva.maltego.chatapi.conn.ConnectionStatusListener;
import com.paterva.maltego.chatapi.msg.ChatMessageTranslator;
import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.chatapi.reconnect.ReconnectController;
import com.paterva.maltego.chatapi.reconnect.ReconnectState;
import com.paterva.maltego.chatapi.user.User;
import com.paterva.maltego.chatapi.user.UserPresence;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.Participant;
import com.paterva.maltego.collab.ParticipantEvent;
import com.paterva.maltego.collab.ParticipantPresence;
import com.paterva.maltego.collab.Payload;
import com.paterva.maltego.collab.PayloadCollection;
import com.paterva.maltego.collab.RxHandler;
import com.paterva.maltego.collab.TxHandler;
import com.paterva.maltego.collab.graph.state.ConnectionController;
import com.paterva.maltego.collab.session.CollaborationServerInfo;
import com.paterva.maltego.collab.session.CollaborationSessionInfo;
import com.paterva.maltego.collab.session.PayloadHelper;
import com.paterva.maltego.collab.session.SessionID;
import com.paterva.maltego.collab.session.SessionIDListener;
import com.paterva.maltego.collab.ui.ChatFilterSettings;
import com.paterva.maltego.collab.ui.GraphMessageType;
import com.paterva.maltego.collab.ui.MessageColors;
import com.paterva.maltego.collab.ui.ReconnectControllers;
import com.paterva.maltego.sound.SoundPlayer;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.output.OutputMessage;
import com.paterva.maltego.util.ui.InactivityListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public abstract class CollaborationChatRoom
extends AbstractChatRoom
implements ConnectionHandler {
    private static final Logger LOG = Logger.getLogger(CollaborationChatRoom.class.getName());
    private ChangeListener _inactivityListener;
    private ConnectionController _controller;
    private LinkedList<ConnectionStatusListener> _listeners = new LinkedList();

    protected CollaborationChatRoom(ConnectionController controller) {
        this._inactivityListener = new InactivityChangeListener();
        this._controller = controller;
        this._controller.setRxHandler(new ChatRxHandler());
        this._controller.addConnectionStatusListener(new ConnectionStateListener());
        this._controller.addSessionIDListener(new CollaborationSessionIDListener());
    }

    protected ConnectionController getConnectionController() {
        return this._controller;
    }

    public ConnectionStatus getConnectionStatus() {
        return this.controller().getConnectionStatus();
    }

    public void connect(ConnectionInfo info, ConnectionInitiationCallback cb) throws ConnectionException {
        this.controller().connect((ConnectionInfo)((CollaborationSessionInfo)info), cb);
        InactivityListener.getSingleton().addChangeListener(this._inactivityListener);
    }

    public void reconnect(ConnectionInitiationCallback cb) throws ConnectionException {
        this.controller().reconnect(cb);
        InactivityListener.getSingleton().addChangeListener(this._inactivityListener);
    }

    public void disconnect() throws ConnectionException {
        this.getConnectionController().setWasManualDisconnect(true);
        InactivityListener.getSingleton().removeChangeListener(this._inactivityListener);
        this.controller().disconnect();
    }

    public String getServerName() {
        CollaborationServerInfo serverInfo = this.getServerInfo();
        return serverInfo != null ? serverInfo.getServerName() : "";
    }

    public String getServerVersion() {
        CollaborationServerInfo serverInfo = this.getServerInfo();
        return serverInfo != null ? serverInfo.getServerVersion() : "";
    }

    public String getServerOSVersion() {
        CollaborationServerInfo serverInfo = this.getServerInfo();
        return serverInfo != null ? serverInfo.getOsVersion() : "";
    }

    private CollaborationServerInfo getServerInfo() {
        CollaborationSessionInfo sessionInfo;
        if (this._controller != null && (sessionInfo = this._controller.getSessionInfo()) != null) {
            return sessionInfo.getServerInfo();
        }
        return null;
    }

    private ConnectionHandler controller() {
        return this._controller;
    }

    protected TxHandler tx() {
        return this._controller;
    }

    public void addConnectionStatusListener(ConnectionStatusListener listener) {
        this._listeners.add(listener);
    }

    public void removeConnectionStatusListener(ConnectionStatusListener listener) {
        this._listeners.remove(listener);
    }

    public void close() {
        try {
            if (ConnectionStatus.isConnected((ConnectionStatus)this.getConnectionStatus())) {
                this.disconnect();
            }
        }
        catch (ConnectionException ex) {
            NormalException.showStackTrace((Throwable)ex);
        }
    }

    protected void debug(String msg) {
        if (ChatFilterSettings.isShow(LogMessageLevel.Debug, this.isDebugMode())) {
            this.log(LogMessageLevel.Debug, msg);
        }
    }

    protected void info(String msg) {
        if (ChatFilterSettings.isShowInfo()) {
            this.log(LogMessageLevel.Info, msg);
        }
    }

    protected void warn(String msg) {
        if (ChatFilterSettings.isShowWarning()) {
            this.log(LogMessageLevel.Warning, msg);
        }
    }

    protected void error(String msg) {
        if (ChatFilterSettings.isShowError()) {
            this.log(LogMessageLevel.Error, msg);
        }
    }

    protected void error(Exception e) {
        if (ChatFilterSettings.isShowError()) {
            this.log(LogMessageLevel.Error, e.toString());
        }
    }

    private void log(final LogMessageLevel level, String message) {
        final OutputMessage msg = new OutputMessage(message);
        CollaborationChatRoom.runInEDTLater(new Runnable(){

            @Override
            public void run() {
                CollaborationChatRoom.this.logMessage(level, msg, MessageColors.getColor(level), null);
                CollaborationChatRoom.this.requestAttention();
            }
        });
    }

    public void sendChat(User user, OutputMessage chatMessage) {
        try {
            String msg = ChatMessageTranslator.getDefault().translate((ChatRoom)this, chatMessage);
            String xml = PayloadHelper.createPayload("chat", msg);
            this.tx().sendPayload(null, xml);
        }
        catch (CollaborationException ex) {
            this.handleTxError("Message sending failed", ex);
        }
    }

    public void sendInfoNotification(String message) {
        this.sendNotification(null, "info", new OutputMessage(message));
    }

    public void sendNotification(User to, String type, OutputMessage chatMessage) {
        try {
            String msg = ChatMessageTranslator.getDefault().translate((ChatRoom)this, chatMessage);
            if (type == null) {
                type = "info";
            }
            String xml = PayloadHelper.createPayload("note", Collections.singletonMap("type", type), msg);
            this.tx().sendPayload(null, xml);
        }
        catch (CollaborationException ex) {
            this.handleTxError("Notification sending failed", ex);
        }
    }

    public void setStatus(String statusText) {
        try {
            User user = this.getClientUser();
            this.setStatusText(user, statusText);
            UserPresence presence = this.getPresence(user);
            this.tx().updateStatus(CollaborationChatRoom.getParticipantPresence(presence), statusText);
            this.fireUserChanged(user);
        }
        catch (CollaborationException ex) {
            this.handleTxError("Status update failed", ex);
        }
    }

    private User getOrCreateUser(Participant p) {
        CollaborationChatRoom.assertIsEDT();
        if (p != null) {
            User user = this.getUser(p.getID());
            if (user == null) {
                user = this.createUser(p);
            }
            return user;
        }
        return null;
    }

    private User getUser(String id) {
        List users = this.getUsers();
        for (User user : users) {
            if (!Utilities.compareObjects((Object)user.getID(), (Object)id)) continue;
            return user;
        }
        return null;
    }

    private User createUser(Participant p) {
        User user = new User(p.getID(), this.getAlias(p));
        user.setStatusText(p.getStatusText());
        user.setClientVersion(String.format("%s %s", p.getProductName(), p.getClientVersion()));
        return user;
    }

    protected String getAlias(Participant p) {
        return p.getName();
    }

    protected void requestAttention() {
        TopComponent.Registry registry = TopComponent.getRegistry();
        Set openedTCs = registry.getOpened();
        for (TopComponent tc : openedTCs) {
            ChatRoomCookie cookie;
            if (tc.equals(registry.getActivated()) || (cookie = (ChatRoomCookie)tc.getLookup().lookup(ChatRoomCookie.class)) == null || !cookie.getChatRoom().equals((Object)this)) continue;
            tc.requestAttention(true);
            break;
        }
    }

    private void setStatusText(User user, String statusText) {
        String oldStatusText = user.getStatusText();
        if (!Utilities.compareObjects((Object)oldStatusText, (Object)statusText)) {
            user.setStatusText(statusText);
            if (!StringUtilities.isNullOrEmpty((String)statusText)) {
                this.info(String.format("%s - %s", user.getAlias(), statusText));
            }
        }
    }

    protected static void runInEDTNow(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
    }

    protected static void runInEDTLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected void handleRxError(String message, CollaborationException ex) {
        this.error(message + ":\n" + (Object)((Object)ex));
        NormalException.showStackTrace((Throwable)((Object)ex));
    }

    protected void handleTxError(String message, CollaborationException ex) {
        this.error(message + ":\n" + (Object)((Object)ex));
        NormalException.showStackTrace((Throwable)((Object)ex));
    }

    protected void handleRxPayload(PayloadCollection payloads) {
        try {
            Collection<Payload> chatPayloads = payloads.ofType("chat");
            this.handleRxChatMessages(chatPayloads, this.parseChatMessages(chatPayloads));
            Collection<Payload> notificationPayloads = payloads.ofType("note");
            this.handleRxNotifications(notificationPayloads, this.parseChatMessages(notificationPayloads));
        }
        catch (CollaborationException ex) {
            this.handleRxError("Error parsing message", ex);
        }
    }

    private void participantJoined(final Participant participant, ParticipantPresence presence) {
        final UserPresence userPresence = CollaborationChatRoom.getUserPresence(presence);
        CollaborationChatRoom.runInEDTLater(new Runnable(){

            @Override
            public void run() {
                User user = CollaborationChatRoom.this.getUser(participant.getID());
                if (user == null) {
                    user = new User(participant.getID(), CollaborationChatRoom.this.getAlias(participant));
                }
                user.setStatusText(participant.getStatusText());
                user.setClientVersion(String.format("%s %s", participant.getProductName(), participant.getClientVersion()));
                CollaborationChatRoom.this.add(user, userPresence);
                if (participant.isMe()) {
                    CollaborationChatRoom.this.setClientUser(user);
                } else {
                    CollaborationChatRoom.this.info(String.format("%s has joined", user.getAlias()));
                }
                CollaborationChatRoom.this.fireUserChanged(user);
            }
        });
    }

    private void participantLeft(final Participant participant) {
        CollaborationChatRoom.runInEDTLater(new Runnable(){

            @Override
            public void run() {
                User user = CollaborationChatRoom.this.getUser(participant.getID());
                CollaborationChatRoom.this.remove(user);
                if (!participant.isMe() && user != null) {
                    CollaborationChatRoom.this.info(String.format("%s has left", user.getAlias()));
                }
            }
        });
    }

    private void participantPresenceChanged(final Participant participant, ParticipantPresence presence) {
        final UserPresence userPresence = CollaborationChatRoom.getUserPresence(presence);
        CollaborationChatRoom.runInEDTLater(new Runnable(){

            @Override
            public void run() {
                User user = CollaborationChatRoom.this.getUser(participant.getID());
                if (user != null) {
                    this.updateLastSeen(user, CollaborationChatRoom.this.getPresence(user), userPresence);
                    user.setClientVersion(String.format("%s %s", participant.getProductName(), participant.getClientVersion()));
                    CollaborationChatRoom.this.setStatusText(user, participant.getStatusText());
                    CollaborationChatRoom.this.setPresence(user, userPresence);
                    CollaborationChatRoom.this.fireUserChanged(user);
                }
            }

            private void updateLastSeen(User user, UserPresence oldPresence, UserPresence newPresence) {
                Date newLastSeen;
                Date oldLastSeen;
                if (newPresence != oldPresence && !Utilities.compareObjects((Object)(oldLastSeen = user.getLastSeen()), (Object)(newLastSeen = oldPresence == UserPresence.AVAILABLE ? new Date() : null))) {
                    user.setLastSeen(newLastSeen);
                }
            }
        });
    }

    private void handleRxChatMessages(final Collection<Payload> chatPayloads, final List<OutputMessage> chatMessages) {
        CollaborationChatRoom.runInEDTLater(new Runnable(){

            @Override
            public void run() {
                int index = 0;
                boolean playSound = false;
                for (Payload payload : chatPayloads) {
                    User user = CollaborationChatRoom.this.createUser(payload.getFrom());
                    if (!CollaborationChatRoom.this.getClientUser().equals(user)) {
                        playSound = true;
                    }
                    CollaborationChatRoom.this.fireReceivedChatMessage(user, (OutputMessage)chatMessages.get(index), payload.getTimestamp());
                    ++index;
                }
                CollaborationChatRoom.this.requestAttention();
                if (playSound) {
                    SoundPlayer.instance().play("ChatReceived");
                }
            }
        });
    }

    private void handleRxNotifications(final Collection<Payload> payloads, final List<OutputMessage> messages) {
        CollaborationChatRoom.runInEDTLater(new Runnable(){

            @Override
            public void run() {
                int index = 0;
                boolean needAttention = false;
                for (Payload payload : payloads) {
                    GraphMessageType mType;
                    OutputMessage msg = (OutputMessage)messages.get(index);
                    User user = CollaborationChatRoom.this.getOrCreateUser(payload.getFrom());
                    OutputMessage chatMessage = new OutputMessage(user.getAlias() + ": ");
                    chatMessage.addChunks((Collection)msg.getChunks());
                    boolean isClientUser = user.equals(CollaborationChatRoom.this.getClientUser());
                    GraphMessageType graphMessageType = mType = isClientUser ? GraphMessageType.OWN_NOTIFICATION : GraphMessageType.OTHER_NOTIFICATION;
                    if (ChatFilterSettings.isShow(mType)) {
                        CollaborationChatRoom.this.fireLogMessage(LogMessageLevel.Info, chatMessage, MessageColors.getColor(mType), null);
                        needAttention = true;
                    }
                    ++index;
                }
                if (needAttention) {
                    CollaborationChatRoom.this.requestAttention();
                    SoundPlayer.instance().play("NotificationReceived");
                }
            }
        });
    }

    private List<OutputMessage> parseChatMessages(Collection<Payload> payloads) throws CollaborationException {
        if (payloads.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OutputMessage> messages = new ArrayList<OutputMessage>();
        ChatMessageTranslator translator = ChatMessageTranslator.getDefault();
        for (Payload p : payloads) {
            String msg = PayloadHelper.parsePayload(p.getType(), p.getBody());
            messages.add(translator.translate((ChatRoom)this, msg));
        }
        return messages;
    }

    public boolean isDebugMode() {
        return this._controller != null ? this._controller.isDebugMode() : false;
    }

    protected void handleShowMessage(LogMessageLevel level, String message) {
        this.log(level, message);
    }

    private void checkAutoReconnect(ConnectionStatus status) {
        if (ConnectionStatus.Offline == status && !this.getConnectionController().wasManualDisconnect()) {
            this.autoReconnect();
        }
    }

    private void autoReconnect() {
        LOG.fine("AutoReconnecting");
        ReconnectController controller = ReconnectControllers.get((ChatRoom)this);
        if (controller.getReconnectProgress().getState() == ReconnectState.NONE) {
            controller.start();
        }
    }

    protected void connectionStatusChanged(ConnectionStatusEvent evt) {
        for (ConnectionStatusListener listener : this._listeners) {
            listener.statusChanged(evt);
        }
        this.checkAutoReconnect(evt.getNewStatus());
    }

    private static UserPresence getUserPresence(ParticipantPresence presence) {
        switch (presence) {
            case Available: {
                return UserPresence.AVAILABLE;
            }
            case Away: {
                return UserPresence.AWAY;
            }
            case Busy: {
                return UserPresence.BUSY;
            }
            case Error: {
                return UserPresence.ERROR;
            }
            case Offline: {
                return UserPresence.OFFLINE;
            }
        }
        throw new IllegalArgumentException("No such presence " + (Object)((Object)presence));
    }

    private static ParticipantPresence getParticipantPresence(UserPresence presence) {
        switch (presence) {
            case AVAILABLE: {
                return ParticipantPresence.Available;
            }
            case AWAY: {
                return ParticipantPresence.Away;
            }
            case BUSY: {
                return ParticipantPresence.Busy;
            }
            case ERROR: {
                return ParticipantPresence.Error;
            }
            case OFFLINE: {
                return ParticipantPresence.Offline;
            }
        }
        throw new IllegalArgumentException("No such presence " + presence);
    }

    private static void assertIsEDT() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"This method can only be called from the event dispatch thread.");
        }
    }

    public String getCreator() {
        SessionID sessionID;
        String creator = null;
        if (this._controller != null && (sessionID = this._controller.getSessionID()) != null) {
            creator = sessionID.getCreatorName();
        }
        return creator != null ? creator : super.getCreator();
    }

    public Date getCreatedDate() {
        SessionID sessionID;
        Date date = null;
        if (this._controller != null && (sessionID = this._controller.getSessionID()) != null) {
            date = sessionID.getStartTime();
        }
        return date != null ? date : super.getCreatedDate();
    }

    public void setBlocked(boolean blocked) throws ConnectionException {
        this._controller.setBlocked(blocked);
    }

    private class CollaborationSessionIDListener
    implements SessionIDListener {
        private CollaborationSessionIDListener() {
        }

        @Override
        public void sessionIDChanged(SessionID id) {
            CollaborationChatRoom.this.firePropertyChanged("chatRoomSessionInfoChanged", null, CollaborationChatRoom.this._controller.getSessionID());
        }
    }

    private class InactivityChangeListener
    implements ChangeListener {
        private InactivityChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            boolean active = InactivityListener.getSingleton().isActive();
            User clientUser = CollaborationChatRoom.this.getClientUser();
            if (clientUser != null) {
                UserPresence presence = active ? UserPresence.AVAILABLE : UserPresence.AWAY;
                try {
                    CollaborationChatRoom.this.tx().updateStatus(CollaborationChatRoom.getParticipantPresence(presence), clientUser.getStatusText());
                    CollaborationChatRoom.this.setPresence(clientUser, presence);
                }
                catch (CollaborationException ex) {
                    Exceptions.printStackTrace((Throwable)((Object)ex));
                }
            }
        }
    }

    private class ConnectionStateListener
    implements ConnectionStatusListener {
        private ConnectionStateListener() {
        }

        public void statusChanged(final ConnectionStatusEvent evt) {
            CollaborationChatRoom.runInEDTLater(new Runnable(){

                @Override
                public void run() {
                    CollaborationChatRoom.this.connectionStatusChanged(evt);
                }
            });
        }
    }

    private class ChatRxHandler
    implements RxHandler {
        private ChatRxHandler() {
        }

        @Override
        public void payloadsReceived(PayloadCollection payloads) {
            CollaborationChatRoom.this.handleRxPayload(payloads);
        }

        @Override
        public void participantEventReceived(ParticipantEvent event) {
            switch (event.getEventType()) {
                case 0: {
                    CollaborationChatRoom.this.participantPresenceChanged(event.getParticipant(), event.getPresence());
                    break;
                }
                case 1: {
                    CollaborationChatRoom.this.participantJoined(event.getParticipant(), event.getPresence());
                    break;
                }
                case 2: {
                    CollaborationChatRoom.this.participantLeft(event.getParticipant());
                }
            }
        }

        @Override
        public void showMessage(LogMessageLevel level, String message) {
            CollaborationChatRoom.this.handleShowMessage(level, message);
        }
    }
}

