/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.reporting.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.html.simpleparser.ChainedProperties;
import com.lowagie.text.html.simpleparser.HTMLWorker;
import com.lowagie.text.html.simpleparser.ImageProvider;
import com.lowagie.text.html.simpleparser.StyleSheet;
import com.lowagie.text.pdf.FontSelector;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.imgfactoryapi.ImageFactory;
import com.paterva.maltego.reporting.pdf.DefaultiTextStyle;
import com.paterva.maltego.reporting.pdf.iTextStyle;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.EntityColorFactory;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.view2d.Graph2DViewExporter;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.Version;
import com.paterva.maltego.util.ui.look.ColorUtils;
import com.paterva.maltego.util.ui.progress.ProgressController;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import yguard.A.J.SA;
import yguard.A.J.U;

public class PdfReportCommonGenerator {
    private static final Logger LOG = Logger.getLogger(PdfReportCommonGenerator.class.getName());
    private static final Color UNKNOWN_TYPE_COLOR = Color.LIGHT_GRAY;
    static final Font CHAPTER_TITLE_FONT = FontFactory.getFont((String)"Helvetica", (float)18.0f, (int)1, (Color)Color.DARK_GRAY);
    static final iTextStyle ITEXT_STYLE = new DefaultiTextStyle();
    static final char OPEN_BRACKET = '[';
    static final char CLOSE_BRACKET = ']';
    static final String SEPERATOR = ", ";
    final boolean _generateTitlePage;
    private final boolean _generateFooter;
    private final Map<String, Object> _interfaceProps = new HashMap<String, MaltegoCacheImageProvider>(Collections.singletonMap("img_provider", new MaltegoCacheImageProvider()));
    private final Map<String, Object> _interfacePropsEmpty = new HashMap<String, MaltegoEmptyCacheImageProvider>(Collections.singletonMap("img_provider", new MaltegoEmptyCacheImageProvider()));
    final HashMap<EntityID, Image> _entityImages = new HashMap();
    boolean _success;
    Document _doc;
    EntityImageFactory factory;
    EntityRegistry _registry;
    U _view;
    Image _footerImage;
    int _chapter;
    int _progress;
    int _progressTotal;
    int _progressOffset;
    List<File> _tempFiles;
    Map<Object, Image> _imagesByObject;
    Map<String, Image> _imagesByType;
    private Optional<Image> _brokenImage;
    PdfWriter _writer;
    StringBuilder _warnings;

    public PdfReportCommonGenerator(boolean generateTitlePage, boolean generateFooter) {
        this._generateTitlePage = generateTitlePage;
        this._generateFooter = generateFooter;
    }

    private Rectangle getPageDrawSize() {
        Rectangle pageSize = this._doc.getPageSize();
        Rectangle drawSize = new Rectangle(pageSize.getWidth() - this._doc.leftMargin() - this._doc.rightMargin(), pageSize.getHeight() - this._doc.bottomMargin() - this._doc.topMargin());
        return drawSize;
    }

    private void addWhiteSpace(float size) throws DocumentException {
        Paragraph whitespace = new Paragraph(" ");
        whitespace.setLeading(0.0f);
        whitespace.setSpacingAfter(size);
        this._doc.add((Element)whitespace);
    }

    void createTitlePage(ProgressController controller) throws IOException, DocumentException, BadElementException {
        controller.progress("Title Page", this._progress++);
        FontSelector titleFontSelectorBig = ITEXT_STYLE.getFontSelector("Helvetica", 42.0f, 4, Color.DARK_GRAY);
        FontSelector titleFontSelectorSmall = ITEXT_STYLE.getFontSelector("Helvetica", 36.0f, 2, Color.DARK_GRAY);
        this.addWhiteSpace(60.0f);
        PdfPTable table = new PdfPTable(3);
        table.setWidthPercentage(100.0f);
        table.setWidths(new float[]{0.3f, 0.4f, 0.3f});
        table.getDefaultCell().setBorder(0);
        table.getDefaultCell().setHorizontalAlignment(1);
        table.addCell(" ");
        table.addCell(this.javaToPdfImage(ImageUtilities.loadImage((String)"com/paterva/maltego/reporting/resources/ReportTitle.png")));
        table.completeRow();
        this._doc.add((Element)table);
        this.addWhiteSpace(20.0f);
        Paragraph docTitle1 = new Paragraph(titleFontSelectorBig.process("Maltego investigation"));
        docTitle1.setAlignment(1);
        this._doc.add((Element)docTitle1);
        this.addWhiteSpace(20.0f);
        DataObject dao = (DataObject)GraphEditorRegistry.getDefault().getTopmost().getLookup().lookup(DataObject.class);
        Paragraph docTitle2 = new Paragraph(titleFontSelectorSmall.process(dao.getName()));
        docTitle2.setAlignment(1);
        this._doc.add((Element)docTitle2);
        this._doc.newPage();
    }

    void createGraphImage(ProgressController controller, boolean wholeGraph) throws DocumentException, BadElementException, IOException {
        Image image;
        File tempFile;
        controller.progress("Graph Image", this._progress++);
        Graph2DViewExporter exporter = new Graph2DViewExporter(this._view);
        File tempDir = new File(System.getProperty("java.io.tmpdir")).getAbsoluteFile();
        try {
            tempFile = File.createTempFile("tmp", ".jpg", tempDir);
        }
        catch (IOException ex) {
            String msg = String.format("Failed to create graph image temp file in %s\n%s", tempDir.getAbsolutePath(), ex.getMessage());
            LOG.info(msg);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            throw ex;
        }
        try {
            exporter.exportToFile(tempFile, 3011, wholeGraph, null);
        }
        catch (IOException ex) {
            String msg = String.format("Failed to create temp image of graph as %s\n%s", tempFile.getAbsolutePath(), ex.getMessage());
            LOG.info(msg);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            throw ex;
        }
        this._tempFiles.add(tempFile);
        this._progress += this._progressOffset / 3 * 2;
        controller.progress("Graph Image", this._progress);
        try {
            image = Image.getInstance((String)tempFile.getAbsolutePath());
        }
        catch (IOException ex) {
            String msg = String.format("Failed to read temp graph image from %s\n%s", tempFile.getAbsolutePath(), ex.getMessage());
            LOG.info(msg);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            throw ex;
        }
        image.scaleToFit(this.getPageDrawSize().getWidth(), this.getPageDrawSize().getHeight());
        this._progress += this._progressOffset / 3;
        controller.progress("Graph Image", this._progress);
        this._doc.add((Element)image);
        this._doc.newPage();
    }

    PdfPTable createSummaryTable(SA graph2D, int numberOfEntities, int linkCount) throws DocumentException {
        boolean wide = false;
        int nodeCount = graph2D.\u00ca();
        int edgeCount = graph2D.\u00c3();
        Object entities = nodeCount;
        Object links = edgeCount;
        if (numberOfEntities > nodeCount || linkCount > edgeCount) {
            wide = true;
            entities = numberOfEntities + " (" + nodeCount + " nodes)";
            links = linkCount + " (" + edgeCount + " edges)";
        }
        PdfPTable table = new PdfPTable(2);
        table.setSpacingBefore(20.0f);
        table.setWidthPercentage(40.0f);
        table.setWidths(new float[]{0.8f, wide ? 0.5f : 0.2f});
        table.setHorizontalAlignment(0);
        table.addCell(ITEXT_STYLE.getCell("Total number of entities", false));
        table.addCell(ITEXT_STYLE.getCell(entities, false));
        table.addCell(ITEXT_STYLE.getCell("Total number of links", false));
        table.addCell(ITEXT_STYLE.getCell(links, false));
        return table;
    }

    PdfPTable createEntityTypeTable(Object entityTypeIdentifier, List<String> entityNames) throws DocumentException {
        Color typeColor;
        String displayNamePlural;
        PdfPTable table = new PdfPTable(2);
        table.setSpacingBefore(20.0f);
        table.setWidthPercentage(100.0f);
        PdfPCell defaultCell = ITEXT_STYLE.getCell(" ", false);
        table.getDefaultCell().setBorder(defaultCell.getBorder());
        table.getDefaultCell().setBackgroundColor(defaultCell.getBackgroundColor());
        if (entityTypeIdentifier instanceof MaltegoEntitySpec) {
            MaltegoEntitySpec spec = (MaltegoEntitySpec)entityTypeIdentifier;
            displayNamePlural = spec.getDisplayNamePlural();
            typeColor = this.getEntityTypeColor(spec);
        } else {
            displayNamePlural = entityTypeIdentifier.toString();
            typeColor = this.getEntityTypeColor(null);
        }
        PdfPCell headerCell = ITEXT_STYLE.getCell(displayNamePlural + " (" + entityNames.size() + ")", true);
        headerCell.setBackgroundColor(typeColor);
        headerCell.setColspan(2);
        table.addCell(headerCell);
        for (String entityName : entityNames) {
            table.addCell(ITEXT_STYLE.getCell(entityName, false));
        }
        table.completeRow();
        return table;
    }

    Color getEntityTypeColor(MaltegoEntitySpec entitySpec) {
        if (entitySpec != null) {
            Color color = EntityColorFactory.getDefault().getTypeColor(entitySpec.getTypeName());
            return ColorUtils.getLighter((Color)color, (double)0.75);
        }
        return UNKNOWN_TYPE_COLOR;
    }

    PdfPTable createNodeHeaderTable(MaltegoEntity entity, boolean includeEntityImages, boolean anonymousReport) throws BadElementException, IOException, DocumentException {
        String typeName;
        int iconSize = IconSize.LARGE.getSize();
        PdfPTable table = new PdfPTable(2);
        table.setSpacingBefore(20.0f);
        table.setWidthPercentage(100.0f);
        table.setWidths(new float[]{0.2f, 0.8f});
        MaltegoEntitySpec spec = this.getMaltegoEntitySpec(entity);
        String typeDisplayName = spec != null ? spec.getDisplayName() : entity.getTypeName();
        String string = typeName = spec != null ? spec.getTypeName() : entity.getTypeName();
        if (includeEntityImages) {
            Image img = this._entityImages.get(entity.getID());
            if (img == null) {
                img = this._imagesByType.get(typeName);
            }
            img.scaleToFit((float)iconSize, (float)iconSize);
            PdfPCell cell = ITEXT_STYLE.getCell(img, true);
            cell.setHorizontalAlignment(1);
            cell.setRowspan(3);
            table.addCell(cell);
        } else {
            PdfPCell cell = ITEXT_STYLE.getCell("", true);
            cell.setRowspan(3);
            table.addCell(cell);
        }
        FontSelector fs = ITEXT_STYLE.getFontSelector("Helvetica", 12.0f, 0, new Color(0x999999));
        Paragraph paragraph = new Paragraph(fs.process(typeDisplayName));
        table.addCell(ITEXT_STYLE.getCell(paragraph, true));
        fs = ITEXT_STYLE.getFontSelector("Helvetica", 10.0f, 0, new Color(0x999999));
        paragraph = anonymousReport ? new Paragraph(fs.process(typeName.replace("maltego.", ""))) : new Paragraph(fs.process(typeName));
        table.addCell(ITEXT_STYLE.getCell(paragraph, true));
        fs = ITEXT_STYLE.getFontSelector("Helvetica", 14.0f, 0, new Color(6065035));
        paragraph = new Paragraph(fs.process(InheritanceHelper.getDisplayString((SpecRegistry)this._registry, (TypedPropertyBag)entity)));
        PdfPCell cell = ITEXT_STYLE.getCell(paragraph, true);
        cell.setPaddingBottom(5.0f);
        table.addCell(cell);
        return table;
    }

    MaltegoEntitySpec getMaltegoEntitySpec(MaltegoEntity entity) throws GraphStoreException {
        String typeName = entity.getTypeName();
        return (MaltegoEntitySpec)this._registry.get(typeName);
    }

    PdfPTable createNodeDisplayInfoTable(DisplayInformation displayInfo, boolean includeDisplayInfoImages, String progressMsg, ProgressController controller) throws DocumentException, IOException {
        PdfPTable table = new PdfPTable(1);
        table.setWidthPercentage(95.0f);
        table.setWidths(new float[]{1.0f});
        PdfPCell cell = ITEXT_STYLE.getCell(displayInfo.getName(), true);
        cell.setColspan(3);
        table.addCell(cell);
        String value = displayInfo.getValue();
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.loadTagStyle("table", "color", "#404040");
        styleSheet.loadTagStyle("a", "color", "#0000FF");
        styleSheet.loadTagStyle("body", "size", "9pt");
        try {
            ArrayList list = includeDisplayInfoImages ? HTMLWorker.parseToList((Reader)new StringReader(value), (StyleSheet)styleSheet, this._interfaceProps) : HTMLWorker.parseToList((Reader)new StringReader(value), (StyleSheet)styleSheet, this._interfacePropsEmpty);
            controller.progress(progressMsg, this._progress);
            for (Object obj : list) {
                cell = ITEXT_STYLE.getCell(obj, false);
                table.addCell(cell);
            }
        }
        catch (Exception ex) {
            String msg = String.format("Failed to parse Display Info (invalid HTML?):\n%s\nError: %s", value, ex.getMessage());
            this._warnings.append(msg);
            this._warnings.append("\n\n");
        }
        return table;
    }

    Image getBrokenImage() {
        if (this._brokenImage == null) {
            try {
                int size = IconSize.MASSIVE.getSize();
                this._brokenImage = Optional.ofNullable(this.javaToPdfImage(ImageUtils.getBrokenImage((int)size, (int)size)));
            }
            catch (Exception ex) {
                this._brokenImage = Optional.empty();
            }
        }
        return this._brokenImage.isPresent() ? this._brokenImage.get() : null;
    }

    Image javaToPdfImage(java.awt.Image img) throws IOException, BadElementException {
        File tempFile;
        BufferedImage bufferedImage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(img, 0, 0, null);
        g2.dispose();
        File tempDir = new File(System.getProperty("java.io.tmpdir")).getAbsoluteFile();
        try {
            tempFile = File.createTempFile("tmp", ".png", tempDir).getAbsoluteFile();
        }
        catch (IOException ex) {
            String msg = String.format("Failed to create temp file in %s\n%s", tempDir.getAbsolutePath(), ex.getMessage());
            LOG.info(msg);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            throw ex;
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", tempFile);
        }
        catch (IOException ex) {
            String msg = String.format("Failed to write %s\n%s", tempFile.getAbsolutePath(), ex.getMessage());
            LOG.info(msg);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            throw ex;
        }
        this._tempFiles.add(tempFile);
        try {
            Image image = Image.getInstance((String)tempFile.getAbsolutePath());
            return image;
        }
        catch (IOException ex) {
            String msg = String.format("Failed to read %s\n%s", tempFile.getAbsoluteFile(), ex.getMessage());
            LOG.info(msg);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            throw ex;
        }
    }

    private class MaltegoEmptyCacheImageProvider
    implements ImageProvider {
        private MaltegoEmptyCacheImageProvider() {
        }

        public Image getImage(String src, HashMap h, ChainedProperties cprops, DocListener doc) {
            return null;
        }
    }

    private class MaltegoCacheImageProvider
    implements ImageProvider {
        private MaltegoCacheImageProvider() {
        }

        public Image getImage(String src, HashMap h, ChainedProperties cprops, DocListener doc) {
            try {
                if (src.startsWith("http:") || src.startsWith("https:")) {
                    java.awt.Image image = ImageFactory.getDefault().getImage((Object)src, null);
                    if (image == null) {
                        return PdfReportCommonGenerator.this.getBrokenImage();
                    }
                    return Image.getInstance((java.awt.Image)image, null, (boolean)false);
                }
            }
            catch (Exception ex) {
                NormalException.logStackTrace((Throwable)ex);
            }
            return null;
        }
    }

    class EndPage
    extends PdfPageEventHelper {
        private final boolean includeGraphImage;

        public EndPage(boolean includeGraphImage) {
            this.includeGraphImage = includeGraphImage;
        }

        public void onEndPage(PdfWriter writer, Document document) {
            int pageNumber = document.getPageNumber();
            if (this.includeGraphImage && pageNumber == 1) {
                return;
            }
            Rectangle page = document.getPageSize();
            FontSelector fs = ITEXT_STYLE.getFontSelector("Helvetica", 10.0f, 0, Color.LIGHT_GRAY);
            PdfPTable foot = new PdfPTable(1);
            foot.setWidthPercentage(100.0f);
            PdfPCell cell = new PdfPCell((Phrase)new Paragraph(fs.process(Integer.toString(pageNumber))));
            cell.setHorizontalAlignment(1);
            cell.setBorder(0);
            cell.setVerticalAlignment(4);
            foot.addCell(cell);
            foot.setTotalWidth(page.getWidth() - document.leftMargin() - document.rightMargin());
            foot.writeSelectedRows(0, -1, document.leftMargin(), document.bottomMargin() - 10.0f, writer.getDirectContent());
            if (PdfReportCommonGenerator.this._generateFooter) {
                foot = new PdfPTable(2);
                foot.setWidthPercentage(100.0f);
                try {
                    foot.setWidths(new float[]{0.92f, 0.08f});
                }
                catch (DocumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                try {
                    if (PdfReportCommonGenerator.this._footerImage == null) {
                        PdfReportCommonGenerator.this._footerImage = PdfReportCommonGenerator.this.javaToPdfImage(ImageUtilities.loadImage((String)"com/paterva/maltego/ui/graph/view2d/PrintFooter.png"));
                    }
                }
                catch (BadElementException | IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                cell = new PdfPCell((Phrase)new Paragraph(fs.process("Generated with " + Version.getCurrent().toString(true, false, true))));
                cell.setHorizontalAlignment(2);
                cell.setBorder(0);
                cell.setVerticalAlignment(6);
                foot.addCell(cell);
                cell = new PdfPCell(PdfReportCommonGenerator.this._footerImage);
                cell.setBorder(0);
                foot.addCell(cell);
                foot.setTotalWidth(page.getWidth() - document.leftMargin() - document.rightMargin());
                foot.writeSelectedRows(0, -1, document.leftMargin(), document.bottomMargin() - 10.0f, writer.getDirectContent());
            }
        }
    }

    static enum SourceTarget {
        SOURCE,
        TARGET;

    }

    static enum Rank {
        RANK_IN_LINKS,
        RANK_OUT_LINKS,
        RANK_TOTAL_LINKS,
        RANK_WEIGHT;

    }
}

