/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.typing.editing.controls.AttachmentsEditorPanel;
import com.paterva.maltego.typing.editing.propertygrid.editors.AlternativePropertyEditor;
import com.paterva.maltego.typing.types.Attachments;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.Lookup;

public class AttachmentsPropertyEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private final AlternativePropertyEditor ape = (AlternativePropertyEditor)Lookup.getDefault().lookup(AlternativePropertyEditor.class);
    private PropertyEnv _env;
    private AttachmentsEditorPanel _editor;

    public AttachmentsPropertyEditor(Object source) {
        super(source);
    }

    public void attachEnv(PropertyEnv env) {
        this._env = env;
        this._env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        this._env.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if ("state".equals(evt.getPropertyName())) {
                    Attachments newAtts = AttachmentsPropertyEditor.this.getEditor().getAttachments();
                    AttachmentsPropertyEditor.this.setValueInternal(newAtts);
                    AttachmentsPropertyEditor.this.firePropertyChange();
                    AttachmentsPropertyEditor.this.getEditor().applyNewEntityImageAttachment();
                }
            }
        });
    }

    @Override
    public Component getCustomEditor() {
        if (this.ape != null) {
            this.ape.setValue(this.getSource());
            return null;
        }
        return this.getEditor();
    }

    private AttachmentsEditorPanel getEditor() {
        if (this._editor == null) {
            this._editor = new AttachmentsEditorPanel((MaltegoPart)this.getSource(), true, null);
        }
        return this._editor;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public String getAsText() {
        Object v = this.getValue();
        int count = 0;
        if (v != null) {
            count = ((Attachments)this.getValue()).size();
        }
        return count + " files";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        if (value == null) {
            value = new Attachments();
        }
        this.getEditor().setAttachments((Attachments)value);
    }

    protected void setValueInternal(Attachments atts) {
        super.setValue(atts);
    }
}

