/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jbosh;

import com.kenai.jbosh.AbstractBody;
import com.kenai.jbosh.AttrAccept;
import com.kenai.jbosh.BOSHClientConfig;
import com.kenai.jbosh.BOSHException;
import com.kenai.jbosh.CMSessionParams;
import com.kenai.jbosh.GZIPCodec;
import com.kenai.jbosh.HTTPResponse;
import com.kenai.jbosh.StaticBody;
import com.kenai.jbosh.ZLIBCodec;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.xlightweb.IFutureResponse;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpResponse;
import org.xlightweb.PostRequest;
import org.xlightweb.client.HttpClient;

final class XLightWebResponse
implements HTTPResponse {
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ACCEPT_ENCODING_VAL = ZLIBCodec.getID() + ", " + GZIPCodec.getID();
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String CHARSET = "UTF-8";
    private static final String CONTENT_TYPE = "text/xml; charset=utf-8";
    private final Lock lock = new ReentrantLock();
    private final IFutureResponse future;
    private IHttpResponse httpResp;
    private AbstractBody resp;
    private BOSHException toThrow;

    XLightWebResponse(HttpClient client, BOSHClientConfig cfg, CMSessionParams params, AbstractBody request) {
        IFutureResponse futureVal;
        try {
            AttrAccept accept;
            String xml = request.toXML();
            byte[] data = xml.getBytes(CHARSET);
            String encoding = null;
            if (cfg.isCompressionEnabled() && params != null && (accept = params.getAccept()) != null) {
                if (accept.isAccepted(ZLIBCodec.getID())) {
                    encoding = ZLIBCodec.getID();
                    data = ZLIBCodec.encode(data);
                } else if (accept.isAccepted(GZIPCodec.getID())) {
                    encoding = GZIPCodec.getID();
                    data = GZIPCodec.encode(data);
                }
            }
            PostRequest post = new PostRequest(cfg.getURI().toString(), CONTENT_TYPE, data);
            if (encoding != null) {
                post.setHeader(CONTENT_ENCODING, encoding);
            }
            post.setTransferEncoding(null);
            post.setContentLength(data.length);
            if (cfg.isCompressionEnabled()) {
                post.setHeader(ACCEPT_ENCODING, ACCEPT_ENCODING_VAL);
            }
            futureVal = client.send((IHttpRequest)post);
        }
        catch (IOException iox) {
            this.toThrow = new BOSHException("Could not send request", iox);
            futureVal = null;
        }
        this.future = futureVal;
    }

    public void abort() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public int getHTTPStatus() throws InterruptedException, BOSHException {
        this.awaitResponse();
        return this.httpResp.getStatus();
    }

    public AbstractBody getBody() throws InterruptedException, BOSHException {
        this.awaitResponse();
        return this.resp;
    }

    private void awaitResponse() throws InterruptedException, BOSHException {
        this.lock.lock();
        try {
            if (this.toThrow != null) {
                throw this.toThrow;
            }
            if (this.httpResp != null) {
                return;
            }
            this.httpResp = this.future.getResponse();
            byte[] data = this.httpResp.getBlockingBody().readBytes();
            String encoding = this.httpResp.getHeader(CONTENT_ENCODING);
            if (ZLIBCodec.getID().equalsIgnoreCase(encoding)) {
                data = ZLIBCodec.decode(data);
            } else if (GZIPCodec.getID().equalsIgnoreCase(encoding)) {
                data = GZIPCodec.decode(data);
            }
            String bodyStr = new String(data, CHARSET);
            this.resp = StaticBody.fromString(bodyStr);
        }
        catch (IOException iox) {
            this.toThrow = new BOSHException("Could not obtain response", iox);
            throw this.toThrow;
        }
        finally {
            this.lock.unlock();
        }
    }
}

