/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.util.FindFile;

public class KeystoreUtil {
    public static KeyStore loadKeyStore(String filename, String password) throws Exception {
        return KeystoreUtil.loadKeyStore(filename, password, null);
    }

    public static KeyStore loadKeyStore(String filename, String password, String preferedType) throws Exception {
        String keystoreType = KeystoreUtil.getKeystoreType(preferedType, filename, KeyStore.getDefaultType());
        KeyStore trustStore = KeyStore.getInstance(keystoreType);
        InputStream trustStream = null;
        if (filename.startsWith("classpath:")) {
            String resourcePath = filename.replace("classpath:", "");
            if (Thread.currentThread().getContextClassLoader() != null) {
                trustStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
            }
            if (trustStream == null) {
                trustStream = KeystoreUtil.class.getResourceAsStream(resourcePath);
            }
            if (trustStream == null) {
                throw new RuntimeException("Unable to find key store in classpath");
            }
        } else {
            trustStream = new FileInputStream(new File(filename));
        }
        try (FileInputStream is = trustStream;){
            trustStore.load(is, password == null ? null : password.toCharArray());
        }
        return trustStore;
    }

    public static KeyPair loadKeyPairFromKeystore(String keystoreFile, String storePassword, String keyPassword, String keyAlias, KeystoreFormat format) {
        InputStream stream = FindFile.findFile(keystoreFile);
        try {
            KeyStore keyStore = CryptoIntegration.getProvider().getKeyStore(format);
            keyStore.load(stream, storePassword.toCharArray());
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, keyPassword.toCharArray());
            if (privateKey == null) {
                throw new RuntimeException("Couldn't load key with alias '" + keyAlias + "' from keystore");
            }
            PublicKey publicKey = keyStore.getCertificate(keyAlias).getPublicKey();
            if (publicKey == null) {
                throw new RuntimeException("Couldn't load public key with alias '" + keyAlias + "' from keystore");
            }
            return new KeyPair(publicKey, privateKey);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load private key: " + e.getMessage(), e);
        }
    }

    public static String getKeystoreType(String preferredType, String path, String defaultType) {
        if (preferredType != null) {
            return preferredType;
        }
        int lastDotIndex = path.lastIndexOf(46);
        if (lastDotIndex > -1) {
            String ext = path.substring(lastDotIndex + 1).toLowerCase();
            Optional<KeystoreFormat> detectedType = Arrays.stream(KeystoreFormat.values()).filter(ksFormat -> ksFormat.getFileExtensions().contains(ext)).findFirst();
            if (detectedType.isPresent()) {
                return detectedType.get().toString();
            }
        }
        return defaultType;
    }

    public static enum KeystoreFormat {
        JKS("jks"),
        PKCS12("p12", "pfx"),
        BCFKS("bcfks");

        private final List<String> fileExtensions;

        private KeystoreFormat(String ... extensions) {
            this.fileExtensions = Arrays.asList(extensions);
        }

        public List<String> getFileExtensions() {
            return this.fileExtensions;
        }

        public String getPrimaryExtension() {
            return this.fileExtensions.get(0);
        }
    }
}

