/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.runtime;

import com.paterva.maltego.automation.Action;
import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.Compilation;
import com.paterva.maltego.automation.InitializationContext;
import com.paterva.maltego.automation.MachineCompilation;
import com.paterva.maltego.automation.MachineMessageHandler;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.Payloads;
import com.paterva.maltego.automation.runtime.Automaton;
import com.paterva.maltego.automation.runtime.AutomatonListener;
import com.paterva.maltego.automation.runtime.MachineProgressEvent;
import com.paterva.maltego.automation.runtime.MachineProgressListener;
import com.paterva.maltego.automation.runtime.MachineRuntimeException;
import com.paterva.maltego.automation.runtime.RuntimeElement;
import com.paterva.maltego.automation.runtime.RuntimeImage;
import com.paterva.maltego.automation.runtime.State;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.openide.LifecycleManager;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class MachineRuntime {
    private Compilation _machine;
    private RuntimeImage _image;
    private AutomatonListener _changeListener;
    private AutomationContext _context;
    private State _state = State.Ready;
    private Payload _output;
    private int _timerInterval = -1;
    private int _iterationNum = 0;
    private int _iterationCount;
    private boolean _shutdownWhenComplete = false;
    private LinkedList<MachineProgressListener> _listeners;
    private LinkedList<AutomatonTask> _suspendQueue;
    private LinkedList<Automaton> _executingQueue;
    private final String _name;

    public MachineRuntime(MachineCompilation machine, int iterationCount, boolean shutdownWhenComplete) {
        this._machine = machine.getMain();
        this._timerInterval = machine.getTimerInterval();
        this._iterationCount = iterationCount;
        this._shutdownWhenComplete = shutdownWhenComplete;
        this._name = machine.getName();
    }

    public int getTimerInterval() {
        return this._timerInterval;
    }

    public int getIterationCount() {
        return this._iterationCount;
    }

    public void start(AutomationContext ctx, Payload payload) throws MachineRuntimeException {
        if (this.isBusy()) {
            throw new MachineRuntimeException("Machine already running");
        }
        try {
            this._context = ctx;
            this._suspendQueue = null;
            this._executingQueue = null;
            if (this._image == null) {
                this._changeListener = new AutomatonListener(){

                    @Override
                    public void stateChanged(Automaton sender, State oldState, State newState) {
                        MachineRuntime.this.automatonStateChange(sender, oldState, newState);
                    }
                };
                this._image = this.optimize(this._machine);
            }
            this.setState(State.Busy);
            this.start(this._image, payload);
        }
        catch (MachineRuntimeException e) {
            this.setState(State.Failed);
            throw e;
        }
        catch (Exception e) {
            this.setState(State.Failed);
            throw new MachineRuntimeException(e.toString());
        }
    }

    public void stop() {
        this.setState(State.Cancelling);
        try {
            this.cancel();
        }
        finally {
            this.setState(State.Cancelled);
        }
    }

    public void suspend() {
        this.setState(State.Suspended);
    }

    public void resume() {
        this.setState(State.Busy);
        if (this._suspendQueue == null || this._suspendQueue.isEmpty()) {
            this.setState(State.Completed);
        } else {
            while (!this._suspendQueue.isEmpty()) {
                AutomatonTask task = this._suspendQueue.pop();
                this.automatonStateChange(task.getAutomaton(), task.getOldState(), task.getNewState());
            }
        }
    }

    public AutomationContext getContext() {
        return this._context;
    }

    private void setState(State newState) {
        if (this._state != newState) {
            State oldState = this._state;
            this._state = newState;
            this.fireProgressEvent(new MachineProgressEvent(this, oldState, newState));
        }
        if (this._state == State.Failed) {
            this.error("Machine failed!", new Object[0]);
        }
    }

    private State getState() {
        return this._state;
    }

    public boolean isWaiting() {
        return this.getState() == State.Waiting;
    }

    public boolean isBusy() {
        return this.getState() == State.Busy;
    }

    public boolean isCompleted() {
        return this.getState() == State.Completed;
    }

    public boolean isDone() {
        return this.isFailed() || this.isCompleted() || this.isCancelled();
    }

    public boolean isFailed() {
        return this.getState() == State.Failed;
    }

    public boolean isCancelled() {
        return this.getState() == State.Cancelled;
    }

    public boolean isSuspended() {
        return this.getState() == State.Suspended;
    }

    public InitializationContext initialize(Payload initialPayload) {
        ArrayList<InitializationContext> contexts = new ArrayList<InitializationContext>();
        for (Automaton automaton : this.optimize(this._machine).getBlocks()) {
            InitializationContext ctx = automaton.initialize(initialPayload);
            if (ctx == null) continue;
            contexts.add(ctx);
        }
        return InitializationContext.compound(contexts);
    }

    private void start(RuntimeImage image, Payload payload) throws MachineRuntimeException {
        image.getStart().input(payload);
    }

    private RuntimeImage optimize(Compilation compilation) {
        HashMap<Compilation.Node, RuntimeElement> map = new HashMap<Compilation.Node, RuntimeElement>();
        return new RuntimeImage(this.convert(compilation.getInput(), map), this.convert(compilation.getChildren(), map), this.convert(compilation.getOutput(), map));
    }

    private Collection<RuntimeElement> convert(Collection<Compilation.Node> dependants, Map<Compilation.Node, RuntimeElement> map) {
        ArrayList<RuntimeElement> elements = new ArrayList<RuntimeElement>();
        for (Compilation.Node node : dependants) {
            elements.add(this.convert(node, map));
        }
        elements.trimToSize();
        return elements;
    }

    private RuntimeElement convert(Compilation.Node node, Map<Compilation.Node, RuntimeElement> map) {
        RuntimeElement element = map.get(node);
        if (element == null) {
            if (node.getChildren().isEmpty()) {
                this.debug("Creating output with %d parents", node.getParentCount());
                element = new OutputElement(node.getParentCount());
            } else if (node.getParentCount() == 0) {
                this.debug("Creating input", new Object[0]);
                element = new InputElement(node.getAction(), this.convert(node.getChildren(), map));
            } else {
                this.debug("Creating action '%s' with %d parents", this.getActionName(node.getAction()), node.getParentCount());
                element = new RuntimeElement(node.getParentCount(), node.getAction(), this.convert(node.getChildren(), map));
            }
            element.addAutomatonListener(this._changeListener);
            map.put(node, element);
        }
        return element;
    }

    private String getActionName(Action action) {
        if (action == null) {
            return null;
        }
        return action.toString();
    }

    private void onCompleted(Payload payload) {
        ++this._iterationNum;
        if (this.getTimerInterval() > 0) {
            MachineMessageHandler.getDefault().info(this.getContext().getTarget(), "Iteration %d completed", this._iterationNum);
        } else {
            MachineMessageHandler.getDefault().info(this.getContext().getTarget(), "Machine completed with %d entities", payload.size());
            MachineMessageHandler.getDefault().debug(this.getContext().getTarget(), "Machine completed payload %s", this.payloadToString(payload, this.getContext()));
        }
        if (this.getTimerInterval() > 0 && this._iterationNum < this.getIterationCount()) {
            this.setState(State.Waiting);
        } else {
            this.setState(State.Completed);
            this._output = payload;
            if (this._shutdownWhenComplete) {
                DataObject target;
                System.out.println("Shutdown initiated by machine");
                if (this._context != null && (target = this._context.getTarget()) != null) {
                    target.setModified(false);
                }
                LifecycleManager.getDefault().exit();
            }
        }
    }

    private String payloadToString(Payload payload, AutomationContext ctx) {
        if (payload.isEmpty()) {
            return "EMPTY";
        }
        EntityRegistry registry = ctx.getEntityRegistry();
        StringBuilder buffer = new StringBuilder();
        for (MaltegoEntity e : payload.getEntities()) {
            buffer.append(InheritanceHelper.getDisplayString((SpecRegistry)registry, (TypedPropertyBag)e));
            buffer.append(", ");
        }
        if (buffer.length() > 2) {
            return buffer.substring(0, buffer.length() - 2);
        }
        return "EMPTY";
    }

    public Payload getOutput() {
        return this._output;
    }

    public String getName() {
        return this._name;
    }

    private void debug(String s, Object ... args) {
        if (this.getContext() != null) {
            MachineMessageHandler.getDefault().debug(this.getContext().getTarget(), s, args);
        }
    }

    private void info(String s, Object ... args) {
        if (this.getContext() != null) {
            MachineMessageHandler.getDefault().info(this.getContext().getTarget(), s, args);
        }
    }

    private void error(String s, Object ... args) {
        if (this.getContext() != null) {
            MachineMessageHandler.getDefault().error(this.getContext().getTarget(), s, args);
        }
    }

    void addMachineProgressListener(MachineProgressListener listener) {
        if (this._listeners == null) {
            this._listeners = new LinkedList();
        }
        this._listeners.add(listener);
    }

    void removeMachineProgressListener(MachineProgressListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    private void fireProgressEvent(MachineProgressEvent evt) {
        if (this._listeners != null) {
            for (MachineProgressListener l : this._listeners) {
                l.machineProgress(evt);
            }
        }
    }

    void reportProgress(String message, int percent) {
        this.fireProgressEvent(new MachineProgressEvent(this, message, percent));
    }

    void timerIdle(int tick) {
        this.fireProgressEvent(new MachineProgressEvent(this, tick));
    }

    private void suspendToQueue(Automaton sender, State oldState, State newState) {
        if (this._suspendQueue == null) {
            this._suspendQueue = new LinkedList();
        }
        this._suspendQueue.add(new AutomatonTask(sender, oldState, newState));
    }

    private void automatonStateChange(Automaton sender, State oldState, State newState) {
        if (newState == State.Ready) {
            if (this.isSuspended()) {
                this.suspendToQueue(sender, oldState, newState);
            } else if (!this.isDone()) {
                this.startAutomaton(sender);
            }
        } else if (newState == State.Failed) {
            if (!this.isDone()) {
                this.setState(State.Failed);
            }
        } else if (newState == State.Completed && !this.isDone()) {
            this.automatonCompleted(sender);
        }
    }

    private void startAutomaton(Automaton automaton) {
        try {
            if (this._executingQueue == null) {
                this._executingQueue = new LinkedList();
            }
            this._executingQueue.add(automaton);
            automaton.start(this._context);
        }
        catch (MachineRuntimeException ex) {
            this._executingQueue.remove(automaton);
            this.setState(State.Failed);
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.progress(automaton, "started");
    }

    private void automatonCompleted(Automaton automaton) {
        if (this._executingQueue != null) {
            this._executingQueue.remove(automaton);
        }
        this.progress(automaton, "completed");
    }

    private void cancel() {
        if (this._executingQueue != null) {
            while (!this._executingQueue.isEmpty()) {
                try {
                    Automaton automaton = this._executingQueue.pop();
                    if (automaton.getAction() != null) {
                        this.info("Cancelling %s", automaton.getAction());
                    }
                    automaton.cancel();
                }
                catch (Exception e) {
                    MachineMessageHandler.getDefault().error(this.getContext().getTarget(), e);
                }
            }
        }
    }

    private void progress(Automaton automaton, String message) {
        this.debug("%s: %s", automaton, message);
    }

    private static Collection<RuntimeElement> noDependants() {
        return Collections.emptySet();
    }

    private class InputElement
    extends RuntimeElement {
        public InputElement(Action action, Collection<RuntimeElement> dependants) {
            super(1, action, dependants);
        }

        @Override
        public String getActionName() {
            return "INPUT";
        }
    }

    private class OutputElement
    extends RuntimeElement {
        public OutputElement(int inputCount) {
            super(inputCount, null, MachineRuntime.noDependants());
        }

        @Override
        public String getActionName() {
            return "OUTPUT";
        }

        @Override
        public synchronized void input(Payload payload) throws MachineRuntimeException {
            super.input(payload);
        }

        @Override
        protected synchronized void setState(State newState) {
            if (newState == State.Ready) {
                Payload payload = Payloads.fromPayloads(this.getInputs());
                MachineRuntime.this.onCompleted(payload);
                this.clearInput();
            }
        }
    }

    private class AutomatonTask {
        private Automaton _automaton;
        private State _oldState;
        private State _newState;

        public AutomatonTask(Automaton automaton, State oldState, State newState) {
            this._automaton = automaton;
            this._oldState = oldState;
            this._newState = newState;
        }

        public Automaton getAutomaton() {
            return this._automaton;
        }

        public State getOldState() {
            return this._oldState;
        }

        public State getNewState() {
            return this._newState;
        }
    }
}

