/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.officelaf.OfficeEditorTabCellRenderer2;

public class OfficeEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private static final Rectangle scratch5 = new Rectangle();
    private static Map<Integer, String[]> buttonIconPaths;

    public OfficeEditorTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
    }

    public static ComponentUI createUI(JComponent c) {
        return new OfficeEditorTabDisplayerUI((TabDisplayer)c);
    }

    public Dimension getPreferredSize(JComponent c) {
        int prefHeight = 23;
        Graphics2D g = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (g != null) {
            FontMetrics fm = g.getFontMetrics(this.displayer.getFont());
            Insets ins = this.getTabAreaInsets();
            prefHeight = Math.max(prefHeight, fm.getHeight() + ins.top + ins.bottom + 6);
        }
        return new Dimension(this.displayer.getWidth(), prefHeight);
    }

    public void paintBackground(Graphics g) {
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        Color bg = laf.getColor("editor-tab-panel-bg");
        g.setColor(bg);
        g.fillRect(0, 0, this.displayer.getWidth(), this.displayer.getHeight());
    }

    protected void paintAfterTabs(Graphics g) {
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new OfficeEditorTabCellRenderer2();
    }

    protected Font getTxtFont() {
        return super.getTxtFont().deriveFont(0);
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            String[] iconPaths = new String[4];
            iconPaths[0] = "org/netbeans/swing/tabcontrol/resources/vista_scrollleft_enabled.png";
            iconPaths[2] = "org/netbeans/swing/tabcontrol/resources/vista_scrollleft_disabled.png";
            iconPaths[3] = "org/netbeans/swing/tabcontrol/resources/vista_scrollleft_rollover.png";
            iconPaths[1] = "org/netbeans/swing/tabcontrol/resources/vista_scrollleft_pressed.png";
            buttonIconPaths.put(9, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "org/netbeans/swing/tabcontrol/resources/vista_scrollright_enabled.png";
            iconPaths[2] = "org/netbeans/swing/tabcontrol/resources/vista_scrollright_disabled.png";
            iconPaths[3] = "org/netbeans/swing/tabcontrol/resources/vista_scrollright_rollover.png";
            iconPaths[1] = "org/netbeans/swing/tabcontrol/resources/vista_scrollright_pressed.png";
            buttonIconPaths.put(10, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "org/netbeans/swing/tabcontrol/resources/vista_popup_enabled.png";
            iconPaths[2] = "org/netbeans/swing/tabcontrol/resources/vista_popup_disabled.png";
            iconPaths[3] = "org/netbeans/swing/tabcontrol/resources/vista_popup_rollover.png";
            iconPaths[1] = "org/netbeans/swing/tabcontrol/resources/vista_popup_pressed.png";
            buttonIconPaths.put(8, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "org/netbeans/swing/tabcontrol/resources/vista_maximize_enabled.png";
            iconPaths[2] = "org/netbeans/swing/tabcontrol/resources/vista_maximize_disabled.png";
            iconPaths[3] = "org/netbeans/swing/tabcontrol/resources/vista_maximize_rollover.png";
            iconPaths[1] = "org/netbeans/swing/tabcontrol/resources/vista_maximize_pressed.png";
            buttonIconPaths.put(3, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "org/netbeans/swing/tabcontrol/resources/vista_restore_enabled.png";
            iconPaths[2] = "org/netbeans/swing/tabcontrol/resources/vista_restore_disabled.png";
            iconPaths[3] = "org/netbeans/swing/tabcontrol/resources/vista_restore_rollover.png";
            iconPaths[1] = "org/netbeans/swing/tabcontrol/resources/vista_restore_pressed.png";
            buttonIconPaths.put(4, iconPaths);
        }
    }

    public Icon getButtonIcon(int buttonId, int buttonState) {
        Icon res = null;
        OfficeEditorTabDisplayerUI.initIcons();
        String[] paths = buttonIconPaths.get(buttonId);
        if (null != paths && buttonState >= 0 && buttonState < paths.length) {
            res = TabControlButtonFactory.getIcon((String)paths[buttonState]);
        }
        return res;
    }
}

