/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula;

import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DarculaTableHeaderUI
extends BasicTableHeaderUI {
    public static final String DRAW_TABLE_HEADER_SMALL = "drawTableHeaderUISmall";
    private int selectedColumnIndexLocal = 0;

    public static ComponentUI createUI(JComponent c) {
        return new DarculaTableHeaderUI();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        size.height += 10;
        return size;
    }

    private static void drawTableHeaderCustom(Graphics g, JComponent c, boolean isSmall) {
        Graphics2D g2D = (Graphics2D)g;
        GraphicsConfig config = new GraphicsConfig(g2D);
        Color bg = c.getBackground();
        g2D.setPaint(bg);
        int h = c.getHeight();
        int w = c.getWidth();
        if (isSmall) {
            g2D.fill(new Rectangle2D.Double(0.0, 0.0, w, h));
        } else {
            g2D.fillRect(0, 0, w, h);
        }
        g2D.setPaint(UIManager.getLookAndFeelDefaults().getColor("TableHeader.darculaMod.bottomLineColor"));
        if (isSmall) {
            if (((JTableHeader)c).getBorder() != null) {
                GraphicsUtil.drawLine(g2D, 0.0, h, w, h);
                GraphicsUtil.drawLine(g2D, 0.0, 0.0, w, 0.0);
                GraphicsUtil.drawLine(g2D, w - 1, 0.0, w - 1, h);
                GraphicsUtil.drawLine(g2D, 0.0, 0.0, 0.0, h);
            }
        } else {
            g2D.drawLine(0, h - 1, w, h - 1);
            g2D.drawLine(0, 0, w, 0);
            g2D.drawLine(w - 1, 0, w - 1, h);
            g2D.drawLine(0, 0, 0, h);
        }
        Enumeration<TableColumn> columns = ((JTableHeader)c).getColumnModel().getColumns();
        Color lineColor = UIManager.getLookAndFeelDefaults().getColor("TableHeader.darculaMod.columnDividerColor");
        Color shadow = UIManager.getLookAndFeelDefaults().getColor("TableHeader.darculaMod.columnDividerShadow");
        int offset = 0;
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            if (columns.hasMoreElements() && column.getWidth() > 0) {
                offset += column.getWidth();
                g2D.setColor(lineColor);
                if (isSmall) {
                    GraphicsUtil.drawLine(g2D, (double)offset - 0.5, 0.0, (double)offset - 0.5, h);
                } else {
                    g2D.drawLine(offset - 1, 0, offset - 1, h - 2);
                }
                g2D.setColor(shadow);
                if (isSmall) {
                    GraphicsUtil.drawLine(g2D, (double)offset - 0.3, 0.0, (double)offset - 0.3, h);
                    continue;
                }
                g2D.drawLine(offset, 0, offset, h - 2);
                continue;
            }
            if (!isSmall || column.getWidth() <= 0) continue;
            g2D.setColor(lineColor);
            GraphicsUtil.drawLine(g2D, (double)(offset += column.getWidth()) - 0.1, 0.0, (double)offset - 0.1, h);
        }
        config.restore();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            Object isSmall = c.getClientProperty(DRAW_TABLE_HEADER_SMALL);
            if (Boolean.TRUE.equals(isSmall)) {
                Graphics2D g2D = (Graphics2D)g.create();
                GraphicsConfig config = new GraphicsConfig(g2D);
                config.setAntialiasing(true);
                g2D.setColor(c.getBackground());
                g2D.fill(new Rectangle2D.Double(0.0, 0.0, c.getWidth(), c.getHeight()));
                config.restore();
                g2D.dispose();
            } else {
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
        }
        this.paint(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int column;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        Object isSmall = c.getClientProperty(DRAW_TABLE_HEADER_SMALL);
        if (Boolean.TRUE.equals(isSmall)) {
            DarculaTableHeaderUI.drawTableHeaderCustom(g, c, true);
        } else {
            DarculaTableHeaderUI.drawTableHeaderCustom(g, c, false);
        }
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle clip = g.getClipBounds();
        Point left = clip.getLocation();
        Point right = new Point(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        TableColumn draggedColumn = this.header.getDraggedColumn();
        Rectangle cellRect = this.header.getHeaderRect(ltr ? cMin : cMax);
        if (ltr) {
            for (column = cMin; column <= cMax; ++column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column);
                }
                cellRect.x += columnWidth;
            }
        } else {
            for (column = cMax; column >= cMin; --column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column);
                }
                cellRect.x += columnWidth;
            }
        }
        if (draggedColumn != null) {
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
            g.setColor(this.header.getParent().getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            draggedCellRect.x += this.header.getDraggedDistance();
            g.setColor(this.header.getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            this.paintCell(g, draggedCellRect, draggedColumnIndex);
        }
        this.rendererPane.removeAll();
    }

    private Component getHeaderRenderer(int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        boolean hasFocus = !this.header.isPaintingForPrint() && columnIndex == this.getSelectedColumnIndex() && this.header.hasFocus();
        return renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, hasFocus, -1, columnIndex);
    }

    private void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
        Component component = this.getHeaderRenderer(columnIndex);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.header.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    void selectColumn(int newColIndex, boolean doScroll) {
        Rectangle repaintRect = this.header.getHeaderRect(this.selectedColumnIndexLocal);
        this.header.repaint(repaintRect);
        this.selectedColumnIndexLocal = newColIndex;
        repaintRect = this.header.getHeaderRect(newColIndex);
        this.header.repaint(repaintRect);
        if (doScroll) {
            this.scrollToColumn(newColIndex);
        }
    }

    private int getSelectedColumnIndex() {
        int numCols = this.header.getColumnModel().getColumnCount();
        if (this.selectedColumnIndexLocal >= numCols && numCols > 0) {
            this.selectedColumnIndexLocal = numCols - 1;
        }
        return this.selectedColumnIndexLocal;
    }

    private void scrollToColumn(int col) {
        JTable table;
        Container container;
        if (this.header.getParent() == null || (container = this.header.getParent().getParent()) == null || !(container instanceof JScrollPane) || (table = this.header.getTable()) == null) {
            return;
        }
        Rectangle vis = table.getVisibleRect();
        Rectangle cellBounds = table.getCellRect(0, col, true);
        vis.x = cellBounds.x;
        vis.width = cellBounds.width;
        table.scrollRectToVisible(vis);
    }
}

