/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.collect;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.store.GraphMods;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import com.paterva.maltego.graph.store.structure.GraphStructureWriter;
import com.paterva.maltego.graph.store.views.collect.CollectionNodeStructureReader;
import com.paterva.maltego.graph.store.views.collect.CollectionSettings;
import com.paterva.maltego.graph.store.views.impl.InMemoryCollectionNodes;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class CollectionNodeStructureStore
implements GraphStructureStore {
    private static final Logger LOG = Logger.getLogger(CollectionNodeStructureStore.class.getName());
    private final GraphStructureStore _model;
    private final CollectionNodeStructureReader _reader;
    private final InMemoryCollectionNodes _collectionNodes;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private final CollectionNodeSettingsListener _settingsListener;
    private final GraphStoreListener _graphStoreListener;
    private final GraphID _graphID;

    public CollectionNodeStructureStore(GraphID graphID, InMemoryCollectionNodes collectionNodes) throws GraphStoreException {
        this._graphID = graphID;
        final GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
        this._model = graphStore.getGraphStructureStore();
        this._collectionNodes = collectionNodes;
        this._reader = new CollectionNodeStructureReader(collectionNodes);
        this._graphStoreListener = new GraphStoreListener();
        graphStore.addPropertyChangeListener((PropertyChangeListener)this._graphStoreListener);
        this._settingsListener = new CollectionNodeSettingsListener();
        CollectionSettings.getDefault().addPropertyChangeListener(this._settingsListener);
        final GraphID finalGraphID = graphID;
        GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("graphClosing".equals(evt.getPropertyName()) && evt.getNewValue().equals(finalGraphID)) {
                    graphStore.removePropertyChangeListener((PropertyChangeListener)CollectionNodeStructureStore.this._graphStoreListener);
                    CollectionSettings.getDefault().removePropertyChangeListener(CollectionNodeStructureStore.this._settingsListener);
                    GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        });
    }

    public GraphStructureStore getModel() {
        return this._model;
    }

    public GraphStructureReader getStructureReader() {
        return this._reader;
    }

    public void syncWithModel(GraphStructureMods graphStructureMods) {
        if (graphStructureMods != null) {
            this.fire(graphStructureMods);
        } else {
            try {
                this._collectionNodes.getViewEntities().clear();
                this._collectionNodes.getViewLinks().clear();
                this._collectionNodes.repopulateHelperMaps();
                GraphStructureReader modelReader = this.getModel().getStructureReader();
                Set entities = modelReader.getEntities();
                if (!entities.isEmpty()) {
                    Set links = modelReader.getLinks();
                    GraphStructureMods mods = new GraphStructureMods();
                    mods.getEntitiesAdded().addAll(entities);
                    mods.getLinksAdded().addAll(links);
                    if (!mods.isEmpty()) {
                        this.translateMods(mods, null);
                    }
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public GraphStructureWriter getStructureWriter() {
        return this.getModel().getStructureWriter();
    }

    private void translateMods(GraphStructureMods structureMods, GraphDataMods dataMods) throws GraphStoreException {
        LOG.log(Level.FINE, "\nStructure Model mods:\n{0}", structureMods);
        LOG.log(Level.FINE, "\nData Model mods:\n{0}", dataMods);
        GraphStructureMods viewStructureMods = this._collectionNodes.update(structureMods, dataMods);
        LOG.log(Level.FINE, "View mods:\n{0}\n\n", viewStructureMods);
        this.fire(viewStructureMods);
    }

    private void recollectAll(boolean layoutNew) throws GraphStoreException {
        LOG.log(Level.FINE, "\nRecollecting all:\n");
        GraphStructureMods viewStructureMods = this._collectionNodes.recollectAll();
        if (viewStructureMods != null) {
            viewStructureMods.setLayoutNew(layoutNew);
        }
        LOG.log(Level.FINE, "View mods:\n{0}\n\n", viewStructureMods);
        this.fire(viewStructureMods);
    }

    private void fire(GraphStructureMods newMods) {
        if (newMods != null) {
            this._changeSupport.firePropertyChange("structureModified", null, newMods);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    private class GraphStoreListener
    implements PropertyChangeListener {
        private GraphStoreListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                GraphMods mods = (GraphMods)evt.getNewValue();
                if (mods.getDataMods() != null && !mods.getDataMods().isEmpty() || mods.getStructureMods() != null && !mods.getStructureMods().isEmpty()) {
                    CollectionNodeStructureStore.this.translateMods(mods.getStructureMods(), mods.getDataMods());
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class CollectionNodeSettingsListener
    implements PropertyChangeListener {
        private CollectionNodeSettingsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                GraphID graphID = (GraphID)evt.getNewValue();
                if (graphID == null || graphID.equals((Object)CollectionNodeStructureStore.this._graphID)) {
                    CollectionNodeStructureStore.this.recollectAll(CollectionSettings.getDefault().isLayoutNew());
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

