/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.transacting;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.EntityUpdate;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphLink;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.LinkUpdate;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import com.paterva.maltego.graph.store.structure.GraphStructureWriter;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.merging.PartMergeStrategy;
import com.paterva.maltego.ui.graph.transacting.GraphTransactor;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorListener;
import com.paterva.maltego.ui.graph.transactions.GraphPositionAndPathHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransactions;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

class GraphTransactorImpl
extends GraphTransactor {
    private static final Logger LOG = Logger.getLogger(GraphTransactorImpl.class.getName());
    private Thread _thread = null;
    private final GraphID _graphID;
    private final List<GraphTransactorListener> _listeners = new ArrayList<GraphTransactorListener>();
    private int _transactionNum = 0;

    public GraphTransactorImpl(GraphID graphID) {
        this._graphID = graphID;
    }

    @Override
    public GraphID getGraphID() {
        return this._graphID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphTransactionBatch executeTransactions(GraphTransactionBatch batch) {
        this._thread = Thread.currentThread();
        GraphTransactionBatch inverseBatch = null;
        GraphStore graphStore = null;
        try {
            graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
            graphStore.beginUpdate();
            inverseBatch = new GraphTransactionBatch(batch.getDescription().createInverse(), batch.isSignificant(), new GraphTransaction[0]);
            for (GraphTransaction transaction : batch.getTransactions()) {
                GraphTransaction inverseTransaction = null;
                switch (transaction.getOperation()) {
                    case Add: {
                        inverseTransaction = this.executeAdd(transaction);
                        break;
                    }
                    case Update: {
                        inverseTransaction = this.executeUpdate(transaction);
                        break;
                    }
                    case Delete: {
                        inverseTransaction = this.executeDelete(transaction);
                        break;
                    }
                    case AddProperties: {
                        inverseTransaction = this.executeAddProperties(transaction);
                        break;
                    }
                    case DeleteProperties: {
                        inverseTransaction = this.executeDeleteProperties(transaction);
                        break;
                    }
                }
                if (inverseTransaction == null) continue;
                inverseBatch.add(inverseTransaction);
            }
            inverseBatch.reverse();
            GraphTransactionHelper.updateViewGraphs(this._graphID);
        }
        catch (Exception ex) {
            Logger.getLogger(GraphTransactorImpl.class.getName()).severe(batch.toString());
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (graphStore != null) {
                graphStore.endUpdate(null);
            }
        }
        return inverseBatch;
    }

    protected GraphTransaction executeAdd(GraphTransaction transaction) {
        List<MaltegoEntity> entities = this.getEntities(transaction);
        List<MaltegoLink> links = this.getLinks(transaction);
        ArrayList<MaltegoEntity> entityClones = new ArrayList<MaltegoEntity>(entities.size());
        for (MaltegoEntity entity : entities) {
            entityClones.add(entity.createClone());
        }
        GraphStoreWriter.addEntities((GraphID)this._graphID, entityClones);
        for (MaltegoLink link : links) {
            EntityID sourceID = transaction.getSourceID((LinkID)link.getID());
            EntityID targetID = transaction.getTargetID((LinkID)link.getID());
            GraphStoreWriter.addLink((GraphID)this._graphID, (MaltegoLink)link.createClone(), (LinkEntityIDs)new LinkEntityIDs(sourceID, targetID));
        }
        GraphPositionAndPathHelper.setAllCenters(this._graphID, transaction);
        GraphPositionAndPathHelper.setAllPaths(this._graphID, transaction);
        Map<EntityID, Boolean> pinned = transaction.getPinned();
        if (pinned != null) {
            try {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
                GraphStructureStore structureStore = graphStore.getGraphStructureStore();
                GraphStructureWriter structureWriter = structureStore.getStructureWriter();
                structureWriter.setPinned(pinned);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return GraphTransactions.deleteEntitiesAndLinks(transaction.getEntityIDs(), transaction.getLinkIDs());
    }

    private List<MaltegoEntity> getEntities(GraphTransaction transaction) {
        Set<EntityID> entityIDs = transaction.getEntityIDs();
        ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>(entityIDs.size());
        for (EntityID entityID : entityIDs) {
            entities.add(transaction.getEntity(entityID));
        }
        return entities;
    }

    private List<MaltegoLink> getLinks(GraphTransaction transaction) {
        Set<LinkID> linkIDs = transaction.getLinkIDs();
        ArrayList<MaltegoLink> links = new ArrayList<MaltegoLink>(linkIDs.size());
        for (LinkID linkID : linkIDs) {
            links.add(transaction.getLink(linkID));
        }
        return links;
    }

    protected GraphTransaction executeDelete(GraphTransaction transaction) {
        Set<EntityID> entityIDs = transaction.getEntityIDs();
        Set<LinkID> linkIDs = transaction.getLinkIDs();
        Set<MaltegoEntity> entities = GraphTransactionHelper.getGraphEntities(this._graphID, entityIDs, true);
        Map connections = GraphStoreHelper.getConnectionLinks((GraphID)this._graphID, entityIDs, linkIDs);
        Map<String, Map<EntityID, Point>> centers = GraphPositionAndPathHelper.getAllCenters(this._graphID, (Set<EntityID>)GraphStoreHelper.getIds(entities));
        Map pinned = GraphStoreHelper.isPinned((GraphID)this._graphID, entityIDs);
        GraphTransaction inverseTransaction = GraphTransactions.addEntitiesAndLinks(entities, (Map<MaltegoLink, LinkEntityIDs>)connections, centers, pinned, false);
        GraphStoreWriter.remove((GraphID)this._graphID, entityIDs, linkIDs);
        return inverseTransaction;
    }

    protected GraphTransaction executeUpdate(GraphTransaction transaction) {
        UpdateStrategy strategy = new UpdateStrategy();
        return strategy.execute(transaction);
    }

    protected GraphTransaction executeAddProperties(GraphTransaction transaction) {
        AddPropertiesStrategy strategy = new AddPropertiesStrategy();
        return strategy.execute(transaction);
    }

    protected GraphTransaction executeDeleteProperties(GraphTransaction transaction) {
        DeletePropertiesStrategy strategy = new DeletePropertiesStrategy();
        return strategy.execute(transaction);
    }

    @Override
    public void commitTransactions(GraphTransactionBatch batch, GraphTransactionBatch inverseBatch) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("--==<commitTransactions>==-- ");
            LOG.log(Level.FINE, "batch = {0}", batch);
            LOG.log(Level.FINE, "inverseBatch = {0}", inverseBatch);
        }
        Thread currentThread = Thread.currentThread();
        if (this._thread != null && !this._thread.equals(currentThread)) {
            String msg = "Transactions must be executed and commited in the same thread. {0} & {1}";
            Object[] params = new Object[]{this._thread, currentThread};
            Logger.getLogger(GraphTransactorImpl.class.getName()).log(Level.WARNING, msg, params);
        }
        batch = new GraphTransactionBatch(batch);
        inverseBatch = new GraphTransactionBatch(inverseBatch);
        Integer sequenceNumber = batch.getSequenceNumber();
        if (sequenceNumber == null) {
            batch.setSequenceNumber(++this._transactionNum);
        } else if (sequenceNumber > this._transactionNum) {
            this._transactionNum = sequenceNumber;
        }
        inverseBatch.setSequenceNumber(batch.getSequenceNumber());
        this.fireTransactionDone(batch, inverseBatch);
    }

    @Override
    public int reserve() {
        return ++this._transactionNum;
    }

    @Override
    public void addGraphTransactorListener(GraphTransactorListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeGraphTransactorListener(GraphTransactorListener listener) {
        this._listeners.remove(listener);
    }

    protected void fireTransactionDone(GraphTransactionBatch batch, GraphTransactionBatch inverseBatch) {
        for (GraphTransactorListener listener : this._listeners) {
            listener.transactionsDone(batch, inverseBatch);
        }
    }

    private class UpdateStrategy {
        private UpdateStrategy() {
        }

        protected PartMergeStrategy getPartMergeStrategy() {
            return PartMergeStrategy.Update;
        }

        protected EntityUpdate createInverseEntityUpdate(MaltegoEntity before, MaltegoEntity after) {
            return GraphTransactionHelper.createEntityUpdate(after, before);
        }

        protected LinkUpdate createInverseLinkUpdate(MaltegoLink before, MaltegoLink after) {
            return GraphTransactionHelper.createLinkUpdate(after, before);
        }

        protected GraphTransaction createInverseTransaction(Collection<EntityUpdate> inverseEntityUpdates, Collection<LinkUpdate> inverseLinkUpdates, Map<String, Map<EntityID, Point>> inverseCenters, Map<String, Map<LinkID, List<Point>>> inversePaths, Map<EntityID, Boolean> inversePinned) {
            return GraphTransactions.updateAll(inverseEntityUpdates, inverseLinkUpdates, inverseCenters, inversePaths, inversePinned);
        }

        public GraphTransaction execute(GraphTransaction transaction) {
            Set<EntityUpdate> inverseEntityUpdates = this.updateEntities(transaction);
            Set<LinkUpdate> inverseLinkUpdates = this.updateLinks(transaction);
            Map<String, Map<EntityID, Point>> inverseCenters = this.updateEntityPositions(transaction);
            Map<String, Map<LinkID, List<Point>>> inversePaths = this.updateLinkPaths(transaction);
            Map<EntityID, Boolean> inversePinned = this.updatePinned(transaction);
            return this.createInverseTransaction(inverseEntityUpdates, inverseLinkUpdates, inverseCenters, inversePaths, inversePinned);
        }

        private Set<EntityUpdate> updateEntities(GraphTransaction transaction) throws IllegalStateException {
            Set<EntityID> entityUpdateIDs = transaction.getEntityIDs();
            HashSet<EntityUpdate> inverseEntityUpdates = new HashSet<EntityUpdate>(entityUpdateIDs.size());
            Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)GraphTransactorImpl.this._graphID, entityUpdateIDs);
            for (MaltegoEntity entity : entities) {
                EntityID entityUpdateID = (EntityID)entity.getID();
                GraphEntity graphEntity = new GraphEntity(GraphTransactorImpl.this._graphID, entityUpdateID);
                MaltegoEntity before = entity.createClone();
                MaltegoEntity merged = (MaltegoEntity)this.getPartMergeStrategy().merge((MaltegoPart)entity, (MaltegoPart)transaction.getEntity(entityUpdateID));
                if (merged.isCopy((MaltegoPart)before)) continue;
                try {
                    GraphStoreHelper.getDataStoreWriter((GraphPart)graphEntity).updateEntity(merged);
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                EntityUpdate inverseEntityUpdate = this.createInverseEntityUpdate(before, entity);
                if (inverseEntityUpdate != null) {
                    inverseEntityUpdates.add(inverseEntityUpdate);
                    continue;
                }
                throw new IllegalStateException("Inverse entity could not be created!");
            }
            return inverseEntityUpdates;
        }

        private Set<LinkUpdate> updateLinks(GraphTransaction transaction) throws IllegalStateException {
            Set<LinkID> linkUpdateIDs = transaction.getLinkIDs();
            HashSet<LinkUpdate> inverseLinkUpdates = new HashSet<LinkUpdate>(linkUpdateIDs.size());
            Map links = GraphStoreHelper.getLinks((GraphID)GraphTransactorImpl.this._graphID, linkUpdateIDs);
            for (Map.Entry entry : links.entrySet()) {
                LinkID linkUpdateID = (LinkID)entry.getKey();
                MaltegoLink link = (MaltegoLink)entry.getValue();
                GraphLink graphLink = new GraphLink(GraphTransactorImpl.this._graphID, linkUpdateID);
                if (link == null) {
                    throw new IllegalStateException("Link not found with id " + linkUpdateID);
                }
                MaltegoLink before = link.createClone();
                MaltegoLink merged = (MaltegoLink)this.getPartMergeStrategy().merge((MaltegoPart)link, (MaltegoPart)transaction.getLink(linkUpdateID));
                if (merged.isCopy((MaltegoPart)before)) continue;
                try {
                    GraphStoreHelper.getDataStoreWriter((GraphPart)graphLink).updateLink(merged);
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                LinkUpdate inverseLinkUpdate = this.createInverseLinkUpdate(before, link);
                if (inverseLinkUpdate != null) {
                    inverseLinkUpdates.add(inverseLinkUpdate);
                    continue;
                }
                throw new IllegalStateException("Inverse link could not be created!");
            }
            return inverseLinkUpdates;
        }

        private Map<String, Map<EntityID, Point>> updateEntityPositions(GraphTransaction transaction) {
            return GraphPositionAndPathHelper.setAllCenters(GraphTransactorImpl.this._graphID, transaction);
        }

        private Map<String, Map<LinkID, List<Point>>> updateLinkPaths(GraphTransaction transaction) {
            return GraphPositionAndPathHelper.setAllPaths(GraphTransactorImpl.this._graphID, transaction);
        }

        private Map<EntityID, Boolean> updatePinned(GraphTransaction transaction) {
            HashMap<EntityID, Boolean> inversePinned = null;
            Map<EntityID, Boolean> pinned = transaction.getPinned();
            if (pinned != null) {
                inversePinned = new HashMap<EntityID, Boolean>(pinned.size());
                try {
                    GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(GraphTransactorImpl.this._graphID);
                    GraphStructureWriter structureWriter = graphStore.getGraphStructureStore().getStructureWriter();
                    GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
                    Map oldPinned = structureReader.getPinned(pinned.keySet());
                    HashMap<EntityID, Boolean> pinUpdates = new HashMap<EntityID, Boolean>(pinned.size());
                    for (Map.Entry<EntityID, Boolean> entry : pinned.entrySet()) {
                        EntityID entityID = entry.getKey();
                        Boolean oldPinState = (Boolean)oldPinned.get(entityID);
                        Boolean newPinState = entry.getValue();
                        if (newPinState == null || oldPinState.equals(newPinState)) continue;
                        pinUpdates.put(entityID, newPinState);
                        inversePinned.put(entityID, oldPinState);
                    }
                    structureWriter.setPinned(pinUpdates);
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return inversePinned;
        }
    }

    private class DeletePropertiesStrategy
    extends UpdateStrategy {
        private DeletePropertiesStrategy() {
        }

        @Override
        protected PartMergeStrategy getPartMergeStrategy() {
            return PartMergeStrategy.DeleteProperties;
        }

        @Override
        protected EntityUpdate createInverseEntityUpdate(MaltegoEntity before, MaltegoEntity after) {
            MaltegoEntity update = GraphTransactionHelper.createAddPropertiesUpdate(after, before);
            if (update == null) {
                update = new EntityUpdate(before);
            }
            return (EntityUpdate)update;
        }

        @Override
        protected LinkUpdate createInverseLinkUpdate(MaltegoLink before, MaltegoLink after) {
            MaltegoLink update = GraphTransactionHelper.createAddPropertiesUpdate(after, before);
            if (update == null) {
                update = new LinkUpdate(before);
            }
            return (LinkUpdate)update;
        }

        @Override
        protected GraphTransaction createInverseTransaction(Collection<EntityUpdate> inverseEntityUpdates, Collection<LinkUpdate> inverseLinkUpdates, Map<String, Map<EntityID, Point>> inverseCenters, Map<String, Map<LinkID, List<Point>>> inversePaths, Map<EntityID, Boolean> pinned) {
            return GraphTransactions.addProperties(inverseEntityUpdates, inverseLinkUpdates);
        }
    }

    private class AddPropertiesStrategy
    extends UpdateStrategy {
        private AddPropertiesStrategy() {
        }

        @Override
        protected PartMergeStrategy getPartMergeStrategy() {
            return PartMergeStrategy.AddProperties;
        }

        @Override
        protected EntityUpdate createInverseEntityUpdate(MaltegoEntity before, MaltegoEntity after) {
            MaltegoEntity update = GraphTransactionHelper.createDeletePropertiesUpdate(after, before);
            if (update == null) {
                update = new EntityUpdate(before);
            }
            return (EntityUpdate)update;
        }

        @Override
        protected LinkUpdate createInverseLinkUpdate(MaltegoLink before, MaltegoLink after) {
            MaltegoLink update = GraphTransactionHelper.createDeletePropertiesUpdate(after, before);
            if (update == null) {
                update = new LinkUpdate(before);
            }
            return (LinkUpdate)update;
        }

        @Override
        protected GraphTransaction createInverseTransaction(Collection<EntityUpdate> inverseEntityUpdates, Collection<LinkUpdate> inverseLinkUpdates, Map<String, Map<EntityID, Point>> inverseCenters, Map<String, Map<LinkID, List<Point>>> inversePaths, Map<EntityID, Boolean> pinned) {
            return GraphTransactions.deleteProperties(inverseEntityUpdates, inverseLinkUpdates);
        }
    }
}

