Notable changes in 0.33.8 since 0.33.7
======================================

May require attention
---------------------

* Previously, `bup get --force-pick: SRC /.tag/DEST` created broken
  commits if the `DEST` was not itself a commit (the parent would be
  whatever `DEST` initially pointed to).

* `bup split --copy` now writes the split data to standard output
  instead of Python memoryview representations like

      <memory at 0x7f7a89358ac0><memory at 0x7f7a89358a00>...

General
-------

* The full git path is now reported for missing objects encountered
  during a `gc` or `validate-object-refs` invocation,
  e.g. `.../some/path/.bupm` instead of just `.../some/path/` when
  only the `.bupm` is missing.

Bugs
----

* `bup on HOST get ...` should no longer hang in some situations where
  the client could provoke duplicate index-cache suggestions from the
  server, which the client then treated as an error.

* `par2` changed its behavior in 1.0 to be incompatible with `bup`'s
  use of symlinks to mitigate a `par2` bug (see the [0.33.4 release
  notes](0.33.4-from-0.33.3.md) for additional information. `bup` now
  uses hardlinks instead.

* Saves with identical dates won't end up with the same name
  (e.g. 2025-01-08-135615 in "bup ls BRANCH") when they're not
  adjacent -- when one isn't the other's direct parent. Previously bup
  appended an increasing "-N" to disambiguate duplicates, but only
  when they were directly related. Now it appends across all
  duplicates.

* `bup prune-older` should no longer be confused by duplicate save
  names, i.e. commits with duplicate commit times (author
  dates). Previously it would fail with a message like "error: cannot
  access SAVE in SAVE".

* Data durability should be improved in some cases where `bup` wasn't
  fully syncing the data, or wasn't syncing the parent directory after
  a rename.

* Durability should also be improved on macos. There were some cases
  where `bup` wasn't relying on `fcntl.F_FULLFSYNC` to avoid macos'
  inadequate fsync/fdatasync implementation.

* `bup` should no longer hang on exit when trying to shut down its
  internal output filtering.

Thanks to (at least)
====================

Anton Khirnov, Ed Maste, Greg Troxel, Johannes Berg, and Rob Browning
