import fontforge

glyphlist = ((0xF721,'exclam.sc'),(0xF724,'dollar.oldstyle'),
             (0xF726,'ampersand.sc'),(0xF73F,'question.sc'),
             (0xF7A1,'exclamdown.sc'),(0xF7A2,'cent.oldstyle'),
             (0xF7BF,'questiondown.sc'),(0xFE5F,'numbersign.small'),
             (0xFE6A,'percent.small'),(0xF7AF,'uni0304.sc'),
             (0xF7A8,'uni0308.sc'),(0xF760,'gravecomb.sc'),
             (0xF6FE,'tildecomb.sc'),(0xF6FA,'oe.sc'),
             (0xF6F6,'uni0302.sc'),(0xE196,'germandbls.sc'),
             (0xF730,'zero.oldstyle'),(0xF731,'one.oldstyle'),
             (0xF732,'two.oldstyle'),(0xF733,'three.oldstyle'),
             (0xF734,'four.oldstyle'),(0xF735,'five.oldstyle'),
             (0xF736,'six.oldstyle'),(0xF737,'seven.oldstyle'),
             (0xF738,'eight.oldstyle'),(0xF739,'nine.oldstyle')
            )

currentfont = fontforge.open("Junicode-Regular.sfd")

def exists(g):
    try:
        l = len(currentfont[g].foreground)
        return True
    except TypeError:
        return False

def renameGlyph(e,n):
    if exists(e):
        currentfont[e].glyphname = n

for encoding, gname in glyphlist:
    renameGlyph(encoding,gname)

currentfont.save("newfont.sfd")
