/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.console.plugins.helpers.servlet;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

/**
 *
 */
public class TabTag extends TagSupport
{		
	private String name;
	private String href;
	private boolean selected;
	
	private NavigationTag myParent = null;
	
	public int doStartTag() throws JspTagException
	{
		myParent = (NavigationTag)findAncestorWithClass(this, NavigationTag.class);
		if (myParent == null) 
		{
			throw new JspTagException("Tab tag not nested within navigation tag.");
		}		
		
		if (name != null)
		{
			addToParent();			
		}
		return EVAL_BODY_INCLUDE;
	}

	/**
	 * 
	 */
	private void addToParent()
	{
		Tab tab = new Tab(name, href, selected);
		myParent.setTabs(tab);
	}
	/**
	 * @return
	 */
	public String getHref()
	{
		return href;
	}

	/**
	 * @return
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * @return
	 */
	public boolean isSelected()
	{
		return selected;
	}

	/**
	 * @param string
	 */
	public void setHref(String string)
	{
		href = string;
	}

	/**
	 * @param string
	 */
	public void setName(String string)
	{
		name = string;
	}

	/**
	 * @param b
	 */
	public void setSelected(boolean b)
	{
		selected = b;
	}

}
