/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed May 27 18:50:23 2015

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_28 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 5854, "epsg", 5854,
        "SWEREF99 18 45", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18.75 +k=1 +x_0=150000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 18 45 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 18 45\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",18.75],PARAMETER[\"scal");
    add_srs_wkt (p, 10,
        "e_factor\",1],PARAMETER[\"false_easting\",150000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"3015\"]],VERT_CS[\"RH2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,AUTH");
    add_srs_wkt (p, 15,
        "ORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 16,
        "PSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"56");
    add_srs_wkt (p, 17,
        "13\"]],AUTHORITY[\"EPSG\",\"5854\"]]");
    p = add_epsg_def_ex (filter, first, last, 5855, "epsg", 5855,
        "SWEREF99 20 15", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=20.25 +k=1 +x_0=150000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 20 15 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 20 15\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",20.25],PARAMETER[\"scal");
    add_srs_wkt (p, 10,
        "e_factor\",1],PARAMETER[\"false_easting\",150000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"3016\"]],VERT_CS[\"RH2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,AUTH");
    add_srs_wkt (p, 15,
        "ORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 16,
        "PSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"56");
    add_srs_wkt (p, 17,
        "13\"]],AUTHORITY[\"EPSG\",\"5855\"]]");
    p = add_epsg_def_ex (filter, first, last, 5856, "epsg", 5856,
        "SWEREF99 21 45", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21.75 +k=1 +x_0=150000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 21 45 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 21 45\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",21.75],PARAMETER[\"scal");
    add_srs_wkt (p, 10,
        "e_factor\",1],PARAMETER[\"false_easting\",150000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"3017\"]],VERT_CS[\"RH2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,AUTH");
    add_srs_wkt (p, 15,
        "ORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 16,
        "PSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"56");
    add_srs_wkt (p, 17,
        "13\"]],AUTHORITY[\"EPSG\",\"5856\"]]");
    p = add_epsg_def_ex (filter, first, last, 5857, "epsg", 5857,
        "SWEREF99 23 15", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=23.25 +k=1 +x_0=150000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 23 15 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 23 15\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",23.25],PARAMETER[\"scal");
    add_srs_wkt (p, 10,
        "e_factor\",1],PARAMETER[\"false_easting\",150000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"3018\"]],VERT_CS[\"RH2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,AUTH");
    add_srs_wkt (p, 15,
        "ORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 16,
        "PSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"56");
    add_srs_wkt (p, 17,
        "13\"]],AUTHORITY[\"EPSG\",\"5857\"]]");
    p = add_epsg_def_ex (filter, first, last, 5858, "epsg", 5858,
        "SAD69(96) / UTM zone 22S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969_96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 22S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-51],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"5858\"]]");
    p = add_epsg_def_ex (filter, first, last, 5875, "epsg", 5875,
        "SAD69(96) / UTM zone 18S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969_96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 18S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-75],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"5875\"]]");
    p = add_epsg_def_ex (filter, first, last, 5876, "epsg", 5876,
        "SAD69(96) / UTM zone 19S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969_96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 19S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-69],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"5876\"]]");
    p = add_epsg_def_ex (filter, first, last, 5877, "epsg", 5877,
        "SAD69(96) / UTM zone 20S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969_96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 20S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-63],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"5877\"]]");
    p = add_epsg_def_ex (filter, first, last, 5879, "epsg", 5879,
        "Cadastre 1997 / UTM zone 38S", 0, 0,
        "International 1924", "Greenwich",
        "Cadastre_1997", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +south +ellps=intl +towgs84=-381.788,");
    add_proj4text (p, 1,
        "-57.501,-256.673,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cadastre 1997 / UTM zone 38S\",GEOGCS[\"Cadastr");
    add_srs_wkt (p, 1,
        "e 1997\",DATUM[\"Cadastre_1997\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-381.788,-57.501,-256.673,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1037\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4475\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",45],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"5879\"]]");
    p = add_epsg_def_ex (filter, first, last, 5880, "epsg", 5880,
        "SIRGAS 2000 / Brazil Polyconic", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Polyconic", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=poly +lat_0=0 +lon_0=-54 +x_0=5000000 +y_0=1000000");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / Brazil Polyconic\",GEOGCS[\"SIRGA");
    add_srs_wkt (p, 1,
        "S 2000\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_");
    add_srs_wkt (p, 2,
        "las_AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 7,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4674\"]],PROJECTION[\"Polyconic\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",-54],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",5000000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"5880\"]]");
    p = add_epsg_def_ex (filter, first, last, 5886, "epsg", 5886,
        "TGD2005", 1, 1,
        "GRS 1980", "Greenwich",
        "Tonga_Geodetic_Datum_2005", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"TGD2005\",DATUM[\"Tonga_Geodetic_Datum_2005\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1095\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"5886\"]]");
    p = add_epsg_def_ex (filter, first, last, 5887, "epsg", 5887,
        "TGD2005 / Tonga Map Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "Tonga_Geodetic_Datum_2005", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=0.9996 +x_0=1500000 ");
    add_proj4text (p, 1,
        "+y_0=5000000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TGD2005 / Tonga Map Grid\",GEOGCS[\"TGD2005\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Tonga_Geodetic_Datum_2005\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1095\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5886\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-177],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",1500000],PARAMETER[\"false_northing\",5000000],UNIT");
    add_srs_wkt (p, 11,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "5887\"]]");
    p = add_epsg_def_ex (filter, first, last, 5890, "epsg", 5890,
        "JAXA Snow Depth Polar Stereographic North", 0, 0,
        "Hughes 1980", "Greenwich",
        "Not_specified_based_on_Hughes_1980_ellipsoid", "Polar_Stereographic", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=70 +lon_0=90 +k=1 +x_0=0 +");
    add_proj4text (p, 1,
        "y_0=0 +a=6378273 +b=6356889.449 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JAXA Snow Depth Polar Stereographic North\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Unspecified datum based upon the Hughes 1980 ellip");
    add_srs_wkt (p, 2,
        "soid\",DATUM[\"Not_specified_based_on_Hughes_1980_ellips");
    add_srs_wkt (p, 3,
        "oid\",SPHEROID[\"Hughes 1980\",6378273,298.279411123064,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"7058\"]],AUTHORITY[\"EPSG\",\"6054\"");
    add_srs_wkt (p, 5,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 6,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 8,
        "T],AUTHORITY[\"EPSG\",\"4054\"]],PROJECTION[\"Polar_Ster");
    add_srs_wkt (p, 9,
        "eographic\"],PARAMETER[\"latitude_of_origin\",70],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",90],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 11,
        "1],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "5890\"]]");
    p = add_epsg_def_ex (filter, first, last, 5921, "epsg", 5921,
        "WGS 84 / EPSG Arctic Regional zone A1", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +");
    add_proj4text (p, 1,
        "lon_0=-111 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone A1\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",85],PARAMETER[\"standard_parallel_2\",77");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",81.317226],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-111],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 13,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"5921\"]]");
    p = add_epsg_def_ex (filter, first, last, 5922, "epsg", 5922,
        "WGS 84 / EPSG Arctic Regional zone A2", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +");
    add_proj4text (p, 1,
        "lon_0=-39 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone A2\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",85],PARAMETER[\"standard_parallel_2\",77");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",81.317226],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-39],PARAMETER[\"false_easting\",0]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"5922\"]]");
    p = add_epsg_def_ex (filter, first, last, 5923, "epsg", 5923,
        "WGS 84 / EPSG Arctic Regional zone A3", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +");
    add_proj4text (p, 1,
        "lon_0=33 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone A3\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",85],PARAMETER[\"standard_parallel_2\",77");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",81.317226],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",33],PARAMETER[\"false_easting\",0],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"5923\"]]");
    p = add_epsg_def_ex (filter, first, last, 5924, "epsg", 5924,
        "WGS 84 / EPSG Arctic Regional zone A4", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +");
    add_proj4text (p, 1,
        "lon_0=105 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone A4\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",85],PARAMETER[\"standard_parallel_2\",77");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",81.317226],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",105],PARAMETER[\"false_easting\",0]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"5924\"]]");
    p = add_epsg_def_ex (filter, first, last, 5925, "epsg", 5925,
        "WGS 84 / EPSG Arctic Regional zone A5", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +");
    add_proj4text (p, 1,
        "lon_0=177 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone A5\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",85],PARAMETER[\"standard_parallel_2\",77");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",81.317226],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",177],PARAMETER[\"false_easting\",0]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"5925\"]]");
    p = add_epsg_def_ex (filter, first, last, 5926, "epsg", 5926,
        "WGS 84 / EPSG Arctic Regional zone B1", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +");
    add_proj4text (p, 1,
        "lon_0=-111 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone B1\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",77],PARAMETER[\"standard_parallel_2\",69");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",73.15574086111111],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",-111],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
        "ting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5926\"]]");
    p = add_epsg_def_ex (filter, first, last, 5927, "epsg", 5927,
        "WGS 84 / EPSG Arctic Regional zone B2", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +");
    add_proj4text (p, 1,
        "lon_0=-39 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone B2\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",77],PARAMETER[\"standard_parallel_2\",69");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",73.15574086111111],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",-39],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5927\"]]");
    p = add_epsg_def_ex (filter, first, last, 5928, "epsg", 5928,
        "WGS 84 / EPSG Arctic Regional zone B3", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +");
    add_proj4text (p, 1,
        "lon_0=33 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone B3\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",77],PARAMETER[\"standard_parallel_2\",69");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",73.15574086111111],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",33],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5928\"]]");
    p = add_epsg_def_ex (filter, first, last, 5929, "epsg", 5929,
        "WGS 84 / EPSG Arctic Regional zone B4", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +");
    add_proj4text (p, 1,
        "lon_0=105 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone B4\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",77],PARAMETER[\"standard_parallel_2\",69");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",73.15574086111111],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",105],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5929\"]]");
    p = add_epsg_def_ex (filter, first, last, 5930, "epsg", 5930,
        "WGS 84 / EPSG Arctic Regional zone B5", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +");
    add_proj4text (p, 1,
        "lon_0=177 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone B5\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",77],PARAMETER[\"standard_parallel_2\",69");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",73.15574086111111],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",177],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5930\"]]");
    p = add_epsg_def_ex (filter, first, last, 5931, "epsg", 5931,
        "WGS 84 / EPSG Arctic Regional zone C1", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +");
    add_proj4text (p, 1,
        "lon_0=-111 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone C1\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",69],PARAMETER[\"standard_parallel_2\",61");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",65.10127088888888],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",-111],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
        "ting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5931\"]]");
    p = add_epsg_def_ex (filter, first, last, 5932, "epsg", 5932,
        "WGS 84 / EPSG Arctic Regional zone C2", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +");
    add_proj4text (p, 1,
        "lon_0=-39 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone C2\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",69],PARAMETER[\"standard_parallel_2\",61");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",65.10127088888888],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",-39],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5932\"]]");
    p = add_epsg_def_ex (filter, first, last, 5933, "epsg", 5933,
        "WGS 84 / EPSG Arctic Regional zone C3", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +");
    add_proj4text (p, 1,
        "lon_0=33 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone C3\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",69],PARAMETER[\"standard_parallel_2\",61");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",65.10127088888888],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",33],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5933\"]]");
    p = add_epsg_def_ex (filter, first, last, 5934, "epsg", 5934,
        "WGS 84 / EPSG Arctic Regional zone C4", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +");
    add_proj4text (p, 1,
        "lon_0=105 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone C4\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",69],PARAMETER[\"standard_parallel_2\",61");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",65.10127088888888],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",105],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5934\"]]");
    p = add_epsg_def_ex (filter, first, last, 5935, "epsg", 5935,
        "WGS 84 / EPSG Arctic Regional zone C5", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +");
    add_proj4text (p, 1,
        "lon_0=177 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone C5\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_1\",69],PARAMETER[\"standard_parallel_2\",61");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",65.10127088888888],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",177],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5935\"]]");
    p = add_epsg_def_ex (filter, first, last, 5936, "epsg", 5936,
        "WGS 84 / EPSG Alaska Polar Stereographic", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Polar_Stereographic", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=90 +lon_0=-150 +k=0.994 +x");
    add_proj4text (p, 1,
        "_0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Alaska Polar Stereographic\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 2,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Polar_Stereographic\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",90],PARAMETER[\"central_meridian\",-150],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.994],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",2000000],PARAMETER[\"false_northing\",2000000],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"5936\"]]");
    p = add_epsg_def_ex (filter, first, last, 5937, "epsg", 5937,
        "WGS 84 / EPSG Canada Polar Stereographic", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Polar_Stereographic", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=90 +lon_0=-100 +k=0.994 +x");
    add_proj4text (p, 1,
        "_0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Canada Polar Stereographic\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 2,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Polar_Stereographic\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",90],PARAMETER[\"central_meridian\",-100],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.994],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",2000000],PARAMETER[\"false_northing\",2000000],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"5937\"]]");
    p = add_epsg_def_ex (filter, first, last, 5938, "epsg", 5938,
        "WGS 84 / EPSG Greenland Polar Stereographic", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Polar_Stereographic", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=90 +lon_0=-33 +k=0.994 +x_");
    add_proj4text (p, 1,
        "0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Greenland Polar Stereographic\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",");
    add_srs_wkt (p, 2,
        "6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Polar_Stereographic\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",90],PARAMETER[\"central_meridian\",-33],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.994],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",2000000],PARAMETER[\"false_northing\",2000000],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"5938\"]]");
    p = add_epsg_def_ex (filter, first, last, 5939, "epsg", 5939,
        "WGS 84 / EPSG Norway Polar Stereographic", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Polar_Stereographic", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=90 +lon_0=18 +k=0.994 +x_0");
    add_proj4text (p, 1,
        "=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Norway Polar Stereographic\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 2,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Polar_Stereographic\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",90],PARAMETER[\"central_meridian\",18],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.994],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "000000],PARAMETER[\"false_northing\",2000000],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"5939\"]]");
    p = add_epsg_def_ex (filter, first, last, 5940, "epsg", 5940,
        "WGS 84 / EPSG Russia Polar Stereographic", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Polar_Stereographic", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=90 +lon_0=105 +k=0.994 +x_");
    add_proj4text (p, 1,
        "0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Russia Polar Stereographic\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 2,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Polar_Stereographic\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",90],PARAMETER[\"central_meridian\",105],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",0.994],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "2000000],PARAMETER[\"false_northing\",2000000],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"5940\"]]");
    p = add_epsg_def_ex (filter, first, last, 5942, "epsg", 5942,
        "ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + NN2000 height\",GEOGCS[\"ETRS89\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"European_Terrestrial_Reference_System_1989\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 8,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 9,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 10,
        "EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5");
    add_srs_wkt (p, 11,
        "941\"]],AUTHORITY[\"EPSG\",\"5942\"]]");
    p = add_epsg_def_ex (filter, first, last, 5945, "epsg", 5945,
        "ETRS89 / NTM zone 5", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=5.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 5 + NN2000 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"ETRS89 / NTM zone 5\",GEOGCS[\"ETRS89\",DATUM[\"Europe");
    add_srs_wkt (p, 2,
        "an_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 9,
        "tor\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",5.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5105\"]],VERT_CS[\"NN2000 height\",V");
    add_srs_wkt (p, 15,
        "ERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY[\"E");
    add_srs_wkt (p, 16,
        "PSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 17,
        "001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"5945\"]]");
    p = add_epsg_def_ex (filter, first, last, 5946, "epsg", 5946,
        "ETRS89 / NTM zone 6", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=6.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 6 + NN2000 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"ETRS89 / NTM zone 6\",GEOGCS[\"ETRS89\",DATUM[\"Europe");
    add_srs_wkt (p, 2,
        "an_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 9,
        "tor\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",6.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5106\"]],VERT_CS[\"NN2000 height\",V");
    add_srs_wkt (p, 15,
        "ERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY[\"E");
    add_srs_wkt (p, 16,
        "PSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 17,
        "001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"5946\"]]");
    p = add_epsg_def_ex (filter, first, last, 5947, "epsg", 5947,
        "ETRS89 / NTM zone 7", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=7.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 7 + NN2000 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"ETRS89 / NTM zone 7\",GEOGCS[\"ETRS89\",DATUM[\"Europe");
    add_srs_wkt (p, 2,
        "an_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 9,
        "tor\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",7.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5107\"]],VERT_CS[\"NN2000 height\",V");
    add_srs_wkt (p, 15,
        "ERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY[\"E");
    add_srs_wkt (p, 16,
        "PSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 17,
        "001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"5947\"]]");
    p = add_epsg_def_ex (filter, first, last, 5948, "epsg", 5948,
        "ETRS89 / NTM zone 8", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=8.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 8 + NN2000 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"ETRS89 / NTM zone 8\",GEOGCS[\"ETRS89\",DATUM[\"Europe");
    add_srs_wkt (p, 2,
        "an_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 9,
        "tor\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",8.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5108\"]],VERT_CS[\"NN2000 height\",V");
    add_srs_wkt (p, 15,
        "ERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY[\"E");
    add_srs_wkt (p, 16,
        "PSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 17,
        "001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"5948\"]]");
    p = add_epsg_def_ex (filter, first, last, 5949, "epsg", 5949,
        "ETRS89 / NTM zone 9", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=9.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 9 + NN2000 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"ETRS89 / NTM zone 9\",GEOGCS[\"ETRS89\",DATUM[\"Europe");
    add_srs_wkt (p, 2,
        "an_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 9,
        "tor\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",9.5],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",100000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5109\"]],VERT_CS[\"NN2000 height\",V");
    add_srs_wkt (p, 15,
        "ERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY[\"E");
    add_srs_wkt (p, 16,
        "PSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 17,
        "001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"5949\"]]");
    p = add_epsg_def_ex (filter, first, last, 5950, "epsg", 5950,
        "ETRS89 / NTM zone 10", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=10.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 10 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 10\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",10.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5110\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5950\"]]");
    p = add_epsg_def_ex (filter, first, last, 5951, "epsg", 5951,
        "ETRS89 / NTM zone 11", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=11.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 11 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 11\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",11.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5111\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5951\"]]");
    p = add_epsg_def_ex (filter, first, last, 5952, "epsg", 5952,
        "ETRS89 / NTM zone 12", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=12.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 12 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 12\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",12.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5112\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5952\"]]");
    p = add_epsg_def_ex (filter, first, last, 5953, "epsg", 5953,
        "ETRS89 / NTM zone 13", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=13.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 13 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 13\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",13.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5113\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5953\"]]");
    p = add_epsg_def_ex (filter, first, last, 5954, "epsg", 5954,
        "ETRS89 / NTM zone 14", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=14.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 14 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 14\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",14.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5114\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5954\"]]");
    p = add_epsg_def_ex (filter, first, last, 5955, "epsg", 5955,
        "ETRS89 / NTM zone 15", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=15.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 15 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 15\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",15.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5115\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5955\"]]");
    p = add_epsg_def_ex (filter, first, last, 5956, "epsg", 5956,
        "ETRS89 / NTM zone 16", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=16.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 16 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 16\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",16.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5116\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5956\"]]");
    p = add_epsg_def_ex (filter, first, last, 5957, "epsg", 5957,
        "ETRS89 / NTM zone 17", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=17.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 17 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 17\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",17.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5117\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5957\"]]");
    p = add_epsg_def_ex (filter, first, last, 5958, "epsg", 5958,
        "ETRS89 / NTM zone 18", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=18.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 18 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 18\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",18.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5118\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5958\"]]");
    p = add_epsg_def_ex (filter, first, last, 5959, "epsg", 5959,
        "ETRS89 / NTM zone 19", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=19.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 19 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 19\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",19.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5119\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5959\"]]");
    p = add_epsg_def_ex (filter, first, last, 5960, "epsg", 5960,
        "ETRS89 / NTM zone 20", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=20.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 20 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 20\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",20.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5120\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5960\"]]");
    p = add_epsg_def_ex (filter, first, last, 5961, "epsg", 5961,
        "ETRS89 / NTM zone 21", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=21.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 21 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 21\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",21.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5121\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5961\"]]");
    p = add_epsg_def_ex (filter, first, last, 5962, "epsg", 5962,
        "ETRS89 / NTM zone 22", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=22.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 22 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 22\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",22.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5122\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5962\"]]");
    p = add_epsg_def_ex (filter, first, last, 5963, "epsg", 5963,
        "ETRS89 / NTM zone 23", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=23.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 23 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 23\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",23.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5123\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5963\"]]");
    p = add_epsg_def_ex (filter, first, last, 5964, "epsg", 5964,
        "ETRS89 / NTM zone 24", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=24.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 24 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 24\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",24.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5124\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5964\"]]");
    p = add_epsg_def_ex (filter, first, last, 5965, "epsg", 5965,
        "ETRS89 / NTM zone 25", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=25.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 25 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 25\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",25.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5125\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5965\"]]");
    p = add_epsg_def_ex (filter, first, last, 5966, "epsg", 5966,
        "ETRS89 / NTM zone 26", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=26.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 26 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 26\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",26.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5126\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5966\"]]");
    p = add_epsg_def_ex (filter, first, last, 5967, "epsg", 5967,
        "ETRS89 / NTM zone 27", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=27.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 27 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 27\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",27.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5127\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5967\"]]");
    p = add_epsg_def_ex (filter, first, last, 5968, "epsg", 5968,
        "ETRS89 / NTM zone 28", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=28.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 28 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 28\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",28.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5128\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5968\"]]");
    p = add_epsg_def_ex (filter, first, last, 5969, "epsg", 5969,
        "ETRS89 / NTM zone 29", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=29.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 29 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 29\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",29.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5129\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5969\"]]");
    p = add_epsg_def_ex (filter, first, last, 5970, "epsg", 5970,
        "ETRS89 / NTM zone 30", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=30.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 30 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 30\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",58],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",30.5],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",100000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5130\"]],VERT_CS[\"NN2000 height");
    add_srs_wkt (p, 15,
        "\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"5970\"]]");
    p = add_epsg_def_ex (filter, first, last, 5971, "epsg", 5971,
        "ETRS89 / UTM zone 31N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 31 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 31N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",3],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 11,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 14,
        "THORITY[\"EPSG\",\"25831\"]],VERT_CS[\"NN2000 height\",V");
    add_srs_wkt (p, 15,
        "ERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY[\"E");
    add_srs_wkt (p, 16,
        "PSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 17,
        "001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"5971\"]]");
    p = add_epsg_def_ex (filter, first, last, 5972, "epsg", 5972,
        "ETRS89 / UTM zone 32N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 32 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 32N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",9],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 11,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 14,
        "THORITY[\"EPSG\",\"25832\"]],VERT_CS[\"NN2000 height\",V");
    add_srs_wkt (p, 15,
        "ERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY[\"E");
    add_srs_wkt (p, 16,
        "PSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 17,
        "001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"5972\"]]");
    p = add_epsg_def_ex (filter, first, last, 5973, "epsg", 5973,
        "ETRS89 / UTM zone 33N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 33 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 33N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",15],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 11,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"25833\"]],VERT_CS[\"NN2000 height\",");
    add_srs_wkt (p, 15,
        "VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 17,
        "9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]],A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"5973\"]]");
    p = add_epsg_def_ex (filter, first, last, 5974, "epsg", 5974,
        "ETRS89 / UTM zone 34N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 34 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 34N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",21],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 11,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"25834\"]],VERT_CS[\"NN2000 height\",");
    add_srs_wkt (p, 15,
        "VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 17,
        "9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]],A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"5974\"]]");
    p = add_epsg_def_ex (filter, first, last, 5975, "epsg", 5975,
        "ETRS89 / UTM zone 35N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 35 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 35N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",27],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 11,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"25835\"]],VERT_CS[\"NN2000 height\",");
    add_srs_wkt (p, 15,
        "VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 17,
        "9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]],A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"5975\"]]");
    p = add_epsg_def_ex (filter, first, last, 5976, "epsg", 5976,
        "ETRS89 / UTM zone 36N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 36 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 36N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",33],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 11,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"25836\"]],VERT_CS[\"NN2000 height\",");
    add_srs_wkt (p, 15,
        "VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 17,
        "9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5941\"]],A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"5976\"]]");
    p = add_epsg_def_ex (filter, first, last, 6050, "epsg", 6050,
        "GR96 / EPSG Arctic zone 1-25", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=-30 +x_0=25500000 +y_0=1500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 1-25\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",87],PARAMETER[\"stan");
    add_srs_wkt (p, 9,
        "dard_parallel_2\",83.66666666666667],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_origin\",85.43711833333333],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-30],PARAMETER[\"false_easting\",25500000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 14,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6050\"]]");
    p = add_epsg_def_ex (filter, first, last, 6051, "epsg", 6051,
        "GR96 / EPSG Arctic zone 2-18", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=-52 +x_0=18500000 +y");
    add_proj4text (p, 2,
        "_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 2-18\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",83.66666666666667],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",80.33333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"latitude_of_origin\",82.05842488888888],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"central_meridian\",-52],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 12,
        "18500000],PARAMETER[\"false_northing\",2500000],UNIT[\"m");
    add_srs_wkt (p, 13,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6051");
    add_srs_wkt (p, 15,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 6052, "epsg", 6052,
        "GR96 / EPSG Arctic zone 2-20", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=-12 +x_0=20500000 +y");
    add_proj4text (p, 2,
        "_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 2-20\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",83.66666666666667],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",80.33333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"latitude_of_origin\",82.05842488888888],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"central_meridian\",-12],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 12,
        "20500000],PARAMETER[\"false_northing\",2500000],UNIT[\"m");
    add_srs_wkt (p, 13,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6052");
    add_srs_wkt (p, 15,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 6053, "epsg", 6053,
        "GR96 / EPSG Arctic zone 3-29", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-69 +x_0=29500000 +y_0=3500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 3-29\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",80.33333333333333],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",77],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_origin\",78.70733752777778],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-69],PARAMETER[\"false_easting\",29500000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",3500000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 14,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6053\"]]");
    p = add_epsg_def_ex (filter, first, last, 6054, "epsg", 6054,
        "GR96 / EPSG Arctic zone 3-31", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-39 +x_0=31500000 +y_0=3500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 3-31\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",80.33333333333333],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",77],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_origin\",78.70733752777778],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-39],PARAMETER[\"false_easting\",31500000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",3500000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 14,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6054\"]]");
    p = add_epsg_def_ex (filter, first, last, 6055, "epsg", 6055,
        "GR96 / EPSG Arctic zone 3-33", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-10 +x_0=33500000 +y_0=3500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 3-33\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",80.33333333333333],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",77],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_origin\",78.70733752777778],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-10],PARAMETER[\"false_easting\",33500000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",3500000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 14,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6055\"]]");
    p = add_epsg_def_ex (filter, first, last, 6056, "epsg", 6056,
        "GR96 / EPSG Arctic zone 4-20", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-64 +x_0=20500000 +y_0=4500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 4-20\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",77],PARAMETER[\"stan");
    add_srs_wkt (p, 9,
        "dard_parallel_2\",73.66666666666667],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_origin\",75.36440330555556],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-64],PARAMETER[\"false_easting\",20500000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",4500000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 14,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6056\"]]");
    p = add_epsg_def_ex (filter, first, last, 6057, "epsg", 6057,
        "GR96 / EPSG Arctic zone 4-22", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-39 +x_0=22500000 +y_0=4500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 4-22\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",77],PARAMETER[\"stan");
    add_srs_wkt (p, 9,
        "dard_parallel_2\",73.66666666666667],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_origin\",75.36440330555556],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-39],PARAMETER[\"false_easting\",22500000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",4500000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 14,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6057\"]]");
    p = add_epsg_def_ex (filter, first, last, 6058, "epsg", 6058,
        "GR96 / EPSG Arctic zone 4-24", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-14 +x_0=24500000 +y_0=4500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 4-24\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",77],PARAMETER[\"stan");
    add_srs_wkt (p, 9,
        "dard_parallel_2\",73.66666666666667],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_origin\",75.36440330555556],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-14],PARAMETER[\"false_easting\",24500000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",4500000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 14,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6058\"]]");
    p = add_epsg_def_ex (filter, first, last, 6059, "epsg", 6059,
        "GR96 / EPSG Arctic zone 5-41", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=-62 +x_0=41500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 5-41\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",73.66666666666667],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",70.33333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"latitude_of_origin\",72.02500919444444],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"central_meridian\",-62],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 12,
        "41500000],PARAMETER[\"false_northing\",5500000],UNIT[\"m");
    add_srs_wkt (p, 13,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6059");
    add_srs_wkt (p, 15,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 6060, "epsg", 6060,
        "GR96 / EPSG Arctic zone 5-43", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=-42 +x_0=43500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 5-43\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",73.66666666666667],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",70.33333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"latitude_of_origin\",72.02500919444444],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"central_meridian\",-42],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 12,
        "43500000],PARAMETER[\"false_northing\",5500000],UNIT[\"m");
    add_srs_wkt (p, 13,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6060");
    add_srs_wkt (p, 15,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 6061, "epsg", 6061,
        "GR96 / EPSG Arctic zone 5-45", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=-22 +x_0=45500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 5-45\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",73.66666666666667],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",70.33333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"latitude_of_origin\",72.02500919444444],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"central_meridian\",-22],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 12,
        "45500000],PARAMETER[\"false_northing\",5500000],UNIT[\"m");
    add_srs_wkt (p, 13,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6061");
    add_srs_wkt (p, 15,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 6062, "epsg", 6062,
        "GR96 / EPSG Arctic zone 6-26", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-56 +x_0=26500000 +y_0=6500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 6-26\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",70.33333333333333],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",67],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_origin\",68.68747555555557],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-56],PARAMETER[\"false_easting\",26500000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",6500000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 14,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6062\"]]");
    p = add_epsg_def_ex (filter, first, last, 6063, "epsg", 6063,
        "GR96 / EPSG Arctic zone 6-28", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-38 +x_0=28500000 +y_0=6500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 6-28\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",70.33333333333333],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",67],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_origin\",68.68747555555557],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-38],PARAMETER[\"false_easting\",28500000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",6500000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 14,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6063\"]]");
    p = add_epsg_def_ex (filter, first, last, 6064, "epsg", 6064,
        "GR96 / EPSG Arctic zone 6-30", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-20 +x_0=30500000 +y_0=6500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 6-30\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",70.33333333333333],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",67],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_origin\",68.68747555555557],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-20],PARAMETER[\"false_easting\",30500000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",6500000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 14,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6064\"]]");
    p = add_epsg_def_ex (filter, first, last, 6065, "epsg", 6065,
        "GR96 / EPSG Arctic zone 7-11", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=67 +lat_2=63.66666666666666 +lat_0=65.3");
    add_proj4text (p, 1,
        "5103930555555 +lon_0=-51 +x_0=11500000 +y_0=7500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 7-11\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",67],PARAMETER[\"stan");
    add_srs_wkt (p, 9,
        "dard_parallel_2\",63.66666666666666],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_origin\",65.35103930555555],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-51],PARAMETER[\"false_easting\",11500000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",7500000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 14,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6065\"]]");
    p = add_epsg_def_ex (filter, first, last, 6066, "epsg", 6066,
        "GR96 / EPSG Arctic zone 7-13", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=67 +lat_2=63.66666666666666 +lat_0=65.3");
    add_proj4text (p, 1,
        "5103930555555 +lon_0=-34 +x_0=13500000 +y_0=7500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 7-13\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",67],PARAMETER[\"stan");
    add_srs_wkt (p, 9,
        "dard_parallel_2\",63.66666666666666],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_origin\",65.35103930555555],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-34],PARAMETER[\"false_easting\",13500000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",7500000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 14,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6066\"]]");
    p = add_epsg_def_ex (filter, first, last, 6067, "epsg", 6067,
        "GR96 / EPSG Arctic zone 8-20", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=63.66666666666666 +lat_2=60.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=62.01530688888889 +lon_0=-52 +x_0=20500000 +y");
    add_proj4text (p, 2,
        "_0=8500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 8-20\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",63.66666666666666],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",60.33333333333334],PARA");
    add_srs_wkt (p, 10,
        "METER[\"latitude_of_origin\",62.01530688888889],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"central_meridian\",-52],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 12,
        "20500000],PARAMETER[\"false_northing\",8500000],UNIT[\"m");
    add_srs_wkt (p, 13,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6067");
    add_srs_wkt (p, 15,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 6068, "epsg", 6068,
        "GR96 / EPSG Arctic zone 8-22", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=63.66666666666666 +lat_2=60.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=62.01530688888889 +lon_0=-37 +x_0=22500000 +y");
    add_proj4text (p, 2,
        "_0=8500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 8-22\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",63.66666666666666],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",60.33333333333334],PARA");
    add_srs_wkt (p, 10,
        "METER[\"latitude_of_origin\",62.01530688888889],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"central_meridian\",-37],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 12,
        "22500000],PARAMETER[\"false_northing\",8500000],UNIT[\"m");
    add_srs_wkt (p, 13,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6068");
    add_srs_wkt (p, 15,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 6069, "epsg", 6069,
        "ETRS89 / EPSG Arctic zone 2-22", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=16 +x_0=22500000 +y_");
    add_proj4text (p, 2,
        "0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 2-22\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",83.66666666666667],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_2\",80.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 11,
        "n\",82.05842488888888],PARAMETER[\"central_meridian\",16");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_easting\",22500000],PARAMETER[\"fals");
    add_srs_wkt (p, 13,
        "e_northing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 15,
        "TH],AUTHORITY[\"EPSG\",\"6069\"]]");
    p = add_epsg_def_ex (filter, first, last, 6070, "epsg", 6070,
        "ETRS89 / EPSG Arctic zone 3-11", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=21 +x_0=11500000 +y_0=3500000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 3-11\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",80.33333333333333],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_2\",77],PARAMETER[\"latitude_of_origin\",78.70733752");
    add_srs_wkt (p, 11,
        "777778],PARAMETER[\"central_meridian\",21],PARAMETER[\"f");
    add_srs_wkt (p, 12,
        "alse_easting\",11500000],PARAMETER[\"false_northing\",35");
    add_srs_wkt (p, 13,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 14,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 15,
        "\"EPSG\",\"6070\"]]");
    p = add_epsg_def_ex (filter, first, last, 6071, "epsg", 6071,
        "ETRS89 / EPSG Arctic zone 4-26", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=10 +x_0=26500000 +y_0=4500000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 4-26\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",77],PARAMETER[\"standard_parallel_2\",73.6666");
    add_srs_wkt (p, 10,
        "6666666667],PARAMETER[\"latitude_of_origin\",75.36440330");
    add_srs_wkt (p, 11,
        "555556],PARAMETER[\"central_meridian\",10],PARAMETER[\"f");
    add_srs_wkt (p, 12,
        "alse_easting\",26500000],PARAMETER[\"false_northing\",45");
    add_srs_wkt (p, 13,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 14,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 15,
        "\"EPSG\",\"6071\"]]");
    p = add_epsg_def_ex (filter, first, last, 6072, "epsg", 6072,
        "ETRS89 / EPSG Arctic zone 4-28", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=34 +x_0=28500000 +y_0=4500000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 4-28\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",77],PARAMETER[\"standard_parallel_2\",73.6666");
    add_srs_wkt (p, 10,
        "6666666667],PARAMETER[\"latitude_of_origin\",75.36440330");
    add_srs_wkt (p, 11,
        "555556],PARAMETER[\"central_meridian\",34],PARAMETER[\"f");
    add_srs_wkt (p, 12,
        "alse_easting\",28500000],PARAMETER[\"false_northing\",45");
    add_srs_wkt (p, 13,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 14,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 15,
        "\"EPSG\",\"6072\"]]");
    p = add_epsg_def_ex (filter, first, last, 6073, "epsg", 6073,
        "ETRS89 / EPSG Arctic zone 5-11", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=14 +x_0=11500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 5-11\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",73.66666666666667],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_2\",70.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 11,
        "n\",72.02500919444444],PARAMETER[\"central_meridian\",14");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_easting\",11500000],PARAMETER[\"fals");
    add_srs_wkt (p, 13,
        "e_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 15,
        "TH],AUTHORITY[\"EPSG\",\"6073\"]]");
    p = add_epsg_def_ex (filter, first, last, 6074, "epsg", 6074,
        "ETRS89 / EPSG Arctic zone 5-13", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444444 +lon_0=34 +x_0=13500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 5-13\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",73.66666666666667],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_2\",70.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 11,
        "n\",72.02500919444444],PARAMETER[\"central_meridian\",34");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_easting\",13500000],PARAMETER[\"fals");
    add_srs_wkt (p, 13,
        "e_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 15,
        "TH],AUTHORITY[\"EPSG\",\"6074\"]]");
    p = add_epsg_def_ex (filter, first, last, 6075, "epsg", 6075,
        "WGS 84 / EPSG Arctic zone 2-24", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=53 +x_0=24500000 +y_");
    add_proj4text (p, 2,
        "0=2500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 2-24\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",83.66666666666667],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",80.33333333333333],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",82.05842488888888],PARAMETER[\"central_meridian\",53],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",24500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"6075\"]]");
    p = add_epsg_def_ex (filter, first, last, 6076, "epsg", 6076,
        "WGS 84 / EPSG Arctic zone 2-26", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=93 +x_0=26500000 +y_");
    add_proj4text (p, 2,
        "0=2500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 2-26\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",83.66666666666667],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",80.33333333333333],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",82.05842488888888],PARAMETER[\"central_meridian\",93],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",26500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"6076\"]]");
    p = add_epsg_def_ex (filter, first, last, 6077, "epsg", 6077,
        "WGS 84 / EPSG Arctic zone 3-13", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=52 +x_0=13500000 +y_0=3500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-13\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",80.33333333333333],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",77],PARAMETER[\"latitude_of_origin\",78.70733752777");
    add_srs_wkt (p, 10,
        "778],PARAMETER[\"central_meridian\",52],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",13500000],PARAMETER[\"false_northing\",35000");
    add_srs_wkt (p, 12,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"6077\"]]");
    p = add_epsg_def_ex (filter, first, last, 6078, "epsg", 6078,
        "WGS 84 / EPSG Arctic zone 3-15", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=83 +x_0=15500000 +y_0=3500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-15\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",80.33333333333333],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",77],PARAMETER[\"latitude_of_origin\",78.70733752777");
    add_srs_wkt (p, 10,
        "778],PARAMETER[\"central_meridian\",83],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",15500000],PARAMETER[\"false_northing\",35000");
    add_srs_wkt (p, 12,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"6078\"]]");
    p = add_epsg_def_ex (filter, first, last, 6079, "epsg", 6079,
        "WGS 84 / EPSG Arctic zone 3-17", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=114 +x_0=17500000 +y_0=3500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-17\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",80.33333333333333],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",77],PARAMETER[\"latitude_of_origin\",78.70733752777");
    add_srs_wkt (p, 10,
        "778],PARAMETER[\"central_meridian\",114],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",17500000],PARAMETER[\"false_northing\",3500");
    add_srs_wkt (p, 12,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"6079\"]]");
    p = add_epsg_def_ex (filter, first, last, 6080, "epsg", 6080,
        "WGS 84 / EPSG Arctic zone 3-19", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=145 +x_0=19500000 +y_0=3500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-19\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",80.33333333333333],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_2\",77],PARAMETER[\"latitude_of_origin\",78.70733752777");
    add_srs_wkt (p, 10,
        "778],PARAMETER[\"central_meridian\",145],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",19500000],PARAMETER[\"false_northing\",3500");
    add_srs_wkt (p, 12,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"6080\"]]");
    p = add_epsg_def_ex (filter, first, last, 6081, "epsg", 6081,
        "WGS 84 / EPSG Arctic zone 4-30", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=58 +x_0=30500000 +y_0=4500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-30\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",77],PARAMETER[\"standard_parallel_2\",73.6666666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"latitude_of_origin\",75.36440330555");
    add_srs_wkt (p, 10,
        "556],PARAMETER[\"central_meridian\",58],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",30500000],PARAMETER[\"false_northing\",45000");
    add_srs_wkt (p, 12,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"6081\"]]");
    p = add_epsg_def_ex (filter, first, last, 6082, "epsg", 6082,
        "WGS 84 / EPSG Arctic zone 4-32", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=82 +x_0=32500000 +y_0=4500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-32\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",77],PARAMETER[\"standard_parallel_2\",73.6666666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"latitude_of_origin\",75.36440330555");
    add_srs_wkt (p, 10,
        "556],PARAMETER[\"central_meridian\",82],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",32500000],PARAMETER[\"false_northing\",45000");
    add_srs_wkt (p, 12,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"6082\"]]");
    p = add_epsg_def_ex (filter, first, last, 6083, "epsg", 6083,
        "WGS 84 / EPSG Arctic zone 4-34", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=106 +x_0=34500000 +y_0=4500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-34\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",77],PARAMETER[\"standard_parallel_2\",73.6666666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"latitude_of_origin\",75.36440330555");
    add_srs_wkt (p, 10,
        "556],PARAMETER[\"central_meridian\",106],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",34500000],PARAMETER[\"false_northing\",4500");
    add_srs_wkt (p, 12,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"6083\"]]");
    p = add_epsg_def_ex (filter, first, last, 6084, "epsg", 6084,
        "WGS 84 / EPSG Arctic zone 4-36", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=130 +x_0=36500000 +y_0=4500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-36\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",77],PARAMETER[\"standard_parallel_2\",73.6666666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"latitude_of_origin\",75.36440330555");
    add_srs_wkt (p, 10,
        "556],PARAMETER[\"central_meridian\",130],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",36500000],PARAMETER[\"false_northing\",4500");
    add_srs_wkt (p, 12,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"6084\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

