%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Ten plik jest czci pakietu MPATTERN
%
% Autor: Piotr Bolek
% wersja: 0.5 (Jun 25, 2001)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Opis
====

Pakiet MPATTERN suy do definiowania i uywania wypenie wzorkowych
w programie MetaPost. W pakiecie wykorzystywana jest dostpna w jzyku
PostScript Level 2 Wzorkowa Przestrze Kolorw (Pattern Color Space).

Zawarto:
- mpattern.mp: makra dla programu MetaPost suce do  definiowania
  i uywania wzorkw.
- README: krtki opis po angielsku.
- README.PL: krtki opis po polsku.
- test.mp, test.tex, test.ps: przykady uycia.

Sposb uycia
=============

W pliku rdowym naley na pocztku wczy poleceniem input plik
mpattern.mp, a nastpnie przetworzy plik standardowym programem
mpost. 

Interfejs uytkownika
=====================

Definiowanie wzorku
--------------------

Wzorki s definiowane przy uyciu konstrukcji:

beginpattern(<nazwa_wzorku>);
...
endpattern;

Parametr <nazwa_wzorku> jest nazw, ktra suy do identyfikacji
wzorku. Nazwa ta moe zawiera litery i znaki podkrelenia ,,_'', ale
nie moe zawiera cyfr. NIE naley podawa tej nazwy w cudzysowach.

W definicji wzorku (w dowolnym miejscu midzy beginpattern a
endpattern) mona poda dodatkowe polecenia: 
- patternbbox(<pair>,<pair>)
- patternbbox((<numeric>,<numeric>,<numeric>,<numeric>) 
  Jawne podanie wsprzdnych prostokta ograniczajcego komrk wzorka

- patternxstep(<numeric>)
- patternystep(<numeric>)
- patternstep(<numeric>,<numeric>)
- patternstep(<pair>)
  Odstpy midzy komrkami wzorka

- patterntransform(<transform>)
  Modyfikacja ksztatu komrki wzorka

- patterncolor(0<= <numeric> <= 1)
  Jawne podanie koloru zwizanego z danym wzorkiem

Kady wzorek jest tymczasowo zapisywany jako rysunek o duym numerze
(domylnie 999), ale jeli uytkownik wykorzysta ten numer do swojego
rysunku, to dla wzorku bdzie uyty najwikszy wolny numer mniejszy od
999.

Uywanie wzorku
---------------

Do wykorzystania zdefiniowanego wzorku suy makro dziaajce jak
operator dwuargumentowy (primary) withpattern. Sposb uycie jest
nastpujcy:

<cieka> withpattern <nazwa_wzorku>;

gdzie <cieka> jest dowolnym wyraeniem okrelajcym zamknit
ciek, a <nazwa_wzorku> jest nazw podan w definicji wzorku.

Przykad
--------

Oto kod sucy do narysowania dwch kek wypenionych rnymi
szachownicami.

input mpattern;

beginpattern(checker);
 d:=4mm;
 fill unitsquare scaled d;
 fill unitsquare scaled d shifted (d,d);
 patternbbox(0,0,2d,2d);
endpattern;

beginpattern(rotated_checker);
 fill unitsquare scaled 4mm rotated 45 withcolor .7white;
endpattern;

beginfig(11);
 path p;
 z1=(1cm,1cm);
 p=fullcircle scaled 3cm;
 fill p withpattern checker;
 unfill p shifted z1;
 fill p shifted z1 withpattern rotated_checker;
endfig;

Zasady rozpowszechniania
========================

Pakiet MPATTERN jest dobrem wsplnym (ang. ,,public domain''). W
przypadku modyfikacji lub redystrybucji pakietu mona stosowa dowoln
aktualn licencj GPL.

Problemy
========

06-2001: Mog by problemy z wypenianiem wzorkami napisw. Aktualne
	 rozwizanie jest prowizoryczne.

Zmiany
======

06-2001: Dziki inspiracji tutorialem Piotra Strzelczyka na
	 konferencji BachoTeX'2001 wyeliminowana zostaa konieczno
	 postprocesingu z wykorzystaniem Perla. Podmiana kolorw na
	 wzorki jest obecnie realizowana z wykorzystaniem sownikw na
	 poziomie PostScriptu.

Kontakt z autorem
=================

e-mail: P.Bolek@gust.org.pl
